/*
 * Decompiled with CFR 0.152.
 */
package wbsdesk;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.math.RoundingMode;
import java.net.URISyntaxException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.scene.control.Alert;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import wbsdesk.JsonUtils;
import wbsdesk.Sk1SrvCommunicator;
import wbsdesk.ToastFXMessages;

public class Utility {
    Sk1SrvCommunicator sk1Comm = new Sk1SrvCommunicator();
    JsonUtils jsonUtil = new JsonUtils();
    static ToastFXMessages toast = new ToastFXMessages();

    public String AnnoMeseGiornoTOGiornoMeseAnno(String currentDate) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date tempDate = simpleDateFormat.parse(currentDate);
        SimpleDateFormat outputDateFormat = new SimpleDateFormat("dd/MM/yyyy");
        String dataStr = outputDateFormat.format(tempDate);
        return dataStr;
    }

    public int getFIXPART(double value) {
        int ret = 0;
        DecimalFormat df = new DecimalFormat("##");
        df.setRoundingMode(RoundingMode.DOWN);
        ret = Integer.parseInt(df.format(value));
        return 0;
    }

    public void createFileLog() {
        try {
            String path = this.getFilePathOfJar().toString().replace("WbsClient.jar", "");
            File f = new File(path + "logerror.txt");
            if (!f.exists()) {
                f.createNewFile();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(Utility.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(Utility.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public File getFilePathOfJar() throws URISyntaxException {
        return new File(Utility.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
    }

    public File checkIfExistOrCreateConfigProperties(String namoffile) throws URISyntaxException, IOException {
        File path = new File(this.getFilePathOfJar().toString().replace("WbsClient.jar", "") + namoffile);
        if (!path.exists()) {
            path.createNewFile();
            PrintWriter writer = new PrintWriter(this.getFilePathOfJar().toString().replace("WbsClient.jar", "") + namoffile, "UTF-8");
            writer.println("#Configurazione Client");
            writer.println("#Thu Jul 21 16:51:58 CEST 2016");
            writer.println("porta=1175");
            writer.println("path_teleaccise=");
            writer.println("ip=localhost");
            writer.close();
        }
        return path;
    }

    public void writeLog(String message) throws IOException {
        try {
            PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(this.getFilePathOfJar().toString().replace("WbsClient.jar", "") + "logerror.txt", true)));
            SimpleDateFormat dateformat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            Date dt = new Date();
            String data = dateformat.format(dt);
            writer.println(data + " - " + message);
            writer.close();
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(Utility.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(Utility.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(Utility.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static String padLeftZeros(String str, int n) {
        return String.format("%1$" + n + "s", str).replace(' ', '0');
    }

    public void alertWindow(Alert.AlertType type, String title, String header, String content) {
        Alert alert = new Alert(type);
        alert.setTitle(title);
        if (!header.equals("")) {
            alert.setHeaderText(header);
        }
        alert.setContentText(content);
        alert.showAndWait();
    }

    public String makeStringJsonDB(String transaction, List<String> tipo, List<String> strSQL, String[][] tipo_ins, String[][] valore, List<Boolean> last_ID, List<Integer> lenghtBidimensionalArray) throws JSONException {
        String ret = "";
        JSONObject mainObj = new JSONObject();
        JSONArray arrayGeneral = new JSONArray();
        JSONObject objVal = new JSONObject();
        for (int i = 0; i < tipo.size(); ++i) {
            JSONObject objTestata = new JSONObject();
            objTestata.put("transaction", (Object)transaction);
            objTestata.put("tipo", (Object)tipo.get(i));
            objTestata.put("strSQL", (Object)strSQL.get(i));
            objTestata.put("last_ID", (Object)last_ID.get(i));
            ArrayList<String> list = new ArrayList<String>();
            ArrayList<String> list2 = new ArrayList<String>();
            if (tipo_ins != null && valore != null) {
                objTestata.put("lenghtBidimensionalArray", (Object)lenghtBidimensionalArray.get(i));
                if (i <= valore.length) {
                    if (!valore[i][0].equals("")) {
                        for (int k = 0; k < valore[i].length; ++k) {
                            list.add(valore[i][k]);
                            list2.add(tipo_ins[i][k]);
                        }
                        objTestata.put("tipo_ins", list2);
                        objTestata.put("valore", list);
                    } else {
                        objTestata.put("tipo_ins", list2);
                        objTestata.put("valore", list);
                    }
                } else {
                    objTestata.put("tipo_ins", list2);
                    objTestata.put("valore", list);
                }
            } else {
                objTestata.put("tipo_ins", list);
                objTestata.put("valore", list2);
            }
            objVal.put(i + "", (Object)objTestata);
            arrayGeneral.put((Object)objVal);
        }
        mainObj.put("testata", (Object)arrayGeneral);
        ret = mainObj.toString();
        return ret;
    }

    public JSONObject makeObjectJsonDB(String transaction, List<String> tipo, List<String> strSQL, String[][] tipo_ins, String[][] valore, List<Boolean> last_ID, List<Integer> lenghtBidimensionalArray) throws JSONException {
        JSONObject ret = null;
        JSONObject mainObj = new JSONObject();
        JSONArray arrayGeneral = new JSONArray();
        JSONObject objVal = new JSONObject();
        for (int i = 0; i < tipo.size(); ++i) {
            JSONObject objTestata = new JSONObject();
            objTestata.put("transaction", (Object)transaction);
            objTestata.put("tipo", (Object)tipo.get(i));
            objTestata.put("strSQL", (Object)strSQL.get(i));
            objTestata.put("last_ID", (Object)last_ID.get(i));
            ArrayList<String> list = new ArrayList<String>();
            ArrayList<String> list2 = new ArrayList<String>();
            if (tipo_ins != null && valore != null) {
                objTestata.put("lenghtBidimensionalArray", (Object)lenghtBidimensionalArray.get(i));
                if (i <= valore.length) {
                    if (!valore[i][0].equals("")) {
                        for (int k = 0; k < valore[i].length; ++k) {
                            list.add(valore[i][k]);
                            list2.add(tipo_ins[i][k]);
                        }
                        objTestata.put("tipo_ins", list2);
                        objTestata.put("valore", list);
                    } else {
                        objTestata.put("tipo_ins", list2);
                        objTestata.put("valore", list);
                    }
                } else {
                    objTestata.put("tipo_ins", list2);
                    objTestata.put("valore", list);
                }
            } else {
                objTestata.put("tipo_ins", list);
                objTestata.put("valore", list2);
            }
            objVal.put(i + "", (Object)objTestata);
            arrayGeneral.put((Object)objVal);
        }
        mainObj.put("testata", (Object)arrayGeneral);
        ret = mainObj;
        return ret;
    }

    public int getNumberOfDayFromTwoDate(String dateMaster, String dateSlave) {
        int ret = 0;
        int date1 = Integer.parseInt(dateMaster.replace("-", ""));
        int date2 = Integer.parseInt(dateSlave.replace("-", ""));
        ret = date1 - date2;
        return ret;
    }

    public Double setDoubleDecimalFormat(Double val) {
        Double ret = 0.0;
        DecimalFormat dec = new DecimalFormat("#.00");
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        dec.setDecimalFormatSymbols(dfs);
        ret = Double.parseDouble(dec.format(val));
        return ret;
    }
}

