/*
 * Decompiled with CFR 0.152.
 */
package wbsdesk;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.image.Image;
import javafx.scene.layout.Pane;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import org.apache.commons.lang3.SystemUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import wbsdesk.FXMLDocumentController;
import wbsdesk.FormAddLoginController;
import wbsdesk.JsonUtils;
import wbsdesk.TableLogin;
import wbsdesk.ToastFXMessages;

public class LoginAziendaController
implements Initializable {
    FXMLDocumentController controller = null;
    @FXML
    public TableView table_login;
    @FXML
    public TableColumn column_id;
    @FXML
    TableColumn column_azienda;
    @FXML
    TableColumn column_sottoaz;
    @FXML
    TableColumn column_icqrf;
    @FXML
    TableColumn column_codcomm;
    @FXML
    TableColumn column_descrizione;
    public ToastFXMessages toast = new ToastFXMessages();
    public ObservableList<TableLogin> lista_table_login;
    JsonUtils jsonUtil = new JsonUtils();
    int port = 0;
    String ip = "";
    boolean isWindows = false;

    public void setController(FXMLDocumentController controller) {
        this.controller = controller;
    }

    public void setConf(String ip, int port) {
        this.ip = ip;
        this.port = port;
        try {
            this.isWindows = SystemUtils.IS_OS_WINDOWS;
        }
        catch (Exception e) {
            this.controller.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", e.toString());
        }
    }

    public void initialize(URL url, ResourceBundle rb) {
        try {
            this.lista_table_login = FXCollections.observableArrayList();
            this.column_id.setCellValueFactory((Callback)new PropertyValueFactory("column_id"));
            this.column_azienda.setCellValueFactory((Callback)new PropertyValueFactory("column_azienda"));
            this.column_sottoaz.setCellValueFactory((Callback)new PropertyValueFactory("column_sottoaz"));
            this.column_icqrf.setCellValueFactory((Callback)new PropertyValueFactory("column_icqrf"));
            this.column_codcomm.setCellValueFactory((Callback)new PropertyValueFactory("column_codcomm"));
            this.column_descrizione.setCellValueFactory((Callback)new PropertyValueFactory("column_descrizione"));
        }
        catch (Exception ex) {
            this.controller.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
        }
    }

    public void setPopulate() {
        try {
            this.refreshListaLogin();
        }
        catch (JSONException ex) {
            Logger.getLogger(LoginAziendaController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void btnAddLogin(ActionEvent event) throws IOException {
        try {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("FormAddLogin.fxml"));
            Stage stage = new Stage();
            stage.setMaximized(false);
            stage.setFullScreen(false);
            stage.setResizable(false);
            stage.setTitle("Login WBS");
            stage.getIcons().add((Object)new Image(this.getClass().getResourceAsStream("wbslogo16.png")));
            stage.setScene(new Scene((Parent)((Pane)loader.load())));
            stage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

                public void handle(WindowEvent we) {
                }
            });
            FormAddLoginController controller = (FormAddLoginController)loader.getController();
            controller.setController(this.controller, this.ip, this.port);
            controller.setPopulateCombo();
            stage.showAndWait();
            this.refreshListaLogin();
        }
        catch (JSONException ex) {
            Logger.getLogger(LoginAziendaController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void btnDeleteLogin(ActionEvent event) {
        int idriga = this.table_login.getSelectionModel().getSelectedIndex();
        if (idriga != -1) {
            try {
                TableLogin ob = (TableLogin)this.table_login.getSelectionModel().getSelectedItem();
                int id = ob.getColumn_id();
                ArrayList<String> tipoSQL = new ArrayList<String>();
                ArrayList<String> strSQL = new ArrayList<String>();
                ArrayList<Boolean> lastID = new ArrayList<Boolean>();
                lastID.add(false);
                tipoSQL.add("delete");
                strSQL.add("DELETE FROM gen_t_icqrf_mxmag WHERE id=" + id);
                String str = this.controller.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
                String data_select = this.controller.sk1Comm.ServerEsecuteRequest(this.ip, this.port, "dbInteraction#@" + str);
                if (data_select.contains("#ERR:")) {
                    this.controller.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", data_select);
                    return;
                }
                this.refreshListaLogin();
            }
            catch (JSONException ex) {
                this.controller.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
            }
        }
    }

    @FXML
    private void btnLogin(ActionEvent event) {
        int idriga = this.table_login.getSelectionModel().getSelectedIndex();
        if (idriga != -1) {
            try {
                TableLogin tb = (TableLogin)this.table_login.getSelectionModel().getSelectedItem();
                int id = tb.getColumn_id();
                String workingDir = System.getProperty("user.dir");
                String dirClient = workingDir.replace("desk", "client");
                String azienda = tb.getColumn_azienda();
                String sotto_az = tb.getColumn_sottoaz();
                String magazzino = tb.getColumn_mag();
                String icqrf = tb.getColumn_icqrf();
                String cod_comm = tb.getColumn_codcomm();
                if (cod_comm.equals("")) {
                    cod_comm = "#@";
                }
                String porta = this.port + "";
                String br = "";
                if (this.isWindows) {
                    Runtime.getRuntime().exec(new String[]{"wscript", dirClient + "\\wbsstart.vbs ", azienda, sotto_az, icqrf, cod_comm, this.ip, porta, magazzino});
                } else {
                    Runtime.getRuntime().exec(new String[]{dirClient + "/wbsstart.sh", azienda, sotto_az, icqrf, cod_comm, this.ip, porta, magazzino});
                }
                System.exit(0);
            }
            catch (IOException ex) {
                this.controller.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
            }
            catch (Exception ex) {
                this.controller.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
            }
        }
    }

    private void refreshListaLogin() throws JSONException {
        this.lista_table_login.clear();
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        lastID.add(false);
        tipoSQL.add("select");
        strSQL.add("SELECT id,azienda,sotto_az,mx_nmag,icqrf,descrizione,cod_committente FROM gen_t_icqrf_mxmag");
        String str = this.controller.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
        String data_select = this.controller.sk1Comm.ServerEsecuteRequest(this.ip, this.port, "dbInteraction#@" + str);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    JSONObject rec = arrayJson.getJSONObject(i);
                    this.lista_table_login.add((Object)new TableLogin(rec.getInt("id"), rec.getString("azienda"), rec.getString("sotto_az"), rec.getString("icqrf"), rec.getString("cod_committente"), rec.getString("descrizione"), rec.getInt("mx_nmag") + ""));
                    continue;
                }
                catch (JSONException ex) {
                    this.controller.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                    return;
                }
            }
        } else {
            this.controller.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", data_select);
            return;
        }
        this.table_login.setItems(this.lista_table_login);
    }
}

