/*
 * Decompiled with CFR 0.152.
 */
package wbsdesk;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Alert;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.TextField;
import javafx.stage.Stage;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import wbsdesk.CodiceDescrizione;
import wbsdesk.CodiceDescrizione2;
import wbsdesk.FXMLDocumentController;
import wbsdesk.Utility;

public class FormAddLoginController
implements Initializable {
    FXMLDocumentController controller = null;
    @FXML
    TextField editText_descr;
    @FXML
    TextField editText_icqrf;
    @FXML
    ComboBox cmbx_azienda;
    @FXML
    ComboBox cmbx_sottoaz;
    @FXML
    ComboBox cmbx_codcomm;
    @FXML
    ComboBox cmbx_magazzino;
    ObservableList<CodiceDescrizione2> lista_cmbx_azienda = null;
    ObservableList<CodiceDescrizione> lista_cmbx_sottoaz = null;
    ObservableList<CodiceDescrizione> lista_cmbx_codcomm = null;
    ObservableList<CodiceDescrizione> lista_cmbx_magazzino = null;
    String ip = "";
    int port = 0;
    String azienda = "";
    String sotto_az = "";
    ContextMenu usernameValidator = null;

    public void setController(FXMLDocumentController controller, String ip, int port) {
        this.controller = controller;
        this.ip = ip;
        this.port = port;
    }

    public void setPopulateCombo() {
        try {
            ArrayList<String> strSQL = new ArrayList<String>();
            ArrayList<String> tipoSQL = new ArrayList<String>();
            ArrayList<Boolean> lastID = new ArrayList<Boolean>();
            lastID.add(false);
            strSQL.add("SHOW DATABASES");
            tipoSQL.add("select");
            String strJson = this.controller.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
            String data_select = this.controller.sk1Comm.ServerEsecuteRequest(this.ip, this.port, "dbInteraction#@" + strJson);
            if (!data_select.contains("#ERR:")) {
                JSONArray arrayJson = this.controller.jsonUtil.strJsonToJSONArray(data_select);
                for (int i = 0; i < arrayJson.length(); ++i) {
                    try {
                        JSONObject rec = arrayJson.getJSONObject(i);
                        String val = rec.getString("database");
                        if (!val.contains("_rp")) continue;
                        this.lista_cmbx_azienda.add((Object)new CodiceDescrizione2(i + "", val.replace("_rp", "").toUpperCase()));
                        continue;
                    }
                    catch (JSONException ex) {
                        this.controller.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                    }
                }
                this.cmbx_azienda.setItems(this.lista_cmbx_azienda);
            } else {
                this.controller.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", data_select);
            }
        }
        catch (JSONException ex) {
            this.controller.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
        }
    }

    private void selectSottoAzienda(String azienda) {
        try {
            String data_select = this.controller.sk1Comm.ServerEsecuteRequest(this.ip, this.port, "mxGetSottoAzie#@" + azienda);
            if (!data_select.contains("#ERR:")) {
                if (!data_select.equals("[]")) {
                    JSONArray arrayJson = this.controller.jsonUtil.strJsonToJSONArray(data_select);
                    for (int i = 0; i < arrayJson.length(); ++i) {
                        try {
                            JSONObject rec = arrayJson.getJSONObject(i);
                            this.lista_cmbx_sottoaz.add((Object)new CodiceDescrizione(rec.getInt("id_sottoaz") + "", rec.getString("descr_sottoaz")));
                            continue;
                        }
                        catch (JSONException ex) {
                            this.controller.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                        }
                    }
                } else {
                    this.lista_cmbx_sottoaz.add((Object)new CodiceDescrizione("1", "."));
                }
                this.cmbx_sottoaz.setItems(this.lista_cmbx_sottoaz);
            } else {
                this.controller.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", data_select);
            }
        }
        catch (Exception ex) {
            this.controller.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
        }
    }

    private void selectMagazzinoMexal() throws JSONException {
        String data_select = this.controller.sk1Comm.ServerEsecuteRequest(this.ip, this.port, "mxSelectMag#@" + this.azienda + "#@" + this.sotto_az);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.controller.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                Utility cfr_ignored_0 = this.controller.util;
                this.lista_cmbx_magazzino.add((Object)new CodiceDescrizione(Utility.padLeftZeros(String.valueOf(rec.getInt("codice")), 3), rec.getString("descrizione")));
            }
            this.cmbx_magazzino.setItems(this.lista_cmbx_magazzino);
        }
    }

    private void selectFornitoreMexal(String azienda, String sotto_az) throws JSONException {
        JSONObject objTestata = new JSONObject();
        objTestata.put("text", (Object)"");
        JSONArray arrayTestata = new JSONArray();
        arrayTestata.put((Object)objTestata);
        JSONObject objCorpo = new JSONObject();
        objCorpo.put("tipo", (Object)"F");
        JSONArray arrayCorpo = new JSONArray();
        arrayCorpo.put((Object)objCorpo);
        JSONObject mainObj = new JSONObject();
        mainObj.put("testata", (Object)arrayTestata);
        mainObj.put("corpo", (Object)arrayCorpo);
        String data_select = this.controller.sk1Comm.ServerEsecuteRequest(this.ip, this.port, "mxSelectCli#@" + mainObj.toString() + "#@" + azienda + "#@" + sotto_az);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.controller.jsonUtil.strJsonToJSONArray(data_select);
            this.lista_cmbx_codcomm.add(null);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    JSONObject rec = arrayJson.getJSONObject(i);
                    this.lista_cmbx_codcomm.add((Object)new CodiceDescrizione(rec.getString("codice") + "", rec.getString("descrizione")));
                    continue;
                }
                catch (JSONException ex) {
                    this.controller.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                }
            }
            this.cmbx_codcomm.setItems(this.lista_cmbx_codcomm);
        }
    }

    public void initialize(URL url, ResourceBundle rb) {
        try {
            this.lista_cmbx_azienda = FXCollections.observableArrayList();
            this.lista_cmbx_sottoaz = FXCollections.observableArrayList();
            this.lista_cmbx_codcomm = FXCollections.observableArrayList();
            this.lista_cmbx_magazzino = FXCollections.observableArrayList();
            this.cmbx_azienda.valueProperty().addListener((ChangeListener)new ChangeListener<CodiceDescrizione2>(){

                public void changed(ObservableValue<? extends CodiceDescrizione2> observable, CodiceDescrizione2 oldValue, CodiceDescrizione2 newValue) {
                    FormAddLoginController.this.lista_cmbx_sottoaz.clear();
                    FormAddLoginController.this.azienda = newValue.getDescrizione();
                    FormAddLoginController.this.selectSottoAzienda(newValue.getDescrizione());
                }
            });
            this.cmbx_sottoaz.valueProperty().addListener((ChangeListener)new ChangeListener<CodiceDescrizione>(){

                public void changed(ObservableValue<? extends CodiceDescrizione> observable, CodiceDescrizione oldValue, CodiceDescrizione newValue) {
                    try {
                        FormAddLoginController.this.lista_cmbx_codcomm.clear();
                        FormAddLoginController.this.lista_cmbx_magazzino.clear();
                        FormAddLoginController.this.sotto_az = newValue.getCodice();
                        FormAddLoginController.this.selectFornitoreMexal(FormAddLoginController.this.azienda, newValue.getCodice());
                        FormAddLoginController.this.selectMagazzinoMexal();
                    }
                    catch (JSONException ex) {
                        Logger.getLogger(FormAddLoginController.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            });
        }
        catch (Exception ex) {
            Logger.getLogger(FormAddLoginController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void btnSalvaLogin(ActionEvent event) throws IOException {
        String descrizione = this.editText_descr.getText().trim();
        CodiceDescrizione2 obj = (CodiceDescrizione2)this.cmbx_azienda.getSelectionModel().getSelectedItem();
        String azienda = "";
        if (obj != null) {
            azienda = obj.getDescrizione().toUpperCase();
        }
        CodiceDescrizione objs = (CodiceDescrizione)this.cmbx_sottoaz.getSelectionModel().getSelectedItem();
        String sotto_az = "";
        if (objs != null) {
            sotto_az = objs.getCodice();
        }
        CodiceDescrizione objc = (CodiceDescrizione)this.cmbx_codcomm.getSelectionModel().getSelectedItem();
        String cod_comm = "";
        if (objc != null) {
            cod_comm = objc.getCodice();
        }
        CodiceDescrizione objm = (CodiceDescrizione)this.cmbx_magazzino.getSelectionModel().getSelectedItem();
        String magazzino = "";
        if (objm != null) {
            magazzino = objm.getCodice();
        }
        String icqrf = this.editText_icqrf.getText().trim().toUpperCase();
        int i = 0;
        if (descrizione.equals("")) {
            this.editText_descr.getStyleClass().remove((Object)"edittext_default");
            this.editText_descr.getStyleClass().add((Object)"edittext_default_error");
            this.editText_descr.requestFocus();
            ++i;
        } else {
            this.editText_descr.getStyleClass().remove((Object)"edittext_default_error");
            this.editText_descr.getStyleClass().add((Object)"edittext_default");
            this.editText_descr.requestFocus();
        }
        if (azienda.equals("")) {
            this.cmbx_azienda.getStyleClass().remove((Object)"edittext_default");
            this.cmbx_azienda.getStyleClass().add((Object)"edittext_default_error");
            this.cmbx_azienda.requestFocus();
            ++i;
        } else {
            this.cmbx_azienda.getStyleClass().remove((Object)"edittext_default_error");
            this.cmbx_azienda.getStyleClass().add((Object)"edittext_default");
            this.cmbx_azienda.requestFocus();
        }
        if (sotto_az.equals("")) {
            this.cmbx_sottoaz.getStyleClass().remove((Object)"edittext_default");
            this.cmbx_sottoaz.getStyleClass().add((Object)"edittext_default_error");
            this.cmbx_sottoaz.requestFocus();
            ++i;
        } else {
            this.cmbx_sottoaz.getStyleClass().remove((Object)"edittext_default_error");
            this.cmbx_sottoaz.getStyleClass().add((Object)"edittext_default");
            this.cmbx_sottoaz.requestFocus();
        }
        if (magazzino.equals("")) {
            this.cmbx_magazzino.getStyleClass().remove((Object)"edittext_default");
            this.cmbx_magazzino.getStyleClass().add((Object)"edittext_default_error");
            this.cmbx_magazzino.requestFocus();
            ++i;
        } else {
            this.cmbx_magazzino.getStyleClass().remove((Object)"edittext_default_error");
            this.cmbx_magazzino.getStyleClass().add((Object)"edittext_default");
            this.cmbx_magazzino.requestFocus();
        }
        if (icqrf.equals("")) {
            this.editText_icqrf.getStyleClass().remove((Object)"edittext_default");
            this.editText_icqrf.getStyleClass().add((Object)"edittext_default_error");
            this.editText_icqrf.requestFocus();
            ++i;
        } else {
            this.editText_icqrf.getStyleClass().remove((Object)"edittext_default_error");
            this.editText_icqrf.getStyleClass().add((Object)"edittext_default");
            this.editText_icqrf.requestFocus();
        }
        if (i == 0) {
            this.insertRecordIntoDB(azienda, sotto_az, icqrf, cod_comm, descrizione, magazzino);
        }
    }

    private void insertRecordIntoDB(String azienda, String sotto_az, String icqrf, String cod_comm, String descrizione, String mx_nmag) {
        try {
            ArrayList<String> strSQL = new ArrayList<String>();
            ArrayList<String> tipoSQL = new ArrayList<String>();
            ArrayList<Boolean> lastID = new ArrayList<Boolean>();
            String[][] tipo_ins = new String[1][6];
            String[][] val_ins = new String[1][6];
            ArrayList<Integer> lenIntegers = new ArrayList<Integer>();
            lastID.add(false);
            strSQL.add("INSERT INTO gen_t_icqrf_mxmag (azienda,sotto_az,icqrf,cod_committente,descrizione,mx_nmag) VALUES (?,?,?,?,?,?)");
            tipoSQL.add("insert");
            lenIntegers.add(6);
            tipo_ins[0][0] = "string";
            tipo_ins[0][1] = "string";
            tipo_ins[0][2] = "string";
            tipo_ins[0][3] = "string";
            tipo_ins[0][4] = "string";
            tipo_ins[0][5] = "int";
            val_ins[0][0] = azienda;
            val_ins[0][1] = sotto_az;
            val_ins[0][2] = icqrf;
            val_ins[0][3] = cod_comm;
            val_ins[0][4] = descrizione;
            val_ins[0][5] = mx_nmag;
            String strJson = this.controller.util.makeStringJsonDB("ON", tipoSQL, strSQL, tipo_ins, val_ins, lastID, lenIntegers);
            String data_select = this.controller.sk1Comm.ServerEsecuteRequest(this.ip, this.port, "dbInteraction#@" + strJson);
            if (!data_select.contains("#ERR:")) {
                this.controller.toast.startToast("Salvataggio avvenuto con successo.", "SUCCESSO", "SUCCESSO");
                Stage st = (Stage)this.cmbx_azienda.getScene().getWindow();
                st.close();
            } else {
                this.controller.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", data_select);
            }
        }
        catch (JSONException ex) {
            this.controller.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
        }
    }
}

