/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.concurrency.JFXUtilities;
import com.jfoenix.controls.RecursiveTreeItem$$Lambda$1;
import com.jfoenix.controls.RecursiveTreeItem$$Lambda$10;
import com.jfoenix.controls.RecursiveTreeItem$$Lambda$11;
import com.jfoenix.controls.RecursiveTreeItem$$Lambda$2;
import com.jfoenix.controls.RecursiveTreeItem$$Lambda$3;
import com.jfoenix.controls.RecursiveTreeItem$$Lambda$4;
import com.jfoenix.controls.RecursiveTreeItem$$Lambda$5;
import com.jfoenix.controls.RecursiveTreeItem$$Lambda$6;
import com.jfoenix.controls.RecursiveTreeItem$$Lambda$7;
import com.jfoenix.controls.RecursiveTreeItem$$Lambda$8;
import com.jfoenix.controls.RecursiveTreeItem$$Lambda$9;
import com.jfoenix.controls.datamodels.treetable.RecursiveTreeObject;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.scene.Node;
import javafx.scene.control.TreeItem;
import javafx.util.Callback;

public class RecursiveTreeItem<T extends RecursiveTreeObject<T>>
extends TreeItem<T> {
    private Callback<RecursiveTreeObject<T>, ObservableList<T>> childrenFactory;
    private ObjectProperty<Predicate<TreeItem<T>>> predicate;
    ObservableList<TreeItem<T>> originalItems;
    FilteredList<TreeItem<T>> filteredItems;

    public RecursiveTreeItem(Callback<RecursiveTreeObject<T>, ObservableList<T>> func) {
        this(null, null, func);
    }

    public RecursiveTreeItem(T value, Callback<RecursiveTreeObject<T>, ObservableList<T>> func) {
        this(value, null, func);
    }

    public RecursiveTreeItem(T value, Node graphic, Callback<RecursiveTreeObject<T>, ObservableList<T>> func) {
        super(value, graphic);
        this.predicate = new SimpleObjectProperty((Object)RecursiveTreeItem$$Lambda$1.lambdaFactory$());
        this.originalItems = FXCollections.observableArrayList();
        this.childrenFactory = func;
        this.init((RecursiveTreeObject<T>)value);
    }

    public RecursiveTreeItem(ObservableList<T> dataList, Callback<RecursiveTreeObject<T>, ObservableList<T>> func) {
        this.predicate = new SimpleObjectProperty((Object)RecursiveTreeItem$$Lambda$2.lambdaFactory$());
        this.originalItems = FXCollections.observableArrayList();
        RecursiveTreeObject<T> root = new RecursiveTreeObject<T>();
        root.setChildren(dataList);
        this.childrenFactory = func;
        this.init(root);
    }

    private void init(RecursiveTreeObject<T> value) {
        if (value != null) {
            this.addChildrenListener(value);
        }
        this.valueProperty().addListener(RecursiveTreeItem$$Lambda$3.lambdaFactory$(this));
        this.filteredItems.predicateProperty().bind((ObservableValue)Bindings.createObjectBinding((Callable)RecursiveTreeItem$$Lambda$4.lambdaFactory$(this), (Observable[])new Observable[]{this.predicate}));
        this.filteredItems.predicateProperty().addListener(RecursiveTreeItem$$Lambda$5.lambdaFactory$(this));
    }

    private void addChildrenListener(RecursiveTreeObject<T> value) {
        ObservableList children = (ObservableList)this.childrenFactory.call(value);
        this.originalItems = FXCollections.observableArrayList();
        for (RecursiveTreeObject child : children) {
            this.originalItems.add(new RecursiveTreeItem<RecursiveTreeObject>(child, this.getGraphic(), this.childrenFactory));
        }
        this.filteredItems = new FilteredList(this.originalItems, RecursiveTreeItem$$Lambda$6.lambdaFactory$());
        this.getChildren().addAll(this.originalItems);
        children.addListener(RecursiveTreeItem$$Lambda$7.lambdaFactory$(this));
    }

    public final ObjectProperty<Predicate<TreeItem<T>>> predicateProperty() {
        return this.predicate;
    }

    public final Predicate<TreeItem<T>> getPredicate() {
        return (Predicate)this.predicateProperty().get();
    }

    public final void setPredicate(Predicate<TreeItem<T>> predicate) {
        this.predicateProperty().set(predicate);
    }

    static /* synthetic */ void lambda$addChildrenListener$9(RecursiveTreeItem this_, ListChangeListener.Change change) {
        while (change.next()) {
            if (change.wasAdded()) {
                change.getAddedSubList().forEach(RecursiveTreeItem$$Lambda$8.lambdaFactory$(this_));
            }
            if (!change.wasRemoved()) continue;
            change.getRemoved().forEach(RecursiveTreeItem$$Lambda$9.lambdaFactory$(this_));
        }
    }

    static /* synthetic */ void lambda$null$8(RecursiveTreeItem this_, RecursiveTreeObject t) {
        for (int i = 0; i < this_.getChildren().size(); ++i) {
            if (!((RecursiveTreeObject)((TreeItem)this_.getChildren().get(i)).getValue()).equals(t)) continue;
            this_.originalItems.remove(this_.getChildren().remove(i));
            --i;
        }
    }

    static /* synthetic */ void lambda$null$7(RecursiveTreeItem this_, RecursiveTreeObject t) {
        RecursiveTreeItem<RecursiveTreeObject> newItem = new RecursiveTreeItem<RecursiveTreeObject>(t, this_.getGraphic(), this_.childrenFactory);
        this_.getChildren().add(newItem);
        this_.originalItems.add(newItem);
    }

    static /* synthetic */ boolean lambda$addChildrenListener$6(TreeItem t) {
        return true;
    }

    static /* synthetic */ void lambda$init$5(RecursiveTreeItem this_, ObservableValue o, Predicate oldVal, Predicate newVal) {
        JFXUtilities.runInFXAndWait(RecursiveTreeItem$$Lambda$10.lambdaFactory$(this_));
    }

    static /* synthetic */ void lambda$null$4(RecursiveTreeItem this_) {
        this_.getChildren().clear();
        this_.getChildren().addAll(this_.filteredItems);
    }

    static /* synthetic */ Predicate lambda$init$3(RecursiveTreeItem this_) throws Exception {
        return RecursiveTreeItem$$Lambda$11.lambdaFactory$(this_);
    }

    static /* synthetic */ boolean lambda$null$2(RecursiveTreeItem this_, TreeItem child) {
        if (child instanceof RecursiveTreeItem && !((RecursiveTreeItem)child).originalItems.isEmpty()) {
            RecursiveTreeItem filterableChild = (RecursiveTreeItem)child;
            filterableChild.setPredicate((Predicate)this_.predicate.get());
        }
        if (this_.predicate.get() == null) {
            return true;
        }
        if (child.getChildren().size() > 0) {
            return true;
        }
        if (child.getValue() instanceof RecursiveTreeObject && ((RecursiveTreeObject)child.getValue()).getClass() == RecursiveTreeObject.class) {
            return child.getChildren().size() != 0;
        }
        return ((Predicate)this_.predicate.get()).test(child);
    }

    static /* synthetic */ void lambda$init$1(RecursiveTreeItem this_, ObservableValue o, RecursiveTreeObject oldValue, RecursiveTreeObject newValue) {
        if (newValue != null) {
            this_.addChildrenListener(newValue);
        }
    }

    static /* synthetic */ boolean lambda$new$0(TreeItem t) {
        return true;
    }
}

