/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.concurrency.JFXUtilities;
import com.jfoenix.controls.JFXTreeTableRow;
import com.jfoenix.controls.JFXTreeTableView$$Lambda$1;
import com.jfoenix.controls.JFXTreeTableView$$Lambda$10;
import com.jfoenix.controls.JFXTreeTableView$$Lambda$11;
import com.jfoenix.controls.JFXTreeTableView$$Lambda$12;
import com.jfoenix.controls.JFXTreeTableView$$Lambda$13;
import com.jfoenix.controls.JFXTreeTableView$$Lambda$2;
import com.jfoenix.controls.JFXTreeTableView$$Lambda$3;
import com.jfoenix.controls.JFXTreeTableView$$Lambda$4;
import com.jfoenix.controls.JFXTreeTableView$$Lambda$5;
import com.jfoenix.controls.JFXTreeTableView$$Lambda$6;
import com.jfoenix.controls.JFXTreeTableView$$Lambda$7;
import com.jfoenix.controls.JFXTreeTableView$$Lambda$8;
import com.jfoenix.controls.JFXTreeTableView$$Lambda$9;
import com.jfoenix.controls.JFXTreeTableView$1$$Lambda$1;
import com.jfoenix.controls.JFXTreeTableView$1$$Lambda$2;
import com.jfoenix.controls.RecursiveTreeItem;
import com.jfoenix.controls.datamodels.treetable.RecursiveTreeObject;
import com.jfoenix.skins.JFXTreeTableViewSkin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Semaphore;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.scene.control.Skin;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableRow;
import javafx.scene.control.TreeTableView;
import javafx.scene.input.MouseEvent;

public class JFXTreeTableView<S extends RecursiveTreeObject<S>>
extends TreeTableView<S> {
    private TreeItem<S> originalRoot;
    private boolean itemWasSelected = false;
    private ObservableList<TreeTableColumn<S, ?>> groupOrder = FXCollections.observableArrayList();
    private Semaphore groupingSemaphore = new Semaphore(1);
    private Timer t;
    private ObjectProperty<Predicate<TreeItem<S>>> predicate;
    private IntegerProperty currentItemsCount;
    private Map<Object, Map<Object, ?>> groups;

    public JFXTreeTableView() {
        this.predicate = new SimpleObjectProperty((Object)JFXTreeTableView$$Lambda$1.lambdaFactory$());
        this.currentItemsCount = new SimpleIntegerProperty(0);
        this.init();
    }

    public JFXTreeTableView(TreeItem<S> root) {
        super(root);
        this.predicate = new SimpleObjectProperty((Object)JFXTreeTableView$$Lambda$2.lambdaFactory$());
        this.currentItemsCount = new SimpleIntegerProperty(0);
        this.originalRoot = root;
        this.init();
    }

    public void propagateMouseEventsToParent() {
        this.addEventHandler(MouseEvent.ANY, JFXTreeTableView$$Lambda$3.lambdaFactory$(this));
    }

    protected Skin<?> createDefaultSkin() {
        return new JFXTreeTableViewSkin(this);
    }

    protected void init() {
        this.setRowFactory(JFXTreeTableView$$Lambda$4.lambdaFactory$());
        this.getSelectionModel().selectedItemProperty().addListener(JFXTreeTableView$$Lambda$5.lambdaFactory$(this));
        this.predicate.addListener(JFXTreeTableView$$Lambda$6.lambdaFactory$(this));
        this.rootProperty().addListener(JFXTreeTableView$$Lambda$7.lambdaFactory$(this));
        this.setCurrentItemsCount(this.count(this.getRoot()));
    }

    public String getUserAgentStylesheet() {
        return ((Object)((Object)this)).getClass().getResource("/css/controls/jfx-tree-table-view.css").toExternalForm();
    }

    public int getTreeItemLevel(TreeItem<?> node) {
        TreeItem root = this.getRoot();
        if (node == null) {
            return -1;
        }
        if (node == root) {
            return 0;
        }
        int level = 0;
        for (TreeItem parent = node.getParent(); parent != null; parent = parent.getParent()) {
            ++level;
            if (parent == root) break;
            if (parent.getValue() == null || !(parent.getValue() instanceof RecursiveTreeObject) || ((RecursiveTreeObject)parent.getValue()).getGroupedColumn() == null) continue;
            --level;
        }
        return level;
    }

    public void sort() {
        this.getSelectionModel().clearSelection();
        super.sort();
        if (this.itemWasSelected) {
            this.getSelectionModel().select(0);
        }
    }

    final ObservableList<TreeTableColumn<S, ?>> getGroupOrder() {
        return this.groupOrder;
    }

    public void group(TreeTableColumn<S, ?> ... treeTableColumns) {
        if (this.groupingSemaphore.tryAcquire()) {
            if (this.groupOrder.size() == 0) {
                this.groups = new HashMap();
            }
            try {
                if (this.originalRoot == null) {
                    this.originalRoot = this.getRoot();
                }
                for (TreeTableColumn<S, ?> treeTableColumn : treeTableColumns) {
                    this.groups = this.group(treeTableColumn, this.groups, null, (RecursiveTreeItem)this.originalRoot);
                }
                this.groupOrder.addAll((Object[])treeTableColumns);
                this.buildGroupedRoot(this.groups, null, 0);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.groupingSemaphore.release();
        }
    }

    private void refreshGroups(List<TreeTableColumn<S, ?>> groupColumns) {
        this.groups = new HashMap();
        for (TreeTableColumn<S, ?> treeTableColumn : groupColumns) {
            this.groups = this.group(treeTableColumn, this.groups, null, (RecursiveTreeItem)this.originalRoot);
        }
        this.groupOrder.addAll(groupColumns);
        this.buildGroupedRoot(this.groups, null, 0);
    }

    public void unGroup(TreeTableColumn<S, ?> ... treeTableColumns) {
        if (this.groupingSemaphore.tryAcquire()) {
            try {
                if (this.groupOrder.size() > 0) {
                    this.groupOrder.removeAll((Object[])treeTableColumns);
                    ArrayList grouped = new ArrayList();
                    grouped.addAll((Collection<TreeTableColumn<S, ?>>)this.groupOrder);
                    this.groupOrder.clear();
                    JFXUtilities.runInFXAndWait(JFXTreeTableView$$Lambda$8.lambdaFactory$(this, grouped));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.groupingSemaphore.release();
        }
    }

    private Map group(TreeTableColumn<S, ?> column, Map parentGroup, Object key, RecursiveTreeItem<S> root) {
        if (parentGroup.isEmpty()) {
            parentGroup = this.groupByFunction((List<TreeItem<S>>)root.filteredItems, column);
            return parentGroup;
        }
        Object value = parentGroup.get(key);
        if (value instanceof List) {
            Map newGroup = this.groupByFunction((List)value, column);
            parentGroup.put(key, newGroup);
            return parentGroup;
        }
        if (value instanceof Map) {
            for (Object childKey : ((Map)value).keySet()) {
                value = this.group(column, (Map)value, childKey, root);
            }
            parentGroup.put(key, value);
            return parentGroup;
        }
        if (key == null) {
            for (Object childKey : parentGroup.keySet()) {
                parentGroup = this.group(column, parentGroup, childKey, root);
            }
            return parentGroup;
        }
        return parentGroup;
    }

    protected Map groupByFunction(List<TreeItem<S>> items, TreeTableColumn<S, ?> column) {
        HashMap map = new HashMap();
        for (TreeItem<S> child : items) {
            Object key = column.getCellData(child);
            map.computeIfAbsent(key, JFXTreeTableView$$Lambda$9.lambdaFactory$());
            ((List)map.get(key)).add(child);
        }
        return map;
    }

    private void buildGroupedRoot(Map groupedItems, RecursiveTreeItem parent, int groupIndex) {
        boolean setRoot = false;
        if (parent == null) {
            parent = new RecursiveTreeItem(new RecursiveTreeObject(), JFXTreeTableView$$Lambda$10.lambdaFactory$());
            setRoot = true;
        }
        for (Object key : groupedItems.keySet()) {
            RecursiveTreeObject groupItem = new RecursiveTreeObject();
            groupItem.setGroupedValue(key);
            groupItem.setGroupedColumn((TreeTableColumn)this.groupOrder.get(groupIndex));
            RecursiveTreeItem node = new RecursiveTreeItem(groupItem, JFXTreeTableView$$Lambda$11.lambdaFactory$());
            node.expandedProperty().addListener(JFXTreeTableView$$Lambda$12.lambdaFactory$(this));
            parent.originalItems.add(node);
            parent.getChildren().add(node);
            Object children = groupedItems.get(key);
            if (children instanceof List) {
                node.originalItems.addAll((Collection)((List)children));
                node.getChildren().addAll((Collection)((List)children));
                continue;
            }
            if (!(children instanceof Map)) continue;
            this.buildGroupedRoot((Map)children, node, groupIndex + 1);
        }
        if (setRoot) {
            RecursiveTreeItem newParent = parent;
            JFXUtilities.runInFX(JFXTreeTableView$$Lambda$13.lambdaFactory$(this, newParent));
        }
    }

    private void filter(final Predicate<TreeItem<S>> predicate) {
        if (this.originalRoot == null) {
            this.originalRoot = this.getRoot();
        }
        if (this.t != null) {
            this.t.cancel();
            this.t.purge();
        }
        this.t = new Timer();
        this.t.schedule(new TimerTask(){

            @Override
            public void run() {
                new Thread(JFXTreeTableView$1$$Lambda$1.lambdaFactory$(this, predicate)).start();
            }

            static /* synthetic */ void lambda$run$1(1 this_, Predicate predicate2) {
                ((RecursiveTreeItem)this_.JFXTreeTableView.this.originalRoot).setPredicate(predicate2);
                this_.JFXTreeTableView.this.reGroup();
                Platform.runLater((Runnable)JFXTreeTableView$1$$Lambda$2.lambdaFactory$(this_));
            }

            static /* synthetic */ void lambda$null$0(1 this_) {
                this_.JFXTreeTableView.this.getSelectionModel().select(0);
                this_.JFXTreeTableView.this.setCurrentItemsCount(this_.JFXTreeTableView.this.count(this_.JFXTreeTableView.this.getRoot()));
            }
        }, 500L);
    }

    public void reGroup() {
        if (!this.groupOrder.isEmpty()) {
            ArrayList tempGroups = new ArrayList(this.groupOrder);
            this.groupOrder.clear();
            this.group(tempGroups.toArray(new TreeTableColumn[tempGroups.size()]));
        }
    }

    public final ObjectProperty<Predicate<TreeItem<S>>> predicateProperty() {
        return this.predicate;
    }

    public final Predicate<TreeItem<S>> getPredicate() {
        return (Predicate)this.predicateProperty().get();
    }

    public final void setPredicate(Predicate<TreeItem<S>> predicate) {
        this.predicateProperty().set(predicate);
    }

    public final IntegerProperty currentItemsCountProperty() {
        return this.currentItemsCount;
    }

    public final int getCurrentItemsCount() {
        return this.currentItemsCountProperty().get();
    }

    public final void setCurrentItemsCount(int currentItemsCount) {
        this.currentItemsCountProperty().set(currentItemsCount);
    }

    private int count(TreeItem<?> node) {
        if (node == null) {
            return 0;
        }
        int count = 1;
        if (node.getValue() == null || node.getValue() != null && node.getValue().getClass().equals(RecursiveTreeObject.class)) {
            count = 0;
        }
        for (TreeItem child : node.getChildren()) {
            count += this.count(child);
        }
        return count;
    }

    static /* synthetic */ boolean lambda$new$9(TreeItem t) {
        return true;
    }

    static /* synthetic */ void lambda$buildGroupedRoot$8(JFXTreeTableView this_, RecursiveTreeItem newParent) {
        ArrayList sortOrder = new ArrayList();
        sortOrder.addAll(this_.getSortOrder());
        this_.setRoot(newParent);
        this_.getSortOrder().addAll(sortOrder);
        this_.getSelectionModel().select(0);
    }

    static /* synthetic */ void lambda$buildGroupedRoot$7(JFXTreeTableView this_, ObservableValue o, Boolean oldVal, Boolean newVal) {
        this_.getSelectionModel().clearSelection();
    }

    static /* synthetic */ List lambda$groupByFunction$6(Object k) {
        return new ArrayList();
    }

    static /* synthetic */ void lambda$unGroup$5(JFXTreeTableView this_, List grouped) {
        ArrayList sortOrder = new ArrayList();
        sortOrder.addAll(this_.getSortOrder());
        List<Object> children = Arrays.asList(this_.originalRoot.getChildren().toArray());
        this_.originalRoot.getChildren().clear();
        this_.originalRoot.getChildren().setAll(children);
        this_.setRoot(this_.originalRoot);
        this_.getSelectionModel().select(0);
        this_.getSortOrder().addAll(sortOrder);
        if (grouped.size() != 0) {
            this_.refreshGroups(grouped);
        }
    }

    static /* synthetic */ void lambda$init$4(JFXTreeTableView this_, ObservableValue o, TreeItem oldVal, TreeItem newVal) {
        if (newVal != null) {
            this_.setCurrentItemsCount(this_.count(this_.getRoot()));
        }
    }

    static /* synthetic */ void lambda$init$3(JFXTreeTableView this_, ObservableValue o, Predicate oldVal, Predicate newVal) {
        this_.filter(newVal);
    }

    static /* synthetic */ void lambda$init$2(JFXTreeTableView this_, ObservableValue o, TreeItem oldVal, TreeItem newVal) {
        if (newVal != null && newVal.getValue() != null) {
            this_.itemWasSelected = true;
        }
    }

    static /* synthetic */ TreeTableRow lambda$init$1(TreeTableView param) {
        return new JFXTreeTableRow();
    }

    static /* synthetic */ void lambda$propagateMouseEventsToParent$0(JFXTreeTableView this_, MouseEvent e) {
        e.consume();
        this_.getParent().fireEvent((Event)e);
    }
}

