/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.animation.alert.JFXAlertAnimation;
import com.jfoenix.controls.JFXAlert$$Lambda$1;
import com.jfoenix.controls.JFXAlert$$Lambda$10;
import com.jfoenix.controls.JFXAlert$$Lambda$2;
import com.jfoenix.controls.JFXAlert$$Lambda$3;
import com.jfoenix.controls.JFXAlert$$Lambda$4;
import com.jfoenix.controls.JFXAlert$$Lambda$5;
import com.jfoenix.controls.JFXAlert$$Lambda$6;
import com.jfoenix.controls.JFXAlert$$Lambda$7;
import com.jfoenix.controls.JFXAlert$$Lambda$8;
import com.jfoenix.controls.JFXAlert$$Lambda$9;
import com.jfoenix.effects.JFXDepthManager;
import com.sun.javafx.event.EventHandlerManager;
import javafx.animation.Animation;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventDispatchChain;
import javafx.event.EventDispatcher;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogEvent;
import javafx.scene.control.DialogPane;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;

public class JFXAlert<R>
extends Dialog<R> {
    private final StackPane contentContainer;
    private final StackPane overlay;
    private final Group contentGroup;
    private Animation transition = null;
    private final EventHandlerManager eventHandlerManager = new EventHandlerManager((Object)this);
    private BooleanProperty overlayClose = new SimpleBooleanProperty(true);
    private ObjectProperty<JFXAlertAnimation> animation = new SimpleObjectProperty((Object)JFXAlertAnimation.CENTER_ANIMATION);

    public JFXAlert(Stage stage) {
        this.initStyle(StageStyle.TRANSPARENT);
        this.initOwner((Window)stage);
        this.setDialogPane(new DialogPane(){
            {
                this.getButtonTypes().add((Object)ButtonType.CLOSE);
                Node closeButton = this.lookupButton(ButtonType.CLOSE);
                closeButton.managedProperty().bind((ObservableValue)closeButton.visibleProperty());
                closeButton.setVisible(false);
            }

            protected Node createButtonBar() {
                return null;
            }
        });
        this.contentContainer = new StackPane();
        this.contentContainer.getStyleClass().add((Object)"jfx-alert-content-container");
        this.contentContainer.setStyle("-fx-background-color: WHITE;");
        DialogPane dialogPane = this.getDialogPane();
        dialogPane.getScene().setFill((Paint)Color.TRANSPARENT);
        dialogPane.setStyle("-fx-background-color: transparent;");
        dialogPane.prefWidthProperty().bind((ObservableValue)stage.getScene().widthProperty());
        dialogPane.prefHeightProperty().bind((ObservableValue)stage.getScene().heightProperty());
        Node materialNode = JFXDepthManager.createMaterialNode((Node)this.contentContainer, 2);
        materialNode.setPickOnBounds(false);
        this.contentGroup = new Group(new Node[]{materialNode});
        this.overlay = new StackPane(new Node[]{this.contentGroup});
        this.overlay.getStyleClass().add((Object)"jfx-alert-overlay");
        this.overlay.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.valueOf((String)"#00000011"), CornerRadii.EMPTY, Insets.EMPTY)}));
        StackPane container = new StackPane(new Node[]{this.overlay});
        container.setPadding(new Insets(0.0));
        dialogPane.setContent((Node)container);
        this.updateX(stage, dialogPane);
        this.updateY(stage, dialogPane);
        stage.getScene().widthProperty().addListener(JFXAlert$$Lambda$1.lambdaFactory$(this, dialogPane));
        stage.getScene().heightProperty().addListener(JFXAlert$$Lambda$2.lambdaFactory$(this, dialogPane));
        stage.xProperty().addListener(JFXAlert$$Lambda$3.lambdaFactory$(this, stage, dialogPane));
        stage.yProperty().addListener(JFXAlert$$Lambda$4.lambdaFactory$(this, stage, dialogPane));
        this.eventHandlerManager.addEventHandler(DialogEvent.DIALOG_SHOWING, JFXAlert$$Lambda$5.lambdaFactory$(this));
        this.eventHandlerManager.addEventHandler(DialogEvent.DIALOG_SHOWN, JFXAlert$$Lambda$6.lambdaFactory$(this));
        this.overlay.addEventHandler(MouseEvent.MOUSE_CLICKED, JFXAlert$$Lambda$7.lambdaFactory$(this));
    }

    private void updateY(Stage stage, DialogPane dialogPane) {
        if (dialogPane.getScene() != null) {
            Parent root = stage.getScene().getRoot();
            Bounds screenBounds = root.localToScreen(root.getLayoutBounds());
            dialogPane.getScene().getWindow().setY(screenBounds.getMinY());
        }
    }

    private void updateX(Stage stage, DialogPane dialogPane) {
        if (dialogPane.getScene() != null) {
            Parent root = stage.getScene().getRoot();
            Bounds screenBounds = root.localToScreen(root.getLayoutBounds());
            dialogPane.getScene().getWindow().setX(screenBounds.getMinX());
        }
    }

    public void hideWithAnimation() {
        if ((this.transition == null || this.transition.getStatus().equals((Object)Animation.Status.STOPPED)) && this.getAnimation() != null) {
            Animation animation = this.getAnimation().createHidingAnimation((Node)this.contentGroup, (Node)this.overlay);
            if (animation != null) {
                this.transition = animation;
                animation.setOnFinished(JFXAlert$$Lambda$8.lambdaFactory$(this));
                animation.play();
            } else {
                Platform.runLater((Runnable)JFXAlert$$Lambda$9.lambdaFactory$(this));
            }
        }
    }

    private void updateSize(DialogPane dialogPane) {
        if (dialogPane.getScene() != null) {
            dialogPane.getScene().getWindow().sizeToScene();
        }
    }

    public EventDispatchChain buildEventDispatchChain(EventDispatchChain tail) {
        return super.buildEventDispatchChain(tail).prepend((EventDispatcher)this.eventHandlerManager);
    }

    public void setContent(Node ... content) {
        this.contentContainer.getChildren().setAll((Object[])content);
    }

    public boolean isOverlayClose() {
        return this.overlayClose.get();
    }

    public BooleanProperty overlayCloseProperty() {
        return this.overlayClose;
    }

    public void setOverlayClose(boolean overlayClose) {
        this.overlayClose.set(overlayClose);
    }

    public JFXAlertAnimation getAnimation() {
        return (JFXAlertAnimation)this.animation.get();
    }

    public ObjectProperty<JFXAlertAnimation> animationProperty() {
        return this.animation;
    }

    public void setAnimation(JFXAlertAnimation animation) {
        this.animation.set((Object)animation);
    }

    public void setSize(double prefWidth, double prefHeight) {
        this.contentContainer.setPrefSize(prefWidth, prefHeight);
    }

    static /* synthetic */ void lambda$hideWithAnimation$8(JFXAlert this_, ActionEvent finish) {
        this_.hide();
        this_.transition = null;
    }

    static /* synthetic */ void lambda$new$7(JFXAlert this_, MouseEvent event) {
        if (this_.isOverlayClose()) {
            new Thread(JFXAlert$$Lambda$10.lambdaFactory$(this_)).start();
        }
    }

    static /* synthetic */ void lambda$null$6(JFXAlert this_) {
        this_.hideWithAnimation();
    }

    static /* synthetic */ void lambda$new$5(JFXAlert this_, DialogEvent event) {
        Animation animation;
        if (this_.getAnimation() != null && (animation = this_.getAnimation().createShowingAnimation((Node)this_.contentGroup, (Node)this_.overlay)) != null) {
            animation.play();
        }
    }

    static /* synthetic */ void lambda$new$4(JFXAlert this_, DialogEvent event) {
        if (this_.getAnimation() != null) {
            this_.getAnimation().initAnimation((Node)this_.contentGroup, (Node)this_.overlay);
        }
    }

    static /* synthetic */ void lambda$new$3(JFXAlert this_, Stage stage, DialogPane dialogPane, ObservableValue observable, Number oldValue, Number newValue) {
        this_.updateY(stage, dialogPane);
    }

    static /* synthetic */ void lambda$new$2(JFXAlert this_, Stage stage, DialogPane dialogPane, ObservableValue observable, Number oldValue, Number newValue) {
        this_.updateX(stage, dialogPane);
    }

    static /* synthetic */ void lambda$new$1(JFXAlert this_, DialogPane dialogPane, Observable observable) {
        this_.updateSize(dialogPane);
    }

    static /* synthetic */ void lambda$new$0(JFXAlert this_, DialogPane dialogPane, Observable observable) {
        this_.updateSize(dialogPane);
    }
}

