/*
 * Decompiled with CFR 0.152.
 */
package vin.mvv;

import com.jfoenix.controls.JFXCheckBox;
import com.jfoenix.controls.JFXComboBox;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Alert;
import javafx.scene.control.TextField;
import javafx.stage.Stage;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import vin.Class.WorkIndicatorDialog;
import vin.controller.FXMLDocumentController;

public class MVVDocumentoController
implements Initializable {
    String id_mvv = "";
    @FXML
    private JFXComboBox<String> cmbx_sigla;
    @FXML
    private TextField editText_serie;
    @FXML
    private TextField editText_numero;
    @FXML
    private JFXCheckBox chk_mexal;
    WorkIndicatorDialog wd = null;

    public void setId_mvv(String id_mvv) {
        this.id_mvv = id_mvv;
    }

    @FXML
    void btnAnnulla(ActionEvent event) {
        Stage stage = (Stage)this.editText_numero.getScene().getWindow();
        stage.close();
    }

    @FXML
    void btnSalva(ActionEvent event) {
        this.wd = new WorkIndicatorDialog(this.editText_numero.getScene().getWindow(), "Caricamento in corso...");
        this.wd.addTaskEndNotification(result -> {
            if (!this.wd.labelWord.equals("")) {
                try {
                    FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "ERRORE", this.wd.labelWord);
                }
                catch (Exception ex) {
                    Logger.getLogger(MVVDocumentoController.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                FXMLDocumentController.toast.startToast("SUCCESSO", "SUCCESSO", "SUCCESSO");
                Stage stage = (Stage)this.editText_numero.getScene().getWindow();
                stage.close();
            }
            this.wd = null;
        });
        this.wd.exec("123", inputParam -> {
            try {
                this.salva();
            }
            catch (Exception ex) {
                this.wd.labelWord = ex.toString();
            }
            return 1;
        });
    }

    private void salva() throws JSONException, IOException {
        String sigla = "";
        String serie = this.editText_serie.getText();
        String numero = this.editText_numero.getText();
        boolean mexal = this.chk_mexal.selectedProperty().getValue();
        if (this.cmbx_sigla.getSelectionModel().getSelectedItem() != null) {
            sigla = (String)this.cmbx_sigla.getSelectionModel().getSelectedItem();
        }
        ArrayList<String> docsMX = new ArrayList<String>();
        if (!sigla.equals("")) {
            if (mexal) {
                try {
                    docsMX.addAll(this.scrivoMexal(sigla));
                }
                catch (FileNotFoundException | URISyntaxException ex) {
                    this.wd.labelWord = this.wd.labelWord + "#ERR:" + ex.toString();
                    return;
                }
            }
        } else {
            sigla = "MVV";
        }
        this.insertOperazioneUSSD(this.id_mvv, docsMX, sigla, serie, numero);
    }

    private List<String> scrivoMexal(String sigla) throws JSONException, IOException, FileNotFoundException, URISyntaxException {
        ArrayList<String> docsMX = new ArrayList<String>();
        ArrayList<String> tipo = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Boolean> last_ID = new ArrayList<Boolean>();
        ArrayList lenghtBidimensionalArray = new ArrayList();
        String[][] tipo_ins = new String[100][100];
        String[][] valore = new String[100][100];
        boolean iterator = false;
        ArrayList<String> ar = new ArrayList<String>();
        tipo.add("select");
        String str = "SELECT IFNULL(b.prodotto_mx,'') AS prodotto_mx,IFNULL(b.num_colli,0) AS pz,IFNULL(b.qta,0) AS qta,IFNULL(c.sian_cod_stato_fisico,'') AS sian_cod_stato_fisico,IFNULL(sian_massa_volumica,'') AS sian_massa_volumica,IFNULL(b.lotto,'') AS lotto,IF(a.acq_codice='',a.dest_codice,a.acq_codice) AS cliente,CAST(IFNULL(DATE_FORMAT(a.data_trasporto,'%Y-%m-%d'),'') AS CHAR) AS data_oper FROM mvv_testata AS a LEFT JOIN mvv_corpo AS b ON a.id=b.id_testata LEFT JOIN gen_tipo_vino_ana AS c ON b.prodotto=c.codice AND b.azienda=c.azienda AND b.sotto_az=c.sotto_az AND b.icqrf=c.icqrf AND b.cod_committente=c.cod_committente WHERE a.id=" + this.id_mvv;
        strSQL.add(str);
        this.wd.labelWord = this.wd.labelWord + "#ERR: " + str + "\n";
        last_ID.add(false);
        String strd = FXMLDocumentController.util.makeStringJsonDB("OFF", tipo, strSQL, null, null, last_ID, null);
        String data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strd);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrays = new JSONArray(data_select);
            for (int i = 0; i < arrays.length(); ++i) {
                JSONObject obj = arrays.getJSONObject(i);
                String prodotto_mx = obj.get("prodotto_mx").toString();
                if (prodotto_mx.equals("")) continue;
                String sian_cod_stato_fisico = obj.get("sian_cod_stato_fisico").toString();
                String pz = obj.get("pz").toString();
                String qta = obj.get("qta").toString();
                String sian_massa_volumica = obj.get("sian_massa_volumica").toString();
                String lotto = obj.get("lotto").toString();
                String cliente = obj.get("cliente").toString().replace("null", "");
                String data_oper = obj.get("data_oper").toString();
                ar.add(prodotto_mx + "|" + sian_cod_stato_fisico + "|" + pz + "|" + qta + "|" + sian_massa_volumica + "|" + lotto + "|" + cliente + "|" + data_oper);
            }
        }
        if (ar.size() > 0) {
            ArrayList<String> prodotto = new ArrayList<String>();
            ArrayList<Double> qtas = new ArrayList<Double>();
            ArrayList<String> lotto_b = new ArrayList<String>();
            ArrayList<Double> lotto_qta = new ArrayList<Double>();
            ArrayList<String> iva_prodotto = new ArrayList<String>();
            HashMap lis = FXMLDocumentController.util.getParameters();
            Boolean collegamento_wbsmexallotti = Boolean.parseBoolean(lis.get("WBS_MEXAL_LOTTI").toString());
            String cliente = "";
            String data_oper = "";
            for (int i = 0; i < ar.size(); ++i) {
                String[] res = ((String)ar.get(i)).split("\\|", -1);
                String prodotto_mx = res[0];
                String sian_cod_stato_fisico = res[1];
                String pz = res[2].replace("-", "");
                String qta = res[3].replace("-", "");
                if (qta.equals("")) {
                    qta = "0";
                }
                if (pz.equals("")) {
                    pz = "0";
                }
                String sian_massa_volumica = res[4];
                String lotto = res[5];
                cliente = res[6];
                data_oper = res[7];
                if (sian_cod_stato_fisico.equals("1") || sian_cod_stato_fisico.equals("")) {
                    prodotto.add(prodotto_mx);
                    qtas.add(Double.parseDouble(qta));
                    lotto_b.add("");
                    lotto_qta.add(0.0);
                    iva_prodotto.add(FXMLDocumentController.util.getIvaArtMexal(prodotto_mx));
                    continue;
                }
                prodotto.add(prodotto_mx);
                qtas.add(Double.parseDouble(pz));
                lotto_b.add(lotto);
                lotto_qta.add(Double.parseDouble(pz));
                iva_prodotto.add(FXMLDocumentController.util.getIvaArtMexal(prodotto_mx));
            }
            String tipo_mov = "SCA";
            String numero = FXMLDocumentController.ricerca.getNumeroDocumentoMX(sigla, tipo_mov, 0);
            this.wd.labelWord = FXMLDocumentController.util.createDocMX(data_oper, qtas, prodotto, sigla, tipo_mov, "MVV", lotto_b, iva_prodotto, lotto_qta, 0, collegamento_wbsmexallotti, false, cliente, FXMLDocumentController.GLOBAL_MAGAZZINO, numero);
            if (!this.wd.labelWord.contains("#ERR")) {
                docsMX.add(this.wd.labelWord);
                this.wd.labelWord = "";
            }
        }
        return docsMX;
    }

    private void insertOperazioneUSSD(String id_mvv, List<String> docsMX, String sigla, String seriex, String numerox) throws JSONException, IOException {
        String data_oper = "";
        String mx_doc_clifor = "";
        String numero_doc_giustificativo = "";
        String data_doc_giusitficativo = "";
        ArrayList<String> tipoSQLmx = new ArrayList<String>();
        ArrayList<String> strSQLmx = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArraymx = new ArrayList<Integer>();
        ArrayList<Boolean> lastIDmx = new ArrayList<Boolean>();
        String[][] tipo_insmx = null;
        String[][] valoremx = null;
        HashMap<Integer, String[]> ipos = new HashMap<Integer, String[]>();
        HashMap<Integer, String[]> alores = new HashMap<Integer, String[]>();
        int iterator = 0;
        boolean errata_postazione = false;
        boolean cod_fornesi = false;
        String[] res = new String[1];
        String str = "SELECT acq_cuaa,IF(a.acq_ragsoc='',IF(a.acq_nome ='','',CONCAT(a.acq_nome,'-' ,a.acq_cognome)),a.acq_ragsoc ) AS acq_nome ,IFNULL(DATE_FORMAT(a.data_trasporto,'%Y-%m-%d'),'') AS data_oper,IFNULL(c.sian_massa_volumica,0) AS sian_massa_volumica,b.invio_vaso,c.sian_cod_stato_fisico,a.numeromvvreale,a.data_trasporto,IF(IFNULL(a.ldest_codice,'')='',a.dest_codice,a.ldest_codice) AS dest_codice,b.prodotto,b.titolo_alcoltot,b.titolo_alcolpot,b.titolo_alcoleff,b.tenore_zucchero,b.num_colli,b.numero_imballi,b.qta,b.um_imballi,b.um,b.capacita_imballi,b.data_cert,b.num_prot,b.ente_cert,b.gg_invecchiamento,b.prodotto_mx,b.lotto,b.codice_vasca,IFNULL(g.id,0) AS id_vaso,b.numero_imballi AS pz,b.percigp,a.cod_committente,a.vend_codice FROM mvv_testata AS a LEFT JOIN mvv_corpo AS b ON a.id=b.id_testata LEFT JOIN gen_tipo_vino_ana AS c ON b.prodotto=c.codice AND b.azienda=c.azienda AND b.sotto_az=c.sotto_az AND b.icqrf=c.icqrf AND b.cod_committente=c.cod_committente LEFT JOIN gen_vasi_vinari_ana AS g ON b.azienda=g.azienda AND b.codice_vasca=g.codice_vaso  AND b.icqrf=g.icqrf  WHERE a.id=" + id_mvv + " GROUP BY b.id ";
        lastIDmx.add(false);
        tipoSQLmx.add("select");
        strSQLmx.add(str);
        lenghtBidimensionalArraymx.add(0);
        res[0] = "";
        ipos.put(iterator, res);
        alores.put(iterator, res);
        ++iterator;
        tipo_insmx = FXMLDocumentController.util.HashMapBidimensionalTOArrayBidimensional(ipos);
        valoremx = FXMLDocumentController.util.HashMapBidimensionalTOArrayBidimensional(alores);
        String strd = FXMLDocumentController.util.makeStringJsonDB("OFF", tipoSQLmx, strSQLmx, null, null, lastIDmx, null);
        String data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strd);
        if (!data_select.contains("#ERR:")) {
            ipos.clear();
            alores.clear();
            strSQLmx.clear();
            lastIDmx.clear();
            lenghtBidimensionalArraymx.clear();
            tipoSQLmx.clear();
            tipo_insmx = null;
            valoremx = null;
            iterator = 0;
            JSONArray arrayJson = FXMLDocumentController.jsonUtil.strJsonToJSONArray(data_select);
            List<String> codcomm = FXMLDocumentController.ricerca.getCommittentiFromDB(FXMLDocumentController.GLOBAL_AZIENDA, FXMLDocumentController.GLOBAL_SOTTOAZZ, FXMLDocumentController.GLOBAL_ICQRF);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject obj = arrayJson.getJSONObject(i);
                data_oper = obj.get("data_oper").toString();
                String vend_codice = obj.get("vend_codice").toString().replace("null", "");
                for (int j = 0; j < codcomm.size(); ++j) {
                    if (!vend_codice.equals(codcomm.get(i))) continue;
                    cod_fornesi = true;
                }
                if (vend_codice.equals(FXMLDocumentController.GLOBAL_CODCOMM) && cod_fornesi || !cod_fornesi && vend_codice.equals(FXMLDocumentController.GLOBAL_CODCOMM)) {
                    String prodotto = obj.get("prodotto").toString().replace("null", "");
                    String sian_cod_stato_fisico = obj.get("sian_cod_stato_fisico").toString().replace("null", "");
                    String invio_vaso = obj.get("invio_vaso").toString().replace("null", "");
                    String titolo_alcoltot = obj.get("titolo_alcoltot").toString().replace("null", "");
                    String id_vaso = obj.get("id_vaso").toString().replace("null", "");
                    String titolo_alcoleff = obj.get("titolo_alcoleff").toString().replace("null", "");
                    String titolo_alcolpot = obj.get("titolo_alcolpot").toString().replace("null", "");
                    String tenore_zucchero = obj.get("tenore_zucchero").toString().replace("null", "");
                    String num_colli = obj.get("num_colli").toString().replace("null", "");
                    String numero_imballi = obj.get("numero_imballi").toString().replace("null", "");
                    String qta = obj.get("qta").toString().replace("null", "");
                    String um_imballi = obj.get("um_imballi").toString().replace("null", "");
                    String um_mis = obj.get("um").toString().replace("null", "");
                    String capacita_imballi = obj.get("capacita_imballi").toString().replace("null", "");
                    String data_cert = obj.get("data_cert").toString().replace("null", "");
                    String num_prot = obj.get("num_prot").toString().replace("null", "");
                    String ente_cert = obj.get("ente_cert").toString().replace("null", "");
                    String gg_invecchiamento = obj.get("gg_invecchiamento").toString().replace("null", "");
                    String prodotto_mx = obj.get("prodotto_mx").toString().replace("null", "");
                    String lotto = obj.get("lotto").toString().replace("null", "");
                    String codice_vasca = obj.get("codice_vasca").toString().replace("null", "");
                    String acq_nome = obj.get("acq_nome").toString().replace("null", "");
                    String acq_cuaa = obj.get("acq_cuaa").toString().replace("null", "");
                    String pz = obj.get("pz").toString().replace("null", "");
                    String litri = obj.get("qta").toString().replace("null", "");
                    String percigp = obj.get("percigp").toString().replace("null", "");
                    String numeromvv = obj.get("numeromvvreale").toString().replace("null", "");
                    String dest_codice = obj.get("dest_codice").toString().replace("null", "");
                    double massa = Double.parseDouble(obj.get("sian_massa_volumica").toString().replace("null", ""));
                    if (i == 0) {
                        String note = "";
                        if (!acq_nome.equals("")) {
                            note = "ACQUIRENTE: " + acq_nome + " - " + acq_cuaa;
                        }
                        if (!numerox.equals("") && docsMX.size() > 0) {
                            String[] a = docsMX.get(0).trim().split("\\|");
                            numerox = a[2];
                        }
                        FXMLDocumentController.sqlUtil.insert_c_operazioni(FXMLDocumentController.GLOBAL_AZIENDA, FXMLDocumentController.GLOBAL_SOTTOAZZ, FXMLDocumentController.GLOBAL_ICQRF, "SR", data_oper, "0", sigla, seriex, numerox, "0", "0", dest_codice, "", "", "", "", "", "", "", "", "", "", "", "", "", "", "0", FXMLDocumentController.GLOBAL_CODCOMM, "", note, "1", data_oper, data_oper, numeromvv, "2147483647", "", "", "", "");
                        strSQLmx.addAll(FXMLDocumentController.sqlUtil.strSQL);
                        tipoSQLmx.addAll(FXMLDocumentController.sqlUtil.tipoinsSQL);
                        lenghtBidimensionalArraymx.addAll(FXMLDocumentController.sqlUtil.lengthSQL);
                        lastIDmx.addAll(FXMLDocumentController.sqlUtil.lastID);
                        ipos.put(iterator, FXMLDocumentController.sqlUtil.tipovaloreSQL.toArray(new String[0]));
                        alores.put(iterator, FXMLDocumentController.sqlUtil.valoreSQL.toArray(new String[0]));
                        ++iterator;
                        lastIDmx.add(false);
                        tipoSQLmx.add("insert");
                        strSQLmx.add("SET @id_oper:=(LAST_INSERT_ID());");
                        lenghtBidimensionalArraymx.add(0);
                        res[0] = "";
                        ipos.put(iterator, res);
                        alores.put(iterator, res);
                        ++iterator;
                        FXMLDocumentController.sqlUtil.update_mvv_testata(id_mvv, "@id_oper");
                        strSQLmx.addAll(FXMLDocumentController.sqlUtil.strSQL);
                        tipoSQLmx.addAll(FXMLDocumentController.sqlUtil.tipoinsSQL);
                        lenghtBidimensionalArraymx.addAll(FXMLDocumentController.sqlUtil.lengthSQL);
                        lastIDmx.addAll(FXMLDocumentController.sqlUtil.lastID);
                        ipos.put(iterator, FXMLDocumentController.sqlUtil.tipovaloreSQL.toArray(new String[0]));
                        alores.put(iterator, FXMLDocumentController.sqlUtil.valoreSQL.toArray(new String[0]));
                        ++iterator;
                        for (int j = 0; j < docsMX.size(); ++j) {
                            String[] a = docsMX.get(j).trim().split("\\|");
                            String siglas = a[0];
                            int serie = (int)Math.floor(Double.parseDouble(a[1]));
                            int numero = (int)Math.floor(Double.parseDouble(a[2]));
                            int causale = (int)Math.floor(Double.parseDouble(a[5]));
                            int magazzino = (int)Math.floor(Double.parseDouble(a[6]));
                            String anno = a[3].substring(0, 4);
                            String mese = a[3].substring(5, 7);
                            String gg = a[3].substring(8, 10);
                            String data = anno + "-" + mese + "-" + gg;
                            String tipo_mov = a[4];
                            FXMLDocumentController.sqlUtil.insert_c_movimenti_mx(FXMLDocumentController.GLOBAL_AZIENDA, FXMLDocumentController.GLOBAL_SOTTOAZZ, FXMLDocumentController.GLOBAL_ICQRF, "@id_oper", siglas, serie + "", numero + "", data, causale + "", magazzino + "", "", "", "", "", "", "", "", "", "", "", "", "", "", tipo_mov, FXMLDocumentController.GLOBAL_CODCOMM);
                            strSQLmx.addAll(FXMLDocumentController.sqlUtil.strSQL);
                            tipoSQLmx.addAll(FXMLDocumentController.sqlUtil.tipoinsSQL);
                            lenghtBidimensionalArraymx.addAll(FXMLDocumentController.sqlUtil.lengthSQL);
                            lastIDmx.addAll(FXMLDocumentController.sqlUtil.lastID);
                            ipos.put(iterator, FXMLDocumentController.sqlUtil.tipovaloreSQL.toArray(new String[0]));
                            alores.put(iterator, FXMLDocumentController.sqlUtil.valoreSQL.toArray(new String[0]));
                            ++iterator;
                        }
                    }
                    String categoria = FXMLDocumentController.ricerca.getCategoriaProdottofromProdotto(prodotto);
                    String um = FXMLDocumentController.ricerca.getUMfromCategoriaProdotto(categoria);
                    if (um_mis.toLowerCase().equals("kg") && massa > 0.0) {
                        litri = String.valueOf(FXMLDocumentController.util.MyMathRound(Double.parseDouble(qta) * massa, 3));
                    } else if (um_mis.toLowerCase().equals("ton") && massa > 0.0) {
                        qta = String.valueOf(FXMLDocumentController.util.MyMathRound(Double.parseDouble(qta) * 1000.0, 3));
                        litri = String.valueOf(FXMLDocumentController.util.MyMathRound(Double.parseDouble(qta) * massa, 3));
                    } else {
                        litri = um_mis.toLowerCase().equals("hl") && massa > 0.0 ? (qta = String.valueOf(FXMLDocumentController.util.MyMathRound(Double.parseDouble(qta) * 100.0, 3))) : (um_mis.toLowerCase().equals("l") && massa > 0.0 || sian_cod_stato_fisico.equals("1") ? qta : (um_mis.toLowerCase().equals("ton") && massa <= 0.0 ? (qta = String.valueOf(FXMLDocumentController.util.MyMathRound(Double.parseDouble(qta) * 1000.0, 3))) : (um_mis.toLowerCase().equals("hl") && massa <= 0.0 ? (qta = String.valueOf(FXMLDocumentController.util.MyMathRound(Double.parseDouble(qta) * 100.0, 3))) : qta)));
                    }
                    FXMLDocumentController.sqlUtil.insert_c_movimenti(FXMLDocumentController.GLOBAL_AZIENDA, FXMLDocumentController.GLOBAL_SOTTOAZZ, "@id_oper", "S", prodotto, num_prot, ente_cert, data_cert, capacita_imballi, Double.parseDouble(qta) + "", Double.parseDouble(qta) + "", sian_cod_stato_fisico, FXMLDocumentController.GLOBAL_ICQRF, "B", pz, FXMLDocumentController.GLOBAL_CODCOMM, prodotto_mx, gg_invecchiamento, percigp, titolo_alcoltot, titolo_alcolpot, titolo_alcoleff, tenore_zucchero, "", "", "", "", "");
                    strSQLmx.addAll(FXMLDocumentController.sqlUtil.strSQL);
                    tipoSQLmx.addAll(FXMLDocumentController.sqlUtil.tipoinsSQL);
                    lenghtBidimensionalArraymx.addAll(FXMLDocumentController.sqlUtil.lengthSQL);
                    lastIDmx.addAll(FXMLDocumentController.sqlUtil.lastID);
                    ipos.put(iterator, FXMLDocumentController.sqlUtil.tipovaloreSQL.toArray(new String[0]));
                    alores.put(iterator, FXMLDocumentController.sqlUtil.valoreSQL.toArray(new String[0]));
                    ++iterator;
                    lastIDmx.add(false);
                    tipoSQLmx.add("insert");
                    strSQLmx.add("SET @id_mov:=(LAST_INSERT_ID());");
                    lenghtBidimensionalArraymx.add(0);
                    res[0] = "";
                    ipos.put(iterator, res);
                    alores.put(iterator, res);
                    ++iterator;
                    if (um.toLowerCase().equals("l") && sian_cod_stato_fisico.equals("1") || um.toLowerCase().equals("kg") && massa > 0.0) {
                        FXMLDocumentController.sqlUtil.insert_gen_vasi_vinari_mov(FXMLDocumentController.GLOBAL_AZIENDA, FXMLDocumentController.GLOBAL_SOTTOAZZ, "@id_mov", id_vaso, "0", "MVV", prodotto, Double.parseDouble(qta) + "", FXMLDocumentController.GLOBAL_ICQRF, FXMLDocumentController.GLOBAL_CODCOMM, invio_vaso);
                        strSQLmx.addAll(FXMLDocumentController.sqlUtil.strSQL);
                        tipoSQLmx.addAll(FXMLDocumentController.sqlUtil.tipoinsSQL);
                        lenghtBidimensionalArraymx.addAll(FXMLDocumentController.sqlUtil.lengthSQL);
                        lastIDmx.addAll(FXMLDocumentController.sqlUtil.lastID);
                        ipos.put(iterator, FXMLDocumentController.sqlUtil.tipovaloreSQL.toArray(new String[0]));
                        alores.put(iterator, FXMLDocumentController.sqlUtil.valoreSQL.toArray(new String[0]));
                        ++iterator;
                    }
                    if (sian_cod_stato_fisico.equals("1") || sian_cod_stato_fisico.equals("")) continue;
                    if (num_colli.equals("")) {
                        num_colli = "0";
                    }
                    FXMLDocumentController.sqlUtil.insert_c_movimenti_lotti("@id_mov", FXMLDocumentController.GLOBAL_AZIENDA, FXMLDocumentController.GLOBAL_SOTTOAZZ, lotto, String.valueOf(-1.0 * Double.parseDouble(pz)), FXMLDocumentController.GLOBAL_ICQRF, prodotto_mx, FXMLDocumentController.GLOBAL_CODCOMM);
                    strSQLmx.addAll(FXMLDocumentController.sqlUtil.strSQL);
                    tipoSQLmx.addAll(FXMLDocumentController.sqlUtil.tipoinsSQL);
                    lenghtBidimensionalArraymx.addAll(FXMLDocumentController.sqlUtil.lengthSQL);
                    lastIDmx.addAll(FXMLDocumentController.sqlUtil.lastID);
                    ipos.put(iterator, FXMLDocumentController.sqlUtil.tipovaloreSQL.toArray(new String[0]));
                    alores.put(iterator, FXMLDocumentController.sqlUtil.valoreSQL.toArray(new String[0]));
                    ++iterator;
                    continue;
                }
                errata_postazione = true;
            }
        }
        if (!errata_postazione) {
            tipo_insmx = FXMLDocumentController.util.HashMapBidimensionalTOArrayBidimensional(ipos);
            valoremx = FXMLDocumentController.util.HashMapBidimensionalTOArrayBidimensional(alores);
            strd = FXMLDocumentController.util.makeStringJsonDB("ON", tipoSQLmx, strSQLmx, tipo_insmx, valoremx, lastIDmx, lenghtBidimensionalArraymx);
            data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strd);
            if (data_select.contains("#ERR:")) {
                this.wd.labelWord = this.wd.labelWord + data_select;
            }
        } else {
            this.wd.labelWord = this.wd.labelWord + "#ERR: Errata postazione, eseguire operazione dal committente";
        }
    }

    private void fillComboBox() {
        this.cmbx_sigla.getItems().add((Object)"");
        this.cmbx_sigla.getItems().add((Object)"SL");
        this.cmbx_sigla.getItems().add((Object)"BC");
        this.cmbx_sigla.getItems().add((Object)"FT");
        this.cmbx_sigla.getItems().add((Object)"BS");
    }

    public void initialize(URL url, ResourceBundle rb) {
        this.fillComboBox();
    }
}

