/*
 * Decompiled with CFR 0.152.
 */
package vin.guigarage;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javafx.beans.property.StringProperty;
import javafx.collections.ListChangeListener;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.stage.Window;

public class Util {
    public static List<Node> getAllNodesInWindow(Window window) {
        Parent root = Optional.of(window).map(w -> w.getScene()).map(s -> s.getRoot()).get();
        if (root == null) {
            return new ArrayList<Node>();
        }
        ArrayList<Node> ret = new ArrayList<Node>();
        ret.add((Node)root);
        ret.addAll(Util.getAllNodesInParent(root));
        return ret;
    }

    public static List<Node> getAllNodesInParent(Parent parent) {
        ArrayList<Node> ret = new ArrayList<Node>();
        for (Node child : parent.getChildrenUnmodifiable()) {
            ret.add(child);
            if (!(child instanceof Parent)) continue;
            ret.addAll(Util.getAllNodesInParent((Parent)child));
        }
        return ret;
    }

    private static ListChangeListener<Node> createRecursiveChildObserver(final Consumer<Node> onRemove, final Consumer<Node> onAdd) {
        return new ListChangeListener<Node>(){

            public void onChanged(ListChangeListener.Change<? extends Node> change) {
                while (change.next()) {
                    if (change.wasAdded()) {
                        for (Node addedChild : change.getAddedSubList()) {
                            if (addedChild instanceof Parent) {
                                ((Parent)addedChild).getChildrenUnmodifiable().addListener((ListChangeListener)this);
                            }
                            onAdd.accept(addedChild);
                        }
                    }
                    if (!change.wasRemoved()) continue;
                    for (Node removedChild : change.getRemoved()) {
                        if (removedChild instanceof Parent) {
                            ((Parent)removedChild).getChildrenUnmodifiable().removeListener((ListChangeListener)this);
                        }
                        onRemove.accept(removedChild);
                    }
                }
            }
        };
    }

    public static void registerRecursiveChildObserver(Window window, Consumer<Node> onRemove, Consumer<Node> onAdd) {
        List<Node> allNodes = Util.getAllNodesInWindow(window);
        ListChangeListener<Node> listener = Util.createRecursiveChildObserver(onRemove, onAdd);
        for (Node child : allNodes) {
            if (!(child instanceof Parent)) continue;
            Parent parent = (Parent)child;
            parent.getChildrenUnmodifiable().addListener(listener);
        }
    }

    public static void bindStyleSheetToWindow(Window window, StringProperty stylesheet) {
        window.sceneProperty().addListener(e -> {
            if (window.getScene() != null) {
                window.getScene().getStylesheets().add(stylesheet.get());
            }
        });
        if (window.getScene() != null) {
            window.getScene().getStylesheets().add(stylesheet.get());
        }
        stylesheet.addListener((obs, o, n) -> {
            if (window.getScene() != null) {
                int oldPos = -1;
                if (o != null) {
                    oldPos = window.getScene().getStylesheets().indexOf(o);
                    window.getScene().getStylesheets().remove(o);
                }
                if (n != null) {
                    if (oldPos >= 0) {
                        window.getScene().getStylesheets().add(oldPos, n);
                    } else {
                        window.getScene().getStylesheets().add(n);
                    }
                }
            }
        });
    }
}

