/*
 * Decompiled with CFR 0.152.
 */
package vin.guigarage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javafx.css.PseudoClass;

public enum DeviceType {
    EXTRA_SMALL,
    SMALL,
    MEDIUM,
    LARGE,
    NONE;

    public static final String STYLESHEET_XS = "skin-xs.css";
    public static final String STYLESHEET_SM = "skin-sm.css";
    public static final String STYLESHEET_MD = "skin-md.css";
    public static final String STYLESHEET_LG = "skin-lg.css";
    public static final double MAX_SIZE_XS = 400.0;
    public static final double MAX_SIZE_SM = 768.0;
    public static final double MAX_SIZE_MD = 979.0;
    public static final PseudoClass PSEUDO_CLASS_XS;
    public static final PseudoClass PSEUDO_CLASS_SM;
    public static final PseudoClass PSEUDO_CLASS_MD;
    public static final PseudoClass PSEUDO_CLASS_LG;
    public static final String STYLE_CLASS_XS_HIDDEN = "hidden-xs";
    public static final String STYLE_CLASS_SM_HIDDEN = "hidden-sm";
    public static final String STYLE_CLASS_MD_HIDDEN = "hidden-md";
    public static final String STYLE_CLASS_LG_HIDDEN = "hidden-lg";
    public static final String STYLE_CLASS_XS_VISIBLE = "visible-xs";
    public static final String STYLE_CLASS_SM_VISIBLE = "visible-sm";
    public static final String STYLE_CLASS_MD_VISIBLE = "visible-md";
    public static final String STYLE_CLASS_LG_VISIBLE = "visible-lg";

    public static DeviceType getForWidth(double width) {
        if (width < 400.0) {
            return EXTRA_SMALL;
        }
        if (width < 768.0) {
            return SMALL;
        }
        if (width < 979.0) {
            return MEDIUM;
        }
        return LARGE;
    }

    public static List<PseudoClass> getAllClasses() {
        return new ArrayList<PseudoClass>(Arrays.asList(PSEUDO_CLASS_XS, PSEUDO_CLASS_SM, PSEUDO_CLASS_MD, PSEUDO_CLASS_LG));
    }

    public List<PseudoClass> getInactiveClasses() {
        List<PseudoClass> classes = DeviceType.getAllClasses();
        classes.removeAll(this.getActiveClasses());
        return classes;
    }

    public List<PseudoClass> getActiveClasses() {
        if (this.equals((Object)EXTRA_SMALL)) {
            return Collections.singletonList(PSEUDO_CLASS_XS);
        }
        if (this.equals((Object)SMALL)) {
            return Collections.singletonList(PSEUDO_CLASS_SM);
        }
        if (this.equals((Object)MEDIUM)) {
            return Collections.singletonList(PSEUDO_CLASS_MD);
        }
        return Collections.singletonList(PSEUDO_CLASS_LG);
    }

    public String getStylesheet() {
        if (this.equals((Object)EXTRA_SMALL)) {
            return DeviceType.class.getResource("/vin/css/skin-xs.css").toExternalForm();
        }
        if (this.equals((Object)SMALL)) {
            return DeviceType.class.getResource("/vin/css/skin-sm.css").toExternalForm();
        }
        if (this.equals((Object)MEDIUM)) {
            return DeviceType.class.getResource("/vin/css/skin-md.css").toExternalForm();
        }
        return DeviceType.class.getResource("/vin/css/skin-lg.css").toExternalForm();
    }

    static {
        PSEUDO_CLASS_XS = PseudoClass.getPseudoClass((String)"extreme-small-device");
        PSEUDO_CLASS_SM = PseudoClass.getPseudoClass((String)"small-device");
        PSEUDO_CLASS_MD = PseudoClass.getPseudoClass((String)"medium-device");
        PSEUDO_CLASS_LG = PseudoClass.getPseudoClass((String)"large-device");
    }
}

