/*
 * Decompiled with CFR 0.152.
 */
package vin.fascette.controller;

import com.jfoenix.controls.JFXDatePicker;
import java.io.IOException;
import java.net.URL;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Label;
import org.json.JSONException;
import vin.Class.WorkIndicatorDialog;
import vin.Uility.JasperReport;
import vin.controller.FXMLDocumentController;

public class StampaInventarioController
implements Initializable {
    WorkIndicatorDialog wd = null;
    @FXML
    private Label label_alladata;
    @FXML
    private JFXDatePicker dtp_alladata;
    JasperReport jasperReport = new JasperReport();

    public void initialize(URL url, ResourceBundle rb) {
        this.dtp_alladata.setValue((Object)LocalDate.now());
    }

    @FXML
    private void btnActionStampa(ActionEvent event) throws IOException, JSONException {
        String alla_data = ((LocalDate)this.dtp_alladata.getValue()).toString();
        if (alla_data.equals("")) {
            FXMLDocumentController.toast.startToast("(Alla Data) Campo obbligatorio", "ERRORE", "ERRORE");
            return;
        }
        this.wd = new WorkIndicatorDialog(this.dtp_alladata.getScene().getWindow(), "Caricamento in corso...");
        this.wd.addTaskEndNotification(result -> {
            System.out.println(result);
            this.wd = null;
        });
        this.wd.exec("123", inputParam -> {
            try {
                String dalladata = "";
                int mese = ((LocalDate)this.dtp_alladata.getValue()).getMonthValue();
                if (!FXMLDocumentController.ricerca.getIfChiusuraNeverWBS(FXMLDocumentController.GLOBAL_AZIENDA, FXMLDocumentController.GLOBAL_SOTTOAZZ, FXMLDocumentController.GLOBAL_ICQRF)) {
                    String anno = String.valueOf(((LocalDate)this.dtp_alladata.getValue()).getYear());
                    if (LocalDate.now().getYear() >= ((LocalDate)this.dtp_alladata.getValue()).getYear()) {
                        if (mese < 8) {
                            dalladata = FXMLDocumentController.ricerca.getDataPerStampaDalla(String.valueOf(Integer.parseInt(anno)));
                            if (dalladata.equals("")) {
                                dalladata = Integer.parseInt(anno) - 1 + "-08-01";
                            }
                        } else {
                            String datas = FXMLDocumentController.ricerca.getDataPerStampaDallaPrima(anno);
                            dalladata = !datas.equals("") ? datas : anno + "-08-01";
                        }
                    } else {
                        dalladata = String.valueOf(LocalDate.now().getYear()) + "-08-01";
                    }
                } else {
                    dalladata = "2017-01-01";
                }
                ArrayList<String> key = new ArrayList<String>();
                ArrayList<Object> value = new ArrayList<Object>();
                key.add("QUERY");
                key.add("AZIENDA");
                key.add("SOTTO_AZ");
                key.add("ICQRF");
                key.add("COD_COMMITTENTE");
                value.add(this.getSelect(dalladata, alla_data));
                value.add(FXMLDocumentController.GLOBAL_AZIENDA);
                value.add(FXMLDocumentController.GLOBAL_SOTTOAZZ);
                value.add(FXMLDocumentController.GLOBAL_ICQRF);
                value.add(FXMLDocumentController.GLOBAL_CODCOMM);
                int tipoStampa = 2;
                String nomeFileJRXML = "";
                nomeFileJRXML = "inventario_faE.jrxml";
                String resp = this.jasperReport.JSONjr(nomeFileJRXML, key, value, tipoStampa, "");
                String nomeFile = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "JasperReport#@" + resp);
                FXMLDocumentController.util.downloadFileTemp(nomeFile);
            }
            catch (Exception ex) {
                System.out.println(ex.toString());
            }
            return 1;
        });
    }

    private String getSelect(String dalla_data, String alla_data) {
        String ret = "";
        ret = "SELECT a.data_operazione,a.sigla,a.codice_prodotto,a.num_protocollo,a.data_ido,a.ente_cert,a.lotto,a.serie,a.da_numero,a.a_numero,b.descrizione AS descr_prod \nFROM movimenti_fascette AS a\nLEFT JOIN gen_tipo_vino_ana AS b ON a.codice_prodotto=b.codice AND a.azienda=b.azienda AND a.sotto_az=b.sotto_az AND a.icqrf=b.icqrf AND a.cod_committente=b.cod_committente\nWHERE a.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND a.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND a.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND a.cod_committente=''\nAND a.data_operazione<='" + alla_data + "' AND a.data_operazione>='" + dalla_data + "'";
        return ret;
    }
}

