/*
 * Decompiled with CFR 0.152.
 */
package vin.fascette.controller;

import com.jfoenix.controls.JFXButton;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URL;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ChoiceDialog;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputDialog;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.DragEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.util.Callback;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import vin.Class.CodiceDescrizione;
import vin.Class.ColumnOperazioniFascette;
import vin.Class.IdoneitaImbSfuso;
import vin.Class.WorkIndicatorDialog;
import vin.controller.FXMLDocumentController;
import vin.controller.SearchCertPool;
import vin.controller.SearchProdottoController_2;
import vin.fascette.controller.FinestraCercaLottoController;
import vin.fascette.controller.FinestraFascetteDisponibiliController;
import vin.fascette.controller.SearchButtonFascetteController;

public class OperazioneFascetteController
implements Initializable {
    @FXML
    private TableView<ColumnOperazioniFascette> table;
    @FXML
    private StackPane stackmaster;
    @FXML
    private JFXButton btn_nuovoMovimento;
    @FXML
    private JFXButton btn_cancella_movimento;
    @FXML
    private JFXButton btn_modifica_movimento;
    @FXML
    private ComboBox<CodiceDescrizione> cmbx_sigla;
    @FXML
    private TextField editText_prodotto;
    @FXML
    private TextField editText_serie;
    @FXML
    private TextField editText_da;
    @FXML
    private TextField editText_a;
    @FXML
    private TableColumn<ColumnOperazioniFascette, String> column_sigla;
    @FXML
    private TableColumn<ColumnOperazioniFascette, String> column_prodotto;
    @FXML
    private TableColumn<ColumnOperazioniFascette, String> column_serie;
    @FXML
    private TableColumn<ColumnOperazioniFascette, String> column_da;
    @FXML
    private TableColumn<ColumnOperazioniFascette, String> column_a;
    private ObservableList<CodiceDescrizione> lista_bio = FXCollections.observableArrayList();
    private ObservableList<ColumnOperazioniFascette> lista_table = FXCollections.observableArrayList();
    WorkIndicatorDialog wd = null;
    boolean flg_modifica = false;
    @FXML
    private DatePicker dtp_dataoperazione;
    double xOffset = 0.0;
    double yOffset = 0.0;
    String id = "";
    @FXML
    private StackPane stackmas;
    @FXML
    private TextField editText_numprot;
    @FXML
    private DatePicker dtp_dataido;
    @FXML
    private TextField editText_entecert;
    @FXML
    private TextField editText_lotto;
    @FXML
    private TextField editText_totale;
    public ObservableList<IdoneitaImbSfuso> lista_cmbxidoneita_ve = FXCollections.observableArrayList();

    public void initialize(URL url, ResourceBundle rb) {
        this.column_sigla.setCellValueFactory((Callback)new PropertyValueFactory("column_sigla"));
        this.column_serie.setCellValueFactory((Callback)new PropertyValueFactory("column_serie"));
        this.column_prodotto.setCellValueFactory((Callback)new PropertyValueFactory("column_prodotto"));
        this.column_a.setCellValueFactory((Callback)new PropertyValueFactory("column_a"));
        this.column_da.setCellValueFactory((Callback)new PropertyValueFactory("column_da"));
        this.table.setItems(this.lista_table);
        this.lista_bio.add((Object)new CodiceDescrizione("FA", "CARICA FASCETTE"));
        this.lista_bio.add((Object)new CodiceDescrizione("FO", "ROTTURA FASCETTE"));
        this.cmbx_sigla.setItems(this.lista_bio);
        FXMLDocumentController.util.addTextToUpperCase(this.editText_serie);
        this.editText_a.textProperty().addListener((observable, oldValue, newValue) -> {
            try {
                if (!newValue.equals("") && newValue.length() >= 1) {
                    String da = this.editText_da.getText().trim();
                    if (da.equals("")) {
                        da = "0";
                    }
                    String a = newValue;
                    String totale = new BigInteger(a).subtract(new BigInteger(da)).add(new BigInteger("1")).toString();
                    this.editText_totale.setText(totale);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.editText_prodotto.textProperty().addListener((observable, oldValue, newValue) -> {
            try {
                if (!newValue.equals("") && newValue.length() == 1) {
                    FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/vin/view/SearchProdotto_2.fxml"));
                    Stage stage = new Stage();
                    stage.setMaximized(false);
                    stage.setTitle("Prodotto");
                    stage.setScene(new Scene((Parent)((Pane)loader.load())));
                    SearchProdottoController_2 controller = (SearchProdottoController_2)loader.getController();
                    controller.setSearch((String)newValue, " AND (((CAST(a.sian_cat_prodotto AS UNSIGNED)>=4) AND (CAST(a.sian_cat_prodotto AS UNSIGNED)<=12))  OR ((CAST(a.sian_cat_prodotto AS UNSIGNED)>=21) AND (CAST(a.sian_cat_prodotto AS UNSIGNED)<=31))  OR (CAST(a.sian_cat_prodotto AS UNSIGNED)=35) OR (CAST(a.sian_cat_prodotto AS UNSIGNED)=39) OR (CAST(a.sian_cat_prodotto AS UNSIGNED)=40) OR (CAST(a.sian_cat_prodotto AS UNSIGNED)=131) OR (CAST(a.sian_cat_prodotto AS UNSIGNED)=132) OR (CAST(a.sian_cat_prodotto AS UNSIGNED)=133) OR (CAST(a.sian_cat_prodotto AS UNSIGNED)=134) OR (CAST(a.sian_cat_prodotto AS UNSIGNED)=41) OR (CAST(a.sian_cat_prodotto AS UNSIGNED)=42) ) AND (CAST(a.sian_cod_stato_fisico AS UNSIGNED)=2 OR CAST(a.sian_cod_stato_fisico AS UNSIGNED)=3 )  AND  sian_atto_certificato='2' ", "");
                    stage.initModality(Modality.APPLICATION_MODAL);
                    stage.setResizable(false);
                    stage.showAndWait();
                    String codice = controller.getCodice();
                    String stato_fisico = controller.getStatoFisico();
                    if (!codice.equals("")) {
                        this.editText_prodotto.setText(codice);
                        HashMap lis = FXMLDocumentController.util.getParameters();
                        boolean GESTISCI_AUTO_CERT_ETIC = (Boolean)lis.get("GESTISCI_AUTO_CERT_ETIC");
                        if (GESTISCI_AUTO_CERT_ETIC) {
                            loader = new FXMLLoader(this.getClass().getResource("/vin/fascette/view/FinestraCercaLotto.fxml"));
                            Stage stage2 = new Stage();
                            stage2.setMaximized(false);
                            stage2.setTitle("Lotto");
                            stage2.setScene(new Scene((Parent)((Pane)loader.load())));
                            FinestraCercaLottoController controller2 = (FinestraCercaLottoController)loader.getController();
                            this.wd = new WorkIndicatorDialog(this.table.getScene().getWindow(), "Caricamento in corso...");
                            this.wd.addTaskEndNotification(result -> {
                                try {
                                    if (this.wd.labelWord.contains("#ERR")) {
                                        FXMLDocumentController.util.alertWindow(this.stackmaster, this.wd.labelWord, "ERRORE", "ERRORE");
                                    }
                                    this.wd = null;
                                    stage2.initModality(Modality.APPLICATION_MODAL);
                                    stage2.setResizable(false);
                                    stage2.showAndWait();
                                    String cod_lotto = controller2.getLotto();
                                    this.editText_lotto.setText(cod_lotto);
                                    this.cercaCertificazione(codice, cod_lotto);
                                }
                                catch (Exception ex) {
                                    Logger.getLogger(OperazioneFascetteController.class.getName()).log(Level.SEVERE, null, ex);
                                }
                            });
                            this.wd.exec("123", inputParam -> {
                                try {
                                    controller2.refreshList(codice);
                                }
                                catch (Exception ex) {
                                    Logger.getLogger(OperazioneFascetteController.class.getName()).log(Level.SEVERE, null, ex);
                                }
                                return 1;
                            });
                        } else {
                            this.cercaCertificazione(codice, "");
                        }
                    } else {
                        this.editText_prodotto.setText("");
                    }
                    stage.close();
                }
            }
            catch (Exception ex) {
                FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
            }
        });
        this.clearCampi();
        this.flg_modifica = false;
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                OperazioneFascetteController.this.refreshList("");
            }
        });
        this.editText_entecert.setEditable(false);
        this.editText_numprot.setEditable(false);
        this.dtp_dataido.setDisable(true);
        this.dtp_dataido.getEditor().setOpacity(1.0);
    }

    private void cercaCertificazione(String codice, String cod_lotto) throws IOException, JSONException {
        FXMLLoader loader1 = new FXMLLoader(this.getClass().getResource("/vin/view/SearchCertPool.fxml"));
        Stage stage1 = new Stage();
        stage1.setMaximized(false);
        stage1.setTitle("Certificazione");
        stage1.setScene(new Scene((Parent)((Pane)loader1.load())));
        SearchCertPool controller1 = (SearchCertPool)loader1.getController();
        String sian_cod_Stato_fisico = FXMLDocumentController.ricerca.getStatofisico(codice);
        this.wd = new WorkIndicatorDialog(this.table.getScene().getWindow(), "Caricamento in corso...");
        this.wd.addTaskEndNotification(result -> {
            try {
                if (this.wd.labelWord.contains("#ERR")) {
                    FXMLDocumentController.util.alertWindow(this.stackmaster, this.wd.labelWord, "ERRORE", "ERRORE");
                }
                this.wd = null;
                stage1.initModality(Modality.APPLICATION_MODAL);
                stage1.setResizable(false);
                stage1.showAndWait();
                String data_ido = controller1.getData_ido();
                String ente_cert = controller1.getEnte_cert();
                String num_prot = controller1.getNum_prot();
                this.editText_numprot.setText(num_prot);
                if (!data_ido.equals("")) {
                    LocalDate dtpo = LocalDate.parse(data_ido);
                    this.dtp_dataido.setValue((Object)dtpo);
                }
                this.editText_entecert.setText(ente_cert);
                String sigla = ((CodiceDescrizione)this.cmbx_sigla.getSelectionModel().getSelectedItem()).getCodice();
                if (!sigla.equals("FA") && sian_cod_Stato_fisico.equals("3")) {
                    this.editText_entecert.setEditable(false);
                    this.editText_numprot.setEditable(false);
                    this.dtp_dataido.setDisable(true);
                    this.dtp_dataido.getEditor().setOpacity(1.0);
                } else if (sigla.equals("FA") && sian_cod_Stato_fisico.equals("3")) {
                    this.editText_entecert.setEditable(false);
                    this.editText_numprot.setEditable(false);
                    this.dtp_dataido.setDisable(true);
                    this.dtp_dataido.getEditor().setOpacity(1.0);
                } else if (!sigla.equals("FA") && sian_cod_Stato_fisico.equals("2")) {
                    this.editText_entecert.setEditable(false);
                    this.editText_numprot.setEditable(false);
                    this.dtp_dataido.setDisable(true);
                    this.dtp_dataido.getEditor().setOpacity(1.0);
                } else {
                    this.editText_entecert.setEditable(true);
                    this.editText_numprot.setEditable(true);
                    this.dtp_dataido.setDisable(false);
                }
            }
            catch (Exception ex) {
                Logger.getLogger(OperazioneFascetteController.class.getName()).log(Level.SEVERE, null, ex);
            }
        });
        this.wd.exec("123", inputParam -> {
            try {
                if (sian_cod_Stato_fisico.equals("2")) {
                    controller1.fillTableConfezionato(codice, cod_lotto);
                } else if (sian_cod_Stato_fisico.equals("3")) {
                    controller1.fillTableSenzaEtichetta(codice);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return 1;
        });
    }

    @FXML
    private void btnRicercaOperazione(ActionEvent event) {
        try {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/vin/fascette/view/SearchButtonFascette.fxml"));
            final Stage stage = new Stage();
            stage.setMaximized(false);
            stage.setTitle("Ricerca Documenti");
            stage.setScene(new Scene((Parent)((Pane)loader.load())));
            SearchButtonFascetteController controller = (SearchButtonFascetteController)loader.getController();
            controller.getParent().setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent event) {
                    OperazioneFascetteController.this.xOffset = event.getSceneX();
                    OperazioneFascetteController.this.yOffset = event.getSceneY();
                }
            });
            controller.getParent().setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent event) {
                    stage.setX(event.getScreenX() - OperazioneFascetteController.this.xOffset);
                    stage.setY(event.getScreenY() - OperazioneFascetteController.this.yOffset);
                    stage.setOpacity((double)0.8f);
                }
            });
            controller.getParent().setOnDragDone((EventHandler)new EventHandler<DragEvent>(){

                public void handle(DragEvent event) {
                    stage.setOpacity(1.0);
                }
            });
            controller.getParent().setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent event) {
                    stage.setOpacity(1.0);
                }
            });
            stage.initModality(Modality.APPLICATION_MODAL);
            stage.initStyle(StageStyle.UNDECORATED);
            stage.initOwner(((Node)event.getSource()).getScene().getWindow());
            stage.setResizable(false);
            stage.showAndWait();
            String ander = "";
            String codice_prodotto = controller.getCodice_prodotto();
            String a_numero = controller.getA_numero();
            String da_numero = controller.getDa_numero();
            String serie = controller.getSerie();
            String dadata = controller.getDadata();
            String adata = controller.getAdata();
            if (!serie.equals("")) {
                ander = ander + " AND serie = '" + serie + "' ";
            }
            if (!da_numero.equals("")) {
                ander = ander + " AND da_numero = '" + da_numero + "' ";
            }
            if (!a_numero.equals("")) {
                ander = ander + " AND a_numero = '" + a_numero + "' ";
            }
            if (!codice_prodotto.equals("")) {
                ander = ander + " AND codice_prodotto = '" + codice_prodotto + "' ";
            }
            if (!dadata.equals("")) {
                ander = ander + " AND data_operazione>='" + dadata + "' ";
            }
            if (!adata.equals("")) {
                ander = ander + " AND  data_operazione<='" + adata + "' ";
            }
            if (!ander.equals("")) {
                this.refreshList(ander);
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    private void refreshList(String ander) {
        this.wd = new WorkIndicatorDialog(this.table.getScene().getWindow(), "Caricamento in corso...");
        this.wd.addTaskEndNotification(result -> {
            if (this.wd.labelWord != null && !this.wd.labelWord.equals("")) {
                FXMLDocumentController.toast.startToast(this.wd.labelWord, "ERRORE", "ERRORE");
            }
            this.wd = null;
            this.table.refresh();
        });
        this.wd.exec("123", inputParam -> {
            try {
                this.wd.labelWord = "";
                ArrayList<String> tipoSQL = new ArrayList<String>();
                ArrayList<String> strSQL = new ArrayList<String>();
                ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
                ArrayList<Boolean> lastID = new ArrayList<Boolean>();
                String data_select = "";
                lastID.add(false);
                this.lista_table.clear();
                this.table.refresh();
                String str = "SELECT id,azienda,sotto_az,icqrf,codice_prodotto,serie,da_numero,a_numero,sigla,data_operazione,id_oper,data_ido,ente_cert,num_protocollo,lotto FROM movimenti_fascette WHERE azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND id_oper=0 ";
                if (!ander.equals("")) {
                    str = str + ander;
                } else {
                    str = str + " AND data_operazione>='" + LocalDate.now().toString() + "' ";
                    str = str + " AND  data_operazione<='" + LocalDate.now().toString() + "' ";
                }
                strSQL.add(str);
                tipoSQL.add("select");
                lenghtBidimensionalArray.add(0);
                String strJson = FXMLDocumentController.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
                data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
                if (!data_select.contains("#ERR:")) {
                    JSONArray arrayJson = FXMLDocumentController.jsonUtil.strJsonToJSONArray(data_select);
                    for (int i = 0; i < arrayJson.length(); ++i) {
                        JSONObject rec = arrayJson.getJSONObject(i);
                        String id = rec.get("id").toString();
                        String codice_prodotto = rec.get("codice_prodotto").toString();
                        String serie = rec.get("serie").toString();
                        String da_numero = rec.get("da_numero").toString();
                        String a_numero = rec.get("a_numero").toString();
                        String sigla = rec.get("sigla").toString();
                        String data_operazione = rec.get("data_operazione").toString();
                        String entecert = rec.get("ente_cert").toString();
                        String data_ido = rec.get("data_ido").toString();
                        String numprot = rec.get("num_protocollo").toString();
                        String lotto = rec.get("lotto").toString();
                        String id_oper = rec.get("id_oper").toString();
                        this.lista_table.add((Object)new ColumnOperazioniFascette(id, codice_prodotto, serie, sigla, da_numero, a_numero, data_operazione, entecert, data_ido, numprot, lotto));
                    }
                }
            }
            catch (JSONException ex) {
                this.wd.labelWord = "#ERR:" + ex.getMessage();
            }
            return 1;
        });
    }

    @FXML
    private void btnSalvaMovimento(ActionEvent event) {
        try {
            String data_oper = "";
            LocalDate operd = (LocalDate)this.dtp_dataoperazione.getValue();
            if (operd != null) {
                data_oper = operd.toString();
            }
            String sigla = ((CodiceDescrizione)this.cmbx_sigla.getSelectionModel().getSelectedItem()).getCodice();
            String serie = this.editText_serie.getText().trim().toUpperCase();
            String codice_prodotto = this.editText_prodotto.getText().trim();
            String num_protocollo = this.editText_numprot.getText().trim();
            String ente_cert = this.editText_entecert.getText().trim();
            String lotto = this.editText_lotto.getText().trim();
            String data_ido = "";
            LocalDate dtop = (LocalDate)this.dtp_dataido.getValue();
            if (dtop != null) {
                data_ido = dtop.toString();
            }
            String da = this.editText_da.getText().trim();
            String a = this.editText_a.getText().trim();
            String tipo = "";
            tipo = sigla.equals("FA") ? "C" : "S";
            if (da.equals("")) {
                da = "0";
            }
            if (a.equals("")) {
                a = "0";
            }
            if (Integer.parseInt(da) > Integer.parseInt(a) || Integer.parseInt(a) < Integer.parseInt(a)) {
                FXMLDocumentController.util.alertWindow(this.stackmas, "Controllare numeri da - a fascette", "INFORMATION", "INFORMATION");
                return;
            }
            this.salva(data_oper, sigla, serie, da, a, tipo, codice_prodotto, num_protocollo, data_ido, ente_cert, lotto);
        }
        catch (Exception ex) {
            Logger.getLogger(OperazioneFascetteController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void salva(String data_oper, String sigla, String serie, String da, String a, String tipo, String prodotto, String num_protocollo, String data_ido, String ente_cert, String lotto) {
        this.wd = new WorkIndicatorDialog(this.editText_a.getScene().getWindow(), "Caricamento in corso...");
        this.wd.addTaskEndNotification(result -> {
            if (this.wd != null && this.wd.labelWord != null) {
                if (this.wd.labelWord.contains("#ERR:")) {
                    FXMLDocumentController.util.alertWindow(this.stackmaster, this.wd.labelWord, "ERRORE", "ERRORE");
                    this.wd = null;
                } else {
                    this.wd = null;
                    this.clearCampi();
                    this.flg_modifica = false;
                    this.refreshList("");
                    FXMLDocumentController.toast.startToast("Operazione correttamente eseguita", "SUCCESSO", "SUCCESSO");
                }
            }
        });
        this.wd.exec("123", inputParam -> {
            try {
                String[] res = new String[1];
                ArrayList<String> tipoSQL = new ArrayList<String>();
                ArrayList<String> strSQL = new ArrayList<String>();
                ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
                ArrayList<Boolean> lastID = new ArrayList<Boolean>();
                String str = "";
                String data_select = "";
                String[][] tipo_ins = null;
                String[][] valore = null;
                HashMap<Integer, String[]> ipos = new HashMap<Integer, String[]>();
                HashMap<Integer, String[]> alores = new HashMap<Integer, String[]>();
                int iterator = 0;
                if (this.flg_modifica) {
                    FXMLDocumentController.sqlUtil.update_fascette(this.id, data_oper, sigla, serie, da, a, tipo, prodotto, ente_cert, data_ido, num_protocollo, lotto);
                    strSQL.addAll(FXMLDocumentController.sqlUtil.strSQL);
                    tipoSQL.addAll(FXMLDocumentController.sqlUtil.tipoinsSQL);
                    lenghtBidimensionalArray.addAll(FXMLDocumentController.sqlUtil.lengthSQL);
                    lastID.addAll(FXMLDocumentController.sqlUtil.lastID);
                    ipos.put(iterator, FXMLDocumentController.sqlUtil.tipovaloreSQL.toArray(new String[0]));
                    alores.put(iterator, FXMLDocumentController.sqlUtil.valoreSQL.toArray(new String[0]));
                    ++iterator;
                } else {
                    FXMLDocumentController.sqlUtil.insert_fascette(FXMLDocumentController.GLOBAL_AZIENDA, FXMLDocumentController.GLOBAL_SOTTOAZZ, FXMLDocumentController.GLOBAL_ICQRF, data_oper, sigla, serie, da, a, prodotto, num_protocollo, data_ido, ente_cert, FXMLDocumentController.GLOBAL_UTENTE, lotto, FXMLDocumentController.GLOBAL_CODCOMM);
                    strSQL.addAll(FXMLDocumentController.sqlUtil.strSQL);
                    tipoSQL.addAll(FXMLDocumentController.sqlUtil.tipoinsSQL);
                    lenghtBidimensionalArray.addAll(FXMLDocumentController.sqlUtil.lengthSQL);
                    lastID.addAll(FXMLDocumentController.sqlUtil.lastID);
                    ipos.put(iterator, FXMLDocumentController.sqlUtil.tipovaloreSQL.toArray(new String[0]));
                    alores.put(iterator, FXMLDocumentController.sqlUtil.valoreSQL.toArray(new String[0]));
                    ++iterator;
                }
                tipo_ins = FXMLDocumentController.util.HashMapBidimensionalTOArrayBidimensional(ipos);
                valore = FXMLDocumentController.util.HashMapBidimensionalTOArrayBidimensional(alores);
                String strJson = FXMLDocumentController.util.makeStringJsonDB("ON", tipoSQL, strSQL, tipo_ins, valore, lastID, lenghtBidimensionalArray);
                data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
                this.wd.labelWord = this.wd.labelWord + data_select;
            }
            catch (Exception ex) {
                Logger.getLogger(OperazioneFascetteController.class.getName()).log(Level.SEVERE, null, ex);
            }
            return new Integer(1);
        });
    }

    @FXML
    private void btnNuovaOperazione(ActionEvent event) {
        this.clearCampi();
        this.flg_modifica = false;
    }

    private void clearCampi() {
        this.id = "";
        this.editText_entecert.setText("");
        this.editText_numprot.setText("");
        this.editText_lotto.setText("");
        this.dtp_dataido.setValue(null);
        this.cmbx_sigla.getSelectionModel().selectFirst();
        this.editText_a.setText("");
        this.editText_da.setText("");
        this.editText_prodotto.setText("");
        this.editText_serie.setText("");
        this.dtp_dataoperazione.setValue((Object)LocalDate.now());
    }

    @FXML
    private void btnEliminaMovimento(ActionEvent event) {
        ColumnOperazioniFascette oper = (ColumnOperazioniFascette)this.table.getSelectionModel().getSelectedItem();
        if (oper != null) {
            String id = oper.getColumn_id();
            TextInputDialog dialogim = new TextInputDialog("");
            dialogim.setTitle("SICUREZZA");
            dialogim.setHeaderText("Confermare la cancellazione dell'operazione " + oper.getColumn_serie() + "/" + oper.getColumn_da() + "-" + oper.getColumn_a() + " ?");
            dialogim.setContentText("Password (PROCEDI):");
            Optional resultim = dialogim.showAndWait();
            if (resultim.isPresent() && ((String)resultim.get()).trim().trim().equals("PROCEDI")) {
                this.wd = new WorkIndicatorDialog(this.table.getScene().getWindow(), "Caricamento in corso...");
                this.wd.addTaskEndNotification(result -> {
                    if (this.wd.labelWord.contains("#ERR")) {
                        String h = this.wd.labelWord;
                        this.wd = null;
                        FXMLDocumentController.util.alertWindow(this.stackmaster, h, "ERRORE", "ERRORE");
                    } else {
                        this.flg_modifica = false;
                        FXMLDocumentController.toast.startToast("Operazione correttamente eseguita", "SUCCESSO", "SUCCESSO");
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                OperazioneFascetteController.this.clearCampi();
                                OperazioneFascetteController.this.flg_modifica = false;
                            }
                        });
                        this.wd = null;
                        this.refreshList("");
                    }
                });
                this.wd.exec("123", inputParam -> {
                    try {
                        this.elimina(id);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return 1;
                });
            }
        }
    }

    private void elimina(String id) throws JSONException {
        int iterator = 0;
        String[] res = new String[1];
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String str = "";
        String data_select = "";
        String[][] tipo_ins = null;
        String[][] valore = null;
        HashMap<Integer, String[]> ipos = new HashMap<Integer, String[]>();
        HashMap<Integer, String[]> alores = new HashMap<Integer, String[]>();
        FXMLDocumentController.sqlUtil.delete_fascette(id);
        strSQL.addAll(FXMLDocumentController.sqlUtil.strSQL);
        tipoSQL.addAll(FXMLDocumentController.sqlUtil.tipoinsSQL);
        lenghtBidimensionalArray.addAll(FXMLDocumentController.sqlUtil.lengthSQL);
        lastID.addAll(FXMLDocumentController.sqlUtil.lastID);
        ipos.put(iterator, FXMLDocumentController.sqlUtil.tipovaloreSQL.toArray(new String[0]));
        alores.put(iterator, FXMLDocumentController.sqlUtil.valoreSQL.toArray(new String[0]));
        ++iterator;
        tipo_ins = FXMLDocumentController.util.HashMapBidimensionalTOArrayBidimensional(ipos);
        valore = FXMLDocumentController.util.HashMapBidimensionalTOArrayBidimensional(alores);
        String strJson = FXMLDocumentController.util.makeStringJsonDB("ON", tipoSQL, strSQL, tipo_ins, valore, lastID, lenghtBidimensionalArray);
        this.wd.labelWord = data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
    }

    @FXML
    private void modificaMovimentazione(ActionEvent event) {
        ColumnOperazioniFascette oper = (ColumnOperazioniFascette)this.table.getSelectionModel().getSelectedItem();
        if (oper != null) {
            String a;
            this.flg_modifica = true;
            this.clearCampi();
            this.editText_a.setText(oper.getColumn_a());
            this.editText_da.setText(oper.getColumn_da());
            this.editText_prodotto.setText(oper.getColumn_prodotto());
            this.editText_serie.setText(oper.getColumn_serie());
            this.editText_entecert.setText(oper.getColumn_entecert());
            this.editText_numprot.setText(oper.getColumn_numprot());
            this.editText_lotto.setText(oper.getColumn_lotto());
            this.dtp_dataido.setValue((Object)LocalDate.parse(oper.getColumn_dataido()));
            String sigla = oper.getColumn_sigla();
            String dataoper = oper.getColumn_dataoperazione();
            this.id = oper.getColumn_id();
            String da = oper.getColumn_da();
            if (da.equals("")) {
                da = "0";
            }
            if ((a = oper.getColumn_a()).equals("")) {
                a = "0";
            }
            String totale = new BigInteger(a).subtract(new BigInteger(da)).add(new BigInteger("1")).toString();
            this.editText_totale.setText(totale);
            this.dtp_dataoperazione.setValue((Object)LocalDate.parse(dataoper));
            if (!sigla.equals("")) {
                String descr = "";
                switch (sigla) {
                    case "FA": {
                        descr = "CARICA FASCETTE";
                        break;
                    }
                    case "FO": {
                        descr = "ROTTURA FASCETTE";
                        break;
                    }
                    case "FS": {
                        descr = "SOSTITUZIONE FASCETTE";
                    }
                }
                CodiceDescrizione obj = new CodiceDescrizione(sigla, descr);
                this.cmbx_sigla.getSelectionModel().select((Object)obj);
            }
        }
    }

    @FXML
    private void btnCercaProdotto(ActionEvent event) throws IOException {
        FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/vin/view/SearchProdotto_2.fxml"));
        Stage stage = new Stage();
        stage.setMaximized(false);
        stage.setTitle("Prodotto");
        stage.setScene(new Scene((Parent)((Pane)loader.load())));
        SearchProdottoController_2 controller = (SearchProdottoController_2)loader.getController();
        controller.setSearch("", " AND (((CAST(a.sian_cat_prodotto AS UNSIGNED)>=4) AND (CAST(a.sian_cat_prodotto AS UNSIGNED)<=12))  OR ((CAST(a.sian_cat_prodotto AS UNSIGNED)>=21) AND (CAST(a.sian_cat_prodotto AS UNSIGNED)<=31))  OR (CAST(a.sian_cat_prodotto AS UNSIGNED)=35) OR (CAST(a.sian_cat_prodotto AS UNSIGNED)=39) OR (CAST(a.sian_cat_prodotto AS UNSIGNED)=40) OR (CAST(a.sian_cat_prodotto AS UNSIGNED)=131) OR (CAST(a.sian_cat_prodotto AS UNSIGNED)=132) OR (CAST(a.sian_cat_prodotto AS UNSIGNED)=133) OR (CAST(a.sian_cat_prodotto AS UNSIGNED)=134) OR (CAST(a.sian_cat_prodotto AS UNSIGNED)=41) OR (CAST(a.sian_cat_prodotto AS UNSIGNED)=42) ) AND (CAST(a.sian_cod_stato_fisico AS UNSIGNED)=2 OR CAST(a.sian_cod_stato_fisico AS UNSIGNED)=3 )  AND  sian_atto_certificato='2' ", "");
        stage.initModality(Modality.APPLICATION_MODAL);
        stage.setResizable(false);
        stage.showAndWait();
        String codice = controller.getCodice();
        if (!codice.equals("")) {
            this.editText_prodotto.setText(codice);
        } else {
            this.editText_prodotto.setText("");
        }
        stage.close();
        if (!codice.equals("")) {
            try {
                HashMap lis = FXMLDocumentController.util.getParameters();
                boolean GESTISCI_AUTO_CERT_ETIC = (Boolean)lis.get("GESTISCI_AUTO_CERT_ETIC");
                if (GESTISCI_AUTO_CERT_ETIC) {
                    loader = new FXMLLoader(this.getClass().getResource("/vin/fascette/view/FinestraCercaLotto.fxml"));
                    Stage stage2 = new Stage();
                    stage2.setMaximized(false);
                    stage2.setTitle("Lotto");
                    stage2.setScene(new Scene((Parent)((Pane)loader.load())));
                    FinestraCercaLottoController controller2 = (FinestraCercaLottoController)loader.getController();
                    this.wd = new WorkIndicatorDialog(this.table.getScene().getWindow(), "Caricamento in corso...");
                    this.wd.addTaskEndNotification(result -> {
                        try {
                            if (this.wd.labelWord.contains("#ERR")) {
                                FXMLDocumentController.util.alertWindow(this.stackmaster, this.wd.labelWord, "ERRORE", "ERRORE");
                            }
                            this.wd = null;
                            stage2.initModality(Modality.APPLICATION_MODAL);
                            stage2.setResizable(false);
                            stage2.showAndWait();
                            String cod_lotto = controller2.getLotto();
                            this.editText_lotto.setText(cod_lotto);
                            this.cercaCertificazione(codice, cod_lotto);
                        }
                        catch (Exception ex) {
                            Logger.getLogger(OperazioneFascetteController.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    });
                    this.wd.exec("123", inputParam -> {
                        try {
                            controller2.refreshList(codice);
                        }
                        catch (Exception ex) {
                            Logger.getLogger(OperazioneFascetteController.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        return 1;
                    });
                } else {
                    this.cercaCertificazione(codice, "");
                }
            }
            catch (Exception ex) {
                Logger.getLogger(OperazioneFascetteController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public String choiceInputDialog(String title, String headerText, String contentText, List choices) {
        ChoiceDialog choice = new ChoiceDialog(null, (Collection)choices);
        choice.setResultConverter(type -> {
            ButtonBar.ButtonData data;
            ButtonBar.ButtonData buttonData = data = type == null ? null : type.getButtonData();
            if (data == ButtonBar.ButtonData.HELP) {
                return "DEBUG@" + (String)choice.getSelectedItem();
            }
            if (data == ButtonBar.ButtonData.OK_DONE) {
                return "OK@" + ((String)choice.getSelectedItem()).toString();
            }
            if (data == ButtonBar.ButtonData.CANCEL_CLOSE) {
                return "#ERR@Campo vuoto";
            }
            return null;
        });
        choice.setTitle(title);
        choice.setHeaderText(headerText);
        choice.setContentText(contentText);
        Optional result = choice.showAndWait();
        if (result.isPresent()) {
            return (String)choice.getSelectedItem();
        }
        return "";
    }

    public static <T> List<T> removeDuplicates(List<T> list) {
        ArrayList<T> newList = new ArrayList<T>();
        for (T element : list) {
            if (newList.contains(element)) continue;
            newList.add(element);
        }
        return newList;
    }

    @FXML
    private void btnCercaFascette(ActionEvent event) {
        try {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/vin/fascette/view/FinestraFascetteDisponibili.fxml"));
            Stage stage = new Stage();
            stage.setMaximized(false);
            stage.setTitle("Fascette");
            stage.setScene(new Scene((Parent)((Pane)loader.load())));
            FinestraFascetteDisponibiliController controller = (FinestraFascetteDisponibiliController)loader.getController();
            this.wd = new WorkIndicatorDialog(this.table.getScene().getWindow(), "Caricamento in corso...");
            this.wd.addTaskEndNotification(result -> {
                try {
                    if (this.wd.labelWord.contains("#ERR")) {
                        FXMLDocumentController.util.alertWindow(this.stackmaster, this.wd.labelWord, "ERRORE", "ERRORE");
                    }
                    this.wd = null;
                    stage.initModality(Modality.APPLICATION_MODAL);
                    stage.setResizable(false);
                    stage.showAndWait();
                    this.editText_a.setText(controller.getA());
                    this.editText_da.setText(controller.getDa());
                    this.editText_serie.setText(controller.getSerie());
                }
                catch (Exception ex) {
                    Logger.getLogger(OperazioneFascetteController.class.getName()).log(Level.SEVERE, null, ex);
                }
            });
            this.wd.exec("123", inputParam -> {
                try {
                    String dalladata = "";
                    String alladata = LocalDate.now().toString();
                    int mese = LocalDate.now().getMonthValue();
                    if (!FXMLDocumentController.ricerca.getIfChiusuraNeverWBS(FXMLDocumentController.GLOBAL_AZIENDA, FXMLDocumentController.GLOBAL_SOTTOAZZ, FXMLDocumentController.GLOBAL_ICQRF)) {
                        String anno = String.valueOf(LocalDate.now().getYear());
                        if (LocalDate.now().getYear() >= LocalDate.now().getYear()) {
                            if (mese < 8) {
                                dalladata = FXMLDocumentController.ricerca.getDataPerStampaDalla(String.valueOf(Integer.parseInt(anno)));
                                if (dalladata.equals("")) {
                                    dalladata = Integer.parseInt(anno) - 1 + "-08-01";
                                }
                            } else {
                                String datas = FXMLDocumentController.ricerca.getDataPerStampaDallaPrima(anno);
                                dalladata = !datas.equals("") ? datas : anno + "-08-01";
                            }
                        } else {
                            dalladata = String.valueOf(LocalDate.now().getYear()) + "-08-01";
                        }
                    } else {
                        dalladata = "2017-01-01";
                    }
                    String codice_prodotto = this.editText_prodotto.getText().trim();
                    String num_protocollo = this.editText_numprot.getText().trim();
                    String data_ido = "";
                    LocalDate dtpd = (LocalDate)this.dtp_dataido.getValue();
                    if (dtpd != null) {
                        data_ido = dtpd.toString();
                    }
                    String ente_cert = this.editText_entecert.getText().trim();
                    String serie = this.editText_serie.getText().trim().toUpperCase();
                    ArrayList<String> tipoSQL = new ArrayList<String>();
                    ArrayList<String> strSQL = new ArrayList<String>();
                    ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
                    ArrayList<Boolean> lastID = new ArrayList<Boolean>();
                    String data_select = "";
                    lastID.add(false);
                    String str = " SELECT * \n FROM movimenti_fascette\n WHERE codice_prodotto='" + codice_prodotto + "' AND num_protocollo='" + num_protocollo + "' AND data_ido='" + data_ido + "' AND ente_cert='" + ente_cert + "'  AND (data_operazione>='" + dalladata + "' AND data_operazione<='" + alladata + "' )";
                    strSQL.add(str);
                    tipoSQL.add("select");
                    lenghtBidimensionalArray.add(0);
                    String strJson = FXMLDocumentController.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
                    data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
                    if (!data_select.contains("#ERR:")) {
                        JSONArray arrayJson = FXMLDocumentController.jsonUtil.strJsonToJSONArray(data_select);
                        HashMap<Integer, HashMap<String, HashMap<Integer, Integer>>> mappe = FXMLDocumentController.util.getRangeCertificazioneProdottoFascette(arrayJson);
                        controller.refreshList(mappe);
                    }
                }
                catch (Exception ex) {
                    Logger.getLogger(OperazioneFascetteController.class.getName()).log(Level.SEVERE, null, ex);
                }
                return 1;
            });
        }
        catch (IOException ex) {
            Logger.getLogger(OperazioneFascetteController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void btnCercaNumProt(ActionEvent event) {
        String codice = this.editText_prodotto.getText().trim();
        if (!codice.equals("")) {
            try {
                FXMLLoader loader1 = new FXMLLoader(this.getClass().getResource("/vin/view/SearchCertPool.fxml"));
                Stage stage1 = new Stage();
                stage1.setMaximized(false);
                stage1.setTitle("Certificazione");
                stage1.setScene(new Scene((Parent)((Pane)loader1.load())));
                SearchCertPool controller1 = (SearchCertPool)loader1.getController();
                String sian_cod_Stato_fisico = FXMLDocumentController.ricerca.getStatofisico(codice);
                this.wd = new WorkIndicatorDialog(this.table.getScene().getWindow(), "Caricamento in corso...");
                this.wd.addTaskEndNotification(result -> {
                    try {
                        if (this.wd.labelWord.contains("#ERR")) {
                            FXMLDocumentController.util.alertWindow(this.stackmaster, this.wd.labelWord, "ERRORE", "ERRORE");
                        }
                        this.wd = null;
                        stage1.initModality(Modality.APPLICATION_MODAL);
                        stage1.setResizable(false);
                        stage1.showAndWait();
                        String data_ido = controller1.getData_ido();
                        String ente_cert = controller1.getEnte_cert();
                        String num_prot = controller1.getNum_prot();
                        if (!num_prot.equals("")) {
                            this.editText_numprot.setText(num_prot);
                            if (!data_ido.equals("")) {
                                LocalDate dtpo = LocalDate.parse(data_ido);
                                this.dtp_dataido.setValue((Object)dtpo);
                            }
                            this.editText_entecert.setText(ente_cert);
                            String sigla = ((CodiceDescrizione)this.cmbx_sigla.getSelectionModel().getSelectedItem()).getCodice();
                            if (!sigla.equals("FA") && sian_cod_Stato_fisico.equals("3")) {
                                this.editText_entecert.setEditable(false);
                                this.editText_numprot.setEditable(false);
                                this.dtp_dataido.setDisable(true);
                                this.dtp_dataido.getEditor().setOpacity(1.0);
                            } else if (sigla.equals("FA") && sian_cod_Stato_fisico.equals("3")) {
                                this.editText_entecert.setEditable(false);
                                this.editText_numprot.setEditable(false);
                                this.dtp_dataido.setDisable(true);
                                this.dtp_dataido.getEditor().setOpacity(1.0);
                            } else if (!sigla.equals("FA") && sian_cod_Stato_fisico.equals("2")) {
                                this.editText_entecert.setEditable(false);
                                this.editText_numprot.setEditable(false);
                                this.dtp_dataido.setDisable(true);
                                this.dtp_dataido.getEditor().setOpacity(1.0);
                            } else {
                                this.editText_entecert.setEditable(true);
                                this.editText_numprot.setEditable(true);
                                this.dtp_dataido.setDisable(false);
                            }
                        }
                    }
                    catch (Exception ex) {
                        Logger.getLogger(OperazioneFascetteController.class.getName()).log(Level.SEVERE, null, ex);
                    }
                });
                this.wd.exec("123", inputParam -> {
                    try {
                        HashMap lis = FXMLDocumentController.util.getParameters();
                        boolean GESTISCI_AUTO_CERT_ETIC = (Boolean)lis.get("GESTISCI_AUTO_CERT_ETIC");
                        if (sian_cod_Stato_fisico.equals("2")) {
                            if (GESTISCI_AUTO_CERT_ETIC) {
                                String cod_lotto = this.editText_lotto.getText().trim();
                                controller1.fillTableConfezionato(codice, cod_lotto);
                            } else {
                                controller1.fillTableConfezionato(codice, "");
                            }
                        } else if (sian_cod_Stato_fisico.equals("3")) {
                            controller1.fillTableSenzaEtichetta(codice);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return 1;
                });
            }
            catch (IOException ex) {
                Logger.getLogger(OperazioneFascetteController.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (JSONException ex) {
                Logger.getLogger(OperazioneFascetteController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @FXML
    private void btnCercaLotto(ActionEvent event) {
        try {
            String codice = this.editText_prodotto.getText().trim();
            if (!codice.equals("")) {
                FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/vin/fascette/view/FinestraCercaLotto.fxml"));
                Stage stage = new Stage();
                stage.setMaximized(false);
                stage.setTitle("Lotto");
                stage.setScene(new Scene((Parent)((Pane)loader.load())));
                FinestraCercaLottoController controller = (FinestraCercaLottoController)loader.getController();
                this.wd = new WorkIndicatorDialog(this.table.getScene().getWindow(), "Caricamento in corso...");
                this.wd.addTaskEndNotification(result -> {
                    try {
                        if (this.wd.labelWord.contains("#ERR")) {
                            FXMLDocumentController.util.alertWindow(this.stackmaster, this.wd.labelWord, "ERRORE", "ERRORE");
                        }
                        this.wd = null;
                        stage.initModality(Modality.APPLICATION_MODAL);
                        stage.setResizable(false);
                        stage.showAndWait();
                        this.editText_lotto.setText(controller.getLotto());
                    }
                    catch (Exception ex) {
                        Logger.getLogger(OperazioneFascetteController.class.getName()).log(Level.SEVERE, null, ex);
                    }
                });
                this.wd.exec("123", inputParam -> {
                    try {
                        controller.refreshList(codice);
                    }
                    catch (Exception ex) {
                        Logger.getLogger(OperazioneFascetteController.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    return 1;
                });
            }
        }
        catch (IOException ex) {
            Logger.getLogger(OperazioneFascetteController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

