/*
 * Decompiled with CFR 0.152.
 */
package vin.controller.librosoci;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import vin.controller.FXMLDocumentController;
import vin.controller.SearchClientiController;

public class ConfTabellaSocioLibroController
implements Initializable {
    @FXML
    private StackPane stack;
    @FXML
    private TextField editText_conferente;
    @FXML
    private Label label_descrizione;
    @FXML
    private TextField editText_numeropagina;
    @FXML
    private TextField editText_numerovolume;
    @FXML
    private TextField editText_iscrizione;
    @FXML
    private DatePicker dtp_datadelibera;
    boolean exist = false;
    String id = "";
    String id_socio = "";

    @FXML
    void btnCercaSocio(ActionEvent event) throws IOException, FileNotFoundException, URISyntaxException, JSONException {
        FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/vin/view/SearchCliente.fxml"));
        Stage stage = new Stage();
        stage.setMaximized(false);
        stage.setTitle("CLIENTI/FORNITORI");
        stage.setScene(new Scene((Parent)((Pane)loader.load())));
        SearchClientiController controller = (SearchClientiController)loader.getController();
        controller.setFillNormal(true, FXMLDocumentController.GLOBAL_AZIENDA, FXMLDocumentController.GLOBAL_SOTTOAZZ, "F");
        stage.initModality(Modality.APPLICATION_MODAL);
        stage.setResizable(false);
        stage.showAndWait();
        String codice = controller.getCodice();
        String descrizione = controller.getDescrizione();
        if (!codice.equals("")) {
            this.controlloSePresenteTestata(codice);
            this.editText_conferente.setText(codice);
            this.label_descrizione.setText(descrizione);
        }
    }

    public void controlloSePresenteTestata(String cod_forn) throws JSONException {
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList lenghtBidimensionalArray = new ArrayList();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        lastID.add(false);
        tipoSQL.add("select");
        strSQL.add("SELECT id,autofattura,entrokm,cod_forn,tipo_fornitore_f1,cod_fiscdest_f1,piva_dest_f1,cognomeragsoc_dest_f1,nomedest_f1,cognomerapr_f2,nomerapr_f2,codfiscrapr_f2,mfrapr_f2,comunenascitarapr_f2,provincianascitarapr_f2,datanascitarapr_f2,codfiscdest_f2,pivadest_f2,cognomeragsocdest_f2,nomedest_f2,mf,tipo_allegato,istat_comunenascita FROM f_ana_fornitore WHERE cod_forn='" + cod_forn + "' AND azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' ");
        String str = FXMLDocumentController.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
        String data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + str);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = FXMLDocumentController.jsonUtil.strJsonToJSONArray(data_select);
            if (arrayJson.length() > 0) {
                for (int i = 0; i < arrayJson.length(); ++i) {
                    JSONObject rec = arrayJson.getJSONObject(i);
                    String id = rec.get("id").toString();
                    String tipo_allegato = rec.getString("tipo_allegato");
                    String MF = rec.getString("mf");
                    String istat_comunenascita = rec.getString("istat_comunenascita").replace("null", "");
                    String tipo_fornitore_f1 = rec.getString("tipo_fornitore_f1").replace("null", "");
                    String cod_fiscdest_f1 = rec.getString("cod_fiscdest_f1").replace("null", "");
                    String piva_dest_f1 = rec.getString("piva_dest_f1").replace("null", "");
                    String cognomeragsoc_dest_f1 = rec.getString("cognomeragsoc_dest_f1").replace("null", "");
                    String nomedest_f1 = rec.getString("nomedest_f1").replace("null", "");
                    String cognomerapr_f2 = rec.getString("cognomerapr_f2").replace("null", "");
                    String nomerapr_f2 = rec.getString("nomerapr_f2").replace("null", "");
                    String codfiscrapr_f2 = rec.getString("codfiscrapr_f2").replace("null", "");
                    String mfrapr_f2 = rec.getString("mfrapr_f2").replace("null", "");
                    String comunenascitarapr_f2 = rec.getString("comunenascitarapr_f2").replace("null", "");
                    String provincianascitarapr_f2 = rec.getString("provincianascitarapr_f2").replace("null", "");
                    String datanascitarapr_f2 = rec.getString("datanascitarapr_f2").replace("null", "");
                    String codfiscdest_f2 = rec.getString("codfiscdest_f2").replace("null", "");
                    String pivadest_f2 = rec.getString("pivadest_f2").replace("null", "");
                    String cognomeragsocdest_f2 = rec.getString("cognomeragsocdest_f2").replace("null", "");
                    String nomedest_f2 = rec.getString("nomedest_f2").replace("null", "");
                    String entrokm = rec.getString("entrokm").replace("null", "").replace("null", "");
                    String autofattura = rec.getString("autofattura").replace("null", "");
                    this.exist = true;
                    this.fillCampiLibro(cod_forn);
                }
            } else {
                this.resetta();
            }
        } else {
            FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", data_select);
        }
    }

    public void fillCampiLibro(String codice_forn) throws JSONException {
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList lenghtBidimensionalArray = new ArrayList();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        lastID.add(false);
        tipoSQL.add("select");
        strSQL.add("SELECT id,n_pagina,n_volume,n_iscrizione,data_delibera FROM f_socio_libro WHERE codice_socio='" + codice_forn + "'  AND azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' ");
        String str = FXMLDocumentController.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
        String data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + str);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = FXMLDocumentController.jsonUtil.strJsonToJSONArray(data_select);
            if (arrayJson.length() > 0) {
                for (int i = 0; i < arrayJson.length(); ++i) {
                    JSONObject rec = arrayJson.getJSONObject(i);
                    String n_pagina = rec.get("n_pagina").toString();
                    String n_volume = rec.get("n_volume").toString();
                    String n_iscrizione = rec.get("n_iscrizione").toString();
                    String data_delibera = rec.get("data_delibera").toString().replace("null", "");
                    this.id = rec.get("id").toString();
                    this.editText_numeropagina.setText(n_pagina);
                    this.editText_numerovolume.setText(n_volume);
                    this.editText_iscrizione.setText(n_iscrizione);
                    if (data_delibera.equals("")) continue;
                    this.dtp_datadelibera.setValue((Object)LocalDate.parse(data_delibera));
                }
            }
        } else {
            FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", data_select);
        }
    }

    private void resetta() {
        this.editText_numeropagina.setText("");
        this.editText_numerovolume.setText("");
        this.editText_iscrizione.setText("");
        this.dtp_datadelibera.setValue(null);
    }

    public void initialize(URL url, ResourceBundle rb) {
    }

    @FXML
    private void btnSalva(ActionEvent event) throws JSONException {
        String codice_socio = this.editText_conferente.getText().trim();
        String n_pagina = this.editText_numeropagina.getText().trim();
        String n_volume = this.editText_numerovolume.getText().trim();
        String n_iscrizione = this.editText_iscrizione.getText().trim();
        String data_delibera = "";
        LocalDate dtps = (LocalDate)this.dtp_datadelibera.getValue();
        if (dtps != null) {
            data_delibera = dtps.toString();
        }
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String[][] tipo_ins = null;
        String[][] valore = null;
        int iterator = 0;
        HashMap<Integer, String[]> ipos = new HashMap<Integer, String[]>();
        HashMap<Integer, String[]> alores = new HashMap<Integer, String[]>();
        if (this.exist) {
            if (!this.id.equals("")) {
                FXMLDocumentController.sqlUtil.update_f_socio_libro(this.id, n_pagina, n_volume, n_iscrizione, data_delibera);
                strSQL.addAll(FXMLDocumentController.sqlUtil.strSQL);
                tipoSQL.addAll(FXMLDocumentController.sqlUtil.tipoinsSQL);
                lenghtBidimensionalArray.addAll(FXMLDocumentController.sqlUtil.lengthSQL);
                lastID.addAll(FXMLDocumentController.sqlUtil.lastID);
                ipos.put(iterator, FXMLDocumentController.sqlUtil.tipovaloreSQL.toArray(new String[0]));
                alores.put(iterator, FXMLDocumentController.sqlUtil.valoreSQL.toArray(new String[0]));
                ++iterator;
            } else {
                FXMLDocumentController.sqlUtil.insert_f_socio_libro(codice_socio, n_pagina, n_volume, n_iscrizione, data_delibera, FXMLDocumentController.GLOBAL_AZIENDA, FXMLDocumentController.GLOBAL_SOTTOAZZ, FXMLDocumentController.GLOBAL_ICQRF);
                strSQL.addAll(FXMLDocumentController.sqlUtil.strSQL);
                tipoSQL.addAll(FXMLDocumentController.sqlUtil.tipoinsSQL);
                lenghtBidimensionalArray.addAll(FXMLDocumentController.sqlUtil.lengthSQL);
                lastID.addAll(FXMLDocumentController.sqlUtil.lastID);
                ipos.put(iterator, FXMLDocumentController.sqlUtil.tipovaloreSQL.toArray(new String[0]));
                alores.put(iterator, FXMLDocumentController.sqlUtil.valoreSQL.toArray(new String[0]));
                ++iterator;
            }
            tipo_ins = FXMLDocumentController.util.HashMapBidimensionalTOArrayBidimensional(ipos);
            valore = FXMLDocumentController.util.HashMapBidimensionalTOArrayBidimensional(alores);
            String strJson = FXMLDocumentController.util.makeStringJsonDB("ON", tipoSQL, strSQL, tipo_ins, valore, lastID, lenghtBidimensionalArray);
            String data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
            if (!data_select.equals("")) {
                FXMLDocumentController.util.alertWindow(this.stack, data_select, "ERRORE", "error");
            } else {
                this.editText_conferente.setText("");
                this.label_descrizione.setText("");
                this.resetta();
                FXMLDocumentController.toast.startToast("Operazione correttamente eseguia", this.id_socio, this.id);
            }
        } else {
            FXMLDocumentController.util.alertWindow(this.stack, "Codificare prima il Socio in Tabella Socio", "ERRORE", "error");
        }
    }
}

