/*
 * Decompiled with CFR 0.152.
 */
package vin.controller.librosoci;

import java.io.IOException;
import java.net.URL;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.Pane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import org.json.JSONException;
import vin.Class.CodiceDescrizioneComboBox;
import vin.Class.WorkIndicatorDialog;
import vin.Uility.JasperReport;
import vin.controller.FXMLDocumentController;
import vin.controller.RicercaConferentiController;

public class ConfStampaLibroSociController
implements Initializable {
    @FXML
    private DatePicker dtp_dadata;
    @FXML
    private DatePicker dtp_adata;
    @FXML
    private TextField editText_conferente;
    JasperReport jasperReport = new JasperReport();
    ToggleGroup groupTipoVino = null;
    ToggleGroup groupTipoStampa = null;
    ToggleGroup groupTipoStampa2 = null;
    WorkIndicatorDialog wd = null;
    private ObservableList<CodiceDescrizioneComboBox> lista_colore = FXCollections.observableArrayList();
    private ObservableList<CodiceDescrizioneComboBox> lista_classificazione = FXCollections.observableArrayList();

    @FXML
    void btnCercaConferente(ActionEvent event) throws IOException {
        FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/vin/view/RicercaConferenti.fxml"));
        Stage stage = new Stage();
        stage.setMaximized(false);
        stage.setTitle("CONFERENTI");
        stage.setScene(new Scene((Parent)((Pane)loader.load())));
        RicercaConferentiController controller = (RicercaConferentiController)loader.getController();
        stage.initModality(Modality.APPLICATION_MODAL);
        stage.initStyle(StageStyle.DECORATED);
        stage.setResizable(false);
        stage.showAndWait();
        String codice = controller.getCodice();
        if (!codice.equals("")) {
            this.editText_conferente.setText(codice);
        }
    }

    @FXML
    void btnActionStampa(ActionEvent event) throws JSONException, IOException {
        this.wd = new WorkIndicatorDialog(this.editText_conferente.getScene().getWindow(), "Caricamento in corso...");
        this.wd.addTaskEndNotification(result -> {
            System.out.println(result);
            this.wd = null;
        });
        this.wd.exec("123", inputParam -> {
            try {
                this.gostampa();
            }
            catch (IOException | JSONException ex) {
                Logger.getLogger(ConfStampaLibroSociController.class.getName()).log(Level.SEVERE, null, ex);
            }
            return 1;
        });
    }

    private void gostampa() throws JSONException, IOException {
        LocalDate endtime2;
        ArrayList<String> key = new ArrayList<String>();
        ArrayList<Object> value = new ArrayList<Object>();
        int tipoStampa = 2;
        boolean tipoStampa2 = false;
        String stato_fisico = "";
        String nomeFileJRXML = "";
        String dalladata = "";
        String alladata = "";
        String conferente = this.editText_conferente.getText();
        LocalDate endtime = (LocalDate)this.dtp_adata.getValue();
        if (endtime != null) {
            alladata = endtime.toString();
        }
        if ((endtime2 = (LocalDate)this.dtp_dadata.getValue()) != null) {
            dalladata = endtime2.toString();
        }
        if (alladata.equals("")) {
            FXMLDocumentController.toast.startToast("(Alla Data) Campo obbligatorio", "ERRORE", "ERRORE");
            return;
        }
        if (dalladata.equals("")) {
            FXMLDocumentController.toast.startToast("(Dalla Data) Campo obbligatorio", "ERRORE", "ERRORE");
            return;
        }
        String strWHERE = this.selectReport(dalladata, alladata, conferente);
        key.add("QUERY");
        key.add("AZIENDA");
        key.add("SOTTO_AZ");
        key.add("ICQRF");
        value.add(strWHERE);
        value.add(FXMLDocumentController.GLOBAL_AZIENDA);
        value.add(FXMLDocumentController.GLOBAL_SOTTOAZZ);
        value.add(FXMLDocumentController.GLOBAL_ICQRF);
        nomeFileJRXML = "registroLibroSoci_E.jrxml";
        String resp = this.jasperReport.JSONjr(nomeFileJRXML, key, value, tipoStampa, "");
        String nomeFile = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "JasperReport#@" + resp);
        FXMLDocumentController.util.downloadFileTemp(nomeFile);
    }

    private String selectReport(String dadata, String adata, String conferente) {
        String ret = "";
        ret = "SELECT a.data_operazione,a.codice_socio,\nIF(c.pers_fisica='S',CONCAT(c.cognome,' ',c.nome),c.rag_soc) AS descrizione_socio,\na.articolo,a.n_volume,a.n_pagina,a.azienda,a.sotto_az,a.icqrf,a.importo,IFNULL(importo_dalla.saldo,0) AS saldo\n FROM f_movimenti_libro  AS a\nLEFT JOIN (\nSELECT data_operazione,codice_socio,azienda,sotto_az,icqrf,SUM(importo) AS saldo \nFROM f_movimenti_libro  \nWHERE azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND data_operazione<'" + dadata + "'\n";
        if (!conferente.equals("")) {
            ret = ret + " AND codice_socio='" + conferente + "' ";
        }
        ret = ret + "GROUP BY codice_socio) AS importo_dalla \nON a.azienda=importo_dalla.azienda AND a.sotto_az=importo_dalla.sotto_az AND a.icqrf=importo_dalla.icqrf AND a.codice_socio=importo_dalla.codice_socio\nLEFT JOIN gen_ana_clifor AS c ON a.codice_socio=c.codice AND a.azienda=c.azienda AND a.sotto_az=c.sotto_az\nWHERE a.data_operazione>='" + dadata + "' AND a.data_operazione<='" + adata + "' \nAND a.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND a.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND a.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "'\n";
        if (!conferente.equals("")) {
            ret = ret + " AND a.codice_socio='" + conferente + "' ";
        }
        ret = ret + "ORDER BY a.data_operazione ASC ";
        return ret;
    }

    public void initialize(URL url, ResourceBundle rb) {
    }
}

