/*
 * Decompiled with CFR 0.152.
 */
package vin.controller.librosoci;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXDatePicker;
import com.jfoenix.controls.JFXTextField;
import java.io.IOException;
import java.net.URL;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.util.Callback;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import vin.Class.ColumnTableConfLibroSoci;
import vin.Class.WorkIndicatorDialog;
import vin.controller.FXMLDocumentController;
import vin.controller.RicercaConferentiController;

public class ConfLibroSociController
implements Initializable {
    @FXML
    private TableView<ColumnTableConfLibroSoci> table;
    @FXML
    private TableColumn<ColumnTableConfLibroSoci, String> column_dataoper;
    @FXML
    private TableColumn<ColumnTableConfLibroSoci, String> column_articolo;
    @FXML
    private TableColumn<ColumnTableConfLibroSoci, String> column_id;
    @FXML
    private TableColumn<ColumnTableConfLibroSoci, String> column_socio;
    @FXML
    private TableColumn<ColumnTableConfLibroSoci, String> column_nvolume;
    @FXML
    private TableColumn<ColumnTableConfLibroSoci, String> column_npagina;
    @FXML
    private TableColumn<ColumnTableConfLibroSoci, String> column_importo;
    @FXML
    private JFXButton btn_nuovoMovimento;
    @FXML
    private JFXButton btn_cancella_movimento;
    @FXML
    private StackPane stack;
    @FXML
    private JFXDatePicker dtp_dataoper;
    @FXML
    private JFXTextField editText_conferente;
    @FXML
    private JFXTextField editText_articolo;
    @FXML
    private JFXTextField editText_npagina;
    @FXML
    private JFXTextField editText_nvolume;
    @FXML
    private JFXTextField editText_importo;
    public ObservableList<ColumnTableConfLibroSoci> lista_catastale = FXCollections.observableArrayList();
    @FXML
    private DatePicker dtp_dadataoper;
    @FXML
    private DatePicker dtp_adataoper;
    @FXML
    private TextField editText_codicesocio;
    @FXML
    private JFXButton btn_ricerca1;
    WorkIndicatorDialog wd = null;
    boolean flg_modifica = false;
    String id = "";

    public void initialize(URL url, ResourceBundle rb) {
        this.column_id.setCellValueFactory((Callback)new PropertyValueFactory("column_id"));
        this.column_articolo.setCellValueFactory((Callback)new PropertyValueFactory("column_articolo"));
        this.column_npagina.setCellValueFactory((Callback)new PropertyValueFactory("column_npagina"));
        this.column_nvolume.setCellValueFactory((Callback)new PropertyValueFactory("column_nvolume"));
        this.column_dataoper.setCellValueFactory((Callback)new PropertyValueFactory("column_dataoper"));
        this.column_importo.setCellValueFactory((Callback)new PropertyValueFactory("column_importo"));
        this.column_socio.setCellValueFactory((Callback)new PropertyValueFactory("column_socio"));
        this.table.setItems(this.lista_catastale);
    }

    private void refreshLista(String codice_socio, String dadata_oper, String adata_oper) throws JSONException {
        this.lista_catastale.clear();
        double tot_propr = 0.0;
        double tot_altro = 0.0;
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList lenghtBidimensionalArray = new ArrayList();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        lastID.add(false);
        tipoSQL.add("select");
        String str2 = "SELECT id,codice_socio,n_pagina,n_volume,articolo,data_operazione,importo FROM f_movimenti_libro  WHERE azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' ";
        if (!dadata_oper.equals("") && !adata_oper.equals("")) {
            str2 = str2 + " AND data_operazione >='" + dadata_oper + "'  AND data_operazione<='" + adata_oper + "' ";
        }
        if (!codice_socio.equals("")) {
            str2 = str2 + " AND codice_socio='" + codice_socio + "' ";
        }
        strSQL.add(str2);
        String str = FXMLDocumentController.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
        String data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + str);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = FXMLDocumentController.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                String data_operazione = rec.getString("data_operazione").replace("null", "");
                String id = rec.get("id").toString();
                String n_pagina = rec.get("n_pagina").toString();
                String n_volume = rec.get("n_volume").toString();
                String articolo = rec.get("articolo").toString();
                String importo = rec.get("importo").toString();
                String socio = rec.get("codice_socio").toString();
                this.lista_catastale.add((Object)new ColumnTableConfLibroSoci(id, data_operazione, articolo, n_pagina, n_volume, socio, importo));
            }
        }
        this.table.refresh();
    }

    @FXML
    private void btnSalvaMovimento(ActionEvent event) {
        this.wd = new WorkIndicatorDialog(this.table.getScene().getWindow(), "Caricamento in corso...");
        this.wd.addTaskEndNotification(result -> {
            if (this.wd != null && this.wd.labelWord != null) {
                if (!this.wd.labelWord.equals("")) {
                    if (this.wd.labelWord.contains("#INFORMATION")) {
                        FXMLDocumentController.toast.startToast(this.wd.labelWord, "INFORMAZIONE", "INFORMAZIONE");
                    } else {
                        FXMLDocumentController.util.alertWindow(this.stack, this.wd.labelWord, "ERRORE", "ERRORE");
                    }
                } else {
                    this.resetta();
                }
            }
        });
        this.wd.exec("123", inputParam -> {
            try {
                String dataoper = "";
                String codice_conf = this.editText_conferente.getText().trim();
                String articolo = this.editText_articolo.getText().trim();
                String importo = this.editText_importo.getText().trim();
                String npagina = this.editText_npagina.getText().trim();
                String nvolume = this.editText_nvolume.getText().trim();
                LocalDate dtp = (LocalDate)this.dtp_dataoper.getValue();
                if (dtp != null) {
                    dataoper = dtp.toString();
                }
                this.scriviOperazione(dataoper, codice_conf, articolo, importo, npagina, nvolume);
            }
            catch (Exception ex) {
                this.wd.labelWord = "#ERR:" + ex.getMessage();
            }
            return 1;
        });
    }

    private void scriviOperazione(String dataoper, String codice_conf, String articolo, String importo, String npagina, String nvolume) throws JSONException {
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String[][] tipo_ins = null;
        String[][] valore = null;
        int iterator = 0;
        HashMap<Integer, String[]> ipos = new HashMap<Integer, String[]>();
        HashMap<Integer, String[]> alores = new HashMap<Integer, String[]>();
        if (this.flg_modifica) {
            FXMLDocumentController.sqlUtil.update_f_movimenti_libro(this.id, npagina, nvolume, articolo, dataoper, codice_conf, importo);
            strSQL.addAll(FXMLDocumentController.sqlUtil.strSQL);
            tipoSQL.addAll(FXMLDocumentController.sqlUtil.tipoinsSQL);
            lenghtBidimensionalArray.addAll(FXMLDocumentController.sqlUtil.lengthSQL);
            lastID.addAll(FXMLDocumentController.sqlUtil.lastID);
            ipos.put(iterator, FXMLDocumentController.sqlUtil.tipovaloreSQL.toArray(new String[0]));
            alores.put(iterator, FXMLDocumentController.sqlUtil.valoreSQL.toArray(new String[0]));
            ++iterator;
        } else {
            FXMLDocumentController.sqlUtil.insert_f_movimenti_libro(codice_conf, npagina, nvolume, articolo, dataoper, importo, FXMLDocumentController.GLOBAL_AZIENDA, FXMLDocumentController.GLOBAL_SOTTOAZZ, FXMLDocumentController.GLOBAL_ICQRF);
            strSQL.addAll(FXMLDocumentController.sqlUtil.strSQL);
            tipoSQL.addAll(FXMLDocumentController.sqlUtil.tipoinsSQL);
            lenghtBidimensionalArray.addAll(FXMLDocumentController.sqlUtil.lengthSQL);
            lastID.addAll(FXMLDocumentController.sqlUtil.lastID);
            ipos.put(iterator, FXMLDocumentController.sqlUtil.tipovaloreSQL.toArray(new String[0]));
            alores.put(iterator, FXMLDocumentController.sqlUtil.valoreSQL.toArray(new String[0]));
            ++iterator;
        }
        tipo_ins = FXMLDocumentController.util.HashMapBidimensionalTOArrayBidimensional(ipos);
        valore = FXMLDocumentController.util.HashMapBidimensionalTOArrayBidimensional(alores);
        String strJson = FXMLDocumentController.util.makeStringJsonDB("ON", tipoSQL, strSQL, tipo_ins, valore, lastID, lenghtBidimensionalArray);
        String data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#OK")) {
            this.wd.labelWord = this.wd.labelWord + "#ERR:" + data_select;
        } else {
            this.resetta();
            this.wd.labelWord = this.wd.labelWord + "";
        }
    }

    private void resetta() {
        this.editText_conferente.setText("");
        this.editText_articolo.setText("");
        this.editText_importo.setText("");
        this.editText_npagina.setText("");
        this.editText_nvolume.setText("");
        this.dtp_dataoper.setValue(null);
        this.id = "";
        this.flg_modifica = false;
    }

    @FXML
    private void btnModifica(ActionEvent event) {
        ColumnTableConfLibroSoci oper = (ColumnTableConfLibroSoci)this.table.getSelectionModel().getSelectedItem();
        if (oper != null) {
            this.id = oper.getColumn_id();
            String dataoper = oper.getColumn_dataoper();
            String codice_conf = oper.getColumn_socio();
            String articolo = oper.getColumn_articolo();
            String importo = oper.getColumn_importo();
            String npagina = oper.getColumn_npagina();
            String nvolume = oper.getColumn_nvolume();
            this.editText_articolo.setText(articolo);
            this.editText_conferente.setText(codice_conf);
            this.editText_importo.setText(importo);
            this.editText_npagina.setText(npagina);
            this.editText_nvolume.setText(nvolume);
            LocalDate dt = LocalDate.parse(dataoper);
            this.dtp_dataoper.setValue((Object)dt);
            this.flg_modifica = true;
        }
    }

    @FXML
    private void btnEliminaMovimento(ActionEvent event) {
        ColumnTableConfLibroSoci oper = (ColumnTableConfLibroSoci)this.table.getSelectionModel().getSelectedItem();
        if (oper != null) {
            this.wd = new WorkIndicatorDialog(this.table.getScene().getWindow(), "Caricamento in corso...");
            this.wd.addTaskEndNotification(result -> {
                if (this.wd != null && this.wd.labelWord != null) {
                    if (!this.wd.labelWord.equals("")) {
                        if (this.wd.labelWord.contains("#INFORMATION")) {
                            FXMLDocumentController.toast.startToast(this.wd.labelWord, "INFORMAZIONE", "INFORMAZIONE");
                        } else {
                            FXMLDocumentController.util.alertWindow(this.stack, this.wd.labelWord, "ERRORE", "ERRORE");
                        }
                    } else {
                        this.resetta();
                    }
                }
            });
            this.wd.exec("123", inputParam -> {
                try {
                    String id = oper.getColumn_id();
                    ArrayList<String> tipoSQL = new ArrayList<String>();
                    ArrayList<String> strSQL = new ArrayList<String>();
                    ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
                    ArrayList<Boolean> lastID = new ArrayList<Boolean>();
                    String[][] tipo_ins = null;
                    String[][] valore = null;
                    int iterator = 0;
                    HashMap<Integer, String[]> ipos = new HashMap<Integer, String[]>();
                    HashMap<Integer, String[]> alores = new HashMap<Integer, String[]>();
                    FXMLDocumentController.sqlUtil.delete_f_movimenti_libro(id);
                    strSQL.addAll(FXMLDocumentController.sqlUtil.strSQL);
                    tipoSQL.addAll(FXMLDocumentController.sqlUtil.tipoinsSQL);
                    lenghtBidimensionalArray.addAll(FXMLDocumentController.sqlUtil.lengthSQL);
                    lastID.addAll(FXMLDocumentController.sqlUtil.lastID);
                    ipos.put(iterator, FXMLDocumentController.sqlUtil.tipovaloreSQL.toArray(new String[0]));
                    alores.put(iterator, FXMLDocumentController.sqlUtil.valoreSQL.toArray(new String[0]));
                    ++iterator;
                    tipo_ins = FXMLDocumentController.util.HashMapBidimensionalTOArrayBidimensional(ipos);
                    valore = FXMLDocumentController.util.HashMapBidimensionalTOArrayBidimensional(alores);
                    String strJson = FXMLDocumentController.util.makeStringJsonDB("ON", tipoSQL, strSQL, tipo_ins, valore, lastID, lenghtBidimensionalArray);
                    String data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
                    if (!data_select.equals("")) {
                        this.wd.labelWord = this.wd.labelWord + "#ERR:" + data_select;
                    } else {
                        this.resetta();
                        this.wd.labelWord = this.wd.labelWord + "";
                    }
                }
                catch (Exception ex) {
                    this.wd.labelWord = "#ERR:" + ex.getMessage();
                }
                return 1;
            });
        }
    }

    @FXML
    private void btnCercaConferente(ActionEvent event) throws IOException {
        FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/vin/view/RicercaConferenti.fxml"));
        Stage stage = new Stage();
        stage.setMaximized(false);
        stage.setTitle("CONFERENTI");
        stage.setScene(new Scene((Parent)((Pane)loader.load())));
        RicercaConferentiController controller = (RicercaConferentiController)loader.getController();
        stage.initModality(Modality.APPLICATION_MODAL);
        stage.initStyle(StageStyle.DECORATED);
        stage.setResizable(false);
        stage.showAndWait();
        String codice = controller.getCodice();
        if (!codice.equals("")) {
            this.editText_conferente.setText(codice);
        }
    }

    @FXML
    private void btnRCerca(ActionEvent event) {
        try {
            String dadata_oper = "";
            String adata_oper = "";
            String codice_socio = this.editText_codicesocio.getText();
            LocalDate dtp_data = (LocalDate)this.dtp_dadataoper.getValue();
            if (dtp_data != null) {
                dadata_oper = dtp_data.toString();
            }
            if ((dtp_data = (LocalDate)this.dtp_adataoper.getValue()) != null) {
                adata_oper = dtp_data.toString();
            }
            this.refreshLista(codice_socio, dadata_oper, adata_oper);
        }
        catch (JSONException ex) {
            Logger.getLogger(ConfLibroSociController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void btnCercaSocio(ActionEvent event) throws IOException {
        FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/vin/view/RicercaConferenti.fxml"));
        Stage stage = new Stage();
        stage.setMaximized(false);
        stage.setTitle("CONFERENTI");
        stage.setScene(new Scene((Parent)((Pane)loader.load())));
        RicercaConferentiController controller = (RicercaConferentiController)loader.getController();
        stage.initModality(Modality.APPLICATION_MODAL);
        stage.initStyle(StageStyle.DECORATED);
        stage.setResizable(false);
        stage.showAndWait();
        String codice = controller.getCodice();
        if (!codice.equals("")) {
            this.editText_codicesocio.setText(codice);
        }
    }

    @FXML
    private void btnResetta(ActionEvent event) {
        this.resetta();
    }
}

