/*
 * Decompiled with CFR 0.152.
 */
package vin.controller;

import java.io.IOException;
import java.net.URL;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import org.json.JSONException;
import vin.Comunicator.Sk1SrvCommunicator;
import vin.Uility.JasperReport;
import vin.Uility.JsonUtils;
import vin.Uility.Utility;
import vin.controller.FXMLDocumentController;
import vin.controller.SearchProdottoPool;
import vin.controller.SearchTableCodiceDescrizioneController;
import vin.controller.ToastFXMessages;

public class StampeController
implements Initializable {
    @FXML
    DatePicker dtp_alladata;
    @FXML
    Button btnstampa;
    @FXML
    DatePicker dtp_dalladata;
    @FXML
    RadioButton chk_sfuso;
    @FXML
    RadioButton chk_standard;
    @FXML
    RadioButton chk_estesa;
    @FXML
    RadioButton chk_imbo;
    @FXML
    RadioButton chk_tutto;
    @FXML
    RadioButton chk_pdf;
    @FXML
    RadioButton chk_xls;
    @FXML
    TextField editText_coddopigp;
    @FXML
    Label label_title;
    @FXML
    Label label_dalladata;
    @FXML
    Label label_alladata;
    @FXML
    Label label_prodotto;
    @FXML
    Label label_codoper;
    @FXML
    Label label_annata;
    @FXML
    HBox box_dopigp;
    @FXML
    Label label_coddopigp;
    @FXML
    TextField editText_prodotto;
    @FXML
    TextField editText_codoper;
    @FXML
    TextField editText_annata;
    ToggleGroup groupTipoVino = null;
    ToggleGroup groupTipoStampa = null;
    ToggleGroup groupTipoStampa2 = null;
    JasperReport jasperReport = new JasperReport();
    Sk1SrvCommunicator sk1Comm = new Sk1SrvCommunicator();
    JsonUtils jsonUtil = new JsonUtils();
    static ToastFXMessages toast = new ToastFXMessages();
    public Utility util;
    String setStampa = "";
    String nomeFile = "";
    String strWHERE = "";

    public void initialize(URL url, ResourceBundle rb) {
        try {
            this.util = new Utility();
            this.editText_coddopigp.setEditable(false);
            this.groupTipoVino = new ToggleGroup();
            this.chk_imbo.setToggleGroup(this.groupTipoVino);
            this.chk_sfuso.setToggleGroup(this.groupTipoVino);
            this.chk_tutto.setToggleGroup(this.groupTipoVino);
            this.groupTipoStampa = new ToggleGroup();
            this.chk_pdf.setToggleGroup(this.groupTipoStampa);
            this.chk_xls.setToggleGroup(this.groupTipoStampa);
            this.groupTipoStampa2 = new ToggleGroup();
            this.chk_estesa.setToggleGroup(this.groupTipoStampa2);
            this.chk_standard.setToggleGroup(this.groupTipoStampa2);
            this.editText_prodotto.textProperty().addListener((observable, oldValue, newValue) -> {
                try {
                    if (!newValue.equals("") && newValue.length() == 1) {
                        String prodotto = this.editText_prodotto.getText().trim();
                        FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/vin/view/SearchProdottoPool.fxml"));
                        Stage stage = new Stage();
                        stage.setMaximized(false);
                        stage.setTitle("Prodotto");
                        stage.setScene(new Scene((Parent)((Pane)loader.load())));
                        SearchProdottoPool controller = (SearchProdottoPool)loader.getController();
                        controller.setSearch((String)newValue, " ", "");
                        stage.initModality(Modality.APPLICATION_MODAL);
                        stage.setResizable(false);
                        stage.showAndWait();
                        String codice = controller.getCodice();
                        String descr = controller.getDesString();
                        String atto_cert = controller.getAttoCert();
                        String anno = controller.getAnno();
                        Double capacita = controller.getCapacita();
                        String id = controller.getID();
                        if (!codice.equals("")) {
                            this.editText_prodotto.setText(codice);
                        } else {
                            this.editText_prodotto.setText("");
                        }
                        stage.close();
                    }
                }
                catch (Exception ex) {
                    FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                }
            });
        }
        catch (IOException ex) {
            Logger.getLogger(StampeController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    void btnClearCodDop(ActionEvent event) {
        this.editText_coddopigp.setText("");
    }

    @FXML
    void btnSearchCodDop(ActionEvent event) throws JSONException, IOException {
        FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/vin/view/SearchTableCodiceDescrizione.fxml"));
        Parent rootLayout = (Parent)loader.load();
        Scene scene = new Scene(rootLayout);
        Stage stage = new Stage();
        stage.setTitle("Codici Dop/IGP");
        stage.setScene(scene);
        SearchTableCodiceDescrizioneController controller = (SearchTableCodiceDescrizioneController)loader.getController();
        controller.setTable("sian_t_dopigp");
        stage.initModality(Modality.APPLICATION_MODAL);
        stage.setResizable(true);
        stage.showAndWait();
        String codice = controller.getCodice();
        String descr = controller.getDescrizione();
        if (!codice.equals("")) {
            this.editText_coddopigp.setText(codice);
        }
    }

    @FXML
    public void btnStampa() {
        try {
            ArrayList<String> key = new ArrayList<String>();
            ArrayList<Object> value = new ArrayList<Object>();
            int tipoStampa = 0;
            int tipoStampa2 = 0;
            String stato_fisico = "";
            String nomeFileJRXML = "";
            String alladata = "";
            LocalDate endtime = (LocalDate)this.dtp_alladata.getValue();
            if (endtime != null) {
                alladata = endtime.toString();
            }
            String dalladata = "";
            LocalDate endtime2 = (LocalDate)this.dtp_dalladata.getValue();
            if (endtime2 != null) {
                dalladata = endtime2.toString();
            }
            RadioButton chk_TipoVino = (RadioButton)this.groupTipoVino.getSelectedToggle();
            RadioButton chk_TipoStampa = (RadioButton)this.groupTipoStampa.getSelectedToggle();
            RadioButton chk_TipoStampa2 = (RadioButton)this.groupTipoStampa2.getSelectedToggle();
            if (!chk_TipoStampa2.getText().equals("Standard")) {
                tipoStampa2 = 1;
            }
            tipoStampa = chk_TipoStampa.getText().equals("PDF") ? 1 : 2;
            if (chk_TipoVino.getText().equals("Imbottigliato")) {
                stato_fisico = "<>'1'";
            } else if (chk_TipoVino.getText().equals("Sfuso")) {
                stato_fisico = "='1'";
            }
            String codoper = this.editText_codoper.getText().trim();
            String annata = this.editText_annata.getText().trim();
            String prodotto = this.editText_prodotto.getText().trim();
            String cod_dop = this.editText_coddopigp.getText().trim();
            String resp = "";
            this.strWHERE = "";
            switch (this.setStampa) {
                case "ProgressivoGiacenza": {
                    if (alladata.equals("")) {
                        toast.startToast("(Alla Data) Campo obbligatorio", "ERRORE", "ERRORE");
                        return;
                    }
                    if (dalladata.equals("")) {
                        toast.startToast("(Dalla Data) Campo obbligatorio", "ERRORE", "ERRORE");
                        return;
                    }
                    String where = "";
                    if (!stato_fisico.equals("")) {
                        where = " AND sian_cod_stato_fisico" + stato_fisico + " ";
                    }
                    this.strWHERE = this.selectReportProgressivoGiacenza(alladata, dalladata, prodotto, tipoStampa2, codoper);
                    key.add("DA_DATA");
                    key.add("A_DATA");
                    key.add("QUERY");
                    key.add("AZIENDA");
                    key.add("SOTTO_AZ");
                    key.add("ICQRF");
                    key.add("COD_COMMITTENTE");
                    value.add(dalladata);
                    value.add(alladata);
                    value.add(this.strWHERE);
                    value.add(FXMLDocumentController.GLOBAL_AZIENDA);
                    value.add(FXMLDocumentController.GLOBAL_SOTTOAZZ);
                    value.add(FXMLDocumentController.GLOBAL_ICQRF);
                    value.add(FXMLDocumentController.GLOBAL_CODCOMM);
                    nomeFileJRXML = tipoStampa == 1 ? "inventarioprogressivo_stdP.jrxml" : "inventarioprogressivo_stdE.jrxml";
                    resp = this.jasperReport.JSONjr(nomeFileJRXML, key, value, tipoStampa, "");
                    this.nomeFile = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "JasperReport#@" + resp);
                    this.util.downloadFileTemp(this.nomeFile);
                    break;
                }
                case "InventarioM": {
                    if (alladata.equals("")) {
                        toast.startToast("(Alla Data) Campo obbligatorio", "ERRORE", "ERRORE");
                        return;
                    }
                    this.strWHERE = this.selectReportInventarioM(dalladata, alladata, annata, prodotto, stato_fisico);
                    key.add("A_DATA");
                    key.add("QUERY");
                    key.add("AZIENDA");
                    key.add("SOTTO_AZ");
                    key.add("ICQRF");
                    key.add("COD_COMMITTENTE");
                    value.add(alladata);
                    value.add(this.strWHERE);
                    value.add(FXMLDocumentController.GLOBAL_AZIENDA);
                    value.add(FXMLDocumentController.GLOBAL_SOTTOAZZ);
                    value.add(FXMLDocumentController.GLOBAL_ICQRF);
                    value.add(FXMLDocumentController.GLOBAL_CODCOMM);
                    nomeFileJRXML = tipoStampa == 1 ? "inventariomP.jrxml" : "inventariomE.jrxml";
                    resp = this.jasperReport.JSONjr(nomeFileJRXML, key, value, tipoStampa, "");
                    this.nomeFile = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "JasperReport#@" + resp);
                    this.util.downloadFileTemp(this.nomeFile);
                }
            }
        }
        catch (IOException | JSONException e) {
            this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", e.toString());
        }
    }

    public void setStampa(String tipo) {
        switch (this.setStampa = tipo) {
            case "ProgressivoGiacenza": {
                this.box_dopigp.setVisible(false);
                this.label_coddopigp.setVisible(false);
                this.label_codoper.setVisible(false);
                this.editText_codoper.setVisible(false);
                this.chk_estesa.setVisible(false);
                this.chk_standard.setVisible(false);
                this.chk_standard.setSelected(true);
                this.dtp_dalladata.setVisible(true);
                this.label_dalladata.setVisible(true);
                this.chk_xls.setSelected(true);
                this.chk_tutto.setSelected(true);
                this.label_title.setText(this.setStampa);
                this.dtp_alladata.setValue((Object)LocalDate.now());
                this.dtp_dalladata.setValue((Object)LocalDate.now());
                this.label_annata.setVisible(false);
                this.label_prodotto.setVisible(true);
                this.editText_annata.setVisible(false);
                this.editText_prodotto.setVisible(true);
                this.label_alladata.setVisible(true);
                break;
            }
            case "CASD-Prodotti": {
                this.box_dopigp.setVisible(false);
                this.label_coddopigp.setVisible(false);
                this.label_codoper.setVisible(false);
                this.editText_codoper.setVisible(false);
                this.chk_estesa.setVisible(false);
                this.chk_standard.setVisible(false);
                this.chk_standard.setSelected(true);
                this.dtp_dalladata.setVisible(true);
                this.label_dalladata.setVisible(true);
                this.chk_xls.setSelected(true);
                this.chk_tutto.setSelected(true);
                this.chk_tutto.setVisible(false);
                this.chk_imbo.setVisible(false);
                this.chk_sfuso.setVisible(false);
                this.label_title.setText(this.setStampa);
                this.dtp_alladata.setValue((Object)LocalDate.now());
                this.dtp_dalladata.setValue((Object)LocalDate.now());
                this.label_annata.setVisible(false);
                this.label_prodotto.setVisible(true);
                this.editText_annata.setVisible(false);
                this.editText_prodotto.setVisible(true);
                this.label_alladata.setVisible(true);
                break;
            }
            case "Inventario": {
                this.box_dopigp.setVisible(true);
                this.label_coddopigp.setVisible(true);
                this.chk_standard.setSelected(true);
                this.dtp_dalladata.setVisible(false);
                this.label_dalladata.setVisible(false);
                this.chk_pdf.setSelected(true);
                this.chk_tutto.setSelected(true);
                this.chk_estesa.setVisible(false);
                this.chk_standard.setVisible(false);
                this.label_title.setText(this.setStampa);
                this.dtp_alladata.setValue((Object)LocalDate.now());
                this.dtp_dalladata.setValue((Object)LocalDate.now());
                this.label_annata.setVisible(true);
                this.label_prodotto.setVisible(true);
                this.editText_annata.setVisible(true);
                this.editText_prodotto.setVisible(true);
                this.label_alladata.setVisible(true);
                this.label_codoper.setVisible(false);
                this.editText_codoper.setVisible(false);
                break;
            }
            case "InventarioM": {
                this.box_dopigp.setVisible(false);
                this.label_coddopigp.setVisible(false);
                this.chk_standard.setSelected(true);
                this.dtp_dalladata.setVisible(false);
                this.label_dalladata.setVisible(false);
                this.chk_pdf.setSelected(true);
                this.chk_tutto.setSelected(true);
                this.chk_estesa.setVisible(false);
                this.chk_standard.setVisible(false);
                this.label_title.setText(this.setStampa);
                this.dtp_alladata.setValue((Object)LocalDate.now());
                this.dtp_dalladata.setValue((Object)LocalDate.now());
                this.label_annata.setVisible(true);
                this.label_prodotto.setVisible(true);
                this.editText_annata.setVisible(true);
                this.editText_prodotto.setVisible(true);
                this.label_alladata.setVisible(true);
                this.label_codoper.setVisible(false);
                this.editText_codoper.setVisible(false);
                break;
            }
            case "InventarioC": {
                this.box_dopigp.setVisible(false);
                this.label_coddopigp.setVisible(false);
                this.chk_standard.setSelected(true);
                this.dtp_dalladata.setVisible(false);
                this.label_dalladata.setVisible(false);
                this.chk_pdf.setSelected(true);
                this.chk_tutto.setSelected(true);
                this.chk_estesa.setVisible(false);
                this.chk_standard.setVisible(false);
                this.label_title.setText(this.setStampa);
                this.dtp_alladata.setValue((Object)LocalDate.now());
                this.dtp_dalladata.setValue((Object)LocalDate.now());
                this.label_annata.setVisible(true);
                this.label_prodotto.setVisible(true);
                this.editText_annata.setVisible(true);
                this.editText_prodotto.setVisible(true);
                this.label_alladata.setVisible(true);
                this.label_codoper.setVisible(false);
                this.editText_codoper.setVisible(false);
                break;
            }
            case "InventarioL": {
                this.box_dopigp.setVisible(false);
                this.label_coddopigp.setVisible(false);
                this.chk_standard.setSelected(true);
                this.dtp_dalladata.setVisible(false);
                this.label_dalladata.setVisible(false);
                this.chk_pdf.setSelected(true);
                this.chk_tutto.setSelected(true);
                this.chk_estesa.setVisible(false);
                this.chk_standard.setVisible(false);
                this.label_title.setText(this.setStampa);
                this.dtp_alladata.setValue((Object)LocalDate.now());
                this.dtp_dalladata.setValue((Object)LocalDate.now());
                this.label_annata.setVisible(true);
                this.label_prodotto.setVisible(true);
                this.editText_annata.setVisible(true);
                this.editText_prodotto.setVisible(true);
                this.label_alladata.setVisible(true);
                this.label_codoper.setVisible(false);
                this.editText_codoper.setVisible(false);
                break;
            }
            case "Movimenti": {
                this.box_dopigp.setVisible(false);
                this.label_coddopigp.setVisible(false);
                this.label_codoper.setVisible(true);
                this.editText_codoper.setVisible(true);
                this.chk_estesa.setVisible(true);
                this.chk_standard.setVisible(true);
                this.chk_standard.setSelected(true);
                this.dtp_dalladata.setVisible(true);
                this.label_dalladata.setVisible(true);
                this.chk_xls.setSelected(true);
                this.chk_tutto.setSelected(true);
                this.label_title.setText(this.setStampa);
                this.dtp_alladata.setValue((Object)LocalDate.now());
                this.dtp_dalladata.setValue((Object)LocalDate.now());
                this.label_annata.setVisible(true);
                this.label_prodotto.setVisible(true);
                this.editText_annata.setVisible(true);
                this.editText_prodotto.setVisible(true);
                this.label_alladata.setVisible(true);
                break;
            }
            case "VasiVinari": {
                this.box_dopigp.setVisible(false);
                this.label_coddopigp.setVisible(false);
                this.chk_standard.setSelected(true);
                this.label_codoper.setVisible(false);
                this.editText_codoper.setVisible(false);
                this.chk_estesa.setVisible(true);
                this.chk_standard.setVisible(true);
                this.dtp_alladata.setVisible(true);
                this.label_dalladata.setVisible(false);
                this.dtp_dalladata.setVisible(false);
                this.chk_imbo.setVisible(false);
                this.chk_sfuso.setVisible(false);
                this.chk_tutto.setVisible(false);
                this.chk_xls.setSelected(true);
                this.chk_tutto.setSelected(true);
                this.label_title.setText(this.setStampa);
                this.dtp_alladata.setValue((Object)LocalDate.now());
                this.label_annata.setVisible(true);
                this.label_prodotto.setVisible(true);
                this.editText_annata.setVisible(true);
                this.editText_prodotto.setVisible(true);
                this.label_alladata.setVisible(true);
                break;
            }
            case "SIAN-Giacenze-test": {
                this.box_dopigp.setVisible(false);
                this.label_coddopigp.setVisible(false);
                this.chk_tutto.setVisible(false);
                this.chk_sfuso.setVisible(false);
                this.chk_imbo.setVisible(false);
                this.chk_pdf.setVisible(false);
                this.chk_xls.setVisible(false);
                this.label_codoper.setVisible(false);
                this.editText_codoper.setVisible(false);
                this.chk_estesa.setVisible(false);
                this.chk_standard.setVisible(false);
                this.chk_standard.setSelected(true);
                this.dtp_dalladata.setVisible(false);
                this.label_dalladata.setVisible(false);
                this.chk_xls.setSelected(true);
                this.chk_tutto.setSelected(true);
                this.label_title.setText(this.setStampa);
                this.dtp_alladata.setValue((Object)LocalDate.now());
                this.label_annata.setVisible(false);
                this.label_prodotto.setVisible(false);
                this.editText_annata.setVisible(false);
                this.editText_prodotto.setVisible(false);
                this.label_alladata.setVisible(true);
                break;
            }
            case "SIAN-Giacenze": {
                this.box_dopigp.setVisible(false);
                this.label_coddopigp.setVisible(false);
                this.chk_tutto.setVisible(false);
                this.chk_sfuso.setVisible(false);
                this.chk_imbo.setVisible(false);
                this.chk_pdf.setVisible(false);
                this.chk_xls.setVisible(false);
                this.label_codoper.setVisible(false);
                this.editText_codoper.setVisible(false);
                this.chk_estesa.setVisible(false);
                this.chk_standard.setVisible(false);
                this.chk_standard.setSelected(true);
                this.dtp_dalladata.setVisible(false);
                this.label_dalladata.setVisible(false);
                this.chk_xls.setSelected(true);
                this.chk_tutto.setSelected(true);
                this.label_title.setText(this.setStampa);
                this.dtp_alladata.setValue((Object)LocalDate.now());
                this.label_annata.setVisible(false);
                this.label_prodotto.setVisible(false);
                this.editText_annata.setVisible(false);
                this.editText_prodotto.setVisible(false);
                this.label_alladata.setVisible(true);
            }
        }
    }

    private String selectReportVasiVinari(String prodotto, String annata, int tipoStampa, String a_data) {
        String res = "";
        if (a_data.equals("")) {
            a_data = LocalDate.now().toString();
        }
        String r = "";
        res = "SELECT DISTINCT a.ID, a.CODICE, a.DESCRIZIONE, a.TIPO, a.COD_VINO, a.DESCR_VINO, a.PROTOCOLLO, a.ENTE, a.DATA, IFNULL(a.GIACENZA,0) AS GIACENZA, a.COMMI,CONCAT(IFNULL(b.commit_nome,''), ' ', IFNULL(b.commit_cognome,'')) AS NOME, IFNULL(b.commit_rag_soc,'') AS RAG_SOC FROM ( SELECT ID, CODICE, DESCRIZIONE, TIPO, IF(GIACENZA = 0 OR ISNULL(GIACENZA), '', COD_VINO) AS COD_VINO, IF(GIACENZA = 0 OR ISNULL(GIACENZA), '', DESCR_VINO) AS DESCR_VINO, IF(GIACENZA = 0 OR ISNULL(GIACENZA), '', PROTOCOLLO) AS PROTOCOLLO, IF(GIACENZA = 0 OR ISNULL(GIACENZA), '', ENTE) AS ENTE, IF(GIACENZA = 0 OR ISNULL(GIACENZA), NULL, DATA) AS DATA, GIACENZA, IF(GIACENZA = 0 OR ISNULL(GIACENZA), '', COMMI) AS COMMI, a.icqrf AS ICQRF FROM ( SELECT a.id AS ID, a.codice_vaso AS CODICE, a.descr_vaso AS DESCRIZIONE, d.DESCRIZIONE AS TIPO, c.codice AS COD_VINO,c.sian_annata AS ANNATA, c.descrizione AS DESCR_VINO, e.num_prot_ido AS PROTOCOLLO, e.ente_cert AS ENTE, IF (e.data_ido = '0000-00-00', NULL, e.data_ido) AS DATA, SUM(b.qta_mov) AS GIACENZA, IFNULL(b.cod_committente,'') AS COMMI, a.icqrf AS ICQRF FROM gen_vasi_vinari_ana AS a LEFT JOIN gen_vasi_vinari_mov AS b ON a.id = b.id_vaso AND a.azienda = b.azienda AND a.sotto_az = b.sotto_az AND a.icqrf = b.icqrf LEFT JOIN gen_tipo_vino_ana AS c ON b.cod_tipo_vino = c.codice AND b.azienda = c.azienda AND b.sotto_az = c.sotto_az AND b.icqrf = c.icqrf AND b.cod_committente = c.cod_committente LEFT JOIN sian_t_tipo_vaso AS d ON a.tipo_vaso = d.CODICE LEFT JOIN c_movimenti AS e ON b.id_mov = e.id LEFT JOIN c_operazioni AS x ON e.id_oper=x.id WHERE a.codice_vaso<>'@VASOWBS@' AND a.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND a.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND a.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "'  AND x.data_oper<='" + a_data + "' GROUP BY a.codice_vaso, c.codice, e.num_prot_ido, e.ente_cert, IF(e.data_ido = '0000-00-00', NULL, e.data_ido), b.cod_committente  ORDER BY a.codice_vaso, b.cod_committente ) AS a WHERE GIACENZA <> 0 ";
        if (!FXMLDocumentController.GLOBAL_CODCOMM.equals("")) {
            res = res + "AND COMMI = '" + FXMLDocumentController.GLOBAL_CODCOMM + "' ";
        }
        if (!prodotto.equals("")) {
            res = res + " AND COD_VINO = '" + prodotto + "' ";
        }
        if (!annata.equals("")) {
            res = res + " AND ANNATA = '" + annata + "' ";
        }
        res = res + "OR ID NOT IN ( SELECT a.ID FROM ( SELECT a.id, SUM(b.qta_mov) AS giacenza FROM gen_vasi_vinari_ana AS a LEFT JOIN gen_vasi_vinari_mov AS b ON b.id_vaso = a.id AND a.azienda = b.azienda AND a.sotto_az = b.sotto_az AND a.icqrf = b.icqrf LEFT JOIN gen_tipo_vino_ana AS c ON b.cod_tipo_vino = c.codice AND b.azienda = c.azienda AND b.sotto_az = c.sotto_az AND b.icqrf = c.icqrf AND b.cod_committente = c.cod_committente LEFT JOIN sian_t_tipo_vaso AS d ON a.tipo_vaso = d.CODICE LEFT JOIN c_movimenti AS e ON b.id_mov = e.id LEFT JOIN c_operazioni AS x ON e.id_oper=x.id WHERE a.codice_vaso<>'@VASOWBS@' AND b.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND b.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND b.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND x.data_oper<='" + a_data + "' GROUP BY a.codice_vaso, c.codice, e.num_prot_ido, e.ente_cert, IF(e.data_ido = '0000-00-00', NULL, e.data_ido), b.cod_committente  HAVING giacenza <> 0 ) AS a ) ) AS a LEFT JOIN gen_t_icqrf_mxmag AS b ON a.ICQRF = b.icqrf AND COMMI = b.cod_committente ORDER BY COMMI, CODICE ";
        return res;
    }

    private String selectReportCASDProdotti(String prodotto, int tipoStampa, String dalladata, String a_data) {
        String ret = "SELECT * FROM ( SELECT a.cod_tipo_vino AS CODICE, b.descrizione AS DESCRIZIONE, SUM(a.qta) AS QTA, SUM(a.litri) AS LITRI, SUM(IF(a.qta >= 0, a.confez,(-1)*a.confez)) AS PEZZI FROM c_movimenti AS a LEFT JOIN gen_tipo_vino_ana AS b ON a.cod_tipo_vino = b.codice AND a.azienda = b.azienda AND a.sotto_az = b.sotto_az AND a.icqrf = b.icqrf AND a.cod_committente = b.cod_committente LEFT JOIN c_operazioni AS c ON a.id_oper = c.id LEFT JOIN gen_t_oper_sian AS k ON c.cod_oper=k.tipo_oper WHERE a.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND a.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND a.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "'   AND a.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "' ";
        if (a_data.equals("")) {
            a_data = LocalDate.now().toString();
        }
        if (dalladata.equals("")) {
            dalladata = LocalDate.now().toString();
        }
        if (!prodotto.equals("")) {
            ret = ret + "AND a.cod_tipo_vino = '" + prodotto + "' ";
        }
        ret = ret + "AND c.data_oper <= '" + a_data + "' AND c.data_oper >= '" + dalladata + "' ";
        ret = ret + "AND (k.sian_cod_oper='CASD' OR k.sian_cod_oper LIKE   CASE WHEN b.sian_cat_prodotto = '18' THEN      'PIGI'    ELSE     'CASD'   END  OR k.sian_cod_oper LIKE   CASE WHEN b.sian_cat_prodotto = '16' OR b.sian_cat_prodotto='17' THEN      'PIGI'    ELSE     'CASD'   END OR k.sian_cod_oper LIKE   CASE WHEN b.sian_cat_prodotto = '16' OR b.sian_cat_prodotto='17' THEN      'SVIN'    ELSE     'CASD'   END OR k.sian_cod_oper LIKE   CASE WHEN b.sian_cat_prodotto = '15'  THEN      'PIGI'    ELSE     'CASD'   END OR k.sian_cod_oper LIKE   CASE WHEN b.sian_cat_prodotto = '15' THEN      'SVIN'    ELSE     'CASD'   END )  ";
        ret = ret + "GROUP BY a.cod_tipo_vino ";
        ret = ret + ") AS a ";
        return ret;
    }

    private String selectReportInventarioM(String da_data, String a_data, String annata, String prodotto, String stato_fisico) {
        String ret = "SELECT * FROM ( SELECT a.cod_tipo_vino AS CODICE,IFNULL(a.cod_prod_mx,'') AS CODICE_MEXAL, b.descrizione AS DESCRIZIONE, b.sian_annata AS ANNATA, SUM(a.qta) AS QTA, SUM(a.litri) AS LITRI, SUM(IF(a.qta >= 0, a.confez,(-1)*a.confez)) AS PEZZI, a.num_prot_ido AS PROTOCOLLO, a.ente_cert AS ENTE, IF(a.data_ido = '0000-00-00',NULL,a.data_ido) AS DATA,'' AS LOTTO FROM c_movimenti AS a LEFT JOIN gen_tipo_vino_ana AS b ON a.cod_tipo_vino = b.codice AND a.azienda = b.azienda AND a.sotto_az = b.sotto_az AND a.icqrf = b.icqrf AND a.cod_committente = b.cod_committente LEFT JOIN c_operazioni AS c ON a.id_oper = c.id WHERE a.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND a.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND a.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "'   AND a.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "' ";
        if (a_data.equals("")) {
            a_data = LocalDate.now().toString();
        }
        if (!prodotto.equals("")) {
            ret = ret + "AND a.cod_tipo_vino = '" + prodotto + "' ";
        }
        if (!stato_fisico.equals("")) {
            ret = ret + "AND b.sian_cod_stato_fisico" + stato_fisico + " ";
        }
        if (!annata.equals("")) {
            ret = ret + "AND b.sian_annata = '" + annata + "' ";
        }
        ret = ret + "AND c.data_oper <= '" + a_data + "' AND c.data_oper >= '" + da_data + "' ";
        ret = ret + "GROUP BY a.cod_prod_mx ";
        ret = ret + ") AS a ";
        return ret;
    }

    private String selectReportInventario(String da_data, String a_data, String annata, String prodotto, String stato_fisico, String cod_dop) {
        String ret = "SELECT * FROM ( SELECT a.cod_tipo_vino AS CODICE, b.descrizione AS DESCRIZIONE, b.sian_annata AS ANNATA, SUM(a.qta) AS QTA, SUM(a.litri) AS LITRI, SUM(IF(a.qta >= 0, a.confez,(-1)*a.confez)) AS PEZZI, a.num_prot_ido AS PROTOCOLLO, a.ente_cert AS ENTE, IF(a.data_ido = '0000-00-00',NULL,a.data_ido) AS DATA,'' AS LOTTO FROM c_movimenti AS a LEFT JOIN gen_tipo_vino_ana AS b ON a.cod_tipo_vino = b.codice AND a.azienda = b.azienda AND a.sotto_az = b.sotto_az AND a.icqrf = b.icqrf AND a.cod_committente = b.cod_committente LEFT JOIN c_operazioni AS c ON a.id_oper = c.id WHERE a.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND a.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND a.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "'   AND a.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "' ";
        if (a_data.equals("")) {
            a_data = LocalDate.now().toString();
        }
        if (da_data.equals("")) {
            da_data = "2017-01-01";
        }
        if (!prodotto.equals("")) {
            ret = ret + "AND a.cod_tipo_vino = '" + prodotto + "' ";
        }
        if (!stato_fisico.equals("")) {
            ret = ret + "AND b.sian_cod_stato_fisico" + stato_fisico + " ";
        }
        if (!annata.equals("")) {
            ret = ret + "AND b.sian_annata = '" + annata + "' ";
        }
        if (!cod_dop.equals("")) {
            ret = ret + "AND b.sian_codice_dop_igp='" + cod_dop + "' ";
        }
        ret = ret + "AND c.data_oper>='" + da_data + "' AND c.data_oper <= '" + a_data + "' ";
        ret = ret + "GROUP BY a.cod_tipo_vino ";
        ret = ret + ") AS a ";
        return ret;
    }

    private String selectReportInventarioL(String da_data, String a_data, String annata, String prodotto, String stato_fisico) {
        String ret = "SELECT * FROM ( SELECT a.cod_tipo_vino AS CODICE, b.descrizione AS DESCRIZIONE, b.sian_annata AS ANNATA,  IFNULL(SUM(d.qta * a.volume),'') AS LITRI, IFNULL(SUM(d.qta),'') AS PEZZI, d.cod_lotto AS LOTTO FROM c_movimenti AS a LEFT JOIN gen_tipo_vino_ana AS b ON a.cod_tipo_vino = b.codice AND a.azienda = b.azienda AND a.sotto_az = b.sotto_az AND a.icqrf = b.icqrf AND a.cod_committente = b.cod_committente LEFT JOIN c_operazioni AS c ON a.id_oper = c.id LEFT JOIN c_movimenti_lotti AS d ON a.id = d.id_mov AND a.azienda = d.azienda AND a.sotto_az = d.sotto_az AND a.icqrf = d.icqrf AND a.cod_committente = d.cod_committente WHERE a.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND a.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND a.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "'   AND a.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "' ";
        if (a_data.equals("")) {
            a_data = LocalDate.now().toString();
        }
        if (!prodotto.equals("")) {
            ret = ret + "AND a.cod_tipo_vino = '" + prodotto + "' ";
        }
        if (!stato_fisico.equals("")) {
            ret = ret + "AND b.sian_cod_stato_fisico" + stato_fisico + " ";
        }
        if (!annata.equals("")) {
            ret = ret + "AND b.sian_annata = '" + annata + "' ";
        }
        ret = ret + "AND c.data_oper <= '" + a_data + "' AND c.data_oper >= '" + da_data + "' GROUP BY a.cod_tipo_vino, d.cod_lotto ) AS a ";
        return ret;
    }

    private String selectReportInventarioC(String da_data, String a_data, String annata, String prodotto, String stato_fisico) {
        String ret = "SELECT * FROM ( SELECT a.cod_tipo_vino AS CODICE, b.descrizione AS DESCRIZIONE, b.sian_annata AS ANNATA, SUM(a.qta) AS QTA, SUM(a.litri) AS LITRI, SUM(IF(a.qta >= 0, a.confez,(-1)*a.confez)) AS PEZZI, a.num_prot_ido AS PROTOCOLLO, a.ente_cert AS ENTE, IF(a.data_ido = '0000-00-00',NULL,a.data_ido) AS DATA FROM c_movimenti AS a LEFT JOIN gen_tipo_vino_ana AS b ON a.cod_tipo_vino = b.codice AND a.azienda = b.azienda AND a.sotto_az = b.sotto_az AND a.icqrf = b.icqrf AND a.cod_committente = b.cod_committente LEFT JOIN c_operazioni AS c ON a.id_oper = c.id WHERE a.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND a.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND a.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "'   AND a.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "' ";
        if (a_data.equals("")) {
            a_data = LocalDate.now().toString();
        }
        if (!prodotto.equals("")) {
            ret = ret + "AND a.cod_tipo_vino = '" + prodotto + "' ";
        }
        if (!stato_fisico.equals("")) {
            ret = ret + "AND b.sian_cod_stato_fisico" + stato_fisico + " ";
        }
        if (!annata.equals("")) {
            ret = ret + "AND b.sian_annata = '" + annata + "' ";
        }
        ret = ret + "AND c.data_oper <= '" + a_data + "' AND c.data_oper >= '" + da_data + "' AND b.sian_atto_certificato = '2' AND b.sian_cod_stato_fisico <> '2' GROUP BY a.cod_tipo_vino, a.num_prot_ido, a.ente_cert, IF(a.data_ido = '0000-00-00',NULL,a.data_ido) ) AS a ";
        return ret;
    }

    private String selectReportProgressivoGiacenza(String a_data, String da_data, String prodotto, int tipoStampa, String cod_oper) {
        String res = "";
        res = "SELECT IF (c.data_oper = '0000-00-00', NULL, c.data_oper) AS DATA_OPER,a.cod_tipo_vino AS CODICE, b.descrizione AS DESCRIZIONE, a.qta AS QTA, a.litri AS LITRI,@a:=@a+a.litri AS TOT FROM c_movimenti AS a LEFT JOIN gen_tipo_vino_ana AS b ON a.cod_tipo_vino = b.codice AND a.azienda = b.azienda AND a.sotto_az = b.sotto_az AND a.icqrf = b.icqrf AND a.cod_committente = b.cod_committente LEFT JOIN c_operazioni AS c ON a.id_oper = c.id WHERE a.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND a.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND a.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "'   AND a.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "' ";
        if (da_data.equals("")) {
            da_data = "2017-01-01";
        }
        if (a_data.equals("")) {
            a_data = LocalDate.now().toString();
        }
        res = res + " AND (c.data_oper >= '" + da_data + "' AND c.data_oper <= '" + a_data + "') ";
        if (!prodotto.equals("")) {
            res = res + "AND a.cod_tipo_vino = '" + prodotto + "' ";
        }
        return res;
    }

    private String selectReportMovimenti(String a_data, String da_data, String prodotto, String annata, String stato_fisico, int tipoStampa, String cod_oper) {
        String ret = "";
        if (tipoStampa == 0) {
            ret = "SELECT data_oper, cod_oper, sigla, num_doc, cod_tipo_vino, descrizione, annata, num_prot_ido, ente_cert, data_ido, confez, lotti, qta,serie,fascette_da,fascette_a,fascette_tot,cod_mx FROM ( SELECT IFNULL(m.serie,'') AS serie,IFNULL(m.n_etic_mov_da,'') AS fascette_da,IFNULL(m.n_etic_mov_a,'') AS fascette_a,IFNULL(m.qta_mov,'') AS fascette_tot,@idmov := b.id AS id_movimento, a.data_oper AS data_oper, d.sian_cod_oper AS cod_oper, a.azienda AS azienda, a.sotto_az AS sotto_az, a.icqrf AS icqrf, a.cod_committente AS cod_committente, a.data_oper AS data_doc_mx, a.tipo_oper, a.mx_doc_sigla AS sigla, IF(a.mx_doc_num <> 0, CONCAT(CAST(a.mx_doc_ser AS CHAR(50)), '/', CAST(a.mx_doc_num AS CHAR(50))), '') AS num_doc, b.cod_tipo_vino AS cod_tipo_vino, c.descrizione AS descrizione, c.sian_annata AS annata, if(b.data_ido = '0000-00-00', NULL, b.data_ido) AS data_ido, b.num_prot_ido AS num_prot_ido, b.ente_cert AS ente_cert,b.confez AS confez, IFNULL((SELECT GROUP_CONCAT(CAST(y.cod_lotto AS CHAR) SEPARATOR '|') FROM c_movimenti_lotti AS y WHERE y.id_mov = @idmov GROUP BY y.id_mov),'') AS lotti, b.volume AS volume_nominale, b.qta AS qta,b.cod_prod_mx AS cod_mx FROM c_operazioni AS a LEFT JOIN c_movimenti AS b ON a.id = b.id_oper LEFT JOIN gen_tipo_vino_ana AS c ON b.cod_tipo_vino = c.codice AND b.azienda=c.azienda AND b.sotto_az=c.sotto_az AND b.icqrf=c.icqrf AND b.cod_committente=c.cod_committente LEFT JOIN gen_t_oper_sian AS d ON a.cod_oper = d.tipo_oper LEFT JOIN c_movimenti_etic AS m ON b.id=m.id_mov WHERE !ISNULL(b.id) AND a.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND a.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND a.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "'   AND a.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "' ";
            if (da_data.equals("")) {
                da_data = "2017-01-01";
            }
            if (a_data.equals("")) {
                a_data = LocalDate.now().toString();
            }
            ret = ret + " AND (a.data_oper >= '" + da_data + "' AND a.data_oper <= '" + a_data + "') ";
            if (!prodotto.equals("")) {
                ret = ret + "AND b.cod_tipo_vino = '" + prodotto + "' ";
            }
            if (!stato_fisico.equals("")) {
                ret = ret + "AND c.sian_cod_stato_fisico" + stato_fisico + " ";
            }
            if (!annata.equals("")) {
                ret = ret + "AND c.sian_annata = '" + annata + "' ";
            }
            if (!cod_oper.equals("")) {
                ret = ret + "AND d.sian_cod_oper = '" + cod_oper + "' ";
            }
            ret = ret + ") AS x ORDER BY data_oper  ";
        } else {
            ret = "SELECT id_movimento, data_oper, azienda, sotto_az, icqrf, cod_stato_fisico, operazione, data_doc_mx, num_doc_mx, forn_dest, cod_tipo_vino, descrizione, classificazione, atto_certificato, stato_fisico, colore, biologico, tenore_zuccherino, codice_dop_igp, percentuale_igp, sottozona, menzioni, data_ido, num_prot_ido, ebacchus, annata, annata_percentuale, varieta, perc_varieta, altre_varieta, zona_viticola, origine_uve, paese_provenienza, pratiche_eno, massa_volumica, titolo_alcol_pot, titolo_alcol_eff, titolo_alcol_tot, codice_vaso, confez, volume_nominale, lotti, qta_scarico, qta_carico, cod_committente,serie,fascette_da,fascette_a,fascette_tot  FROM ( SELECT IFNULL(u.serie,'') AS serie,IFNULL(u.n_etic_mov_da,'') AS fascette_da,IFNULL(u.n_etic_mov_a,'') AS fascette_a,IFNULL(u.qta_mov,'') AS fascette_tot,@idmov := b.id AS id_movimento, a.data_oper AS data_oper, a.azienda AS azienda, a.sotto_az AS sotto_az, a.icqrf AS icqrf, a.cod_committente AS cod_committente, c.sian_cod_stato_fisico AS cod_stato_fisico, IF(d.sian_cod_oper <> '', CONCAT(d.sian_cod_oper, ' - ', d.descrizione), '') AS operazione, a.data_oper AS data_doc_mx, a.tipo_oper, IF(a.mx_doc_num <> 0, CONCAT(CAST(a.mx_doc_ser AS CHAR(50)), '/', CAST(a.mx_doc_num AS CHAR(50))), '') AS num_doc_mx, CONCAT(a.mx_doc_cli_ragsoc, a.mx_doc_cli_nome, '', a.mx_doc_cli_cognome) AS forn_dest, b.cod_tipo_vino AS cod_tipo_vino, c.descrizione AS descrizione, IF(c.sian_classificazione <> '', CONCAT(c.sian_classificazione, ' - ', e.DESCRIZIONE), '') AS classificazione, IF(c.sian_atto_certificato <> '', CONCAT(c.sian_atto_certificato, ' - ', f.DESCRIZIONE), '') AS atto_certificato, IF(c.sian_cod_stato_fisico <> '', CONCAT(c.sian_cod_stato_fisico, ' - ', g.DESCRIZIONE), '') AS stato_fisico, IF(c.sian_colore <> '', CONCAT(c.sian_colore, ' - ', h.DESCRIZIONE), '') AS colore, IF(c.sian_biologico <> '', CONCAT(c.sian_biologico, ' - ', i.DESCRIZIONE), '') AS biologico, IF(c.sian_cod_tenore_zuccherino<> '',CONCAT(c.sian_cod_tenore_zuccherino,' - ',l.DESCRIZIONE), '') AS tenore_zuccherino, IF(c.sian_codice_dop_igp <> '',CONCAT(c.sian_codice_dop_igp, ' - ', m.Codice), '') AS codice_dop_igp, c.sian_percentuale_igp AS percentuale_igp, IF(c.sian_cod_sottozona <> '', CONCAT(c.sian_cod_sottozona, ' - ', n.DESCRIZIONE), '') AS sottozona, c.sian_menzioni AS menzioni, IF(b.data_ido = '0000-00-00', NULL, b.data_ido) AS data_ido, b.num_prot_ido AS num_prot_ido, IF(c.sian_cod_ebac <> '', CONCAT(c.sian_cod_ebac, ' - ', o.PAESE), '') AS ebacchus, c.sian_annata AS annata, c.sian_annata_percentuale AS annata_percentuale, IF(c.sian_varieta <> '',CONCAT(c.sian_varieta,' - ', p.DESCRIZIONE), '') AS varieta,c.sian_perc_varieta AS perc_varieta, c.sian_altre_varieta AS altre_varieta, IF(c.sian_cod_zona_viticola> '',CONCAT(c.sian_cod_zona_viticola,' - ',q.DESCRIZIONE), '') AS zona_viticola,IF(c.sian_origine_uve <> '', CONCAT(c.sian_origine_uve, ' - ', r.name), '') AS origine_uve, IFNULL(k.DESCRIZIONE,'') AS paese_provenienza, c.sian_pratiche_eno AS pratiche_eno, c.sian_massa_volumica AS massa_volumica, c.sian_titolo_alcol_pot AS titolo_alcol_pot, c.sian_titolo_alcol_eff AS titolo_alcol_eff, c.sian_titolo_alcol_tot AS titolo_alcol_tot, t.codice_vaso AS codice_vaso, b.confez AS confez, IF(c.sian_volume_nominale <> 0, c.sian_volume_nominale, 0) AS volume_nominale, IFNULL((SELECT GROUP_CONCAT(CAST(y.cod_lotto AS CHAR) SEPARATOR '|') FROM c_movimenti_lotti AS y WHERE y.id_mov = @idmov GROUP BY y.id_mov),'') AS lotti, IF(s.qta_mov <> 0, IF(s.qta_mov < 0, s.qta_mov, 0), IF(b.qta < 0, b.qta, 0)) AS qta_scarico, IF (s.qta_mov <> 0, IF(s.qta_mov > 0, s.qta_mov, 0), IF(b.qta > 0, b.qta, 0)) AS qta_carico FROM c_operazioni AS a LEFT JOIN c_movimenti AS b ON a.id = b.id_oper LEFT JOIN gen_tipo_vino_ana AS c ON b.cod_tipo_vino = c.codice AND b.azienda = c.azienda AND b.sotto_az = c.sotto_az AND b.icqrf = c.icqrf AND b.cod_committente = c.cod_committente LEFT JOIN gen_t_oper_sian AS d ON a.cod_oper = d.tipo_oper LEFT JOIN sian_t_classificazione AS e ON c.sian_classificazione = e.CODICE LEFT JOIN sian_t_atto_certificato AS f ON c.sian_atto_certificato = f.CODICE LEFT JOIN sian_t_stato_fisico AS g ON c.sian_cod_stato_fisico = g.CODICE LEFT JOIN sian_t_colore AS h ON c.sian_colore = h.CODICE LEFT JOIN sian_t_biologico AS i ON c.sian_biologico = i.CODICE LEFT JOIN sian_t_tenore_zuccheri AS l ON c.sian_cod_tenore_zuccherino = l.CODICE LEFT JOIN sian_t_dopigp AS m ON c.sian_codice_dop_igp = m.Codice LEFT JOIN sian_t_sottozone AS n ON c.sian_cod_sottozona = n.CODICE LEFT JOIN sian_t_ebacchus AS o ON c.sian_cod_ebac = o.CODICE LEFT JOIN sian_t_varieta AS p ON c.sian_varieta = p.CODICE LEFT JOIN sian_t_zona_viticola AS q ON c.sian_cod_zona_viticola = q.CODICE LEFT JOIN sian_t_paesiiso AS r ON c.sian_origine_uve = r.ISO3166_1_numeric LEFT JOIN sian_t_provenienza AS k ON c.sian_paese = k.CODICE LEFT JOIN gen_vasi_vinari_mov AS s ON b.id = s.id_mov LEFT JOIN gen_vasi_vinari_ana AS t ON s.id_vaso = t.id LEFT JOIN c_movimenti_etic AS u ON b.id=u.id_mov WHERE !ISNULL(b.id) AND a.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND a.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND a.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "'   AND a.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "' ";
            if (da_data.equals("")) {
                da_data = "2017-01-01";
            }
            if (a_data.equals("")) {
                a_data = LocalDate.now().toString();
            }
            ret = ret + " AND (a.data_oper >= '" + da_data + "' AND a.data_oper <= '" + a_data + "') ";
            if (!prodotto.equals("")) {
                ret = ret + "AND b.cod_tipo_vino = '" + prodotto + "' ";
            }
            if (!stato_fisico.equals("")) {
                ret = ret + "AND c.sian_cod_stato_fisico" + stato_fisico + " ";
            }
            if (!annata.equals("")) {
                ret = ret + "AND c.sian_annata = '" + annata + "' ";
            }
            if (!cod_oper.equals("")) {
                ret = ret + "AND d.sian_cod_oper = '" + cod_oper + "' ";
            }
            ret = ret + ") AS x GROUP BY id_movimento ORDER BY data_oper,id_movimento ";
        }
        return ret;
    }
}

