/*
 * Decompiled with CFR 0.152.
 */
package vin.controller;

import com.jfoenix.controls.JFXRadioButton;
import com.jfoenix.controls.JFXTextField;
import java.io.IOException;
import java.net.URL;
import java.time.LocalDate;
import java.time.Month;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.chart.BarChart;
import javafx.scene.chart.PieChart;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Alert;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import vin.Class.WorkIndicatorDialog;
import vin.Uility.JasperReport;
import vin.conf.ConfStampaConferimentiController;
import vin.controller.FXMLDocumentController;
import vin.controller.SearchProdottoPool;
import vin.controller.SearchTableCodiceDescrizioneController;

public class StampaSVasiVinariController
implements Initializable {
    @FXML
    private Label label_dalladata;
    @FXML
    private Label label_alladata;
    @FXML
    private Label label_prodotto;
    @FXML
    private Label label_annata;
    @FXML
    private Label label_codoper;
    @FXML
    private Label label_coddopigp;
    @FXML
    private JFXRadioButton chk_imbo;
    @FXML
    private JFXRadioButton chk_sfuso;
    @FXML
    private JFXRadioButton chk_tutto;
    @FXML
    JFXRadioButton chk_standard;
    @FXML
    JFXRadioButton chk_estesa;
    @FXML
    JFXRadioButton chk_pdf;
    @FXML
    JFXRadioButton chk_xls;
    @FXML
    private DatePicker dtp_dalladata;
    @FXML
    private DatePicker dtp_alladata;
    @FXML
    private JFXTextField editText_prodotto;
    @FXML
    private JFXTextField editText_annata;
    @FXML
    private JFXTextField editText_codoper;
    @FXML
    private HBox box_dopigp;
    @FXML
    private JFXTextField editText_coddopigp;
    @FXML
    private PieChart torta;
    @FXML
    private BarChart bar_chart;
    JasperReport jasperReport = new JasperReport();
    ToggleGroup groupTipoVino = null;
    ToggleGroup groupTipoStampa = null;
    ToggleGroup groupTipoStampa2 = null;
    WorkIndicatorDialog wd = null;

    @FXML
    void btnClearCodDop(ActionEvent event) {
        this.editText_coddopigp.setText("");
    }

    @FXML
    void btnSearchCodDop(ActionEvent event) throws JSONException, IOException {
        FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/vin/view/SearchTableCodiceDescrizione.fxml"));
        Parent rootLayout = (Parent)loader.load();
        Scene scene = new Scene(rootLayout);
        Stage stage = new Stage();
        stage.setTitle("Codici Dop/IGP");
        stage.setScene(scene);
        SearchTableCodiceDescrizioneController controller = (SearchTableCodiceDescrizioneController)loader.getController();
        controller.setTable("sian_t_dopigp");
        stage.initModality(Modality.APPLICATION_MODAL);
        stage.setResizable(true);
        stage.showAndWait();
        String codice = controller.getCodice();
        String descr = controller.getDescrizione();
        if (!codice.equals("")) {
            this.editText_coddopigp.setText(codice);
        }
    }

    @FXML
    void btnActionGrafico(ActionEvent event) throws JSONException {
        ArrayList key = new ArrayList();
        ArrayList value = new ArrayList();
        int tipoStampa = 0;
        int tipoStampa2 = 0;
        String stato_fisico = "";
        String nomeFileJRXML = "";
        String alladata = "";
        LocalDate endtime = (LocalDate)this.dtp_alladata.getValue();
        if (endtime != null) {
            alladata = endtime.toString();
        }
        String dalladata = "";
        LocalDate endtime2 = (LocalDate)this.dtp_dalladata.getValue();
        if (endtime2 != null) {
            dalladata = endtime2.toString();
        }
        JFXRadioButton chk_TipoVino = (JFXRadioButton)this.groupTipoVino.getSelectedToggle();
        JFXRadioButton chk_TipoStampa = (JFXRadioButton)this.groupTipoStampa.getSelectedToggle();
        JFXRadioButton chk_TipoStampa2 = (JFXRadioButton)this.groupTipoStampa2.getSelectedToggle();
        if (!chk_TipoStampa2.getText().equals("Standard")) {
            tipoStampa2 = 1;
        }
        tipoStampa = chk_TipoStampa.getText().equals("PDF") ? 1 : 2;
        if (chk_TipoVino.getText().equals("Imbottigliato")) {
            stato_fisico = "<>'1'";
        } else if (chk_TipoVino.getText().equals("Sfuso")) {
            stato_fisico = "='1'";
        }
        String annata = this.editText_annata.getText().trim();
        String prodotto = this.editText_prodotto.getText().trim();
        String cod_dop = this.editText_coddopigp.getText().trim();
        String codoper = this.editText_codoper.getText().trim();
        if (alladata.equals("")) {
            FXMLDocumentController.toast.startToast("(Alla Data) Campo obbligatorio", "ERRORE", "ERRORE");
            return;
        }
        if (dalladata.equals("")) {
            FXMLDocumentController.toast.startToast("(Dalla Data) Campo obbligatorio", "ERRORE", "ERRORE");
            return;
        }
        String where = "";
        if (!stato_fisico.equals("")) {
            where = " AND sian_cod_stato_fisico" + stato_fisico + " ";
        }
        String strWHERE = this.selectReportVasiVinariGRAFICO(prodotto, annata, tipoStampa2, alladata);
        XYChart.Series series1 = new XYChart.Series();
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList lenghtBidimensionalArray = new ArrayList();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String str = "";
        String data_select = "";
        lastID.add(false);
        tipoSQL.add("select");
        strSQL.add(strWHERE);
        str = FXMLDocumentController.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
        data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + str);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = FXMLDocumentController.jsonUtil.strJsonToJSONArray(data_select);
            this.bar_chart.getData().clear();
            ObservableList pieChartData = FXCollections.observableArrayList();
            double tot = 0.0;
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                String prod = rec.get("vasca").toString();
                Double pr = rec.getDouble("giacenza");
                series1.getData().add((Object)new XYChart.Data((Object)prod, (Object)pr));
                pieChartData.add((Object)new PieChart.Data(prod, pr.doubleValue()));
                tot = pr + tot;
            }
            series1.setName(tot + "");
            this.bar_chart.getData().setAll(new Object[]{series1});
            this.torta.getData().setAll((Collection)pieChartData);
        } else {
            FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", data_select);
        }
    }

    private String selectReportVasiVinari(String prodotto, String annata, int tipoStampa, String a_data, String da_data) {
        String res = "";
        if (a_data.equals("")) {
            a_data = LocalDate.now().toString();
        }
        String r = "";
        res = "SELECT  c.id, c.codice AS CODICE, c.descrizione, c.tipo, IFNULL(IF(a.giacenza=0,'',a.COD_VINO),'') AS COD_VINO, IFNULL(IF(a.GIACENZA=0,'',a.DESCR_VINO),'') AS DESCR_VINO,\nIFNULL(IF(a.GIACENZA=0,'', a.PROTOCOLLO),'') AS PROTOCOLLO, IFNULL(IF(a.GIACENZA=0,'',a.ENTE),'') AS ENTE, a.DATA  AS DATA, \nIFNULL(a.GIACENZA,0) AS GIACENZA, IFNULL(a.COMMI,'') AS COMMI , IFNULL(CONCAT(IFNULL(b.commit_nome,''), ' ', IFNULL(b.commit_cognome,'')),'') AS NOME, \n IFNULL(b.commit_rag_soc,'') AS RAG_SOC \n FROM (SELECT a.id AS ID, a.codice_vaso AS CODICE, \na.descr_vaso AS DESCRIZIONE, d.DESCRIZIONE AS TIPO,  a.icqrf AS ICQRF,a.azienda,a.sotto_az \nFROM gen_vasi_vinari_ana AS a \nLEFT JOIN sian_t_tipo_vaso AS d ON a.tipo_vaso = d.CODICE \nWHERE a.codice_vaso<>'@VASOWBS@' AND a.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND a.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "') AS c \n LEFT JOIN ( SELECT a.id AS ID ,a.codice AS CODICE,a.descrizione AS DESCRIZIONE,a.tipo AS TIPO,SUM(b.qta_mov) AS GIACENZA, e.num_prot_ido AS PROTOCOLLO,\n e.ente_cert AS ENTE, IF (e.data_ido = '0000-00-00', NULL, e.data_ido) AS DATA, IFNULL(b.cod_committente,'') AS COMMI,\n  c.codice AS COD_VINO,c.sian_annata AS ANNATA, c.descrizione AS DESCR_VINO,a.azienda,a.sotto_az,a.icqrf\nFROM (SELECT a.id AS ID, a.codice_vaso AS CODICE, \na.descr_vaso AS DESCRIZIONE, d.DESCRIZIONE AS TIPO,  a.icqrf AS ICQRF,a.azienda,a.sotto_az \nFROM gen_vasi_vinari_ana AS a \nLEFT JOIN sian_t_tipo_vaso AS d ON a.tipo_vaso = d.CODICE \nWHERE a.codice_vaso<>'@VASOWBS@' AND a.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND a.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "') AS a \nLEFT JOIN gen_vasi_vinari_mov AS b ON a.id = b.id_vaso  AND a.azienda = b.azienda AND a.sotto_az = b.sotto_az AND a.icqrf = b.icqrf \nLEFT JOIN c_movimenti AS e ON b.id_mov = e.id\n LEFT JOIN c_operazioni AS k ON e.id_oper=k.id \n LEFT JOIN gen_tipo_vino_ana AS c ON e.cod_tipo_vino = c.codice  AND e.azienda = c.azienda AND e.sotto_az = c.sotto_az AND e.icqrf = c.icqrf \n  AND e.cod_committente = c.cod_committente \n WHERE (k.data_oper>='" + da_data + "' AND k.data_oper<='" + a_data + "' ) AND   e.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "' \n";
        if (!prodotto.equals("")) {
            res = res + " AND e.cod_tipo_vino='" + prodotto + "' ";
        }
        if (!annata.equals("")) {
            res = res + " AND c.sian_annata='" + annata + "' ";
        }
        res = res + "GROUP BY a.id,e.cod_tipo_vino, e.num_prot_ido , e.ente_cert , IF(e.data_ido = '0000-00-00', NULL, e.data_ido),b.cod_committente\n HAVING giacenza <> 0 \nORDER BY a.codice, b.cod_committente ) AS a ON c.id=a.id \n  LEFT JOIN (SELECT azienda,sotto_az,icqrf,cod_committente,commit_nome,commit_cognome,commit_rag_soc FROM gen_t_icqrf_mxmag GROUP BY azienda,icqrf,cod_committente) AS b ON a.azienda=b.azienda AND a.ICQRF = b.icqrf AND COMMI = b.cod_committente  \nORDER BY a.commi, IFNULL(c.codice,'')     ";
        return res;
    }

    private String selectReportVasiVinariGRAFICO(String prodotto, String annata, int tipoStampa, String a_data) {
        String res = "";
        if (a_data.equals("")) {
            a_data = LocalDate.now().toString();
        }
        String r = "";
        res = "SELECT CONCAT(a.CODICE,' ',a.DESCRIZIONE) AS vasca,SUM(a.GIACENZA) AS giacenza FROM( SELECT DISTINCT a.ID, a.CODICE, a.DESCRIZIONE, a.TIPO, a.COD_VINO, a.DESCR_VINO, a.PROTOCOLLO, a.ENTE, a.DATA, IFNULL(a.GIACENZA,0) AS GIACENZA, a.COMMI,CONCAT(IFNULL(b.commit_nome,''), ' ', IFNULL(b.commit_cognome,'')) AS NOME, IFNULL(b.commit_rag_soc,'') AS RAG_SOC FROM ( SELECT ID, CODICE, DESCRIZIONE, TIPO, IF(GIACENZA = 0 OR ISNULL(GIACENZA), '', COD_VINO) AS COD_VINO, IF(GIACENZA = 0 OR ISNULL(GIACENZA), '', DESCR_VINO) AS DESCR_VINO, IF(GIACENZA = 0 OR ISNULL(GIACENZA), '', PROTOCOLLO) AS PROTOCOLLO, IF(GIACENZA = 0 OR ISNULL(GIACENZA), '', ENTE) AS ENTE, IF(GIACENZA = 0 OR ISNULL(GIACENZA), NULL, DATA) AS DATA, GIACENZA, IF(GIACENZA = 0 OR ISNULL(GIACENZA), '', COMMI) AS COMMI, a.icqrf AS ICQRF FROM ( SELECT a.id AS ID, a.codice_vaso AS CODICE, a.descr_vaso AS DESCRIZIONE, d.DESCRIZIONE AS TIPO, c.codice AS COD_VINO,c.sian_annata AS ANNATA, c.descrizione AS DESCR_VINO, e.num_prot_ido AS PROTOCOLLO, e.ente_cert AS ENTE, IF (e.data_ido = '0000-00-00', NULL, e.data_ido) AS DATA, SUM(b.qta_mov) AS GIACENZA, IFNULL(b.cod_committente,'') AS COMMI, a.icqrf AS ICQRF FROM gen_vasi_vinari_ana AS a LEFT JOIN gen_vasi_vinari_mov AS b ON a.id = b.id_vaso AND a.azienda = b.azienda AND a.sotto_az = b.sotto_az AND a.icqrf = b.icqrf LEFT JOIN gen_tipo_vino_ana AS c ON b.cod_tipo_vino = c.codice AND b.azienda = c.azienda AND b.sotto_az = c.sotto_az AND b.icqrf = c.icqrf AND b.cod_committente = c.cod_committente LEFT JOIN sian_t_tipo_vaso AS d ON a.tipo_vaso = d.CODICE LEFT JOIN c_movimenti AS e ON b.id_mov = e.id LEFT JOIN c_operazioni AS x ON e.id_oper=x.id WHERE a.codice_vaso<>'@VASOWBS@' AND a.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND a.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND a.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "'  AND x.data_oper<='" + a_data + "' GROUP BY a.codice_vaso, c.codice, e.num_prot_ido, e.ente_cert, IF(e.data_ido = '0000-00-00', NULL, e.data_ido), b.cod_committente  ORDER BY a.codice_vaso, b.cod_committente ) AS a WHERE GIACENZA <> 0 ";
        if (!FXMLDocumentController.GLOBAL_CODCOMM.equals("")) {
            res = res + "AND COMMI = '" + FXMLDocumentController.GLOBAL_CODCOMM + "' ";
        }
        if (!prodotto.equals("")) {
            res = res + " AND COD_VINO = '" + prodotto + "' ";
        }
        if (!annata.equals("")) {
            res = res + " AND ANNATA = '" + annata + "' ";
        }
        res = res + "OR ID NOT IN ( SELECT a.ID FROM ( SELECT a.id, SUM(b.qta_mov) AS giacenza FROM gen_vasi_vinari_ana AS a LEFT JOIN gen_vasi_vinari_mov AS b ON b.id_vaso = a.id AND a.azienda = b.azienda AND a.sotto_az = b.sotto_az AND a.icqrf = b.icqrf LEFT JOIN gen_tipo_vino_ana AS c ON b.cod_tipo_vino = c.codice AND b.azienda = c.azienda AND b.sotto_az = c.sotto_az AND b.icqrf = c.icqrf AND b.cod_committente = c.cod_committente LEFT JOIN sian_t_tipo_vaso AS d ON a.tipo_vaso = d.CODICE LEFT JOIN c_movimenti AS e ON b.id_mov = e.id LEFT JOIN c_operazioni AS x ON e.id_oper=x.id WHERE a.codice_vaso<>'@VASOWBS@' AND b.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND b.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND b.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND x.data_oper<='" + a_data + "' GROUP BY a.codice_vaso, c.codice, e.num_prot_ido, e.ente_cert, IF(e.data_ido = '0000-00-00', NULL, e.data_ido), b.cod_committente  HAVING giacenza <> 0 ) AS a ) ) AS a LEFT JOIN gen_t_icqrf_mxmag AS b ON a.ICQRF = b.icqrf AND COMMI = b.cod_committente ORDER BY COMMI, CODICE ) AS a GROUP BY a.CODICE ";
        return res;
    }

    @FXML
    void btnActionStampa(ActionEvent event) throws JSONException, IOException {
        this.wd = new WorkIndicatorDialog(this.chk_pdf.getScene().getWindow(), "Caricamento in corso...");
        this.wd.addTaskEndNotification(result -> {
            System.out.println(result);
            this.wd = null;
        });
        this.wd.exec("123", inputParam -> {
            try {
                this.goStampa();
            }
            catch (IOException | JSONException ex) {
                Logger.getLogger(ConfStampaConferimentiController.class.getName()).log(Level.SEVERE, null, ex);
            }
            return 1;
        });
    }

    private void goStampa() throws JSONException, IOException {
        ArrayList<String> key = new ArrayList<String>();
        ArrayList<Object> value = new ArrayList<Object>();
        int tipoStampa = 0;
        int tipoStampa2 = 0;
        String stato_fisico = "";
        String nomeFileJRXML = "";
        String alladata = "";
        LocalDate endtime = (LocalDate)this.dtp_alladata.getValue();
        if (endtime != null) {
            alladata = endtime.toString();
        }
        String dalladata = "";
        LocalDate endtime2 = LocalDate.parse(FXMLDocumentController.ricerca.getDallaDataInizioAnno());
        if (endtime2 != null) {
            dalladata = endtime2.toString().equals("2017-01-01") ? endtime2.toString() : endtime2.plusDays(1L).toString();
        }
        JFXRadioButton chk_TipoVino = (JFXRadioButton)this.groupTipoVino.getSelectedToggle();
        JFXRadioButton chk_TipoStampa = (JFXRadioButton)this.groupTipoStampa.getSelectedToggle();
        JFXRadioButton chk_TipoStampa2 = (JFXRadioButton)this.groupTipoStampa2.getSelectedToggle();
        if (!chk_TipoStampa2.getText().equals("Standard")) {
            tipoStampa2 = 1;
        }
        tipoStampa = chk_TipoStampa.getText().equals("PDF") ? 1 : 2;
        if (chk_TipoVino.getText().equals("Imbottigliato")) {
            stato_fisico = "<>'1'";
        } else if (chk_TipoVino.getText().equals("Sfuso")) {
            stato_fisico = "='1'";
        }
        String annata = this.editText_annata.getText().trim();
        String prodotto = this.editText_prodotto.getText().trim();
        String cod_dop = this.editText_coddopigp.getText().trim();
        String codoper = this.editText_codoper.getText().trim();
        if (alladata.equals("")) {
            FXMLDocumentController.toast.startToast("(Alla Data) Campo obbligatorio", "ERRORE", "ERRORE");
            return;
        }
        String strWHERE = this.selectReportVasiVinari(prodotto, annata, tipoStampa2, alladata, dalladata);
        key.add("QUERY");
        key.add("AZIENDA");
        key.add("SOTTO_AZ");
        key.add("ICQRF");
        key.add("COD_COMMITTENTE");
        value.add(strWHERE);
        value.add(FXMLDocumentController.GLOBAL_AZIENDA);
        value.add(FXMLDocumentController.GLOBAL_SOTTOAZZ);
        value.add(FXMLDocumentController.GLOBAL_ICQRF);
        value.add(FXMLDocumentController.GLOBAL_CODCOMM);
        nomeFileJRXML = tipoStampa == 1 ? "vasi_vinariP.jrxml" : "vasi_vinariE.jrxml";
        String resp = this.jasperReport.JSONjr(nomeFileJRXML, key, value, tipoStampa, "");
        String nomeFile = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "JasperReport#@" + resp);
        FXMLDocumentController.util.downloadFileTemp(nomeFile);
    }

    public void initialize(URL url, ResourceBundle rb) {
        this.groupTipoVino = new ToggleGroup();
        this.chk_imbo.setToggleGroup(this.groupTipoVino);
        this.chk_sfuso.setToggleGroup(this.groupTipoVino);
        this.chk_tutto.setToggleGroup(this.groupTipoVino);
        this.groupTipoVino.selectToggle((Toggle)this.chk_tutto);
        this.groupTipoStampa = new ToggleGroup();
        this.chk_pdf.setToggleGroup(this.groupTipoStampa);
        this.chk_xls.setToggleGroup(this.groupTipoStampa);
        this.groupTipoStampa2 = new ToggleGroup();
        this.chk_estesa.setToggleGroup(this.groupTipoStampa2);
        this.chk_standard.setToggleGroup(this.groupTipoStampa2);
        this.groupTipoStampa2.selectToggle((Toggle)this.chk_standard);
        this.groupTipoStampa.selectToggle((Toggle)this.chk_xls);
        this.dtp_alladata.setValue((Object)LocalDate.now());
        this.dtp_dalladata.setValue((Object)LocalDate.of(2017, Month.JANUARY, 1));
        this.editText_prodotto.textProperty().addListener((observable, oldValue, newValue) -> {
            try {
                if (!newValue.equals("") && newValue.length() == 1) {
                    String prodotto = this.editText_prodotto.getText().trim();
                    FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/vin/view/SearchProdottoPool.fxml"));
                    Stage stage = new Stage();
                    stage.setMaximized(false);
                    stage.setTitle("Prodotto");
                    stage.setScene(new Scene((Parent)((Pane)loader.load())));
                    SearchProdottoPool controller = (SearchProdottoPool)loader.getController();
                    controller.setSearch((String)newValue, " ", "");
                    stage.initModality(Modality.APPLICATION_MODAL);
                    stage.setResizable(false);
                    stage.showAndWait();
                    String codice = controller.getCodice();
                    String descr = controller.getDesString();
                    String atto_cert = controller.getAttoCert();
                    String anno = controller.getAnno();
                    Double capacita = controller.getCapacita();
                    String id = controller.getID();
                    if (!codice.equals("")) {
                        this.editText_prodotto.setText(codice);
                    } else {
                        this.editText_prodotto.setText("");
                    }
                    stage.close();
                }
            }
            catch (Exception ex) {
                FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
            }
        });
    }
}

