/*
 * Decompiled with CFR 0.152.
 */
package vin.controller;

import com.jfoenix.controls.JFXRadioButton;
import com.jfoenix.controls.JFXTextField;
import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Month;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import org.json.JSONException;
import vin.Uility.JasperReport;
import vin.controller.FXMLDocumentController;
import vin.controller.SearchProdottoPool;
import vin.controller.SearchTableCodiceDescrizioneController;

public class StampaSIANgtestController
implements Initializable {
    @FXML
    private Label label_dalladata;
    @FXML
    private Label label_alladata;
    @FXML
    private Label label_prodotto;
    @FXML
    private Label label_annata;
    @FXML
    private Label label_codoper;
    @FXML
    private Label label_coddopigp;
    @FXML
    private JFXRadioButton chk_imbo;
    @FXML
    private JFXRadioButton chk_sfuso;
    @FXML
    private JFXRadioButton chk_tutto;
    @FXML
    JFXRadioButton chk_standard;
    @FXML
    JFXRadioButton chk_estesa;
    @FXML
    JFXRadioButton chk_pdf;
    @FXML
    JFXRadioButton chk_xls;
    @FXML
    private DatePicker dtp_dalladata;
    @FXML
    private DatePicker dtp_alladata;
    @FXML
    private JFXTextField editText_prodotto;
    @FXML
    private JFXTextField editText_annata;
    @FXML
    private JFXTextField editText_codoper;
    @FXML
    private HBox box_dopigp;
    @FXML
    private JFXTextField editText_coddopigp;
    JasperReport jasperReport = new JasperReport();
    ToggleGroup groupTipoVino = null;
    ToggleGroup groupTipoStampa = null;
    ToggleGroup groupTipoStampa2 = null;

    @FXML
    void btnClearCodDop(ActionEvent event) {
        this.editText_coddopigp.setText("");
    }

    @FXML
    void btnSearchCodDop(ActionEvent event) throws JSONException, IOException {
        FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/vin/view/SearchTableCodiceDescrizione.fxml"));
        Parent rootLayout = (Parent)loader.load();
        Scene scene = new Scene(rootLayout);
        Stage stage = new Stage();
        stage.setTitle("Codici Dop/IGP");
        stage.setScene(scene);
        SearchTableCodiceDescrizioneController controller = (SearchTableCodiceDescrizioneController)loader.getController();
        controller.setTable("sian_t_dopigp");
        stage.initModality(Modality.APPLICATION_MODAL);
        stage.setResizable(true);
        stage.showAndWait();
        String codice = controller.getCodice();
        String descr = controller.getDescrizione();
        if (!codice.equals("")) {
            this.editText_coddopigp.setText(codice);
        }
    }

    @FXML
    void btnActionGrafico(ActionEvent event) throws JSONException {
    }

    @FXML
    void btnActionStampa(ActionEvent event) throws JSONException, IOException {
        try {
            ArrayList key = new ArrayList();
            ArrayList value = new ArrayList();
            int tipoStampa = 0;
            boolean tipoStampa2 = false;
            String stato_fisico = "";
            String nomeFileJRXML = "";
            String alladata = "";
            LocalDate endtime = (LocalDate)this.dtp_alladata.getValue();
            if (endtime != null) {
                alladata = endtime.toString();
            }
            String dalladata = "";
            LocalDate endtime2 = (LocalDate)this.dtp_dalladata.getValue();
            if (endtime2 != null) {
                dalladata = endtime2.toString();
            }
            JFXRadioButton chk_TipoVino = (JFXRadioButton)this.groupTipoVino.getSelectedToggle();
            JFXRadioButton chk_TipoStampa = (JFXRadioButton)this.groupTipoStampa.getSelectedToggle();
            JFXRadioButton chk_TipoStampa2 = (JFXRadioButton)this.groupTipoStampa2.getSelectedToggle();
            if (!chk_TipoStampa2.getText().equals("Standard")) {
                tipoStampa2 = true;
            }
            tipoStampa = chk_TipoStampa.getText().equals("PDF") ? 1 : 2;
            if (chk_TipoVino.getText().equals("Imbottigliato")) {
                stato_fisico = "<>'1'";
            } else if (chk_TipoVino.getText().equals("Sfuso")) {
                stato_fisico = "='1'";
            }
            String annata = this.editText_annata.getText().trim();
            String prodotto = this.editText_prodotto.getText().trim();
            String cod_dop = this.editText_coddopigp.getText().trim();
            String codoper = this.editText_codoper.getText().trim();
            if (alladata.equals("")) {
                FXMLDocumentController.toast.startToast("(Alla Data) Campo obbligatorio", "ERRORE", "ERRORE");
                return;
            }
            String br = FXMLDocumentController.util.getPathSO();
            String workingDir = System.getProperty("user.dir");
            String data = LocalDateTime.now().toString().replace("/", "").replace("\\", "").replace("-", "").replace(".", "").replace(":", "");
            String pathToSave = workingDir + br + "temp" + br + "report" + data + ".csv";
            URL url = new URL("http://drwebtest.ufficiosystem.com/wbs/ReportGiacenzeWBS.aspx?icqrf=" + FXMLDocumentController.GLOBAL_ICQRF + "&data=" + alladata);
            URLConnection urlConnection = url.openConnection();
            Map<String, List<String>> headers = urlConnection.getHeaderFields();
            InputStream inputStream = urlConnection.getInputStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String line = bufferedReader.readLine();
            PrintWriter writer = new PrintWriter(pathToSave, "UTF-8");
            while (line != null) {
                line = bufferedReader.readLine();
                if (!line.contains("CodPrimario") && !line.contains("ERRORE")) continue;
                String[] rec = line.split("<br/>");
                System.out.println(rec.length);
                int o = 0;
                for (String rec1 : rec) {
                    String campo1;
                    String[] datad;
                    int j;
                    String[] dat = rec1.split(";");
                    System.out.println(dat.length);
                    if (o > 0) {
                        for (j = 0; j < dat.length; ++j) {
                            if (j == 3 && !dat[j].trim().equals("")) {
                                datad = dat[j].trim().split("\\(");
                                campo1 = datad[0].replace("\\(", "").trim();
                                String campo2 = datad[1].replace("\\)", "").trim();
                                writer.print(campo1 + ";");
                                writer.print(campo2 + ";");
                                continue;
                            }
                            if (j == dat.length) {
                                writer.print(dat[j].trim());
                                continue;
                            }
                            writer.print(dat[j].trim() + ";");
                        }
                    } else {
                        for (j = 0; j < dat.length; ++j) {
                            if (j == 3) {
                                datad = dat[j].trim();
                                campo1 = "Annata%";
                                writer.print((String)datad + ";");
                                writer.print(campo1 + ";");
                                continue;
                            }
                            if (j == dat.length) {
                                writer.print(dat[j].trim());
                                continue;
                            }
                            writer.print(dat[j].trim() + ";");
                        }
                    }
                    ++o;
                    writer.print("\n\r");
                    System.out.println(rec1.trim());
                }
                writer.close();
                break;
            }
            bufferedReader.close();
            if (Desktop.isDesktopSupported()) {
                try {
                    File myFile = new File(pathToSave);
                    Desktop.getDesktop().open(myFile);
                }
                catch (IOException ex) {
                    FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                }
            }
            FXMLDocumentController.toast.startToast("File scritto con successo:" + pathToSave, "SUCCESSO", "SUCCESSO");
        }
        catch (Exception e) {
            FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", e.toString());
        }
    }

    public void initialize(URL url, ResourceBundle rb) {
        this.groupTipoVino = new ToggleGroup();
        this.chk_imbo.setToggleGroup(this.groupTipoVino);
        this.chk_sfuso.setToggleGroup(this.groupTipoVino);
        this.chk_tutto.setToggleGroup(this.groupTipoVino);
        this.groupTipoVino.selectToggle((Toggle)this.chk_tutto);
        this.groupTipoStampa = new ToggleGroup();
        this.chk_pdf.setToggleGroup(this.groupTipoStampa);
        this.chk_xls.setToggleGroup(this.groupTipoStampa);
        this.groupTipoStampa2 = new ToggleGroup();
        this.chk_estesa.setToggleGroup(this.groupTipoStampa2);
        this.chk_standard.setToggleGroup(this.groupTipoStampa2);
        this.groupTipoStampa2.selectToggle((Toggle)this.chk_standard);
        this.groupTipoStampa.selectToggle((Toggle)this.chk_xls);
        this.dtp_alladata.setValue((Object)LocalDate.now());
        this.dtp_dalladata.setValue((Object)LocalDate.of(2017, Month.JANUARY, 1));
        this.editText_prodotto.textProperty().addListener((observable, oldValue, newValue) -> {
            try {
                if (!newValue.equals("") && newValue.length() == 1) {
                    String prodotto = this.editText_prodotto.getText().trim();
                    FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/vin/view/SearchProdottoPool.fxml"));
                    Stage stage = new Stage();
                    stage.setMaximized(false);
                    stage.setTitle("Prodotto");
                    stage.setScene(new Scene((Parent)((Pane)loader.load())));
                    SearchProdottoPool controller = (SearchProdottoPool)loader.getController();
                    controller.setSearch((String)newValue, " ", "");
                    stage.initModality(Modality.APPLICATION_MODAL);
                    stage.setResizable(false);
                    stage.showAndWait();
                    String codice = controller.getCodice();
                    String descr = controller.getDesString();
                    String atto_cert = controller.getAttoCert();
                    String anno = controller.getAnno();
                    Double capacita = controller.getCapacita();
                    String id = controller.getID();
                    if (!codice.equals("")) {
                        this.editText_prodotto.setText(codice);
                    } else {
                        this.editText_prodotto.setText("");
                    }
                    stage.close();
                }
            }
            catch (Exception ex) {
                FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
            }
        });
    }
}

