/*
 * Decompiled with CFR 0.152.
 */
package vin.controller;

import com.jfoenix.controls.JFXRadioButton;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Alert;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import vin.Class.CodiceDescrizioneComboBox;
import vin.Class.Ricerca;
import vin.Class.WorkIndicatorDialog;
import vin.Uility.JasperReport;
import vin.controller.FXMLDocumentController;

public class StampaMovimentiSIANController
implements Initializable {
    @FXML
    private Label label_dalladata;
    @FXML
    private Label label_alladata;
    @FXML
    JFXRadioButton chk_pdf;
    @FXML
    JFXRadioButton chk_xls;
    @FXML
    JFXRadioButton chk_test;
    @FXML
    JFXRadioButton chk_reale;
    @FXML
    JFXRadioButton chk_confrontawbs;
    @FXML
    JFXRadioButton chk_nonconfrontawbs;
    @FXML
    private DatePicker dtp_dalladata;
    @FXML
    private DatePicker dtp_alladata;
    JasperReport jasperReport = new JasperReport();
    ToggleGroup groupTipoVino = null;
    ToggleGroup groupTipoStampa = null;
    ToggleGroup groupTipoStampa2 = null;
    ToggleGroup groupConfronto = null;
    ToggleGroup groupTipo = null;
    WorkIndicatorDialog wd = null;
    ObservableList<CodiceDescrizioneComboBox> lista_table = FXCollections.observableArrayList();

    @FXML
    void btnActionStampa(ActionEvent event) throws JSONException, IOException {
        LocalDate endtime;
        ArrayList key = new ArrayList();
        ArrayList value = new ArrayList();
        boolean tipoStampa = false;
        boolean tipoStampa2 = false;
        String stato_fisico = "";
        String nomeFileJRXML = "";
        String alladata = "";
        boolean bool_reale = this.chk_reale.isSelected();
        boolean bool_test = this.chk_test.isSelected();
        boolean bool_confronta = this.chk_confrontawbs.isSelected();
        boolean bool_nonconfronta = this.chk_nonconfrontawbs.isSelected();
        String tipo = "";
        tipo = bool_test ? "TEST" : "REALE";
        boolean confronta = false;
        if (bool_confronta) {
            confronta = true;
        }
        if ((endtime = (LocalDate)this.dtp_alladata.getValue()) != null) {
            alladata = endtime.toString();
        }
        String dalladata = "";
        LocalDate endtime2 = (LocalDate)this.dtp_dalladata.getValue();
        if (endtime2 != null) {
            dalladata = endtime2.toString();
        }
        if (alladata.equals("")) {
            FXMLDocumentController.toast.startToast("(Alla Data) Campo obbligatorio", "ERRORE", "ERRORE");
            return;
        }
        if (dalladata.equals("")) {
            FXMLDocumentController.toast.startToast("(Dalla Data) Campo obbligatorio", "ERRORE", "ERRORE");
            return;
        }
        FileChooser fileChooser = new FileChooser();
        FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("excel files (*.xls)", new String[]{"*.xls"});
        fileChooser.getExtensionFilters().add((Object)extFilter);
        File file = fileChooser.showSaveDialog((Window)this.dtp_alladata.getContextMenu());
        if (file != null) {
            this.SaveFile(file, dalladata, alladata, tipo, confronta);
        }
    }

    private void SaveFile(File file, String data_inizio, String data_fine, String tipo, boolean confrontoWBS) {
        try {
            this.wd = new WorkIndicatorDialog(this.dtp_alladata.getScene().getWindow(), "Caricamento in corso...");
            this.wd.addTaskEndNotification(result -> {
                System.out.println(result);
                if (this.wd.labelWord.contains("#ERR")) {
                    FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "ERROR", this.wd.labelWord);
                } else {
                    FXMLDocumentController.toast.startToast("File scritto con successo", "SUCCESSO", "SUCCESSO");
                }
                this.wd = null;
            });
            this.wd.exec("123", inputParam -> {
                try {
                    FileOutputStream fileOut = new FileOutputStream(file);
                    String tipos = "";
                    tipos = tipo.equals("REALE") ? "VisOperSiRPV" : "TESTVisOperSiRPV";
                    if (confrontoWBS) {
                        this.confrontaWBS(fileOut, data_inizio, data_fine, tipos);
                    } else {
                        this.nonconfrontaWBS(fileOut, data_inizio, data_fine, tipos);
                    }
                    fileOut.flush();
                    fileOut.close();
                }
                catch (Exception ex) {
                    Logger.getLogger(StampaMovimentiSIANController.class.getName()).log(Level.SEVERE, null, ex);
                }
                return 1;
            });
        }
        catch (Exception e) {
            FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", e.toString());
        }
    }

    private void nonconfrontaWBS(FileOutputStream fileout, String data_inizio, String data_fine, String tipos) {
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet worksheet = workbook.createSheet("POI Worksheet");
        HSSFCellStyle style = workbook.createCellStyle();
        style.setFillForegroundColor(HSSFColor.LIGHT_BLUE.index);
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        HSSFFont font = workbook.createFont();
        font.setColor(HSSFColor.WHITE.index);
        font.setBold(true);
        style.setFont((Font)font);
        HSSFRow row1 = worksheet.createRow(0);
        Cell cell = row1.createCell(0);
        cell.setCellValue("DATA OPERAZIONE");
        cell.setCellStyle((CellStyle)style);
        cell = row1.createCell(1);
        cell.setCellValue("CODICE OPERAZIONE");
        cell.setCellStyle((CellStyle)style);
        cell = row1.createCell(2);
        cell.setCellValue("NUMERO OPERAZIONE");
        cell.setCellStyle((CellStyle)style);
        cell = row1.createCell(3);
        cell.setCellValue("QTA");
        cell.setCellStyle((CellStyle)style);
        String data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, tipos + "#@" + FXMLDocumentController.GLOBAL_AZIENDA + "#@" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "#@" + FXMLDocumentController.GLOBAL_ICQRF + "#@" + FXMLDocumentController.GLOBAL_CODCOMM + "#@" + data_inizio + "#@" + data_fine + "#@#@#@#@");
        if (!data_select.contains("#ERR:")) {
            int counterrow = 1;
            try {
                JSONObject rec = new JSONObject(data_select);
                String codice = rec.get("codice").toString();
                String messaggio = rec.get("messaggio").toString();
                if (codice.equals("")) {
                    JSONArray arpo = rec.getJSONArray("lista");
                    for (int j = 0; j < arpo.length(); ++j) {
                        JSONObject objk = arpo.getJSONObject(j);
                        String codice_operazione = objk.get("codice_operazione").toString();
                        String data_operazione = objk.get("data_operazione").toString();
                        String numero_operazione = objk.get("numero_operazione").toString();
                        JSONArray lista = objk.getJSONArray("lista");
                        for (int k = 0; k < lista.length(); ++k) {
                            String codice_secondario;
                            JSONObject objkdd;
                            int l;
                            JSONObject objkd = lista.getJSONObject(k);
                            JSONArray prodotto1 = objkd.getJSONArray("prodotto1");
                            JSONArray prodotto2 = objkd.getJSONArray("prodotto2");
                            JSONArray prodotto3 = objkd.getJSONArray("prodotto3");
                            JSONArray prodotto4 = objkd.getJSONArray("prodotto4");
                            JSONArray prodotto5 = objkd.getJSONArray("prodotto5");
                            for (l = 0; l < prodotto1.length(); ++l) {
                                objkdd = prodotto1.getJSONObject(l);
                                codice_secondario = objkdd.get("codice_secondario").toString();
                                if (codice_secondario.equals("")) continue;
                                this.writeRow(worksheet, objkdd, cell, data_operazione, codice_operazione, numero_operazione, counterrow);
                                ++counterrow;
                            }
                            for (l = 0; l < prodotto2.length(); ++l) {
                                objkdd = prodotto2.getJSONObject(l);
                                codice_secondario = objkdd.get("codice_secondario").toString();
                                if (codice_secondario.equals("")) continue;
                                this.writeRow(worksheet, objkdd, cell, data_operazione, codice_operazione, numero_operazione, counterrow);
                                ++counterrow;
                            }
                            for (l = 0; l < prodotto3.length(); ++l) {
                                objkdd = prodotto3.getJSONObject(l);
                                codice_secondario = objkdd.get("codice_secondario").toString();
                                if (codice_secondario.equals("")) continue;
                                this.writeRow(worksheet, objkdd, cell, data_operazione, codice_operazione, numero_operazione, counterrow);
                                ++counterrow;
                            }
                            for (l = 0; l < prodotto4.length(); ++l) {
                                objkdd = prodotto4.getJSONObject(l);
                                codice_secondario = objkdd.get("codice_secondario").toString();
                                if (codice_secondario.equals("")) continue;
                                this.writeRow(worksheet, objkdd, cell, data_operazione, codice_operazione, numero_operazione, counterrow);
                                ++counterrow;
                            }
                            for (l = 0; l < prodotto5.length(); ++l) {
                                objkdd = prodotto5.getJSONObject(l);
                                codice_secondario = objkdd.get("codice_secondario").toString();
                                if (codice_secondario.equals("")) continue;
                                this.writeRow(worksheet, objkdd, cell, data_operazione, codice_operazione, numero_operazione, counterrow);
                                ++counterrow;
                            }
                        }
                    }
                }
                workbook.write((OutputStream)fileout);
            }
            catch (JSONException ex) {
                this.wd.labelWord = "#ERR: " + ex.toString();
            }
            catch (IOException ex) {
                this.wd.labelWord = "#ERR: " + ex.toString();
            }
        } else {
            this.wd.labelWord = data_select;
        }
    }

    private int writeRow(HSSFSheet worksheet, JSONObject objkdd, Cell cell, String data_operazione, String codice_operazione, String numero_operazione, int counterrow) throws JSONException {
        String qta = objkdd.get("qta").toString();
        String qta_perdita = objkdd.get("qta_perdita").toString();
        String gg_inv = objkdd.get("gg_inv").toString();
        String codice_partita_lotto = objkdd.get("codice_partita_lotto").toString();
        String codice_partita_serie = objkdd.get("codice_partita_serie").toString();
        String codice_partita_fa = objkdd.get("codice_partita_fa").toString();
        String codice_partita_fda = objkdd.get("codice_partita_fda").toString();
        String codice_partita_nconf = objkdd.get("codice_partita_nconf").toString();
        String codice_partita_vnom = objkdd.get("codice_partita_vnom").toString();
        String percigp = objkdd.get("percigp").toString();
        String tit_eff = objkdd.get("tit_eff").toString();
        String tit_pot = objkdd.get("tit_pot").toString();
        String metodope = objkdd.get("metodope").toString();
        String cod_tenore = objkdd.get("cod_tenore").toString();
        String tit_tot = objkdd.get("tit_tot").toString();
        String montegradi = objkdd.get("montegradi").toString();
        String grado_acidita = objkdd.get("grado_acidita").toString();
        String codice_recipiente = objkdd.get("codice_recipiente").toString();
        String codice_secondario = objkdd.get("codice_secondario").toString();
        String codice_categoria = objkdd.get("codice_categoria").toString();
        String codice_classificazione = objkdd.get("codice_classificazione").toString();
        String codice_atto_certificato = objkdd.get("codice_atto_certificato").toString();
        String codice_biologico = objkdd.get("codice_biologico").toString();
        String codice_colore = objkdd.get("codice_colore").toString();
        String codice_dopigp = objkdd.get("codice_dopigp").toString();
        String codice_partita = objkdd.get("codice_partita").toString();
        String sotto_zona = objkdd.get("sotto_zona").toString();
        String stato_fisico = objkdd.get("stato_fisico").toString();
        String codice_vigna = objkdd.get("codice_vigna").toString();
        String cod_zonaviticola = objkdd.get("cod_zonaviticola").toString();
        String origine_uve = objkdd.get("origine_uve").toString();
        String provenienza = objkdd.get("provenienza").toString();
        String annata = objkdd.get("annata").toString();
        String annata_perc = objkdd.get("annata_perc").toString();
        String massa_vol = objkdd.get("massa_vol").toString();
        String pratEno = objkdd.get("pratEno").toString();
        String var = objkdd.get("var").toString();
        String var_perc = objkdd.get("var_perc").toString();
        String paesiprov = objkdd.get("paesiprov").toString();
        String menzioni = objkdd.get("menzioni").toString();
        String altre_varieta = objkdd.get("altre_varieta").toString();
        String codice_ebacchus = objkdd.get("codice_ebacchus").toString();
        String data_cert = objkdd.get("data_cert").toString();
        String num_cert = objkdd.get("num_cert").toString();
        if (!codice_secondario.equals("")) {
            HSSFRow row = worksheet.createRow((int)((short)counterrow));
            int incre = 0;
            cell = row.createCell((int)((short)incre));
            cell.setCellValue(data_operazione);
            cell = row.createCell((int)((short)(++incre)));
            cell.setCellValue(codice_operazione);
            cell = row.createCell((int)((short)(++incre)));
            cell.setCellValue(numero_operazione);
            cell = row.createCell((int)((short)(++incre)));
            cell.setCellValue(codice_secondario);
            cell = row.createCell((int)((short)(++incre)));
            cell.setCellValue(codice_categoria);
            cell = row.createCell((int)((short)(++incre)));
            cell.setCellValue(stato_fisico);
            cell = row.createCell((int)((short)(++incre)));
            cell.setCellValue(codice_classificazione);
            cell = row.createCell((int)((short)(++incre)));
            cell.setCellValue(codice_atto_certificato);
            cell = row.createCell((int)((short)(++incre)));
            cell.setCellValue(codice_dopigp);
            cell = row.createCell((int)((short)(++incre)));
            cell.setCellValue(codice_colore);
            cell = row.createCell((int)((short)(++incre)));
            cell.setCellValue(codice_biologico);
            cell = row.createCell((int)((short)(++incre)));
            cell.setCellValue(codice_ebacchus);
            cell = row.createCell((int)((short)(++incre)));
            cell.setCellValue(codice_partita);
            cell = row.createCell((int)((short)(++incre)));
            cell.setCellValue(codice_vigna);
            cell = row.createCell((int)((short)(++incre)));
            cell.setCellValue(sotto_zona);
            cell = row.createCell((int)((short)(++incre)));
            cell.setCellValue(cod_zonaviticola);
            cell = row.createCell((int)((short)(++incre)));
            cell.setCellValue(origine_uve);
            cell = row.createCell((int)((short)(++incre)));
            cell.setCellValue(annata);
            cell = row.createCell((int)((short)(++incre)));
            cell.setCellValue(annata_perc);
            cell = row.createCell((int)((short)(++incre)));
            cell.setCellValue(massa_vol);
            cell = row.createCell((int)((short)(++incre)));
            cell.setCellValue(provenienza);
            cell = row.createCell((int)((short)(++incre)));
            cell.setCellValue(altre_varieta);
            cell = row.createCell((int)((short)(++incre)));
            cell.setCellValue(data_cert);
            cell = row.createCell((int)((short)(++incre)));
            cell.setCellValue(num_cert);
            cell = row.createCell((int)((short)(++incre)));
            cell.setCellValue(pratEno);
            cell = row.createCell((int)((short)(++incre)));
            cell.setCellValue(var);
            cell = row.createCell((int)((short)(++incre)));
            cell.setCellValue(var_perc);
            cell = row.createCell((int)((short)(++incre)));
            cell.setCellValue(menzioni);
            cell = row.createCell((int)((short)(++incre)));
            cell.setCellValue(paesiprov);
            cell = row.createCell((int)((short)(++incre)));
            cell.setCellValue(grado_acidita);
            cell = row.createCell((int)((short)(++incre)));
            cell.setCellValue(montegradi);
            cell = row.createCell((int)((short)(++incre)));
            cell.setCellValue(cod_tenore);
            cell = row.createCell((int)((short)(++incre)));
            cell.setCellValue(metodope);
            cell = row.createCell((int)((short)(++incre)));
            cell.setCellValue(gg_inv);
            cell = row.createCell((int)((short)(++incre)));
            cell.setCellValue(codice_partita_serie);
            cell = row.createCell((int)((short)(++incre)));
            cell.setCellValue(codice_partita_fda);
            cell = row.createCell((int)((short)(++incre)));
            cell.setCellValue(codice_partita_fa);
            cell = row.createCell((int)((short)(++incre)));
            cell.setCellValue(codice_partita_lotto);
            cell = row.createCell((int)((short)(++incre)));
            cell.setCellValue(codice_partita_nconf);
            cell = row.createCell((int)((short)(++incre)));
            cell.setCellValue(codice_partita_vnom);
            cell = row.createCell((int)((short)(++incre)));
            cell.setCellValue(percigp);
            cell = row.createCell((int)((short)(++incre)));
            cell.setCellValue(tit_tot);
            cell = row.createCell((int)((short)(++incre)));
            cell.setCellValue(tit_pot);
            cell = row.createCell((int)((short)(++incre)));
            cell.setCellValue(tit_eff);
            cell = row.createCell((int)((short)(++incre)));
            cell.setCellValue(codice_recipiente);
            cell = row.createCell((int)((short)(++incre)));
            cell.setCellValue(qta_perdita);
            cell = row.createCell((int)((short)(++incre)));
            cell.setCellValue(qta);
        } else {
            --counterrow;
        }
        return counterrow;
    }

    private void confrontaWBS(FileOutputStream fileout, String data_inizio, String data_fine, String tipos) throws JSONException {
        String data_select;
        JSONArray arraySIAN = null;
        JSONArray arrayWBS = null;
        String cod_comm = new Ricerca().getCodiceSianAnagraficaCliente(FXMLDocumentController.GLOBAL_CODCOMM);
        if (cod_comm.equals("")) {
            cod_comm = FXMLDocumentController.GLOBAL_CODCOMM;
        }
        if (!(data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, tipos + "#@" + FXMLDocumentController.GLOBAL_AZIENDA + "#@" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "#@" + FXMLDocumentController.GLOBAL_ICQRF + "#@" + cod_comm + "#@" + data_inizio + "#@" + data_fine + "#@#@#@#@")).contains("#ERR:")) {
            try {
                JSONObject rec = new JSONObject(data_select);
                String codice = rec.get("codice").toString();
                String messaggio = rec.get("messaggio").toString();
                if (codice.equals("")) {
                    arraySIAN = rec.getJSONArray("lista");
                }
                if (!(data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "STAMPAWBSOPERAZIONI#@" + FXMLDocumentController.GLOBAL_AZIENDA + "#@" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "#@" + FXMLDocumentController.GLOBAL_ICQRF + "#@" + FXMLDocumentController.GLOBAL_CODCOMM + "#@" + data_inizio + "#@" + data_fine)).contains("#ERR:")) {
                    JSONObject recd = new JSONObject(data_select);
                    arrayWBS = recd.getJSONArray("lista");
                }
                this.writeFileWBSSIAN(arraySIAN, arrayWBS, fileout);
            }
            catch (JSONException ex) {
                this.wd.labelWord = "#ERR: " + ex.toString();
            }
            catch (IOException ex) {
                this.wd.labelWord = "#ERR: " + ex.toString();
            }
        } else {
            this.wd.labelWord = data_select;
        }
    }

    private void writeFileWBSSIAN(JSONArray arraySIAN, JSONArray arrayWBS, FileOutputStream fileOut) throws JSONException, IOException {
        String numero_operazione;
        JSONObject objk;
        int j;
        int counterrow = 1;
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet worksheet = workbook.createSheet("POI Worksheet");
        HSSFCellStyle style = workbook.createCellStyle();
        style.setFillForegroundColor(HSSFColor.LIGHT_BLUE.index);
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        HSSFFont font = workbook.createFont();
        font.setColor(HSSFColor.WHITE.index);
        font.setBold(true);
        style.setFont((Font)font);
        HSSFRow row1 = worksheet.createRow(0);
        Cell cell = row1.createCell(0);
        cell.setCellValue("DATA OPERAZIONE");
        cell.setCellStyle((CellStyle)style);
        cell = row1.createCell(1);
        cell.setCellValue("CODICE OPERAZIONE");
        cell.setCellStyle((CellStyle)style);
        cell = row1.createCell(2);
        cell.setCellValue("NUMERO OPERAZIONE");
        cell.setCellStyle((CellStyle)style);
        cell = row1.createCell(3);
        cell.setCellValue("QTA SIAN");
        cell.setCellStyle((CellStyle)style);
        cell = row1.createCell(4);
        cell.setCellValue("QTA WBS");
        cell.setCellStyle((CellStyle)style);
        cell = row1.createCell(5);
        cell.setCellValue("COMMITTENTE");
        cell.setCellStyle((CellStyle)style);
        for (j = 0; j < arraySIAN.length(); ++j) {
            objk = arraySIAN.getJSONObject(j);
            String codice_operazione = objk.get("codice_operazione").toString();
            String data_operazione = objk.get("data_operazione").toString();
            String cod_committente = objk.get("cod_committente").toString();
            numero_operazione = objk.get("numero_operazione").toString();
            JSONArray lista = objk.getJSONArray("lista");
            for (int k = 0; k < lista.length(); ++k) {
                String qta;
                JSONObject objkdd;
                int l;
                JSONObject objkd = lista.getJSONObject(k);
                JSONArray prodotto1 = objkd.getJSONArray("prodotto1");
                JSONArray prodotto2 = objkd.getJSONArray("prodotto2");
                JSONArray prodotto3 = objkd.getJSONArray("prodotto3");
                JSONArray prodotto4 = objkd.getJSONArray("prodotto4");
                JSONArray prodotto5 = objkd.getJSONArray("prodotto5");
                BigDecimal qtaTot = new BigDecimal(0);
                for (l = 0; l < prodotto1.length(); ++l) {
                    objkdd = prodotto1.getJSONObject(l);
                    qta = objkdd.get("qta").toString().replace("null", "0");
                    if (!(Double.parseDouble(qta) > 0.0) && !(Double.parseDouble(qta) < 0.0)) continue;
                    qtaTot = qtaTot.add(new BigDecimal(qta));
                }
                for (l = 0; l < prodotto2.length(); ++l) {
                    objkdd = prodotto2.getJSONObject(l);
                    qta = objkdd.get("qta").toString().replace("null", "0");
                    if (!(Double.parseDouble(qta) > 0.0) && !(Double.parseDouble(qta) < 0.0)) continue;
                    qtaTot = qtaTot.add(new BigDecimal(qta));
                }
                for (l = 0; l < prodotto3.length(); ++l) {
                    objkdd = prodotto3.getJSONObject(l);
                    qta = objkdd.get("qta").toString().replace("null", "0");
                    if (!(Double.parseDouble(qta) > 0.0) && !(Double.parseDouble(qta) < 0.0)) continue;
                    qtaTot = qtaTot.add(new BigDecimal(qta));
                }
                for (l = 0; l < prodotto4.length(); ++l) {
                    objkdd = prodotto4.getJSONObject(l);
                    qta = objkdd.get("qta").toString().replace("null", "0");
                    if (!(Double.parseDouble(qta) > 0.0) && !(Double.parseDouble(qta) < 0.0)) continue;
                    qtaTot = qtaTot.add(new BigDecimal(qta));
                }
                for (l = 0; l < prodotto5.length(); ++l) {
                    objkdd = prodotto5.getJSONObject(l);
                    qta = objkdd.get("qta").toString().replace("null", "0");
                    if (!(Double.parseDouble(qta) > 0.0) && !(Double.parseDouble(qta) < 0.0)) continue;
                    qtaTot = qtaTot.add(new BigDecimal(qta));
                }
                HSSFRow row = worksheet.createRow((int)((short)counterrow));
                cell = row.createCell(0);
                cell.setCellValue(data_operazione);
                cell = row.createCell(1);
                cell.setCellValue(codice_operazione);
                cell = row.createCell(2);
                cell.setCellValue(numero_operazione);
                cell = row.createCell(3);
                cell.setCellValue(qtaTot.toString());
                cell = row.createCell(4);
                cell.setCellValue("");
                cell = row.createCell(5);
                cell.setCellValue(cod_committente);
                for (int jj = 0; jj < arrayWBS.length(); ++jj) {
                    JSONObject objkq = arrayWBS.getJSONObject(jj);
                    String codice_operazioned = objkq.get("codice_operazione").toString();
                    String data_operazioned = objkq.get("data_operazione").toString();
                    String numero_operazioned = objkq.get("numero_operazione").toString();
                    String cod_committentes = objkq.get("cod_committente").toString();
                    String quantita = objkq.get("quantita").toString();
                    if (!codice_operazione.equals(codice_operazioned) || !data_operazione.equals(data_operazioned) || !numero_operazione.equals(numero_operazioned)) continue;
                    cell = row.createCell(4);
                    cell.setCellValue(quantita);
                    arrayWBS.remove(jj);
                }
                ++counterrow;
            }
        }
        for (j = 0; j < arrayWBS.length(); ++j) {
            objk = arrayWBS.getJSONObject(j);
            String cod_committente = objk.get("cod_committente").toString();
            String codice_operazione = objk.get("codice_operazione").toString();
            String data_operazione = objk.get("data_operazione").toString();
            numero_operazione = objk.get("numero_operazione").toString();
            String quantita = objk.get("quantita").toString();
            HSSFRow row = worksheet.createRow((int)((short)counterrow));
            cell = row.createCell(0);
            cell.setCellValue(data_operazione);
            cell = row.createCell(1);
            cell.setCellValue(codice_operazione);
            cell = row.createCell(2);
            cell.setCellValue(numero_operazione);
            cell = row.createCell(3);
            cell.setCellValue("");
            cell = row.createCell(4);
            cell.setCellValue(quantita);
            cell = row.createCell(5);
            cell.setCellValue(cod_committente);
            ++counterrow;
        }
        workbook.write((OutputStream)fileOut);
    }

    public void initialize(URL url, ResourceBundle rb) {
        try {
            this.groupTipoStampa = new ToggleGroup();
            this.chk_pdf.setToggleGroup(this.groupTipoStampa);
            this.chk_xls.setToggleGroup(this.groupTipoStampa);
            this.groupTipoStampa.selectToggle((Toggle)this.chk_xls);
            this.dtp_alladata.setValue((Object)LocalDate.now());
            this.dtp_dalladata.setValue((Object)LocalDate.now());
            this.groupTipo = new ToggleGroup();
            this.chk_test.setToggleGroup(this.groupTipo);
            this.chk_reale.setToggleGroup(this.groupTipo);
            this.groupTipo.selectToggle((Toggle)this.chk_test);
            this.groupConfronto = new ToggleGroup();
            this.chk_confrontawbs.setToggleGroup(this.groupConfronto);
            this.chk_nonconfrontawbs.setToggleGroup(this.groupConfronto);
            this.groupConfronto.selectToggle((Toggle)this.chk_test);
        }
        catch (Exception ex) {
            Logger.getLogger(StampaMovimentiSIANController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

