/*
 * Decompiled with CFR 0.152.
 */
package vin.controller;

import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.controls.JFXRadioButton;
import com.jfoenix.controls.JFXTextField;
import java.io.IOException;
import java.net.URL;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.chart.BarChart;
import javafx.scene.chart.PieChart;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Alert;
import javafx.scene.control.CheckBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import vin.Class.CodiceDescrizioneComboBox;
import vin.Class.WorkIndicatorDialog;
import vin.Uility.JasperReport;
import vin.controller.FXMLDocumentController;
import vin.controller.SearchClientiController;
import vin.controller.SearchLottoIdoneitaController;
import vin.controller.SearchProdottoPool;
import vin.controller.SearchTableCodiceDescrizioneController;
import vin.controller.StampaInventarioController;

public class StampaMovimentiController
implements Initializable {
    @FXML
    private JFXComboBox<CodiceDescrizioneComboBox> cmbx_classificazione;
    @FXML
    private JFXComboBox<CodiceDescrizioneComboBox> cmbx_colore;
    @FXML
    private Label label_dalladata;
    @FXML
    private Label label_alladata;
    @FXML
    private Label label_prodotto;
    @FXML
    private Label label_annata;
    @FXML
    private Label label_coddopigp;
    @FXML
    private JFXRadioButton chk_imbo;
    @FXML
    private JFXRadioButton chk_sfuso;
    @FXML
    private JFXRadioButton chk_tutto;
    @FXML
    JFXRadioButton chk_standard;
    @FXML
    JFXRadioButton chk_estesa;
    @FXML
    JFXRadioButton chk_pdf;
    @FXML
    JFXRadioButton chk_xls;
    @FXML
    private DatePicker dtp_dalladata;
    @FXML
    private DatePicker dtp_alladata;
    @FXML
    private JFXTextField editText_prodotto;
    @FXML
    private JFXTextField editText_annata;
    @FXML
    private JFXTextField editText_codoper;
    @FXML
    private JFXTextField editText_codlotto;
    @FXML
    private HBox box_dopigp;
    @FXML
    private JFXTextField editText_coddopigp;
    @FXML
    private PieChart torta;
    @FXML
    private BarChart bar_chart;
    JasperReport jasperReport = new JasperReport();
    ToggleGroup groupTipoVino = null;
    ToggleGroup groupTipoStampa = null;
    ToggleGroup groupTipoStampa2 = null;
    @FXML
    private Label label_annata1;
    @FXML
    private Label label_annata11;
    @FXML
    private Label label_annata111;
    @FXML
    private Label label_annata12;
    @FXML
    private Label label_annata121;
    @FXML
    private HBox box_dopigp1;
    @FXML
    private JFXComboBox<CodiceDescrizioneComboBox> cmbx_biologico;
    public ObservableList<CodiceDescrizioneComboBox> lista_bio = FXCollections.observableArrayList();
    @FXML
    private CheckBox chk_globale;
    @FXML
    private Label label_annata1211;
    @FXML
    private HBox box_dopigp2;
    @FXML
    private JFXTextField editText_codcli;
    @FXML
    private CheckBox chk_escludiprimoagosto;
    WorkIndicatorDialog wd = null;
    ObservableList<CodiceDescrizioneComboBox> lista_classificazione = FXCollections.observableArrayList();
    ObservableList<CodiceDescrizioneComboBox> lista_colore = FXCollections.observableArrayList();

    @FXML
    void btnClearCodDop(ActionEvent event) {
        this.editText_coddopigp.setText("");
    }

    @FXML
    void btnSearchCodLotto(ActionEvent event) throws JSONException, IOException {
        FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/vin/view/SearchTableCodiceDescrizione.fxml"));
        Parent rootLayout = (Parent)loader.load();
        Scene scene = new Scene(rootLayout);
        Stage stage = new Stage();
        stage.setTitle("Lotto");
        stage.setScene(scene);
        SearchTableCodiceDescrizioneController controller = (SearchTableCodiceDescrizioneController)loader.getController();
        controller.setTableLotto();
        stage.initModality(Modality.APPLICATION_MODAL);
        stage.setResizable(true);
        stage.showAndWait();
        String codice = controller.getCodice();
        String descr = controller.getDescrizione();
        if (!codice.equals("")) {
            this.editText_codlotto.setText(codice);
        }
    }

    @FXML
    void btnSearchCodDop(ActionEvent event) throws JSONException, IOException {
        String codiced = this.editText_coddopigp.getText().trim();
        FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/vin/view/SearchTableCodiceDescrizione.fxml"));
        Parent rootLayout = (Parent)loader.load();
        Scene scene = new Scene(rootLayout);
        Stage stage = new Stage();
        stage.setTitle("Codici Dop/IGP");
        stage.setScene(scene);
        SearchTableCodiceDescrizioneController controller = (SearchTableCodiceDescrizioneController)loader.getController();
        controller.setTable("sian_t_dopigp");
        if (!codiced.equals("")) {
            controller.setCodice(codiced);
        }
        stage.initModality(Modality.APPLICATION_MODAL);
        stage.setResizable(true);
        stage.showAndWait();
        String codice = controller.getCodice();
        String descr = controller.getDescrizione();
        if (!codice.equals("")) {
            this.editText_coddopigp.setText(codice);
        }
    }

    @FXML
    void btnActionGrafico(ActionEvent event) throws JSONException {
        this.bar_chart.getData().setAll(new Object[0]);
        this.torta.getData().setAll((Object[])new PieChart.Data[0]);
        this.wd = new WorkIndicatorDialog(this.bar_chart.getScene().getWindow(), "Caricamento in corso...");
        this.wd.addTaskEndNotification(result -> {
            System.out.println(result);
            this.wd = null;
        });
        this.wd.exec("123", inputParam -> {
            try {
                this.gografico();
            }
            catch (Exception ex) {
                Logger.getLogger(StampaMovimentiController.class.getName()).log(Level.SEVERE, null, ex);
            }
            return new Integer(1);
        });
    }

    private void gografico() throws JSONException {
        ArrayList key = new ArrayList();
        ArrayList value = new ArrayList();
        int tipoStampa = 0;
        int tipoStampa2 = 0;
        String stato_fisico = "";
        String nomeFileJRXML = "";
        String alladata = "";
        LocalDate endtime = (LocalDate)this.dtp_alladata.getValue();
        if (endtime != null) {
            alladata = endtime.toString();
        }
        String dalladata = "";
        LocalDate endtime2 = (LocalDate)this.dtp_dalladata.getValue();
        if (endtime2 != null) {
            dalladata = endtime2.toString();
        }
        JFXRadioButton chk_TipoVino = (JFXRadioButton)this.groupTipoVino.getSelectedToggle();
        JFXRadioButton chk_TipoStampa = (JFXRadioButton)this.groupTipoStampa.getSelectedToggle();
        JFXRadioButton chk_TipoStampa2 = (JFXRadioButton)this.groupTipoStampa2.getSelectedToggle();
        if (!chk_TipoStampa2.getText().equals("Standard")) {
            tipoStampa2 = 1;
        }
        tipoStampa = chk_TipoStampa.getText().equals("PDF") ? 1 : 2;
        if (chk_TipoVino.getText().equals("Imbottigliato")) {
            stato_fisico = "<>'1'";
        } else if (chk_TipoVino.getText().equals("Sfuso")) {
            stato_fisico = "='1'";
        }
        String annata = this.editText_annata.getText().trim();
        String prodotto = this.editText_prodotto.getText().trim();
        String cod_dop = this.editText_coddopigp.getText().trim();
        String codoper = this.editText_codoper.getText().trim();
        CodiceDescrizioneComboBox combos = (CodiceDescrizioneComboBox)this.cmbx_biologico.getSelectionModel().getSelectedItem();
        String codice_bio = "";
        if (combos != null) {
            codice_bio = combos.getCodice();
        }
        if (alladata.equals("")) {
            SearchLottoIdoneitaController.toast.startToast("(Alla Data) Campo obbligatorio", "ERRORE", "ERRORE");
            return;
        }
        if (dalladata.equals("")) {
            SearchLottoIdoneitaController.toast.startToast("(Dalla Data) Campo obbligatorio", "ERRORE", "ERRORE");
            return;
        }
        String strWHERE = this.selectReportMovimentiGRAFICO(alladata, dalladata, prodotto, annata, stato_fisico, tipoStampa2, codoper);
        final XYChart.Series series1 = new XYChart.Series();
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList lenghtBidimensionalArray = new ArrayList();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String str = "";
        String data_select = "";
        lastID.add(false);
        tipoSQL.add("select");
        strSQL.add(strWHERE);
        str = FXMLDocumentController.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
        data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + str);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = FXMLDocumentController.jsonUtil.strJsonToJSONArray(data_select);
            this.bar_chart.getData().clear();
            final ObservableList pieChartData = FXCollections.observableArrayList();
            double tot = 0.0;
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                String prod = rec.get("cod_oper").toString();
                Double qta = rec.getDouble("noper");
                series1.getData().add((Object)new XYChart.Data((Object)prod, (Object)qta));
                pieChartData.add((Object)new PieChart.Data(prod, qta.doubleValue()));
                tot = qta + tot;
            }
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        StampaMovimentiController.this.bar_chart.getData().setAll(new Object[]{series1});
                        StampaMovimentiController.this.bar_chart.setBarGap(3.0);
                        StampaMovimentiController.this.bar_chart.setCategoryGap(20.0);
                        StampaMovimentiController.this.torta.getData().setAll((Collection)pieChartData);
                    }
                    catch (Exception ex) {
                        Logger.getLogger(StampaMovimentiController.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            });
        } else {
            FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", data_select);
        }
    }

    @FXML
    void btnActionStampa(ActionEvent event) throws JSONException, IOException {
        this.wd = new WorkIndicatorDialog(this.bar_chart.getScene().getWindow(), "Caricamento in corso...");
        this.wd.addTaskEndNotification(result -> {
            System.out.println(result);
            this.wd = null;
        });
        this.wd.exec("123", inputParam -> {
            try {
                this.gostampa();
            }
            catch (IOException | JSONException ex) {
                Logger.getLogger(StampaMovimentiController.class.getName()).log(Level.SEVERE, null, ex);
            }
            return 1;
        });
    }

    private void gostampa() throws JSONException, IOException {
        CodiceDescrizioneComboBox cmc;
        ArrayList<String> key = new ArrayList<String>();
        ArrayList<Object> value = new ArrayList<Object>();
        int tipoStampa = 0;
        int tipoStampa2 = 0;
        String stato_fisico = "";
        String nomeFileJRXML = "";
        String alladata = "";
        LocalDate endtime = (LocalDate)this.dtp_alladata.getValue();
        if (endtime != null) {
            alladata = endtime.toString();
        }
        String dalladata = "";
        LocalDate endtime2 = (LocalDate)this.dtp_dalladata.getValue();
        if (endtime2 != null) {
            dalladata = endtime2.toString();
        }
        JFXRadioButton chk_TipoVino = (JFXRadioButton)this.groupTipoVino.getSelectedToggle();
        JFXRadioButton chk_TipoStampa = (JFXRadioButton)this.groupTipoStampa.getSelectedToggle();
        JFXRadioButton chk_TipoStampa2 = (JFXRadioButton)this.groupTipoStampa2.getSelectedToggle();
        if (!chk_TipoStampa2.getText().equals("Standard")) {
            tipoStampa2 = 1;
        }
        tipoStampa = chk_TipoStampa.getText().equals("PDF") ? 1 : 2;
        if (chk_TipoVino.getText().equals("Imbottigliato")) {
            stato_fisico = "<>'1'";
        } else if (chk_TipoVino.getText().equals("Sfuso")) {
            stato_fisico = "='1'";
        }
        String annata = this.editText_annata.getText().trim();
        String prodotto = this.editText_prodotto.getText().trim();
        String cod_dop = this.editText_coddopigp.getText().trim();
        String codoper = this.editText_codoper.getText().trim();
        String lotto = this.editText_codlotto.getText().trim();
        boolean globale = this.chk_globale.selectedProperty().getValue();
        boolean escludi_primoagosto = this.chk_escludiprimoagosto.selectedProperty().getValue();
        String colore = "";
        String classificazione = "";
        CodiceDescrizioneComboBox cm = (CodiceDescrizioneComboBox)this.cmbx_classificazione.getSelectionModel().getSelectedItem();
        if (cm != null) {
            classificazione = cm.getCodice();
        }
        if ((cmc = (CodiceDescrizioneComboBox)this.cmbx_colore.getSelectionModel().getSelectedItem()) != null) {
            colore = cmc.getCodice();
        }
        CodiceDescrizioneComboBox combos = (CodiceDescrizioneComboBox)this.cmbx_biologico.getSelectionModel().getSelectedItem();
        String codice_bio = "";
        if (combos != null) {
            codice_bio = combos.getCodice();
        }
        if (alladata.equals("")) {
            SearchLottoIdoneitaController.toast.startToast("(Alla Data) Campo obbligatorio", "ERRORE", "ERRORE");
            return;
        }
        if (dalladata.equals("")) {
            SearchLottoIdoneitaController.toast.startToast("(Dalla Data) Campo obbligatorio", "ERRORE", "ERRORE");
            return;
        }
        String codice_cli = this.editText_codcli.getText().trim();
        String strWHERE = this.selectReportMovimenti(alladata, dalladata, prodotto, annata, stato_fisico, tipoStampa2, codoper, classificazione, colore, cod_dop, lotto, codice_bio, globale, codice_cli, escludi_primoagosto);
        key.add("DA_DATA");
        key.add("A_DATA");
        key.add("QUERY");
        key.add("AZIENDA");
        key.add("SOTTO_AZ");
        key.add("ICQRF");
        key.add("COD_COMMITTENTE");
        value.add(dalladata);
        value.add(alladata);
        value.add(strWHERE);
        value.add(FXMLDocumentController.GLOBAL_AZIENDA);
        value.add(FXMLDocumentController.GLOBAL_SOTTOAZZ);
        value.add(FXMLDocumentController.GLOBAL_ICQRF);
        value.add(FXMLDocumentController.GLOBAL_CODCOMM);
        if (tipoStampa2 == 0) {
            nomeFileJRXML = tipoStampa == 1 ? "movimenti_stdP.jrxml" : "movimenti_stdE.jrxml";
        } else {
            String sd = "";
            nomeFileJRXML = tipoStampa == 1 ? "movimenti_extP.jrxml" : "movimenti_extE.jrxml";
        }
        String resp = this.jasperReport.JSONjr(nomeFileJRXML, key, value, tipoStampa, "");
        String nomeFile = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "JasperReport#@" + resp);
        FXMLDocumentController.util.downloadFileTemp(nomeFile);
    }

    private String selectReportMovimenti(String a_data, String da_data, String prodotto, String annata, String stato_fisico, int tipoStampa, String cod_oper, String classificazione, String colore, String cod_dop, String lotto, String codice_bio, boolean globale, String codcli, boolean escludi_primoagosto) {
        String ret = "";
        if (tipoStampa == 0) {
            ret = "SELECT numero_doc_giustificativo,data_doc_giustificativo,invio_sian_id,data_oper, cod_oper, sigla, num_doc, cod_tipo_vino, annata, num_prot_ido, ente_cert, data_ido, if(confez=0,0,confez) as confez, lotti, qta,serie,fascette_da,fascette_a,fascette_tot,cod_mx,cod_clifor,descr_prodotto,descr_clifor,cod_committente,ragsoc_codcomm  FROM ( SELECT  a.numero_doc_giustificativo,a.data_doc_giustificativo,a.invio_sian_id,a.mx_doc_clifor AS cod_clifor,IF(k.pers_fisica='N',IFNULL(k.rag_soc,''),CONCAT(IFNULL(k.nome,''),' ',IFNULL(k.cognome,''))) AS descr_clifor,IFNULL(m.serie,'') AS serie,IFNULL(m.n_etic_mov_da,'') AS fascette_da,IFNULL(m.n_etic_mov_a,'') AS fascette_a,IFNULL(m.qta_mov,'') AS fascette_tot,@idmov := b.id AS id_movimento, a.data_oper AS data_oper, d.sian_cod_oper AS cod_oper, a.azienda AS azienda, a.sotto_az AS sotto_az, a.icqrf AS icqrf, a.cod_committente AS cod_committente, a.data_oper AS data_doc_mx, a.tipo_oper, a.mx_doc_sigla AS sigla, IF(a.mx_doc_num <> 0, CONCAT(CAST(a.mx_doc_ser AS CHAR(50)), '/', CAST(a.mx_doc_num AS CHAR(50))), '') AS num_doc, b.cod_tipo_vino AS cod_tipo_vino, c.descrizione AS descr_prodotto, c.sian_annata AS annata, if(b.data_ido = '0000-00-00', NULL, b.data_ido) AS data_ido, b.num_prot_ido AS num_prot_ido, b.ente_cert AS ente_cert,if(b.tipo_mov='S',b.confez*-1,b.confez) AS confez, IFNULL(GROUP_CONCAT(CAST(j.cod_lotto AS CHAR) SEPARATOR '|')  ,'') AS lotti, b.volume AS volume_nominale, b.qta AS qta,b.cod_prod_mx AS cod_mx,    IF(IFNULL(clifor.rag_soc,'')='',CONCAT(IFNULL(clifor.cognome,''),' ',IFNULL(clifor.nome,'')),IFNULL(clifor.rag_soc,'')) AS ragsoc_codcomm  FROM c_operazioni AS a LEFT JOIN c_movimenti AS b ON a.id = b.id_oper LEFT JOIN gen_tipo_vino_ana AS c ON b.cod_tipo_vino = c.codice AND b.azienda=c.azienda AND b.sotto_az=c.sotto_az AND b.icqrf=c.icqrf AND b.cod_committente=c.cod_committente LEFT JOIN gen_t_oper_sian AS d ON a.cod_oper = d.tipo_oper LEFT JOIN c_movimenti_etic AS m ON b.id=m.id_mov LEFT JOIN gen_ana_clifor AS k ON a.mx_doc_clifor=k.codice  AND a.azienda=k.azienda AND a.sotto_az=k.sotto_az LEFT JOIN c_movimenti_lotti AS j ON b.id=j.id_mov  LEFT JOIN gen_ana_clifor AS clifor ON a.cod_committente=clifor.codice AND a.azienda=clifor.azienda AND a.sotto_az=clifor.sotto_az WHERE !ISNULL(b.id) AND a.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND a.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND a.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "'   ";
            if (!globale) {
                ret = !FXMLDocumentController.GLOBAL_CODCOMM.equals("") ? ret + " AND a.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "' " : ret + " AND a.cod_committente='' ";
            }
            ret = ret + " AND a.cod_oper<>'AZZERAMENTO' ";
            if (da_data.equals("")) {
                da_data = "2017-01-01";
            }
            if (a_data.equals("")) {
                a_data = LocalDate.now().toString();
            }
            ret = ret + " AND (a.data_oper >= '" + da_data + "' AND a.data_oper <= '" + a_data + "') ";
            if (!prodotto.equals("")) {
                ret = ret + "AND b.cod_tipo_vino = '" + prodotto + "' ";
            }
            if (!stato_fisico.equals("")) {
                ret = ret + "AND c.sian_cod_stato_fisico" + stato_fisico + " ";
            }
            if (!classificazione.equals("")) {
                ret = ret + "AND c.sian_classificazione='" + classificazione + "' ";
            }
            if (!annata.equals("")) {
                ret = ret + "AND c.sian_annata = '" + annata + "' ";
            }
            if (escludi_primoagosto) {
                ret = ret + "AND d.sian_cod_oper <> 'GIACENZA31' ";
            }
            if (!cod_oper.equals("")) {
                ret = ret + "AND d.sian_cod_oper = '" + cod_oper + "' ";
            }
            if (!colore.equals("")) {
                ret = ret + "AND c.sian_colore = '" + colore + "' ";
            }
            if (!cod_dop.equals("")) {
                ret = ret + " AND c.sian_codice_dop_igp='" + cod_dop + "' ";
            }
            if (!codice_bio.equals("")) {
                ret = ret + " AND c.sian_biologico='" + codice_bio + "' ";
            }
            if (!codcli.equals("")) {
                ret = ret + " AND a.mx_doc_clifor='" + codcli + "' ";
            }
            ret = ret + " GROUP BY a.id,b.id) AS x ";
            if (!lotto.equals("")) {
                ret = ret + " WHERE lotti LIKE '" + lotto + "' ";
            }
            ret = ret + " ORDER BY data_oper  ";
        } else {
            ret = "SELECT IFNULL(cali,0) AS cali,numero_doc_giustificativo,data_doc_giustificativo,id_movimento, data_oper, azienda, sotto_az, icqrf, cod_stato_fisico, operazione, data_doc_mx, num_doc_mx, forn_dest, cod_tipo_vino, descrizione, classificazione, atto_certificato, stato_fisico, colore, biologico, tenore_zuccherino, codice_dop_igp, percentuale_igp, sottozona, menzioni, data_ido, num_prot_ido, ebacchus, annata, annata_percentuale, varieta, perc_varieta, altre_varieta, zona_viticola, origine_uve, paese_provenienza, pratiche_eno, massa_volumica, titolo_alcol_pot, titolo_alcol_eff, titolo_alcol_tot, codice_vaso, if(confez=0,0,confez) as confez, volume_nominale, lotti, qta_scarico, qta_carico, cod_committente,serie,fascette_da,fascette_a,fascette_tot,id_movvaso,ragsoc_codcomm  FROM ( SELECT a.numero_doc_giustificativo,a.data_doc_giustificativo,s.id AS id_movvaso,IFNULL(u.serie,'') AS serie,IFNULL(u.n_etic_mov_da,'') AS fascette_da,IFNULL(u.n_etic_mov_a,'') AS fascette_a,IFNULL(u.qta_mov,'') AS fascette_tot,@idmov := b.id AS id_movimento, a.data_oper AS data_oper, a.azienda AS azienda, a.sotto_az AS sotto_az, a.icqrf AS icqrf, a.cod_committente AS cod_committente, c.sian_cod_stato_fisico AS cod_stato_fisico, IF(d.sian_cod_oper <> '', CONCAT(d.sian_cod_oper, ' - ', d.descrizione), '') AS operazione, a.data_oper AS data_doc_mx, a.tipo_oper, IF(a.mx_doc_num <> 0, CONCAT(CAST(a.mx_doc_ser AS CHAR(50)), '/', CAST(a.mx_doc_num AS CHAR(50))), '') AS num_doc_mx, a.mx_doc_clifor AS forn_dest, b.cod_tipo_vino AS cod_tipo_vino, c.descrizione AS descrizione, IF(c.sian_classificazione <> '', CONCAT(c.sian_classificazione, ' - ', e.DESCRIZIONE), '') AS classificazione, IF(c.sian_atto_certificato <> '', CONCAT(c.sian_atto_certificato, ' - ', f.DESCRIZIONE), '') AS atto_certificato, IF(c.sian_cod_stato_fisico <> '', CONCAT(c.sian_cod_stato_fisico, ' - ', g.DESCRIZIONE), '') AS stato_fisico, IF(c.sian_colore <> '', CONCAT(c.sian_colore, ' - ', h.DESCRIZIONE), '') AS colore, IF(c.sian_biologico <> '', CONCAT(c.sian_biologico, ' - ', i.DESCRIZIONE), '') AS biologico, IF(c.sian_cod_tenore_zuccherino<> '',CONCAT(c.sian_cod_tenore_zuccherino,' - ',l.DESCRIZIONE), '') AS tenore_zuccherino, IF(c.sian_codice_dop_igp <> '',CONCAT(c.sian_codice_dop_igp, ' - ', m.Codice), '') AS codice_dop_igp, IFNULL(c.sian_percentuale_igp,0) AS percentuale_igp, IF(c.sian_cod_sottozona <> '', CONCAT(c.sian_cod_sottozona, ' - ', n.DESCRIZIONE), '') AS sottozona, c.sian_menzioni AS menzioni, IF(b.data_ido = '0000-00-00', NULL, b.data_ido) AS data_ido, b.num_prot_ido AS num_prot_ido, IF(c.sian_cod_ebac <> '', CONCAT(c.sian_cod_ebac, ' - ', o.PAESE), '') AS ebacchus, c.sian_annata AS annata, c.sian_annata_percentuale AS annata_percentuale, IF(c.sian_varieta <> '',CONCAT(c.sian_varieta,' - ', p.DESCRIZIONE), '') AS varieta,c.sian_perc_varieta AS perc_varieta, c.sian_altre_varieta AS altre_varieta, IF(c.sian_cod_zona_viticola> '',CONCAT(c.sian_cod_zona_viticola,' - ',q.DESCRIZIONE), '') AS zona_viticola,IF(c.sian_origine_uve <> '', CONCAT(c.sian_origine_uve, ' - ', r.name), '') AS origine_uve, IFNULL(k.DESCRIZIONE,'') AS paese_provenienza, c.sian_pratiche_eno AS pratiche_eno, c.sian_massa_volumica AS massa_volumica, IFNULL(c.sian_titolo_alcol_pot,0) AS titolo_alcol_pot, IFNULL(c.sian_titolo_alcol_eff,0) AS titolo_alcol_eff, IFNULL(c.sian_titolo_alcol_tot,0) AS titolo_alcol_tot, t.codice_vaso AS codice_vaso, if(b.tipo_mov='S',b.confez*-1,b.confez) AS confez, IF(c.sian_volume_nominale <> 0, c.sian_volume_nominale, 0) AS volume_nominale, IFNULL(GROUP_CONCAT(CAST(j.cod_lotto AS CHAR) SEPARATOR '|')  ,'') AS lotti, IF(s.qta_mov < 0, IF(s.qta_mov < 0, s.qta_mov, 0), IF(b.qta < 0, b.qta, 0)) AS qta_scarico, IF (s.qta_mov > 0, IF(s.qta_mov > 0, s.qta_mov, 0), IF(b.qta > 0, b.qta, 0)) AS qta_carico,   IF(IFNULL(clifor.rag_soc,'')='',CONCAT(IFNULL(clifor.cognome,''),' ',IFNULL(clifor.nome,'')),IFNULL(clifor.rag_soc,'')) AS ragsoc_codcomm,a.cali  FROM c_operazioni AS a \nLEFT JOIN c_movimenti AS b ON a.id = b.id_oper \nLEFT JOIN gen_tipo_vino_ana AS c ON b.cod_tipo_vino = c.codice AND b.azienda = c.azienda AND b.sotto_az = c.sotto_az AND b.icqrf = c.icqrf AND b.cod_committente = c.cod_committente LEFT JOIN gen_t_oper_sian AS d ON a.cod_oper = d.tipo_oper \nLEFT JOIN sian_t_classificazione AS e ON c.sian_classificazione = e.CODICE \nLEFT JOIN sian_t_atto_certificato AS f ON c.sian_atto_certificato = f.CODICE \nLEFT JOIN sian_t_stato_fisico AS g ON c.sian_cod_stato_fisico = g.CODICE \nLEFT JOIN sian_t_colore AS h ON c.sian_colore = h.CODICE \nLEFT JOIN sian_t_biologico AS i ON c.sian_biologico = i.CODICE LEFT JOIN sian_t_tenore_zuccheri AS l ON c.sian_cod_tenore_zuccherino = l.CODICE \nLEFT JOIN sian_t_dopigp AS m ON c.sian_codice_dop_igp = m.Codice AND m.progressivo=''\n LEFT JOIN sian_t_sottozone AS n ON c.sian_cod_sottozona = n.CODICE \nLEFT JOIN sian_t_ebacchus AS o ON c.sian_cod_ebac = o.CODICE \nLEFT JOIN sian_t_varieta AS p ON c.sian_varieta = p.CODICE \nLEFT JOIN sian_t_zona_viticola AS q ON c.sian_cod_zona_viticola = q.CODICE\n LEFT JOIN sian_t_paesiiso AS r ON c.sian_origine_uve = r.ISO3166_1_numeric\n LEFT JOIN sian_t_provenienza AS k ON c.sian_paese = k.CODICE\n LEFT JOIN gen_vasi_vinari_mov AS s ON b.id = s.id_mov\n LEFT JOIN gen_vasi_vinari_ana AS t ON s.id_vaso = t.id\n LEFT JOIN c_movimenti_etic AS u ON b.id=u.id_mov\n LEFT JOIN c_movimenti_lotti AS j ON b.id=j.id_mov \n        LEFT JOIN gen_ana_clifor AS clifor ON a.cod_committente=clifor.codice AND a.azienda=clifor.azienda AND a.sotto_az=clifor.sotto_az\n WHERE !ISNULL(b.id) \nAND a.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND a.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND a.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "'   ";
            if (!globale) {
                ret = !FXMLDocumentController.GLOBAL_CODCOMM.equals("") ? ret + " AND a.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "' " : ret + " AND a.cod_committente='' ";
            }
            ret = ret + " AND a.cod_oper<>'AZZERAMENTO' ";
            if (da_data.equals("")) {
                da_data = "2017-01-01";
            }
            if (a_data.equals("")) {
                a_data = LocalDate.now().toString();
            }
            ret = ret + " AND (a.data_oper >= '" + da_data + "' AND a.data_oper <= '" + a_data + "') ";
            if (!prodotto.equals("")) {
                ret = ret + "AND b.cod_tipo_vino = '" + prodotto + "' ";
            }
            if (!stato_fisico.equals("")) {
                ret = ret + "AND c.sian_cod_stato_fisico" + stato_fisico + " ";
            }
            if (!classificazione.equals("")) {
                ret = ret + "AND c.sian_classificazione='" + classificazione + "' ";
            }
            if (!annata.equals("")) {
                ret = ret + "AND c.sian_annata = '" + annata + "' ";
            }
            if (!cod_oper.equals("")) {
                ret = ret + "AND d.sian_cod_oper = '" + cod_oper + "' ";
            }
            if (!colore.equals("")) {
                ret = ret + "AND c.sian_colore = '" + colore + "' ";
            }
            if (!cod_dop.equals("")) {
                ret = ret + " AND c.sian_codice_dop_igp='" + cod_dop + "' ";
            }
            if (!codice_bio.equals("")) {
                ret = ret + " AND c.sian_biologico='" + codice_bio + "' ";
            }
            ret = ret + " GROUP BY a.id,b.id,s.id ) AS x ";
            if (!lotto.equals("")) {
                ret = ret + " WHERE lotti LIKE '%" + lotto + "%' ";
            }
            ret = ret + "GROUP BY id_movimento,id_movvaso ORDER BY data_oper,id_movimento ";
        }
        return ret;
    }

    private String selectReportMovimentiGRAFICO(String a_data, String da_data, String prodotto, String annata, String stato_fisico, int tipoStampa, String cod_oper) {
        String ret = "";
        ret = "SELECT invio_sian_id,data_oper, cod_oper, sigla, num_doc, cod_tipo_vino, annata, num_prot_ido, ente_cert, data_ido, confez, lotti, qta,serie,fascette_da,fascette_a,fascette_tot,cod_mx,cod_clifor,descr_prodotto,descr_clifor FROM ( SELECT a.invio_sian_id,a.mx_doc_clifor AS cod_clifor,IF(k.pers_fisica='N',IFNULL(k.rag_soc,''),CONCAT(IFNULL(k.nome,''),' ',IFNULL(k.cognome,''))) AS descr_clifor,IFNULL(m.serie,'') AS serie,IFNULL(m.n_etic_mov_da,'') AS fascette_da,IFNULL(m.n_etic_mov_a,'') AS fascette_a,IFNULL(m.qta_mov,'') AS fascette_tot,@idmov := b.id AS id_movimento, a.data_oper AS data_oper, d.sian_cod_oper AS cod_oper, a.azienda AS azienda, a.sotto_az AS sotto_az, a.icqrf AS icqrf, a.cod_committente AS cod_committente, a.data_oper AS data_doc_mx, a.tipo_oper, a.mx_doc_sigla AS sigla, IF(a.mx_doc_num <> 0, CONCAT(CAST(a.mx_doc_ser AS CHAR(50)), '/', CAST(a.mx_doc_num AS CHAR(50))), '') AS num_doc, b.cod_tipo_vino AS cod_tipo_vino, c.descrizione AS descr_prodotto, c.sian_annata AS annata, if(b.data_ido = '0000-00-00', NULL, b.data_ido) AS data_ido, b.num_prot_ido AS num_prot_ido, b.ente_cert AS ente_cert,b.confez AS confez, IFNULL((SELECT GROUP_CONCAT(CAST(y.cod_lotto AS CHAR) SEPARATOR '|') FROM c_movimenti_lotti AS y WHERE y.id_mov = @idmov GROUP BY y.id_mov),'') AS lotti, b.volume AS volume_nominale, b.qta AS qta,b.cod_prod_mx AS cod_mx FROM c_operazioni AS a LEFT JOIN c_movimenti AS b ON a.id = b.id_oper LEFT JOIN gen_tipo_vino_ana AS c ON b.cod_tipo_vino = c.codice AND b.azienda=c.azienda AND b.sotto_az=c.sotto_az AND b.icqrf=c.icqrf AND b.cod_committente=c.cod_committente LEFT JOIN gen_t_oper_sian AS d ON a.cod_oper = d.tipo_oper LEFT JOIN c_movimenti_etic AS m ON b.id=m.id_mov LEFT JOIN gen_ana_clifor AS k ON a.mx_doc_clifor=k.codice  AND a.azienda=k.azienda WHERE !ISNULL(b.id) AND a.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND a.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND a.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "'   AND a.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "' AND a.cod_oper<>'AZZERAMENTO' ";
        if (da_data.equals("")) {
            da_data = "2017-01-01";
        }
        if (a_data.equals("")) {
            a_data = LocalDate.now().toString();
        }
        ret = ret + " AND (a.data_oper >= '" + da_data + "' AND a.data_oper <= '" + a_data + "') ";
        if (!prodotto.equals("")) {
            ret = ret + "AND b.cod_tipo_vino = '" + prodotto + "' ";
        }
        if (!stato_fisico.equals("")) {
            ret = ret + "AND c.sian_cod_stato_fisico" + stato_fisico + " ";
        }
        if (!annata.equals("")) {
            ret = ret + "AND c.sian_annata = '" + annata + "' ";
        }
        if (!cod_oper.equals("")) {
            ret = ret + "AND d.sian_cod_oper = '" + cod_oper + "' ";
        }
        ret = ret + ") AS x ORDER BY data_oper  ";
        return ret;
    }

    private void setListaClassificazione() throws JSONException {
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        lastID.add(false);
        strSQL.add("SELECT * FROM sian_t_classificazione");
        tipoSQL.add("select");
        String strJson = FXMLDocumentController.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
        String data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = FXMLDocumentController.jsonUtil.strJsonToJSONArray(data_select);
            this.lista_classificazione.clear();
            this.lista_classificazione.add((Object)new CodiceDescrizioneComboBox("", ""));
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    JSONObject rec = arrayJson.getJSONObject(i);
                    this.lista_classificazione.add((Object)new CodiceDescrizioneComboBox(rec.getString("codice"), rec.getString("descrizione")));
                    continue;
                }
                catch (JSONException ex) {
                    FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                }
            }
            this.cmbx_classificazione.setItems(this.lista_classificazione);
        } else {
            FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", data_select);
        }
    }

    private void setListaColore() throws JSONException {
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        lastID.add(false);
        strSQL.add("SELECT * FROM sian_t_colore");
        tipoSQL.add("select");
        String strJson = FXMLDocumentController.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
        String data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = FXMLDocumentController.jsonUtil.strJsonToJSONArray(data_select);
            this.lista_colore.clear();
            this.lista_colore.add((Object)new CodiceDescrizioneComboBox("", ""));
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    JSONObject rec = arrayJson.getJSONObject(i);
                    this.lista_colore.add((Object)new CodiceDescrizioneComboBox(rec.getString("codice"), rec.getString("descrizione")));
                    continue;
                }
                catch (JSONException ex) {
                    FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                }
            }
            this.cmbx_colore.setItems(this.lista_colore);
        } else {
            FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", data_select);
        }
    }

    private void fillComboBio() {
        try {
            this.lista_bio.clear();
            this.lista_bio.add((Object)new CodiceDescrizioneComboBox("", ""));
            ArrayList<String> tipoSQL = new ArrayList<String>();
            ArrayList<String> strSQL = new ArrayList<String>();
            ArrayList lenghtBidimensionalArray = new ArrayList();
            ArrayList<Boolean> lastID = new ArrayList<Boolean>();
            lastID.add(false);
            tipoSQL.add("select");
            strSQL.add("SELECT CODICE,DESCRIZIONE FROM sian_t_biologico ");
            String str = FXMLDocumentController.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
            String data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + str);
            if (!data_select.contains("#ERR:")) {
                JSONArray arrayJson = FXMLDocumentController.jsonUtil.strJsonToJSONArray(data_select);
                for (int i = 0; i < arrayJson.length(); ++i) {
                    try {
                        JSONObject rec = arrayJson.getJSONObject(i);
                        this.lista_bio.add((Object)new CodiceDescrizioneComboBox(rec.get("codice").toString(), rec.get("descrizione").toString()));
                        continue;
                    }
                    catch (JSONException ex) {
                        FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                        return;
                    }
                }
            } else {
                FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", data_select);
            }
        }
        catch (JSONException ex) {
            Logger.getLogger(StampaInventarioController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void initialize(URL url, ResourceBundle rb) {
        try {
            this.groupTipoVino = new ToggleGroup();
            this.chk_imbo.setToggleGroup(this.groupTipoVino);
            this.chk_sfuso.setToggleGroup(this.groupTipoVino);
            this.chk_tutto.setToggleGroup(this.groupTipoVino);
            this.groupTipoVino.selectToggle((Toggle)this.chk_tutto);
            this.groupTipoStampa = new ToggleGroup();
            this.chk_pdf.setToggleGroup(this.groupTipoStampa);
            this.chk_xls.setToggleGroup(this.groupTipoStampa);
            this.groupTipoStampa2 = new ToggleGroup();
            this.chk_estesa.setToggleGroup(this.groupTipoStampa2);
            this.chk_standard.setToggleGroup(this.groupTipoStampa2);
            this.groupTipoStampa2.selectToggle((Toggle)this.chk_standard);
            this.groupTipoStampa.selectToggle((Toggle)this.chk_xls);
            this.setListaClassificazione();
            this.setListaColore();
            this.fillComboBio();
            this.cmbx_biologico.setItems(this.lista_bio);
            this.dtp_alladata.setValue((Object)LocalDate.now());
            this.dtp_dalladata.setValue((Object)LocalDate.now());
            this.editText_prodotto.textProperty().addListener((observable, oldValue, newValue) -> {
                try {
                    if (!newValue.equals("") && newValue.length() == 1) {
                        String prodotto = this.editText_prodotto.getText().trim();
                        FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/vin/view/SearchProdottoPool.fxml"));
                        Stage stage = new Stage();
                        stage.setMaximized(false);
                        stage.setTitle("Prodotto");
                        stage.setScene(new Scene((Parent)((Pane)loader.load())));
                        SearchProdottoPool controller = (SearchProdottoPool)loader.getController();
                        controller.setSearch((String)newValue, " ", "");
                        stage.initModality(Modality.APPLICATION_MODAL);
                        stage.setResizable(false);
                        stage.showAndWait();
                        String codice = controller.getCodice();
                        String descr = controller.getDesString();
                        String atto_cert = controller.getAttoCert();
                        String anno = controller.getAnno();
                        Double capacita = controller.getCapacita();
                        String id = controller.getID();
                        if (!codice.equals("")) {
                            this.editText_prodotto.setText(codice);
                        } else {
                            this.editText_prodotto.setText("");
                        }
                        stage.close();
                    }
                }
                catch (Exception ex) {
                    FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                }
            });
        }
        catch (JSONException ex) {
            Logger.getLogger(StampaMovimentiController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void btnSearchCodCli(ActionEvent event) throws IOException {
        FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/vin/view/SearchCliente.fxml"));
        Stage stage = new Stage();
        stage.setMaximized(false);
        stage.setTitle("Clienti/Fornitori");
        stage.setScene(new Scene((Parent)((Pane)loader.load())));
        SearchClientiController controller = (SearchClientiController)loader.getController();
        controller.setFillIndirizzo(true, FXMLDocumentController.GLOBAL_AZIENDA, FXMLDocumentController.GLOBAL_SOTTOAZZ, "");
        stage.initModality(Modality.APPLICATION_MODAL);
        stage.setResizable(false);
        stage.showAndWait();
        String codice = controller.getCodice();
        String descrizione = controller.getDescrizione();
        if (!codice.equals("")) {
            this.editText_codcli.setText(codice);
        }
    }

    @FXML
    private void btnClearCodCli(ActionEvent event) {
        this.editText_codcli.setText("");
    }
}

