/*
 * Decompiled with CFR 0.152.
 */
package vin.controller;

import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.controls.JFXRadioButton;
import com.jfoenix.controls.JFXTextField;
import java.io.IOException;
import java.net.URL;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.chart.BarChart;
import javafx.scene.chart.PieChart;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Alert;
import javafx.scene.control.CheckBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import vin.Class.CodiceDescrizione;
import vin.Class.CodiceDescrizioneComboBox;
import vin.Class.WorkIndicatorDialog;
import vin.Uility.JasperReport;
import vin.controller.FXMLDocumentController;
import vin.controller.SearchOperazioniConferimentiController;
import vin.controller.SearchProdottoPool;
import vin.controller.SearchTableCodiceDescrizioneController;
import vin.controller.StampaMovimentiController;

public class StampaInventarioController
implements Initializable {
    @FXML
    private Label label_dalladata;
    @FXML
    private Label label_alladata;
    @FXML
    private Label label_prodotto;
    @FXML
    private Label label_annata;
    @FXML
    private Label label_coddopigp;
    @FXML
    private JFXRadioButton chk_imbo;
    @FXML
    private JFXRadioButton chk_sfuso;
    @FXML
    private JFXRadioButton chk_imbse;
    @FXML
    private JFXRadioButton chk_tutto;
    @FXML
    JFXRadioButton chk_standard;
    @FXML
    JFXRadioButton chk_estesa;
    @FXML
    JFXRadioButton chk_pdf;
    @FXML
    JFXRadioButton chk_xls;
    @FXML
    JFXRadioButton chk_qtaminore;
    @FXML
    JFXRadioButton chk_qtamaggiore;
    @FXML
    JFXRadioButton chk_qtauguale;
    @FXML
    JFXRadioButton chk_qtatutto;
    @FXML
    JFXRadioButton chk_precancellati;
    @FXML
    private ToggleGroup gruppoqta;
    @FXML
    private DatePicker dtp_dalladata;
    @FXML
    private DatePicker dtp_alladata;
    @FXML
    private JFXTextField editText_prodotto;
    @FXML
    private JFXTextField editText_annata;
    @FXML
    private HBox box_dopigp;
    @FXML
    private JFXTextField editText_coddopigp;
    @FXML
    private PieChart torta;
    @FXML
    private BarChart bar_chart;
    JasperReport jasperReport = new JasperReport();
    ToggleGroup groupTipoVino = null;
    ToggleGroup groupTipoStampa = null;
    ToggleGroup groupTipoStampa2 = null;
    @FXML
    private Label label_coddopigp1;
    @FXML
    private JFXComboBox<CodiceDescrizioneComboBox> btn_biologico;
    public ObservableList<CodiceDescrizioneComboBox> lista_bio = FXCollections.observableArrayList();
    public ObservableList<CodiceDescrizioneComboBox> lista_zona = FXCollections.observableArrayList();
    public ObservableList<CodiceDescrizioneComboBox> lista_colore = FXCollections.observableArrayList();
    public ObservableList<CodiceDescrizione> lista_pratiche = FXCollections.observableArrayList();
    @FXML
    private JFXRadioButton chk_imbsecon;
    @FXML
    private JFXRadioButton chk_qtatuttodivzero;
    @FXML
    private CheckBox chk_globale;
    @FXML
    private ToggleGroup gruppostato;
    @FXML
    private Label label_coddopigp11;
    @FXML
    private Label label_coddopigp111;
    @FXML
    private Label label_coddopigp1111;
    @FXML
    private JFXComboBox<CodiceDescrizioneComboBox> btn_zona;
    @FXML
    private JFXComboBox<CodiceDescrizioneComboBox> btn_colore;
    @FXML
    private JFXComboBox<CodiceDescrizione> btn_pratiche;
    WorkIndicatorDialog wd = null;

    @FXML
    void btnClearCodDop(ActionEvent event) {
        this.editText_coddopigp.setText("");
    }

    @FXML
    void btnSearchCodDop(ActionEvent event) throws JSONException, IOException {
        String codiced = this.editText_coddopigp.getText().trim();
        FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/vin/view/SearchTableCodiceDescrizione.fxml"));
        Parent rootLayout = (Parent)loader.load();
        Scene scene = new Scene(rootLayout);
        Stage stage = new Stage();
        stage.setTitle("Codici Dop/IGP");
        stage.setScene(scene);
        SearchTableCodiceDescrizioneController controller = (SearchTableCodiceDescrizioneController)loader.getController();
        controller.setTable("sian_t_dopigp");
        if (!codiced.equals("")) {
            controller.setCodice(codiced);
        }
        stage.initModality(Modality.APPLICATION_MODAL);
        stage.setResizable(true);
        stage.showAndWait();
        String codice = controller.getCodice();
        String descr = controller.getDescrizione();
        if (!codice.equals("")) {
            this.editText_coddopigp.setText(codice);
        }
    }

    @FXML
    void btnActionGrafico(ActionEvent event) throws JSONException {
        this.bar_chart.getData().setAll(new Object[0]);
        this.torta.getData().setAll((Object[])new PieChart.Data[0]);
        this.wd = new WorkIndicatorDialog(this.bar_chart.getScene().getWindow(), "Caricamento in corso...");
        this.wd.addTaskEndNotification(result -> {
            System.out.println(result);
            this.wd = null;
        });
        this.wd.exec("123", inputParam -> {
            try {
                this.gografico();
            }
            catch (Exception ex) {
                System.out.println(ex.toString());
            }
            return 1;
        });
    }

    private void gografico() throws JSONException {
        ArrayList key = new ArrayList();
        ArrayList value = new ArrayList();
        int tipoStampa = 0;
        boolean tipoStampa2 = false;
        String stato_fisico = "";
        String nomeFileJRXML = "";
        String alladata = "";
        LocalDate endtime = (LocalDate)this.dtp_alladata.getValue();
        if (endtime != null) {
            alladata = endtime.toString();
        }
        String dalladata = "";
        LocalDate endtime2 = LocalDate.parse(FXMLDocumentController.ricerca.getDallaDataInizioAnno());
        if (endtime2 != null) {
            dalladata = endtime2.toString().equals("2017-01-01") ? endtime2.toString() : endtime2.plusDays(1L).toString();
        }
        JFXRadioButton chk_TipoVino = (JFXRadioButton)this.groupTipoVino.getSelectedToggle();
        JFXRadioButton chk_TipoStampa = (JFXRadioButton)this.groupTipoStampa.getSelectedToggle();
        JFXRadioButton chk_TipoStampa2 = (JFXRadioButton)this.groupTipoStampa2.getSelectedToggle();
        if (!chk_TipoStampa2.getText().equals("Standard")) {
            tipoStampa2 = true;
        }
        tipoStampa = chk_TipoStampa.getText().equals("PDF") ? 1 : 2;
        boolean togli_precancellati = this.chk_precancellati.isSelected();
        if (chk_TipoVino.getText().equals("Imbottigliato")) {
            stato_fisico = " (b.sian_cod_stato_fisico='3' OR b.sian_cod_stato_fisico='2') ";
        } else if (chk_TipoVino.getText().equals("Sfuso")) {
            stato_fisico = " (b.sian_cod_stato_fisico='1' OR b.sian_cod_stato_fisico='') ";
        }
        JFXRadioButton chk_qta = (JFXRadioButton)this.gruppoqta.getSelectedToggle();
        String whereqta = "";
        if (chk_qta.getText().equals("<0")) {
            whereqta = " WHERE a.QTA<0 ";
        } else if (chk_qta.getText().equals(">0")) {
            whereqta = " WHERE a.QTA>0 ";
        } else if (chk_qta.getText().equals("=0")) {
            whereqta = " WHERE a.QTA=0 ";
        }
        String annata = this.editText_annata.getText().trim();
        String prodotto = this.editText_prodotto.getText().trim();
        String cod_dop = this.editText_coddopigp.getText().trim();
        CodiceDescrizioneComboBox combos = (CodiceDescrizioneComboBox)this.btn_biologico.getSelectionModel().getSelectedItem();
        String codice_bio = "";
        if (combos != null) {
            codice_bio = combos.getCodice();
        }
        if (alladata.equals("")) {
            FXMLDocumentController.toast.startToast("(Alla Data) Campo obbligatorio", "ERRORE", "ERRORE");
            return;
        }
        final XYChart.Series series1 = new XYChart.Series();
        String strWHERE = this.selectReportInventario(dalladata, alladata, annata, prodotto, stato_fisico, cod_dop, whereqta, togli_precancellati, codice_bio, false, "", "", "");
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList lenghtBidimensionalArray = new ArrayList();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String str = "";
        String data_select = "";
        lastID.add(false);
        tipoSQL.add("select");
        strSQL.add(strWHERE);
        str = FXMLDocumentController.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
        data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + str);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = FXMLDocumentController.jsonUtil.strJsonToJSONArray(data_select);
            this.bar_chart.getData().clear();
            final ObservableList pieChartData = FXCollections.observableArrayList();
            double tot = 0.0;
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                String prod = rec.get("codice").toString();
                Double pr = rec.getDouble("qta");
                series1.getData().add((Object)new XYChart.Data((Object)prod, (Object)pr));
                pieChartData.add((Object)new PieChart.Data(prod, pr.doubleValue()));
                tot = pr + tot;
            }
            series1.setName(tot + "");
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    StampaInventarioController.this.bar_chart.getData().setAll(new Object[]{series1});
                    StampaInventarioController.this.torta.getData().setAll((Collection)pieChartData);
                }
            });
        } else {
            FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", data_select);
        }
    }

    @FXML
    void btnActionStampa(ActionEvent event) throws JSONException, IOException {
        this.wd = new WorkIndicatorDialog(this.bar_chart.getScene().getWindow(), "Caricamento in corso...");
        this.wd.addTaskEndNotification(result -> {
            System.out.println(result);
            this.wd = null;
        });
        this.wd.exec("123", inputParam -> {
            try {
                this.gostampa();
            }
            catch (IOException | JSONException ex) {
                Logger.getLogger(StampaMovimentiController.class.getName()).log(Level.SEVERE, null, ex);
            }
            return 1;
        });
    }

    private void gostampa() throws IOException, JSONException {
        String h2;
        String h;
        ArrayList<String> key = new ArrayList<String>();
        ArrayList<Object> value = new ArrayList<Object>();
        int tipoStampa = 0;
        boolean tipoStampa2 = false;
        String stato_fisico = "";
        String nomeFileJRXML = "";
        String alladata = "";
        LocalDate endtime = (LocalDate)this.dtp_alladata.getValue();
        String dalladata = "";
        if (endtime != null) {
            alladata = endtime.toString();
        }
        int mese = endtime.getMonthValue();
        if (!FXMLDocumentController.ricerca.getIfChiusuraNeverWBS(FXMLDocumentController.GLOBAL_AZIENDA, FXMLDocumentController.GLOBAL_SOTTOAZZ, FXMLDocumentController.GLOBAL_ICQRF)) {
            String anno = String.valueOf(endtime.getYear());
            if (LocalDate.now().getYear() >= endtime.getYear()) {
                if (mese < 8) {
                    dalladata = FXMLDocumentController.ricerca.getDataPerStampaDalla(String.valueOf(Integer.parseInt(anno)));
                    if (dalladata.equals("")) {
                        dalladata = Integer.parseInt(anno) - 1 + "-08-01";
                    }
                } else {
                    String datas = FXMLDocumentController.ricerca.getDataPerStampaDallaPrima(anno);
                    dalladata = !datas.equals("") ? datas : anno + "-08-01";
                }
            } else {
                dalladata = String.valueOf(LocalDate.now().getYear()) + "-08-01";
            }
        } else {
            dalladata = "2017-01-01";
        }
        JFXRadioButton chk_TipoVino = (JFXRadioButton)this.groupTipoVino.getSelectedToggle();
        JFXRadioButton chk_TipoStampa = (JFXRadioButton)this.groupTipoStampa.getSelectedToggle();
        JFXRadioButton chk_TipoStampa2 = (JFXRadioButton)this.groupTipoStampa2.getSelectedToggle();
        if (!chk_TipoStampa2.getText().equals("Standard")) {
            tipoStampa2 = true;
        }
        tipoStampa = chk_TipoStampa.getText().equals("PDF") ? 1 : 2;
        if (chk_TipoVino.getText().equals("Imbottigliato")) {
            stato_fisico = " (b.sian_cod_stato_fisico='2') ";
        } else if (chk_TipoVino.getText().equals("Sfuso")) {
            stato_fisico = " (b.sian_cod_stato_fisico='1' OR b.sian_cod_stato_fisico='') ";
        } else if (chk_TipoVino.getText().equals("Imbottigliato senza etichetta")) {
            stato_fisico = " (b.sian_cod_stato_fisico='3') ";
        } else if (chk_TipoVino.getText().equals("Imbottigliato senza e conf.")) {
            stato_fisico = " (b.sian_cod_stato_fisico='3') OR (b.sian_cod_stato_fisico='2') ";
        }
        JFXRadioButton chk_qta = (JFXRadioButton)this.gruppoqta.getSelectedToggle();
        String whereqta = "";
        if (chk_qta.getText().equals("<0")) {
            whereqta = " WHERE a.QTA<0 ";
        } else if (chk_qta.getText().equals(">0")) {
            whereqta = " WHERE a.QTA>0 ";
        } else if (chk_qta.getText().equals("=0")) {
            whereqta = " WHERE a.QTA=0 ";
        } else if (chk_qta.getText().equals("<>0")) {
            whereqta = " WHERE a.QTA<>0 ";
        }
        boolean togli_precancellati = this.chk_precancellati.isSelected();
        String annata = this.editText_annata.getText().trim();
        String prodotto = this.editText_prodotto.getText().trim();
        String cod_dop = this.editText_coddopigp.getText().trim();
        boolean globale = this.chk_globale.selectedProperty().getValue();
        CodiceDescrizioneComboBox combos = (CodiceDescrizioneComboBox)this.btn_biologico.getSelectionModel().getSelectedItem();
        CodiceDescrizioneComboBox combos_colore = (CodiceDescrizioneComboBox)this.btn_colore.getSelectionModel().getSelectedItem();
        CodiceDescrizioneComboBox combos_zona = (CodiceDescrizioneComboBox)this.btn_zona.getSelectionModel().getSelectedItem();
        CodiceDescrizione combos_pratiche = (CodiceDescrizione)this.btn_pratiche.getSelectionModel().getSelectedItem();
        String codice_bio = "";
        if (combos != null) {
            codice_bio = combos.getCodice();
        }
        String codice_colore = "";
        if (combos_colore != null) {
            codice_colore = combos_colore.getCodice();
        }
        String codice_zona = "";
        if (combos_zona != null) {
            codice_zona = combos_zona.getCodice();
        }
        String codice_pratiche = "";
        if (combos_pratiche != null) {
            codice_pratiche = combos_pratiche.getCodice();
        }
        if (alladata.equals("")) {
            SearchOperazioniConferimentiController.toast.startToast("(Alla Data) Campo obbligatorio", "ERRORE", "ERRORE");
            return;
        }
        String strWHERE = this.selectReportInventario(dalladata, alladata, annata, prodotto, stato_fisico, cod_dop, whereqta, togli_precancellati, codice_bio, globale, codice_colore, codice_zona, codice_pratiche);
        key.add("A_DATA");
        key.add("QUERY");
        key.add("AZIENDA");
        key.add("SOTTO_AZ");
        key.add("ICQRF");
        key.add("COD_COMMITTENTE");
        value.add(alladata);
        value.add(strWHERE);
        value.add(FXMLDocumentController.GLOBAL_AZIENDA);
        value.add(FXMLDocumentController.GLOBAL_SOTTOAZZ);
        value.add(FXMLDocumentController.GLOBAL_ICQRF);
        value.add(FXMLDocumentController.GLOBAL_CODCOMM);
        if (!tipoStampa2) {
            if (tipoStampa == 1) {
                h = "";
                nomeFileJRXML = "inventarioP.jrxml";
            } else {
                h2 = "";
                nomeFileJRXML = "inventarioE.jrxml";
            }
        } else if (tipoStampa2) {
            if (tipoStampa == 1) {
                h = "";
                nomeFileJRXML = "inventarioextP.jrxml";
            } else {
                h2 = "";
                nomeFileJRXML = "inventarioextE.jrxml";
            }
        }
        String resp = this.jasperReport.JSONjr(nomeFileJRXML, key, value, tipoStampa, "");
        String nomeFile = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "JasperReport#@" + resp);
        FXMLDocumentController.util.downloadFileTemp(nomeFile);
    }

    private String selectReportInventario(String da_data, String a_data, String annata, String prodotto, String stato_fisico, String cod_dop, String whereqta, boolean togli_precancellati, String codice_bio, boolean globale, String codice_colore, String codice_zona, String codice_pratiche) {
        String ret = "SELECT a.CODICE,a.DESCRIZIONE,a.ANNATA,a.QTA,a.LITRI,a.PEZZI,a.CODDOPIGP,a.CLASSIFICAZIONE,a.BIOLOGICO,a.CATPROD,a.CODICEPARTITA,\na.STATOFISICO,a.ATTOCERT,a.COD_COMMITTENTE,a.RAGSOC_CODCOMM \nFROM ( SELECT a.cod_tipo_vino AS CODICE, b.descrizione AS DESCRIZIONE, b.sian_annata AS ANNATA,\n SUM(a.qta) AS QTA, SUM(a.litri) AS LITRI, SUM(IF(a.qta >= 0, a.confez,(-1)*a.confez)) AS PEZZI,IFNULL(k.Descrizione,'') AS CODDOPIGP,\n IFNULL(g.DESCRIZIONE,'') AS CLASSIFICAZIONE,IFNULL(l.DESCRIZIONE,'') AS BIOLOGICO,IFNULL(xx.DESCRIZIONE,'') AS CATPROD,\n IFNULL(b.sian_cod_partita_gg_inv,'') AS CODICEPARTITA,IFNULL(f.DESCRIZIONE,'') AS STATOFISICO,IFNULL(s.DESCRIZIONE,'') AS ATTOCERT,\n a.cod_committente AS COD_COMMITTENTE,\n IF(IFNULL(clifor.rag_soc,'')='',CONCAT(IFNULL(clifor.cognome,''),' ',IFNULL(clifor.nome,'')),IFNULL(clifor.rag_soc,'')) AS RAGSOC_CODCOMM\n FROM c_movimenti AS a \n LEFT JOIN gen_tipo_vino_ana AS b ON a.cod_tipo_vino = b.codice AND a.azienda = b.azienda AND a.sotto_az = b.sotto_az AND a.icqrf = b.icqrf \n AND a.cod_committente = b.cod_committente \n LEFT JOIN c_operazioni AS c ON a.id_oper = c.id \n LEFT JOIN sian_t_dopigp AS k ON b.sian_codice_dop_igp=k.Codice AND k.progressivo='' \n LEFT JOIN sian_t_classificazione AS g ON b.sian_classificazione=g.CODICE \n LEFT JOIN sian_t_biologico AS l ON b.sian_biologico=l.CODICE \n LEFT JOIN sian_t_categoria AS xx ON b.sian_cat_prodotto=xx.CODICE \n LEFT JOIN sian_t_stato_fisico AS f ON b.sian_cod_stato_fisico=f.CODICE \n LEFT JOIN sian_t_atto_certificato AS s ON b.sian_atto_certificato=s.CODICE \n LEFT JOIN gen_ana_clifor AS clifor ON a.cod_committente=clifor.codice AND a.azienda=clifor.azienda AND a.sotto_az=clifor.sotto_az WHERE a.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND a.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND a.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "'   ";
        if (!globale) {
            ret = !FXMLDocumentController.GLOBAL_CODCOMM.equals("") ? ret + " AND a.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "' " : ret + " AND a.cod_committente='' ";
        }
        if (a_data.equals("")) {
            a_data = LocalDate.now().toString();
        }
        if (da_data.equals("")) {
            da_data = "2017-01-01";
        }
        if (!prodotto.equals("")) {
            ret = ret + " AND a.cod_tipo_vino = '" + prodotto + "' ";
        }
        if (!stato_fisico.equals("")) {
            ret = ret + " AND ( " + stato_fisico + " )";
        }
        if (!annata.equals("")) {
            ret = ret + " AND b.sian_annata = '" + annata + "' ";
        }
        if (!cod_dop.equals("")) {
            ret = ret + " AND b.sian_codice_dop_igp='" + cod_dop + "' ";
        }
        if (!togli_precancellati) {
            ret = ret + " AND b.cancellato<>1 ";
        }
        if (!codice_bio.equals("")) {
            ret = ret + " AND b.sian_biologico='" + codice_bio + "' ";
        }
        if (!codice_colore.equals("")) {
            ret = ret + " AND b.sian_colore='" + codice_colore + "' ";
        }
        if (!codice_zona.equals("")) {
            ret = ret + " AND b.sian_cod_zona_viticola='" + codice_zona + "' ";
        }
        if (!codice_pratiche.equals("")) {
            ret = ret + " AND b.sian_pratiche_eno LIKE '%" + codice_pratiche + "%' ";
        }
        ret = ret + " AND c.data_oper <= '" + a_data + "' AND c.data_oper >= '" + da_data + "' ";
        ret = ret + " GROUP BY a.azienda,a.sotto_az,a.icqrf,a.cod_committente,a.cod_tipo_vino  ";
        ret = ret + ") AS a ";
        if (!whereqta.equals("")) {
            ret = ret + whereqta;
        }
        return ret;
    }

    public void initialize(URL url, ResourceBundle rb) {
        this.groupTipoVino = new ToggleGroup();
        this.chk_imbo.setToggleGroup(this.groupTipoVino);
        this.chk_sfuso.setToggleGroup(this.groupTipoVino);
        this.chk_imbse.setToggleGroup(this.groupTipoVino);
        this.chk_imbsecon.setToggleGroup(this.groupTipoVino);
        this.chk_tutto.setToggleGroup(this.groupTipoVino);
        this.groupTipoVino.selectToggle((Toggle)this.chk_tutto);
        this.groupTipoStampa = new ToggleGroup();
        this.chk_pdf.setToggleGroup(this.groupTipoStampa);
        this.chk_xls.setToggleGroup(this.groupTipoStampa);
        this.groupTipoStampa2 = new ToggleGroup();
        this.chk_estesa.setToggleGroup(this.groupTipoStampa2);
        this.chk_standard.setToggleGroup(this.groupTipoStampa2);
        this.groupTipoStampa2.selectToggle((Toggle)this.chk_standard);
        this.groupTipoStampa.selectToggle((Toggle)this.chk_xls);
        this.fillComboBio();
        this.fillComboColore();
        this.fillComboPratiche();
        this.fillComboZona();
        this.btn_biologico.setItems(this.lista_bio);
        this.btn_zona.setItems(this.lista_zona);
        this.btn_colore.setItems(this.lista_colore);
        this.btn_pratiche.setItems(this.lista_pratiche);
        this.dtp_alladata.setValue((Object)LocalDate.now());
        this.editText_prodotto.textProperty().addListener((observable, oldValue, newValue) -> {
            try {
                if (!newValue.equals("") && newValue.length() == 1) {
                    String prodotto = this.editText_prodotto.getText().trim();
                    FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/vin/view/SearchProdottoPool.fxml"));
                    Stage stage = new Stage();
                    stage.setMaximized(false);
                    stage.setTitle("Prodotto");
                    stage.setScene(new Scene((Parent)((Pane)loader.load())));
                    SearchProdottoPool controller = (SearchProdottoPool)loader.getController();
                    controller.setSearch((String)newValue, " ", "");
                    stage.initModality(Modality.APPLICATION_MODAL);
                    stage.setResizable(false);
                    stage.showAndWait();
                    String codice = controller.getCodice();
                    String descr = controller.getDesString();
                    String atto_cert = controller.getAttoCert();
                    String anno = controller.getAnno();
                    Double capacita = controller.getCapacita();
                    String id = controller.getID();
                    if (!codice.equals("")) {
                        this.editText_prodotto.setText(codice);
                    } else {
                        this.editText_prodotto.setText("");
                    }
                    stage.close();
                }
            }
            catch (Exception ex) {
                FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
            }
        });
    }

    private void fillComboBio() {
        try {
            this.lista_bio.clear();
            this.lista_bio.add((Object)new CodiceDescrizioneComboBox("", ""));
            ArrayList<String> tipoSQL = new ArrayList<String>();
            ArrayList<String> strSQL = new ArrayList<String>();
            ArrayList lenghtBidimensionalArray = new ArrayList();
            ArrayList<Boolean> lastID = new ArrayList<Boolean>();
            lastID.add(false);
            tipoSQL.add("select");
            strSQL.add("SELECT CODICE,DESCRIZIONE FROM sian_t_biologico ");
            String str = FXMLDocumentController.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
            String data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + str);
            if (!data_select.contains("#ERR:")) {
                JSONArray arrayJson = FXMLDocumentController.jsonUtil.strJsonToJSONArray(data_select);
                for (int i = 0; i < arrayJson.length(); ++i) {
                    try {
                        JSONObject rec = arrayJson.getJSONObject(i);
                        this.lista_bio.add((Object)new CodiceDescrizioneComboBox(rec.get("codice").toString(), rec.get("descrizione").toString()));
                        continue;
                    }
                    catch (JSONException ex) {
                        FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                        return;
                    }
                }
            } else {
                FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", data_select);
            }
        }
        catch (JSONException ex) {
            Logger.getLogger(StampaInventarioController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void fillComboColore() {
        try {
            this.lista_colore.clear();
            this.lista_colore.add((Object)new CodiceDescrizioneComboBox("", ""));
            ArrayList<String> tipoSQL = new ArrayList<String>();
            ArrayList<String> strSQL = new ArrayList<String>();
            ArrayList lenghtBidimensionalArray = new ArrayList();
            ArrayList<Boolean> lastID = new ArrayList<Boolean>();
            lastID.add(false);
            tipoSQL.add("select");
            strSQL.add("SELECT CODICE,DESCRIZIONE FROM sian_t_colore ");
            String str = FXMLDocumentController.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
            String data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + str);
            if (!data_select.contains("#ERR:")) {
                JSONArray arrayJson = FXMLDocumentController.jsonUtil.strJsonToJSONArray(data_select);
                for (int i = 0; i < arrayJson.length(); ++i) {
                    try {
                        JSONObject rec = arrayJson.getJSONObject(i);
                        this.lista_colore.add((Object)new CodiceDescrizioneComboBox(rec.get("codice").toString(), rec.get("descrizione").toString()));
                        continue;
                    }
                    catch (JSONException ex) {
                        FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                        return;
                    }
                }
            } else {
                FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", data_select);
            }
        }
        catch (JSONException ex) {
            Logger.getLogger(StampaInventarioController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void fillComboZona() {
        try {
            this.lista_zona.clear();
            this.lista_zona.add((Object)new CodiceDescrizioneComboBox("", ""));
            ArrayList<String> tipoSQL = new ArrayList<String>();
            ArrayList<String> strSQL = new ArrayList<String>();
            ArrayList lenghtBidimensionalArray = new ArrayList();
            ArrayList<Boolean> lastID = new ArrayList<Boolean>();
            lastID.add(false);
            tipoSQL.add("select");
            strSQL.add("SELECT CODICE,DESCRIZIONE FROM sian_t_zona_viticola ");
            String str = FXMLDocumentController.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
            String data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + str);
            if (!data_select.contains("#ERR:")) {
                JSONArray arrayJson = FXMLDocumentController.jsonUtil.strJsonToJSONArray(data_select);
                for (int i = 0; i < arrayJson.length(); ++i) {
                    try {
                        JSONObject rec = arrayJson.getJSONObject(i);
                        this.lista_zona.add((Object)new CodiceDescrizioneComboBox(rec.get("codice").toString(), rec.get("descrizione").toString()));
                        continue;
                    }
                    catch (JSONException ex) {
                        FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                        return;
                    }
                }
            } else {
                FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", data_select);
            }
        }
        catch (JSONException ex) {
            Logger.getLogger(StampaInventarioController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void fillComboPratiche() {
        try {
            this.lista_pratiche.clear();
            this.lista_pratiche.add((Object)new CodiceDescrizione("", ""));
            ArrayList<String> tipoSQL = new ArrayList<String>();
            ArrayList<String> strSQL = new ArrayList<String>();
            ArrayList lenghtBidimensionalArray = new ArrayList();
            ArrayList<Boolean> lastID = new ArrayList<Boolean>();
            lastID.add(false);
            tipoSQL.add("select");
            strSQL.add("SELECT CODICE,DESCRIZIONE FROM sian_t_pratiche_enologiche ");
            String str = FXMLDocumentController.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
            String data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + str);
            if (!data_select.contains("#ERR:")) {
                JSONArray arrayJson = FXMLDocumentController.jsonUtil.strJsonToJSONArray(data_select);
                for (int i = 0; i < arrayJson.length(); ++i) {
                    try {
                        JSONObject rec = arrayJson.getJSONObject(i);
                        this.lista_pratiche.add((Object)new CodiceDescrizione(rec.get("codice").toString(), rec.get("descrizione").toString()));
                        continue;
                    }
                    catch (JSONException ex) {
                        FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                        return;
                    }
                }
            } else {
                FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", data_select);
            }
        }
        catch (JSONException ex) {
            Logger.getLogger(StampaInventarioController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

