/*
 * Decompiled with CFR 0.152.
 */
package vin.controller;

import com.jfoenix.controls.JFXRadioButton;
import com.jfoenix.controls.JFXTextField;
import java.io.IOException;
import java.net.URL;
import java.time.LocalDate;
import java.time.Month;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.chart.BarChart;
import javafx.scene.chart.PieChart;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Alert;
import javafx.scene.control.CheckBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import vin.Uility.JasperReport;
import vin.controller.FXMLDocumentController;
import vin.controller.SearchProdottoPool;
import vin.controller.SearchTableCodiceDescrizioneController;

public class StampaInventarioCController
implements Initializable {
    @FXML
    private Label label_dalladata;
    @FXML
    private Label label_alladata;
    @FXML
    private Label label_prodotto;
    @FXML
    private Label label_annata;
    @FXML
    private Label label_coddopigp;
    @FXML
    private JFXRadioButton chk_imbo;
    @FXML
    private JFXRadioButton chk_sfuso;
    @FXML
    private JFXRadioButton chk_tutto;
    @FXML
    JFXRadioButton chk_standard;
    @FXML
    JFXRadioButton chk_estesa;
    @FXML
    JFXRadioButton chk_pdf;
    @FXML
    JFXRadioButton chk_xls;
    @FXML
    private DatePicker dtp_dalladata;
    @FXML
    private DatePicker dtp_alladata;
    @FXML
    private JFXTextField editText_prodotto;
    @FXML
    private JFXTextField editText_annata;
    @FXML
    private HBox box_dopigp;
    @FXML
    private JFXTextField editText_coddopigp;
    @FXML
    private PieChart torta;
    @FXML
    private BarChart bar_chart;
    JasperReport jasperReport = new JasperReport();
    ToggleGroup groupTipoVino = null;
    ToggleGroup groupTipoStampa = null;
    ToggleGroup groupTipoStampa2 = null;
    @FXML
    private CheckBox chk_globale;

    @FXML
    void btnClearCodDop(ActionEvent event) {
        this.editText_coddopigp.setText("");
    }

    @FXML
    void btnSearchCodDop(ActionEvent event) throws JSONException, IOException {
        FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/vin/view/SearchTableCodiceDescrizione.fxml"));
        Parent rootLayout = (Parent)loader.load();
        Scene scene = new Scene(rootLayout);
        Stage stage = new Stage();
        stage.setTitle("Codici Dop/IGP");
        stage.setScene(scene);
        SearchTableCodiceDescrizioneController controller = (SearchTableCodiceDescrizioneController)loader.getController();
        controller.setTable("sian_t_dopigp");
        stage.initModality(Modality.APPLICATION_MODAL);
        stage.setResizable(true);
        stage.showAndWait();
        String codice = controller.getCodice();
        String descr = controller.getDescrizione();
        if (!codice.equals("")) {
            this.editText_coddopigp.setText(codice);
        }
    }

    @FXML
    void btnActionGrafico(ActionEvent event) throws JSONException {
        ArrayList key = new ArrayList();
        ArrayList value = new ArrayList();
        int tipoStampa = 0;
        boolean tipoStampa2 = false;
        String stato_fisico = "";
        String nomeFileJRXML = "";
        String alladata = "";
        LocalDate endtime = (LocalDate)this.dtp_alladata.getValue();
        if (endtime != null) {
            alladata = endtime.toString();
        }
        String dalladata = "";
        LocalDate endtime2 = LocalDate.parse(FXMLDocumentController.ricerca.getDallaDataInizioAnno());
        if (endtime2 != null) {
            dalladata = endtime2.toString().equals("2017-01-01") ? endtime2.toString() : endtime2.plusDays(1L).toString();
        }
        JFXRadioButton chk_TipoVino = (JFXRadioButton)this.groupTipoVino.getSelectedToggle();
        JFXRadioButton chk_TipoStampa = (JFXRadioButton)this.groupTipoStampa.getSelectedToggle();
        JFXRadioButton chk_TipoStampa2 = (JFXRadioButton)this.groupTipoStampa2.getSelectedToggle();
        if (!chk_TipoStampa2.getText().equals("Standard")) {
            tipoStampa2 = true;
        }
        tipoStampa = chk_TipoStampa.getText().equals("PDF") ? 1 : 2;
        if (chk_TipoVino.getText().equals("Imbottigliato")) {
            stato_fisico = "<>'1'";
        } else if (chk_TipoVino.getText().equals("Sfuso")) {
            stato_fisico = "='1'";
        }
        String annata = this.editText_annata.getText().trim();
        String prodotto = this.editText_prodotto.getText().trim();
        String cod_dop = this.editText_coddopigp.getText().trim();
        if (alladata.equals("")) {
            FXMLDocumentController.toast.startToast("(Alla Data) Campo obbligatorio", "ERRORE", "ERRORE");
            return;
        }
        XYChart.Series series1 = new XYChart.Series();
        boolean globale = this.chk_globale.selectedProperty().getValue();
        String strWHERE = this.selectReportInventarioC(dalladata, alladata, annata, prodotto, stato_fisico, globale);
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList lenghtBidimensionalArray = new ArrayList();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String str = "";
        String data_select = "";
        lastID.add(false);
        tipoSQL.add("select");
        strSQL.add(strWHERE);
        str = FXMLDocumentController.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
        data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + str);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = FXMLDocumentController.jsonUtil.strJsonToJSONArray(data_select);
            this.bar_chart.getData().clear();
            ObservableList pieChartData = FXCollections.observableArrayList();
            double tot = 0.0;
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                String prod = rec.get("codice").toString();
                Double pr = rec.getDouble("qta");
                series1.getData().add((Object)new XYChart.Data((Object)prod, (Object)pr));
                pieChartData.add((Object)new PieChart.Data(prod, pr.doubleValue()));
                tot = pr + tot;
            }
            series1.setName(tot + "");
            this.bar_chart.getData().setAll(new Object[]{series1});
            this.torta.getData().setAll((Collection)pieChartData);
        } else {
            FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", data_select);
        }
    }

    @FXML
    void btnActionStampa(ActionEvent event) throws JSONException, IOException {
        ArrayList<String> key = new ArrayList<String>();
        ArrayList<Object> value = new ArrayList<Object>();
        int tipoStampa = 0;
        boolean tipoStampa2 = false;
        String stato_fisico = "";
        String nomeFileJRXML = "";
        String alladata = "";
        LocalDate endtime = (LocalDate)this.dtp_alladata.getValue();
        if (endtime != null) {
            alladata = endtime.toString();
        }
        String dalladata = "";
        int mese = endtime.getMonthValue();
        if (!FXMLDocumentController.ricerca.getIfChiusuraNeverWBS(FXMLDocumentController.GLOBAL_AZIENDA, FXMLDocumentController.GLOBAL_SOTTOAZZ, FXMLDocumentController.GLOBAL_ICQRF)) {
            String anno = String.valueOf(endtime.getYear());
            if (LocalDate.now().getYear() >= endtime.getYear()) {
                if (mese < 8) {
                    dalladata = FXMLDocumentController.ricerca.getDataPerStampaDalla(String.valueOf(Integer.parseInt(anno)));
                    if (dalladata.equals("")) {
                        dalladata = Integer.parseInt(anno) - 1 + "-08-01";
                    }
                } else {
                    String datas = FXMLDocumentController.ricerca.getDataPerStampaDallaPrima(anno);
                    dalladata = !datas.equals("") ? datas : anno + "-08-01";
                }
            } else {
                dalladata = String.valueOf(LocalDate.now().getYear()) + "-08-01";
            }
        } else {
            dalladata = "2017-01-01";
        }
        JFXRadioButton chk_TipoVino = (JFXRadioButton)this.groupTipoVino.getSelectedToggle();
        JFXRadioButton chk_TipoStampa = (JFXRadioButton)this.groupTipoStampa.getSelectedToggle();
        JFXRadioButton chk_TipoStampa2 = (JFXRadioButton)this.groupTipoStampa2.getSelectedToggle();
        if (!chk_TipoStampa2.getText().equals("Standard")) {
            tipoStampa2 = true;
        }
        tipoStampa = chk_TipoStampa.getText().equals("PDF") ? 1 : 2;
        if (chk_TipoVino.getText().equals("Imbottigliato")) {
            stato_fisico = "<>'1'";
        } else if (chk_TipoVino.getText().equals("Sfuso")) {
            stato_fisico = "='1'";
        }
        String annata = this.editText_annata.getText().trim();
        String prodotto = this.editText_prodotto.getText().trim();
        String cod_dop = this.editText_coddopigp.getText().trim();
        if (alladata.equals("")) {
            FXMLDocumentController.toast.startToast("(Alla Data) Campo obbligatorio", "ERRORE", "ERRORE");
            return;
        }
        boolean globale = this.chk_globale.selectedProperty().getValue();
        String strWHERE = this.selectReportInventarioC(dalladata, alladata, annata, prodotto, stato_fisico, globale);
        key.add("A_DATA");
        key.add("QUERY");
        key.add("AZIENDA");
        key.add("SOTTO_AZ");
        key.add("ICQRF");
        value.add(alladata);
        value.add(strWHERE);
        value.add(FXMLDocumentController.GLOBAL_AZIENDA);
        value.add(FXMLDocumentController.GLOBAL_SOTTOAZZ);
        value.add(FXMLDocumentController.GLOBAL_ICQRF);
        nomeFileJRXML = tipoStampa == 1 ? "inventario_idoP.jrxml" : "inventario_idoE.jrxml";
        String resp = this.jasperReport.JSONjr(nomeFileJRXML, key, value, tipoStampa, "");
        String nomeFile = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "JasperReport#@" + resp);
        FXMLDocumentController.util.downloadFileTemp(nomeFile);
    }

    private String selectReportInventarioC(String da_data, String a_data, String annata, String prodotto, String stato_fisico, boolean globale) {
        String ret = "SELECT * FROM ( SELECT a.cod_tipo_vino AS CODICE, b.descrizione AS DESCRIZIONE, b.sian_annata AS ANNATA, SUM(a.qta) AS QTA, SUM(a.litri) AS LITRI, SUM(IF(a.qta >= 0, a.confez,(-1)*a.confez)) AS PEZZI, a.num_prot_ido AS PROTOCOLLO, a.ente_cert AS ENTE, IF(a.data_ido = '0000-00-00',NULL,a.data_ido) AS DATA,  a.cod_committente AS cod_committente,\n IF(IFNULL(clifor.rag_soc,'')='',CONCAT(IFNULL(clifor.cognome,''),' ',IFNULL(clifor.nome,'')),IFNULL(clifor.rag_soc,'')) AS ragsoc_codcommittente \nFROM c_movimenti AS a LEFT JOIN gen_tipo_vino_ana AS b ON a.cod_tipo_vino = b.codice AND a.azienda = b.azienda AND a.sotto_az = b.sotto_az AND a.icqrf = b.icqrf AND a.cod_committente = b.cod_committente LEFT JOIN c_operazioni AS c ON a.id_oper = c.id  LEFT JOIN gen_ana_clifor AS clifor ON a.cod_committente=clifor.codice AND a.azienda=clifor.azienda AND a.sotto_az=clifor.sotto_az WHERE a.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND a.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND a.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "'   ";
        if (!globale) {
            ret = !FXMLDocumentController.GLOBAL_CODCOMM.equals("") ? ret + " AND a.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "' " : ret + " AND a.cod_committente='' ";
        }
        if (a_data.equals("")) {
            a_data = LocalDate.now().toString();
        }
        if (!prodotto.equals("")) {
            ret = ret + "AND a.cod_tipo_vino = '" + prodotto + "' ";
        }
        if (!stato_fisico.equals("")) {
            ret = ret + "AND b.sian_cod_stato_fisico" + stato_fisico + " ";
        }
        if (!annata.equals("")) {
            ret = ret + "AND b.sian_annata = '" + annata + "' ";
        }
        ret = ret + "AND c.data_oper <= '" + a_data + "' AND c.data_oper >= '" + da_data + "' AND b.sian_atto_certificato = '2' AND b.sian_cod_stato_fisico <> '2' GROUP BY a.azienda,a.sotto_az,a.icqrf,a.cod_committente,a.cod_tipo_vino, a.num_prot_ido, a.ente_cert, IF(a.data_ido = '0000-00-00',NULL,a.data_ido) ) AS a ";
        return ret;
    }

    public void initialize(URL url, ResourceBundle rb) {
        this.groupTipoVino = new ToggleGroup();
        this.chk_imbo.setToggleGroup(this.groupTipoVino);
        this.chk_sfuso.setToggleGroup(this.groupTipoVino);
        this.chk_tutto.setToggleGroup(this.groupTipoVino);
        this.groupTipoVino.selectToggle((Toggle)this.chk_tutto);
        this.groupTipoStampa = new ToggleGroup();
        this.chk_pdf.setToggleGroup(this.groupTipoStampa);
        this.chk_xls.setToggleGroup(this.groupTipoStampa);
        this.groupTipoStampa2 = new ToggleGroup();
        this.chk_estesa.setToggleGroup(this.groupTipoStampa2);
        this.chk_standard.setToggleGroup(this.groupTipoStampa2);
        this.groupTipoStampa2.selectToggle((Toggle)this.chk_standard);
        this.groupTipoStampa.selectToggle((Toggle)this.chk_xls);
        this.dtp_alladata.setValue((Object)LocalDate.now());
        this.dtp_dalladata.setValue((Object)LocalDate.of(2017, Month.JANUARY, 1));
        this.editText_prodotto.textProperty().addListener((observable, oldValue, newValue) -> {
            try {
                if (!newValue.equals("") && newValue.length() == 1) {
                    String prodotto = this.editText_prodotto.getText().trim();
                    FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/vin/view/SearchProdottoPool.fxml"));
                    Stage stage = new Stage();
                    stage.setMaximized(false);
                    stage.setTitle("Prodotto");
                    stage.setScene(new Scene((Parent)((Pane)loader.load())));
                    SearchProdottoPool controller = (SearchProdottoPool)loader.getController();
                    controller.setSearch((String)newValue, " ", "");
                    stage.initModality(Modality.APPLICATION_MODAL);
                    stage.setResizable(false);
                    stage.showAndWait();
                    String codice = controller.getCodice();
                    String descr = controller.getDesString();
                    String atto_cert = controller.getAttoCert();
                    String anno = controller.getAnno();
                    Double capacita = controller.getCapacita();
                    String id = controller.getID();
                    if (!codice.equals("")) {
                        this.editText_prodotto.setText(codice);
                    } else {
                        this.editText_prodotto.setText("");
                    }
                    stage.close();
                }
            }
            catch (Exception ex) {
                FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
            }
        });
    }
}

