/*
 * Decompiled with CFR 0.152.
 */
package vin.controller;

import com.jfoenix.controls.JFXRadioButton;
import com.jfoenix.controls.JFXTextField;
import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.chart.PieChart;
import javafx.scene.control.Alert;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import org.json.JSONException;
import vin.Class.WorkIndicatorDialog;
import vin.Uility.JasperReport;
import vin.controller.FXMLDocumentController;
import vin.controller.SearchProdottoPool;
import vin.controller.SearchTableCodiceDescrizioneController;
import vin.controller.StampaMovimentiController;

public class StampaDocDuplicatiController
implements Initializable {
    @FXML
    private Label label_dalladata;
    @FXML
    private Label label_alladata;
    @FXML
    private Label label_prodotto;
    @FXML
    private Label label_annata;
    @FXML
    private Label label_codoper;
    @FXML
    private Label label_coddopigp;
    @FXML
    private JFXRadioButton chk_imbo;
    @FXML
    private JFXRadioButton chk_sfuso;
    @FXML
    private JFXRadioButton chk_tutto;
    @FXML
    JFXRadioButton chk_standard;
    @FXML
    JFXRadioButton chk_estesa;
    @FXML
    JFXRadioButton chk_pdf;
    @FXML
    JFXRadioButton chk_xls;
    @FXML
    private DatePicker dtp_dalladata;
    @FXML
    private DatePicker dtp_alladata;
    @FXML
    private JFXTextField editText_prodotto;
    @FXML
    private JFXTextField editText_annata;
    @FXML
    private JFXTextField editText_codoper;
    @FXML
    private JFXTextField editText_sigla;
    @FXML
    private JFXTextField editText_serie;
    @FXML
    private JFXTextField editText_numero;
    @FXML
    private JFXTextField editText_progressivo;
    @FXML
    private HBox box_dopigp;
    @FXML
    private JFXTextField editText_coddopigp;
    @FXML
    private PieChart torta;
    JasperReport jasperReport = new JasperReport();
    ToggleGroup groupTipoVino = null;
    ToggleGroup groupTipoStampa = null;
    ToggleGroup groupTipoStampa2 = null;
    WorkIndicatorDialog wd = null;

    @FXML
    void btnClearCodDop(ActionEvent event) {
        this.editText_coddopigp.setText("");
    }

    @FXML
    void btnSearchCodDop(ActionEvent event) throws JSONException, IOException {
        FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/vin/view/SearchTableCodiceDescrizione.fxml"));
        Parent rootLayout = (Parent)loader.load();
        Scene scene = new Scene(rootLayout);
        Stage stage = new Stage();
        stage.setTitle("Codici Dop/IGP");
        stage.setScene(scene);
        SearchTableCodiceDescrizioneController controller = (SearchTableCodiceDescrizioneController)loader.getController();
        controller.setTable("sian_t_dopigp");
        stage.initModality(Modality.APPLICATION_MODAL);
        stage.setResizable(true);
        stage.showAndWait();
        String codice = controller.getCodice();
        String descr = controller.getDescrizione();
        if (!codice.equals("")) {
            this.editText_coddopigp.setText(codice);
        }
    }

    @FXML
    void btnActionGrafico(ActionEvent event) throws JSONException {
    }

    @FXML
    void btnActionStampa(ActionEvent event) throws JSONException, IOException {
        this.wd = new WorkIndicatorDialog(this.editText_annata.getScene().getWindow(), "Caricamento in corso...");
        this.wd.addTaskEndNotification(result -> {
            System.out.println(result);
            this.wd = null;
        });
        this.wd.exec("123", inputParam -> {
            try {
                this.gostampa();
            }
            catch (IOException | ParseException | JSONException ex) {
                Logger.getLogger(StampaMovimentiController.class.getName()).log(Level.SEVERE, null, ex);
            }
            return 1;
        });
    }

    private void gostampa() throws JSONException, IOException, ParseException {
        ArrayList<String> key = new ArrayList<String>();
        ArrayList<Object> value = new ArrayList<Object>();
        int tipoStampa = 0;
        boolean tipoStampa2 = false;
        String stato_fisico = "";
        String nomeFileJRXML = "";
        String alladata = "";
        LocalDate endtime = (LocalDate)this.dtp_alladata.getValue();
        if (endtime != null) {
            alladata = endtime.toString();
        }
        String dalladata = "";
        LocalDate endtime2 = (LocalDate)this.dtp_dalladata.getValue();
        if (endtime2 != null) {
            dalladata = endtime2.toString();
        }
        JFXRadioButton chk_TipoVino = (JFXRadioButton)this.groupTipoVino.getSelectedToggle();
        JFXRadioButton chk_TipoStampa = (JFXRadioButton)this.groupTipoStampa.getSelectedToggle();
        JFXRadioButton chk_TipoStampa2 = (JFXRadioButton)this.groupTipoStampa2.getSelectedToggle();
        if (!chk_TipoStampa2.getText().equals("Standard")) {
            tipoStampa2 = true;
        }
        tipoStampa = chk_TipoStampa.getText().equals("PDF") ? 1 : 2;
        if (chk_TipoVino.getText().equals("Imbottigliato")) {
            stato_fisico = "<>'1'";
        } else if (chk_TipoVino.getText().equals("Sfuso")) {
            stato_fisico = "='1'";
        }
        String annata = this.editText_annata.getText().trim();
        String prodotto = this.editText_prodotto.getText().trim();
        String cod_dop = this.editText_coddopigp.getText().trim();
        String codoper = this.editText_codoper.getText().trim();
        String sigla = this.editText_sigla.getText().trim();
        String serie = this.editText_serie.getText().trim();
        String numero = this.editText_numero.getText().trim();
        String progressivo = this.editText_progressivo.getText().trim();
        if (alladata.equals("")) {
            alladata = LocalDate.now().toString();
        }
        if (dalladata.equals("")) {
            dalladata = "2017-01-01";
        }
        String stringa = "";
        stringa = this.stampaDocDup(alladata, dalladata, sigla);
        key = new ArrayList();
        value = new ArrayList();
        key.add("QUERY");
        key.add("AZIENDA");
        key.add("SOTTO_AZ");
        key.add("ICQRF");
        key.add("COD_COMMITTENTE");
        value.add(stringa);
        value.add(FXMLDocumentController.GLOBAL_AZIENDA);
        value.add(FXMLDocumentController.GLOBAL_SOTTOAZZ);
        value.add(FXMLDocumentController.GLOBAL_ICQRF);
        value.add(FXMLDocumentController.GLOBAL_CODCOMM);
        int tipoFile = 1;
        nomeFileJRXML = "movimenti_docdup.jrxml";
        String resp = this.jasperReport.JSONjr(nomeFileJRXML, key, value, tipoFile, "");
        String nomeFile = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "JasperReport#@" + resp);
        if (!nomeFile.contains("#ERR:")) {
            FXMLDocumentController.util.downloadFileTemp(nomeFile);
        } else {
            FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", nomeFile);
        }
    }

    private String stampaDocDup(String a_data, String da_data, String sigla) {
        String stringa = "SELECT COUNT(a.id) AS conto,a.id,a.azienda,a.sotto_az,a.icqrf,a.cod_committente,a.data_oper AS data_oper,a.mx_doc_sigla AS sigla_documento,a.mx_doc_ser AS serie_documento,a.mx_doc_num AS numero_documento,a.mx_doc_clifor AS clifor_documento,v.sian_cod_oper AS cod_oper,a.tipo_oper FROM c_operazioni AS a LEFT JOIN gen_t_oper_sian AS v ON a.cod_oper=v.tipo_oper WHERE azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND (a.tipo_oper<>'C' OR ISNULL(a.tipo_oper)) AND (v.sian_cod_oper='CASD' OR v.sian_cod_oper='USSD' ) AND (a.mx_doc_sigla<>'CL' AND a.mx_doc_sigla<>'SL')";
        if (da_data.equals("")) {
            da_data = "2017-01-01";
        }
        if (a_data.equals("")) {
            a_data = LocalDate.now().toString();
        }
        stringa = stringa + " AND (a.data_oper >= '" + da_data + "' AND a.data_oper <= '" + a_data + "')   ";
        stringa = !sigla.equals("") ? stringa + "AND a.mx_doc_sigla='" + sigla + "' " : stringa + "AND a.mx_doc_sigla<>'' ";
        stringa = stringa + "GROUP BY a.mx_doc_sigla,a.mx_doc_ser,a.mx_doc_num HAVING conto>1 ORDER BY a.mx_doc_sigla,a.mx_doc_ser,a.mx_doc_num";
        return stringa;
    }

    public void initialize(URL url, ResourceBundle rb) {
        this.groupTipoVino = new ToggleGroup();
        this.chk_imbo.setToggleGroup(this.groupTipoVino);
        this.chk_sfuso.setToggleGroup(this.groupTipoVino);
        this.chk_tutto.setToggleGroup(this.groupTipoVino);
        this.groupTipoVino.selectToggle((Toggle)this.chk_tutto);
        this.groupTipoStampa = new ToggleGroup();
        this.chk_pdf.setToggleGroup(this.groupTipoStampa);
        this.chk_xls.setToggleGroup(this.groupTipoStampa);
        this.groupTipoStampa2 = new ToggleGroup();
        this.chk_estesa.setToggleGroup(this.groupTipoStampa2);
        this.chk_standard.setToggleGroup(this.groupTipoStampa2);
        this.groupTipoStampa2.selectToggle((Toggle)this.chk_standard);
        this.groupTipoStampa.selectToggle((Toggle)this.chk_xls);
        this.dtp_alladata.setValue((Object)LocalDate.now());
        this.dtp_dalladata.setValue((Object)LocalDate.now());
        this.editText_prodotto.textProperty().addListener((observable, oldValue, newValue) -> {
            try {
                if (!newValue.equals("") && newValue.length() == 1) {
                    String prodotto = this.editText_prodotto.getText().trim();
                    FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/vin/view/SearchProdottoPool.fxml"));
                    Stage stage = new Stage();
                    stage.setMaximized(false);
                    stage.setTitle("Prodotto");
                    stage.setScene(new Scene((Parent)((Pane)loader.load())));
                    SearchProdottoPool controller = (SearchProdottoPool)loader.getController();
                    controller.setSearch((String)newValue, " ", "");
                    stage.initModality(Modality.APPLICATION_MODAL);
                    stage.setResizable(false);
                    stage.showAndWait();
                    String codice = controller.getCodice();
                    String descr = controller.getDesString();
                    String atto_cert = controller.getAttoCert();
                    String anno = controller.getAnno();
                    Double capacita = controller.getCapacita();
                    String id = controller.getID();
                    if (!codice.equals("")) {
                        this.editText_prodotto.setText(codice);
                    } else {
                        this.editText_prodotto.setText("");
                    }
                    stage.close();
                }
            }
            catch (Exception ex) {
                FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
            }
        });
    }
}

