/*
 * Decompiled with CFR 0.152.
 */
package vin.controller;

import com.jfoenix.controls.JFXDatePicker;
import com.jfoenix.controls.JFXTextField;
import java.awt.Desktop;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.StackPane;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import vin.Class.ColumnTableSian;
import vin.Class.Ricerca;
import vin.Class.SendFileToSk1;
import vin.Class.WorkIndicatorDialog;
import vin.Uility.ImportFileCSV;
import vin.controller.FXMLDocumentController;
import vin.controller.SearchTableCodiceDescrizioneController;
import vin.controller.StampaConfrontaSIANREALEController;

public class StampaConfrontaWBSMEXALController
implements Initializable {
    @FXML
    private StackPane stack_;
    @FXML
    private JFXDatePicker dtp_alladata;
    @FXML
    private JFXTextField editText_categoria;
    @FXML
    private JFXTextField editText_statofisico;
    @FXML
    private JFXTextField editText_classificazione;
    @FXML
    private JFXTextField editText_coddopigp;
    @FXML
    private TextField editText_search;
    @FXML
    private TableView<ColumnTableSian> table;
    @FXML
    private TableColumn<ColumnTableSian, String> column_giacenzaWBS;
    @FXML
    private TableColumn<ColumnTableSian, String> column_giacenzaMexal;
    @FXML
    private TableColumn<ColumnTableSian, String> column_differenze;
    @FXML
    private TableColumn<ColumnTableSian, String> column_button;
    @FXML
    private TableColumn<ColumnTableSian, String> column_punti;
    @FXML
    private TableColumn<ColumnTableSian, String> column_codwbs;
    @FXML
    private TableColumn<ColumnTableSian, String> column_codmexal;
    @FXML
    private Label txt_labeldate;
    String alladata = "";
    ComboBox<String> edit;
    ComboBox<String> edit2;
    WorkIndicatorDialog wd = null;
    ObservableList<ColumnTableSian> lista_table = FXCollections.observableArrayList();
    FilteredList<ColumnTableSian> filteredData = null;

    public void initialize(URL url, ResourceBundle rb) {
        this.column_codwbs.setCellValueFactory((Callback)new PropertyValueFactory("column_codwbs"));
        this.column_codmexal.setCellValueFactory((Callback)new PropertyValueFactory("column_codsian"));
        this.column_giacenzaMexal.setCellValueFactory((Callback)new PropertyValueFactory("column_giacenzaSian"));
        this.column_differenze.setCellValueFactory((Callback)new PropertyValueFactory("column_differenze"));
        this.column_punti.setCellValueFactory((Callback)new PropertyValueFactory("column_esactly"));
        this.dtp_alladata.setValue((Object)LocalDate.now());
        this.column_giacenzaWBS.setCellValueFactory((Callback)new PropertyValueFactory("column_giacenzaWBS"));
        Callback<TableColumn<ColumnTableSian, String>, TableCell<ColumnTableSian, String>> cellFactory = new Callback<TableColumn<ColumnTableSian, String>, TableCell<ColumnTableSian, String>>(){

            public TableCell call(TableColumn<ColumnTableSian, String> param) {
                TableCell<ColumnTableSian, String> cell = new TableCell<ColumnTableSian, String>(){
                    final Button btn = new Button("");

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                            this.setText(null);
                        } else {
                            this.btn.setStyle("-fx-min-height: 24px;-fx-min-width: 24px;-fx-background-size: 24px 24px;-fx-background-repeat: no-repeat;-fx-background-position: center;-fx-background-image: url('vin/images/fix.png')");
                            this.btn.setOnAction(event -> {
                                ColumnTableSian person = (ColumnTableSian)this.getTableView().getItems().get(this.getIndex());
                                if (!person.getColumn_codwbs().equals("") && person.getColumn_codsian().equals("") || !person.getColumn_codwbs().equals("") || !person.getColumn_codsian().equals("")) {
                                    // empty if block
                                }
                            });
                            this.setGraphic((Node)this.btn);
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        };
        this.column_button.setCellFactory((Callback)cellFactory);
        this.column_codmexal.setCellFactory(column -> new TableCell<ColumnTableSian, String>(){

            protected void updateItem(String item, boolean empty) {
                super.updateItem((Object)item, empty);
                this.setText(empty ? "" : ((String)this.getItem()).toString());
                this.setGraphic(null);
                TableRow currentRow = this.getTableRow();
                if (currentRow != null && !this.isEmpty()) {
                    String rower = item.toString().replace("null", "");
                    if (rower.equals("")) {
                        rower = "0";
                    }
                    if (currentRow.getItem() != null) {
                        if (!((ColumnTableSian)currentRow.getItem()).getColumn_codsian().equals("") && !((ColumnTableSian)currentRow.getItem()).getColumn_codwbs().equals("")) {
                            currentRow.setStyle("-fx-background-color:lightgreen");
                        } else {
                            currentRow.setStyle("-fx-background-color:#DD4B39;");
                        }
                    }
                }
            }
        });
        this.filteredData = new FilteredList(this.lista_table, p -> true);
        this.editText_search.textProperty().addListener((observable, oldValue, newValue) -> this.filteredData.setPredicate(person -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lowerCaseFilter = newValue.toLowerCase();
            if (person.getColumn_codsian().toLowerCase().contains(lowerCaseFilter)) {
                return true;
            }
            if (person.getColumn_codwbs().toLowerCase().contains(lowerCaseFilter)) {
                return true;
            }
            if (person.getColumn_coddopigp().toLowerCase().contains(lowerCaseFilter)) {
                return true;
            }
            if (person.getColumn_codstatofisico().toLowerCase().contains(lowerCaseFilter)) {
                return true;
            }
            if (person.getColumn_annata().toLowerCase().contains(lowerCaseFilter)) {
                return true;
            }
            return person.getColumn_codclassificazione().toLowerCase().contains(lowerCaseFilter);
        }));
        SortedList sortedData = new SortedList(this.filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)this.table.comparatorProperty());
        this.table.setItems((ObservableList)sortedData);
    }

    private void SaveFile(File file) {
        try {
            FileOutputStream fileOut = new FileOutputStream(file);
            HSSFWorkbook workbook = new HSSFWorkbook();
            HSSFSheet worksheet = workbook.createSheet("POI Worksheet");
            HSSFCellStyle style = workbook.createCellStyle();
            style.setFillForegroundColor(HSSFColor.LIGHT_BLUE.index);
            style.setFillPattern((short)1);
            HSSFFont font = workbook.createFont();
            font.setColor(HSSFColor.WHITE.index);
            font.setBold(true);
            style.setFont((Font)font);
            HSSFRow row1 = worksheet.createRow(0);
            Cell cell = row1.createCell(0);
            cell.setCellValue("CODICE WBS");
            cell.setCellStyle((CellStyle)style);
            cell = row1.createCell(1);
            cell.setCellValue("CODICE MEXAL");
            cell.setCellStyle((CellStyle)style);
            cell = row1.createCell(2);
            cell.setCellValue("GIACENZA WBS");
            cell.setCellStyle((CellStyle)style);
            cell = row1.createCell(3);
            cell.setCellValue("GIACENZA MEXAL");
            cell.setCellStyle((CellStyle)style);
            cell = row1.createCell(4);
            int y = 1;
            for (int i = 0; i < this.lista_table.size(); ++i) {
                HSSFRow row = worksheet.createRow((int)((short)y));
                cell = row.createCell(0);
                cell.setCellValue(((ColumnTableSian)this.lista_table.get(i)).getColumn_codwbs());
                cell = row.createCell(1);
                cell.setCellValue(((ColumnTableSian)this.lista_table.get(i)).getColumn_codsian());
                cell = row.createCell(2);
                cell.setCellValue(((ColumnTableSian)this.lista_table.get(i)).getColumn_giacenzaWBS().doubleValue());
                cell = row.createCell(3);
                cell.setCellValue(((ColumnTableSian)this.lista_table.get(i)).getColumn_giacenzaSian().doubleValue());
                cell = row.createCell(4);
                ++y;
            }
            workbook.write((OutputStream)fileOut);
            fileOut.flush();
            fileOut.close();
        }
        catch (FileNotFoundException e) {
            FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", e.toString());
        }
        catch (IOException e) {
            FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", e.toString());
        }
    }

    @FXML
    void btnSearchCODDOPIGP(ActionEvent event) throws JSONException, IOException {
        FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/vin/view/SearchTableCodiceDescrizione.fxml"));
        Parent rootLayout = (Parent)loader.load();
        Scene scene = new Scene(rootLayout);
        Stage stage = new Stage();
        stage.setTitle("Codici Dop/IGP");
        stage.setScene(scene);
        SearchTableCodiceDescrizioneController controller = (SearchTableCodiceDescrizioneController)loader.getController();
        controller.setTable("sian_t_dopigp");
        stage.initModality(Modality.APPLICATION_MODAL);
        stage.setResizable(true);
        stage.showAndWait();
        String codice = controller.getCodice();
        String descr = controller.getDescrizione();
        if (!codice.equals("")) {
            this.editText_coddopigp.setText(codice);
        }
    }

    @FXML
    void btnSearchCategoria(ActionEvent event) throws IOException {
        try {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/vin/view/SearchTableCodiceDescrizione.fxml"));
            Parent rootLayout = (Parent)loader.load();
            Scene scene = new Scene(rootLayout);
            Stage stage = new Stage();
            stage.setTitle("Categoria");
            stage.setScene(scene);
            SearchTableCodiceDescrizioneController controller = (SearchTableCodiceDescrizioneController)loader.getController();
            controller.setTable("sian_t_categoria");
            stage.initModality(Modality.APPLICATION_MODAL);
            stage.setResizable(true);
            stage.showAndWait();
            String codice = controller.getCodice();
            String descr = controller.getDescrizione();
            if (!codice.equals("")) {
                this.editText_categoria.setText(codice);
            }
        }
        catch (JSONException ex) {
            Logger.getLogger(StampaConfrontaSIANREALEController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    void btnSearchClassificazione(ActionEvent event) throws IOException {
        try {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/vin/view/SearchTableCodiceDescrizione.fxml"));
            Parent rootLayout = (Parent)loader.load();
            Scene scene = new Scene(rootLayout);
            Stage stage = new Stage();
            stage.setTitle("Classificazione");
            stage.setScene(scene);
            SearchTableCodiceDescrizioneController controller = (SearchTableCodiceDescrizioneController)loader.getController();
            controller.setTable("sian_t_classificazione");
            stage.initModality(Modality.APPLICATION_MODAL);
            stage.setResizable(true);
            stage.showAndWait();
            String codice = controller.getCodice();
            String descr = controller.getDescrizione();
            if (!codice.equals("")) {
                this.editText_classificazione.setText(codice);
            }
        }
        catch (JSONException ex) {
            Logger.getLogger(StampaConfrontaSIANREALEController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    void btnSearchStatoFisico(ActionEvent event) throws IOException {
        try {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/vin/view/SearchTableCodiceDescrizione.fxml"));
            Parent rootLayout = (Parent)loader.load();
            Scene scene = new Scene(rootLayout);
            Stage stage = new Stage();
            stage.setTitle("StatoFisico");
            stage.setScene(scene);
            SearchTableCodiceDescrizioneController controller = (SearchTableCodiceDescrizioneController)loader.getController();
            controller.setTable("sian_t_stato_fisico");
            stage.initModality(Modality.APPLICATION_MODAL);
            stage.setResizable(true);
            stage.showAndWait();
            String codice = controller.getCodice();
            String descr = controller.getDescrizione();
            if (!codice.equals("")) {
                this.editText_statofisico.setText(codice);
            }
        }
        catch (JSONException ex) {
            Logger.getLogger(StampaConfrontaSIANREALEController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void btnRefreshTable(ActionEvent event) {
        try {
            this.refresh();
        }
        catch (Exception ex) {
            Logger.getLogger(StampaConfrontaWBSMEXALController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void refresh() throws JSONException, Exception {
        this.alladata = "";
        LocalDate dt = (LocalDate)this.dtp_alladata.getValue();
        if (dt != null) {
            this.alladata = dt.toString();
        }
        if (this.alladata.equals("")) {
            FXMLDocumentController.toast.startToast("(Alla Data) Campo obbligatorio", "ERRORE", "ERRORE");
            return;
        }
        this.wd = new WorkIndicatorDialog(this.editText_search.getScene().getWindow(), "Caricamento in corso...");
        this.wd.addTaskEndNotification(result -> {
            System.out.println(result);
            if (this.wd.labelWord.contains("#ERR")) {
                FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "ERRORE", this.wd.labelWord);
            }
            this.wd = null;
            this.table.refresh();
        });
        this.wd.exec("123", inputParam -> {
            try {
                this.doWork(this.alladata);
            }
            catch (Exception ex) {
                System.out.println(ex.toString());
            }
            return 1;
        });
    }

    private void doWork(String alladata) throws Exception {
        String stringadapassare;
        String data_select;
        String rT;
        String categoria = this.editText_categoria.getText().trim();
        String classificazione = this.editText_classificazione.getText().trim();
        String cod_dopigp = this.editText_coddopigp.getText().trim();
        String stato_fisico = this.editText_statofisico.getText().trim();
        String cod_comm = "";
        Ricerca ric = new Ricerca();
        cod_comm = ric.getCodiceSianAnagraficaCliente(FXMLDocumentController.GLOBAL_CODCOMM);
        if (cod_comm.equals("")) {
            cod_comm = FXMLDocumentController.GLOBAL_CODCOMM;
        }
        String dadata = "";
        LocalDate endtime2 = LocalDate.parse(FXMLDocumentController.ricerca.getDallaDataInizioAnno());
        if (endtime2 != null) {
            dadata = endtime2.toString().equals("2017-01-01") ? endtime2.toString() : endtime2.plusDays(1L).toString();
        }
        if (!(rT = (data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, stringadapassare = "WebServiceconfrontaWBSMEXAL#@" + FXMLDocumentController.GLOBAL_AZIENDA + "#@" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "#@" + FXMLDocumentController.GLOBAL_ICQRF + "#@" + FXMLDocumentController.GLOBAL_CODCOMM + "#@" + alladata + "#@" + stato_fisico + "#@" + cod_dopigp + "#@" + classificazione + "#@" + categoria + "#@" + cod_comm + "#@" + dadata))).contains("#ERR:")) {
            this.lista_table.clear();
            this.table.refresh();
            JSONArray arrayJson = FXMLDocumentController.jsonUtil.strJsonToJSONArray(rT);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    JSONObject rec = arrayJson.getJSONObject(i);
                    this.lista_table.add((Object)new ColumnTableSian(rec.getString("codice_grouper_mx"), rec.getString("codice"), "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", Double.parseDouble(rec.get("qta_mx").toString()), Double.parseDouble(rec.get("litri").toString()), rec.get("differenze").toString(), "", ""));
                    continue;
                }
                catch (Exception ex) {
                    FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                    return;
                }
            }
        } else {
            this.wd.labelWord = rT.contains("java.net.SocketTimeoutException: Read timed out") ? "#ERR:Errore di comunicazione con il SIAN" : "#ERR:" + rT;
        }
    }

    @FXML
    void btnDownloadExcell(ActionEvent event) {
        FileChooser fileChooser = new FileChooser();
        FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("excel files (*.xls)", new String[]{"*.xls"});
        fileChooser.getExtensionFilters().add((Object)extFilter);
        File file = fileChooser.showSaveDialog((Window)this.table.getContextMenu());
        this.wd = new WorkIndicatorDialog(this.editText_search.getScene().getWindow(), "Caricamento in corso...");
        this.wd.addTaskEndNotification(result -> {
            if (this.wd.labelWord.contains("#ERR")) {
                FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "ERRORE", this.wd.labelWord);
            } else if (Desktop.isDesktopSupported()) {
                try {
                    Desktop.getDesktop().open(file);
                }
                catch (IOException ex) {
                    Logger.getLogger(StampaConfrontaWBSMEXALController.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            this.wd = null;
            this.table.refresh();
        });
        this.wd.exec("123", inputParam -> {
            try {
                if (file != null) {
                    this.SaveFile(file);
                }
            }
            catch (Exception ex) {
                System.out.println(ex.toString());
            }
            return 1;
        });
    }

    @FXML
    private void btnImportInvMexal(ActionEvent event) {
        try {
            boolean rel;
            ImportFileCSV csv = new ImportFileCSV();
            csv.getFile();
            File file = csv.open();
            SendFileToSk1 sk1sendfile = new SendFileToSk1();
            String alladata = "";
            if (file != null && (rel = sk1sendfile.sendFile("IMPORT_FILEMEXAL_INVART", file, FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT + 1))) {
                Thread.sleep(500L);
                alladata = this.getAllaData();
                String sds = "Alla Data: " + alladata;
                this.txt_labeldate.setText(sds);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(StampaConfrontaSIANREALEController.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(StampaConfrontaWBSMEXALController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public String getAllaData() {
        String ret = "";
        try {
            ArrayList<String> tipo = new ArrayList<String>();
            ArrayList<String> strSQL = new ArrayList<String>();
            ArrayList<Boolean> last_ID = new ArrayList<Boolean>();
            tipo.add("select");
            String alladata = "";
            strSQL.add("SELECT alladata FROM tmp_importinvmx LIMIT 1 ");
            last_ID.add(false);
            String str = FXMLDocumentController.util.makeStringJsonDB("OFF", tipo, strSQL, null, null, last_ID, null);
            String data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + str);
            if (!data_select.contains("#ERR:")) {
                JSONArray arrayJson = FXMLDocumentController.jsonUtil.strJsonToJSONArray(data_select);
                for (int i = 0; i < arrayJson.length(); ++i) {
                    try {
                        JSONObject rec = arrayJson.getJSONObject(i);
                        ret = rec.get("alladata").toString();
                        continue;
                    }
                    catch (JSONException ex) {
                        FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                    }
                }
            }
        }
        catch (JSONException ex) {
            FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
        }
        return ret;
    }
}

