/*
 * Decompiled with CFR 0.152.
 */
package vin.controller;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import vin.Class.CodiceDescrizione;
import vin.Class.ObservableCodiceDescrizione;
import vin.Class.PDF;
import vin.Comunicator.Sk1SrvCommunicator;
import vin.Uility.JsonUtils;
import vin.Uility.Utility;
import vin.controller.FXMLDocumentController;
import vin.controller.ToastFXMessages;

public class StampaCartaceaRegistroVinificazioneController
implements Initializable {
    @FXML
    private DatePicker dtp_dataDa;
    @FXML
    private DatePicker dtp_dataA;
    PDF pdf;
    @FXML
    private ComboBox<ObservableCodiceDescrizione> cmbx_vino;
    @FXML
    private ComboBox<ObservableCodiceDescrizione> cmbx_annata;
    @FXML
    private ComboBox<ObservableCodiceDescrizione> cmbx_registro;
    @FXML
    private ComboBox<CodiceDescrizione> cmbx_magazzino;
    Sk1SrvCommunicator sk1Comm = new Sk1SrvCommunicator();
    JsonUtils jsonUtil = new JsonUtils();
    ToastFXMessages toast = new ToastFXMessages();
    ObservableList<ObservableCodiceDescrizione> lista_vini;
    ObservableList<ObservableCodiceDescrizione> lista_registri;
    ObservableList<ObservableCodiceDescrizione> lista_annate;
    ObservableList<CodiceDescrizione> lista_magazzini;
    Utility util;
    String codice = "02";
    String descrizione = "";
    String data_select = "";
    List<String> strSQL = new ArrayList<String>();
    List<String> tipo = new ArrayList<String>();
    List<Boolean> last_ID = new ArrayList<Boolean>();
    String str = "";
    @FXML
    Button btnstampa;

    public void initialize(URL url, ResourceBundle rb) {
        try {
            JSONObject rec;
            int i;
            JSONArray arrayJson;
            this.pdf = new PDF();
            this.util = new Utility();
            this.lista_vini = FXCollections.observableArrayList();
            this.lista_registri = FXCollections.observableArrayList();
            this.lista_magazzini = FXCollections.observableArrayList();
            this.lista_annate = FXCollections.observableArrayList();
            this.strSQL = new ArrayList<String>();
            this.tipo = new ArrayList<String>();
            this.last_ID = new ArrayList<Boolean>();
            this.tipo.add("select");
            this.strSQL.add("SELECT codice,descrizione FROM v_anag_vini");
            this.last_ID.add(false);
            this.str = this.util.makeStringJsonDB("OFF", this.tipo, this.strSQL, null, null, this.last_ID, null);
            this.data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + this.str);
            if (!this.data_select.contains("#ERR:")) {
                this.lista_vini.clear();
                this.lista_vini.add(null);
                arrayJson = this.jsonUtil.strJsonToJSONArray(this.data_select);
                for (i = 0; i < arrayJson.length(); ++i) {
                    rec = arrayJson.getJSONObject(i);
                    this.lista_vini.add((Object)new ObservableCodiceDescrizione(rec.getString("codice"), rec.getString("descrizione")));
                }
            }
            this.cmbx_vino.setItems(this.lista_vini);
            this.strSQL = new ArrayList<String>();
            this.tipo = new ArrayList<String>();
            this.last_ID = new ArrayList<Boolean>();
            this.tipo.add("select");
            this.strSQL.add("SELECT id AS codice,anno AS descrizione FROM v_anag_annate");
            this.last_ID.add(false);
            this.str = this.util.makeStringJsonDB("OFF", this.tipo, this.strSQL, null, null, this.last_ID, null);
            this.data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + this.str);
            if (!this.data_select.contains("#ERR:")) {
                this.lista_annate.clear();
                this.lista_annate.add(null);
                arrayJson = this.jsonUtil.strJsonToJSONArray(this.data_select);
                for (i = 0; i < arrayJson.length(); ++i) {
                    rec = arrayJson.getJSONObject(i);
                    this.lista_annate.add((Object)new ObservableCodiceDescrizione(String.valueOf(rec.getInt("codice")), rec.getString("descrizione")));
                }
            }
            this.cmbx_annata.setItems(this.lista_annate);
            this.strSQL = new ArrayList<String>();
            this.tipo = new ArrayList<String>();
            this.last_ID = new ArrayList<Boolean>();
            this.tipo.add("select");
            this.strSQL.add("SELECT codice,descrizione FROM v_anag_registri");
            this.last_ID.add(false);
            this.str = this.util.makeStringJsonDB("OFF", this.tipo, this.strSQL, null, null, this.last_ID, null);
            this.data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + this.str);
            if (!this.data_select.contains("#ERR:")) {
                this.lista_registri.clear();
                this.lista_registri.add(null);
                arrayJson = this.jsonUtil.strJsonToJSONArray(this.data_select);
                for (i = 0; i < arrayJson.length(); ++i) {
                    rec = arrayJson.getJSONObject(i);
                    this.lista_registri.add((Object)new ObservableCodiceDescrizione(rec.getString("codice"), rec.getString("descrizione")));
                }
            }
            this.cmbx_registro.setItems(this.lista_registri);
            this.strSQL = new ArrayList<String>();
            this.tipo = new ArrayList<String>();
            this.last_ID = new ArrayList<Boolean>();
            this.data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "mxSelectMag#@" + FXMLDocumentController.GLOBAL_AZIENDA + "#@" + FXMLDocumentController.GLOBAL_SOTTOAZZ);
            if (!this.data_select.contains("#ERR:")) {
                this.lista_magazzini.add(null);
                arrayJson = this.jsonUtil.strJsonToJSONArray(this.data_select);
                for (i = 0; i < arrayJson.length(); ++i) {
                    rec = arrayJson.getJSONObject(i);
                    this.lista_magazzini.add((Object)new CodiceDescrizione(Utility.padLeftZeros(String.valueOf(rec.getInt("codice")), 3), rec.getString("descrizione")));
                }
            }
            this.cmbx_magazzino.setItems(this.lista_magazzini);
            this.cmbx_vino.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<ObservableCodiceDescrizione>(){

                public void changed(ObservableValue<? extends ObservableCodiceDescrizione> arg0, ObservableCodiceDescrizione arg1, ObservableCodiceDescrizione arg2) {
                    if (arg2 != null) {
                        StampaCartaceaRegistroVinificazioneController.this.codice = arg2.getCodice();
                        StampaCartaceaRegistroVinificazioneController.this.descrizione = arg2.getDescrizione();
                    } else {
                        StampaCartaceaRegistroVinificazioneController.this.codice = "";
                        StampaCartaceaRegistroVinificazioneController.this.descrizione = "";
                    }
                }
            });
            this.cmbx_annata.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<ObservableCodiceDescrizione>(){

                public void changed(ObservableValue<? extends ObservableCodiceDescrizione> arg0, ObservableCodiceDescrizione arg1, ObservableCodiceDescrizione arg2) {
                    if (arg2 != null) {
                        StampaCartaceaRegistroVinificazioneController.this.codice = arg2.getCodice();
                        StampaCartaceaRegistroVinificazioneController.this.descrizione = arg2.getDescrizione();
                    } else {
                        StampaCartaceaRegistroVinificazioneController.this.codice = "";
                        StampaCartaceaRegistroVinificazioneController.this.descrizione = "";
                    }
                }
            });
            this.cmbx_registro.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<ObservableCodiceDescrizione>(){

                public void changed(ObservableValue<? extends ObservableCodiceDescrizione> arg0, ObservableCodiceDescrizione arg1, ObservableCodiceDescrizione arg2) {
                    if (arg2 != null) {
                        StampaCartaceaRegistroVinificazioneController.this.codice = arg2.getCodice();
                        StampaCartaceaRegistroVinificazioneController.this.descrizione = arg2.getDescrizione();
                    } else {
                        StampaCartaceaRegistroVinificazioneController.this.codice = "";
                        StampaCartaceaRegistroVinificazioneController.this.descrizione = "";
                    }
                }
            });
            this.cmbx_magazzino.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<CodiceDescrizione>(){

                public void changed(ObservableValue<? extends CodiceDescrizione> arg0, CodiceDescrizione arg1, CodiceDescrizione arg2) {
                    if (arg2 != null) {
                        StampaCartaceaRegistroVinificazioneController.this.codice = arg2.getCodice();
                        StampaCartaceaRegistroVinificazioneController.this.descrizione = arg2.getDescrizione();
                    } else {
                        StampaCartaceaRegistroVinificazioneController.this.codice = "";
                        StampaCartaceaRegistroVinificazioneController.this.descrizione = "";
                    }
                }
            });
        }
        catch (IOException | JSONException ex) {
            this.util.alertWindow(Alert.AlertType.NONE, "ERRORE", "", ex.toString());
        }
    }

    @FXML
    private void btnStampa() throws JSONException {
        int count = 0;
        ArrayList<String> campi_vuoti = new ArrayList<String>();
        String daData = String.valueOf(this.dtp_dataDa.getValue());
        String aData = String.valueOf(this.dtp_dataA.getValue());
        ObservableCodiceDescrizione vino = (ObservableCodiceDescrizione)this.cmbx_vino.getSelectionModel().getSelectedItem();
        CodiceDescrizione magazzino = (CodiceDescrizione)this.cmbx_magazzino.getSelectionModel().getSelectedItem();
        ObservableCodiceDescrizione annata = (ObservableCodiceDescrizione)this.cmbx_annata.getSelectionModel().getSelectedItem();
        ObservableCodiceDescrizione registro = (ObservableCodiceDescrizione)this.cmbx_registro.getSelectionModel().getSelectedItem();
        if (daData.equals("") || this.dtp_dataDa.getValue() == null) {
            campi_vuoti.add("(da Data) Campo Obbligatorio");
            ++count;
        }
        if (aData.equals("") || this.dtp_dataA.getValue() == null) {
            campi_vuoti.add("(a Data) Campo Obbligatorio");
            ++count;
        }
        if (registro == null) {
            campi_vuoti.add("(Registro) Campo Obbligatorio");
            ++count;
        }
        if (magazzino == null) {
            campi_vuoti.add("(Magazzino) Campo Obbligatorio");
            ++count;
        }
        if (count > 0) {
            StringBuilder builder = new StringBuilder();
            for (String s : campi_vuoti) {
                if (s == null) continue;
                builder.append(s + "\r\n");
            }
            this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE:", "VALIDAZIONE", builder.toString());
        } else {
            this.strSQL = new ArrayList<String>();
            this.tipo = new ArrayList<String>();
            this.last_ID = new ArrayList<Boolean>();
            this.tipo.add("select");
            this.strSQL.add("SELECT ");
            this.last_ID.add(false);
            this.str = this.util.makeStringJsonDB("OFF", this.tipo, this.strSQL, null, null, this.last_ID, null);
            this.data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + this.str);
            if (!this.data_select.contains("#ERR:")) {
                this.lista_registri.clear();
                this.lista_registri.add(null);
                JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(this.data_select);
                for (int i = 0; i < arrayJson.length(); ++i) {
                    JSONObject jSONObject = arrayJson.getJSONObject(i);
                }
            }
        }
    }
}

