/*
 * Decompiled with CFR 0.152.
 */
package vin.controller;

import com.jfoenix.controls.JFXRadioButton;
import com.jfoenix.controls.JFXTextField;
import java.io.IOException;
import java.net.URL;
import java.time.LocalDate;
import java.time.Month;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.chart.BarChart;
import javafx.scene.chart.PieChart;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Alert;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import vin.Class.Combobox_SIAN_Categoria;
import vin.Class.WorkIndicatorDialog;
import vin.Uility.JasperReport;
import vin.controller.FXMLDocumentController;
import vin.controller.SearchProdottoPool;
import vin.controller.SearchTableCodiceDescrizioneController;

public class StampaCaricoProdottiController
implements Initializable {
    @FXML
    private Label label_dalladata;
    @FXML
    private Label label_alladata;
    @FXML
    private Label label_prodotto;
    @FXML
    private Label label_annata;
    @FXML
    private Label label_codoper;
    @FXML
    private Label label_coddopigp;
    @FXML
    private ComboBox<Combobox_SIAN_Categoria> cmbx_categoria;
    @FXML
    private JFXRadioButton chk_imbo;
    @FXML
    private JFXRadioButton chk_sfuso;
    @FXML
    private JFXRadioButton chk_tutto;
    @FXML
    JFXRadioButton chk_standard;
    @FXML
    JFXRadioButton chk_estesa;
    @FXML
    JFXRadioButton chk_pdf;
    @FXML
    JFXRadioButton chk_xls;
    @FXML
    private DatePicker dtp_dalladata;
    @FXML
    private DatePicker dtp_alladata;
    @FXML
    private JFXTextField editText_prodotto;
    @FXML
    private JFXTextField editText_annata;
    @FXML
    private JFXTextField editText_codoper;
    @FXML
    private HBox box_dopigp;
    @FXML
    private JFXTextField editText_coddopigp;
    @FXML
    private PieChart torta;
    @FXML
    private BarChart bar_chart;
    JasperReport jasperReport = new JasperReport();
    ToggleGroup groupTipoVino = null;
    ToggleGroup groupTipoStampa = null;
    ToggleGroup groupTipoStampa2 = null;
    WorkIndicatorDialog wd = null;
    String annata = "";
    String prodotto = "";
    String cod_dop = "";
    String codoper = "";
    int tipoStampa = 0;
    int tipoStampa2 = 0;
    String categoria_cod = "";
    String stato_fisico = "";
    String nomeFileJRXML = "";
    String alladata = "";
    String dalladata = "";
    ObservableList<Combobox_SIAN_Categoria> lista_sian_categoria = FXCollections.observableArrayList();

    @FXML
    void btnClearCodDop(ActionEvent event) {
        this.editText_coddopigp.setText("");
    }

    @FXML
    void btnSearchCodDop(ActionEvent event) throws JSONException, IOException {
        FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/vin/view/SearchTableCodiceDescrizione.fxml"));
        Parent rootLayout = (Parent)loader.load();
        Scene scene = new Scene(rootLayout);
        Stage stage = new Stage();
        stage.setTitle("Codici Dop/IGP");
        stage.setScene(scene);
        SearchTableCodiceDescrizioneController controller = (SearchTableCodiceDescrizioneController)loader.getController();
        controller.setTable("sian_t_dopigp");
        stage.initModality(Modality.APPLICATION_MODAL);
        stage.setResizable(true);
        stage.showAndWait();
        String codice = controller.getCodice();
        String descr = controller.getDescrizione();
        if (!codice.equals("")) {
            this.editText_coddopigp.setText(codice);
        }
    }

    @FXML
    void btnActionGrafico(ActionEvent event) throws JSONException {
        ArrayList key = new ArrayList();
        ArrayList value = new ArrayList();
        int tipoStampa = 0;
        int tipoStampa2 = 0;
        String stato_fisico = "";
        String nomeFileJRXML = "";
        String alladata = "";
        LocalDate endtime = (LocalDate)this.dtp_alladata.getValue();
        if (endtime != null) {
            alladata = endtime.toString();
        }
        String dalladata = "";
        LocalDate endtime2 = (LocalDate)this.dtp_dalladata.getValue();
        if (endtime2 != null) {
            dalladata = endtime2.toString();
        }
        JFXRadioButton chk_TipoVino = (JFXRadioButton)this.groupTipoVino.getSelectedToggle();
        JFXRadioButton chk_TipoStampa = (JFXRadioButton)this.groupTipoStampa.getSelectedToggle();
        JFXRadioButton chk_TipoStampa2 = (JFXRadioButton)this.groupTipoStampa2.getSelectedToggle();
        if (!chk_TipoStampa2.getText().equals("Standard")) {
            tipoStampa2 = 1;
        }
        tipoStampa = chk_TipoStampa.getText().equals("PDF") ? 1 : 2;
        if (chk_TipoVino.getText().equals("Imbottigliato")) {
            stato_fisico = "<>'1'";
        } else if (chk_TipoVino.getText().equals("Sfuso")) {
            stato_fisico = "='1'";
        }
        String annata = this.editText_annata.getText().trim();
        String prodotto = this.editText_prodotto.getText().trim();
        String cod_dop = this.editText_coddopigp.getText().trim();
        String codoper = this.editText_codoper.getText().trim();
        Combobox_SIAN_Categoria categoria = (Combobox_SIAN_Categoria)this.cmbx_categoria.getSelectionModel().getSelectedItem();
        String categoria_cod = "";
        if (categoria != null) {
            categoria_cod = categoria.getCodice();
        }
        if (alladata.equals("")) {
            FXMLDocumentController.toast.startToast("(Alla Data) Campo obbligatorio", "ERRORE", "ERRORE");
            return;
        }
        if (dalladata.equals("")) {
            FXMLDocumentController.toast.startToast("(Dalla Data) Campo obbligatorio", "ERRORE", "ERRORE");
            return;
        }
        String where = "";
        if (!stato_fisico.equals("")) {
            where = " AND sian_cod_stato_fisico" + stato_fisico + " ";
        }
        String strWHERE = this.selectReportCASDProdotti(prodotto, tipoStampa2, dalladata, alladata, categoria_cod);
        XYChart.Series series1 = new XYChart.Series();
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList lenghtBidimensionalArray = new ArrayList();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String str = "";
        String data_select = "";
        lastID.add(false);
        tipoSQL.add("select");
        strSQL.add(strWHERE);
        str = FXMLDocumentController.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
        data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + str);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = FXMLDocumentController.jsonUtil.strJsonToJSONArray(data_select);
            this.bar_chart.getData().clear();
            ObservableList pieChartData = FXCollections.observableArrayList();
            double tot = 0.0;
            for (int i = 0; i < arrayJson.length(); ++i) {
                JSONObject rec = arrayJson.getJSONObject(i);
                String prod = rec.get("codice").toString();
                Double pr = rec.getDouble("qta");
                series1.getData().add((Object)new XYChart.Data((Object)prod, (Object)pr));
                pieChartData.add((Object)new PieChart.Data(prod, pr.doubleValue()));
                tot = pr + tot;
            }
            series1.setName(tot + "");
            this.bar_chart.getData().setAll(new Object[]{series1});
            this.torta.getData().setAll((Collection)pieChartData);
        } else {
            FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", data_select);
        }
    }

    @FXML
    void btnActionStampa(ActionEvent event) throws JSONException, IOException {
        LocalDate endtime2;
        LocalDate endtime = (LocalDate)this.dtp_alladata.getValue();
        if (endtime != null) {
            this.alladata = endtime.toString();
        }
        if ((endtime2 = (LocalDate)this.dtp_dalladata.getValue()) != null) {
            this.dalladata = endtime2.toString();
        }
        JFXRadioButton chk_TipoVino = (JFXRadioButton)this.groupTipoVino.getSelectedToggle();
        JFXRadioButton chk_TipoStampa = (JFXRadioButton)this.groupTipoStampa.getSelectedToggle();
        JFXRadioButton chk_TipoStampa2 = (JFXRadioButton)this.groupTipoStampa2.getSelectedToggle();
        if (!chk_TipoStampa2.getText().equals("Standard")) {
            this.tipoStampa2 = 1;
        }
        this.tipoStampa = chk_TipoStampa.getText().equals("PDF") ? 1 : 2;
        if (chk_TipoVino.getText().equals("Imbottigliato")) {
            this.stato_fisico = "<>'1'";
        } else if (chk_TipoVino.getText().equals("Sfuso")) {
            this.stato_fisico = "='1'";
        }
        this.annata = this.editText_annata.getText().trim();
        this.prodotto = this.editText_prodotto.getText().trim();
        this.cod_dop = this.editText_coddopigp.getText().trim();
        this.codoper = this.editText_codoper.getText().trim();
        Combobox_SIAN_Categoria categoria = (Combobox_SIAN_Categoria)this.cmbx_categoria.getSelectionModel().getSelectedItem();
        this.categoria_cod = "";
        if (categoria != null) {
            this.categoria_cod = categoria.getCodice();
        }
        if (this.alladata.equals("")) {
            FXMLDocumentController.toast.startToast("(Alla Data) Campo obbligatorio", "ERRORE", "ERRORE");
        }
        if (this.dalladata.equals("")) {
            FXMLDocumentController.toast.startToast("(Dalla Data) Campo obbligatorio", "ERRORE", "ERRORE");
        }
        String where = "";
        if (!this.stato_fisico.equals("")) {
            where = " AND sian_cod_stato_fisico" + this.stato_fisico + " ";
        }
        this.wd = new WorkIndicatorDialog(this.editText_annata.getScene().getWindow(), "Caricamento in corso...");
        this.wd.addTaskEndNotification(result -> {
            System.out.println(result);
            this.wd = null;
        });
        this.wd.exec("123", inputParam -> {
            try {
                ArrayList<String> key = new ArrayList<String>();
                ArrayList<Object> value = new ArrayList<Object>();
                String strWHERE = this.selectReportCASDProdotti(this.prodotto, this.tipoStampa2, this.dalladata, this.alladata, this.categoria_cod);
                key.add("QUERY");
                key.add("DA_DATA");
                key.add("A_DATA");
                key.add("AZIENDA");
                key.add("SOTTO_AZ");
                key.add("ICQRF");
                key.add("COD_COMMITTENTE");
                value.add(strWHERE);
                value.add(this.dalladata);
                value.add(this.alladata);
                value.add(FXMLDocumentController.GLOBAL_AZIENDA);
                value.add(FXMLDocumentController.GLOBAL_SOTTOAZZ);
                value.add(FXMLDocumentController.GLOBAL_ICQRF);
                value.add(FXMLDocumentController.GLOBAL_CODCOMM);
                this.nomeFileJRXML = this.tipoStampa == 1 ? "casd_prodottiP.jrxml" : "casd_prodottiE.jrxml";
                String resp = this.jasperReport.JSONjr(this.nomeFileJRXML, key, value, this.tipoStampa, "");
                String nomeFile = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "JasperReport#@" + resp);
                FXMLDocumentController.util.downloadFileTemp(nomeFile);
            }
            catch (IOException | JSONException ex) {
                System.out.println(ex.toString());
            }
            return new Integer(1);
        });
    }

    private String selectReportCASDProdotti(String prodotto, int tipoStampa, String dalladata, String a_data, String categoria) {
        String ret = "SELECT * FROM ( SELECT a.cod_tipo_vino AS CODICE, b.descrizione AS DESCRIZIONE, SUM(a.qta) AS QTA, SUM(a.litri) AS LITRI, SUM(IF(a.qta >= 0, a.confez,(-1)*a.confez)) AS PEZZI FROM c_movimenti AS a LEFT JOIN gen_tipo_vino_ana AS b ON a.cod_tipo_vino = b.codice AND a.azienda = b.azienda AND a.sotto_az = b.sotto_az AND a.icqrf = b.icqrf AND a.cod_committente = b.cod_committente LEFT JOIN c_operazioni AS c ON a.id_oper = c.id LEFT JOIN gen_t_oper_sian AS k ON c.cod_oper=k.tipo_oper WHERE a.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND a.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND a.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "'   AND a.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "' ";
        if (a_data.equals("")) {
            a_data = LocalDate.now().toString();
        }
        if (dalladata.equals("")) {
            dalladata = LocalDate.now().toString();
        }
        if (!prodotto.equals("")) {
            ret = ret + "AND a.cod_tipo_vino = '" + prodotto + "' ";
        }
        if (!categoria.equals("")) {
            ret = ret + "AND b.sian_cat_prodotto = '" + categoria + "' ";
        }
        ret = ret + "AND c.data_oper <= '" + a_data + "' AND c.data_oper >= '" + dalladata + "' ";
        ret = ret + "AND (k.sian_cod_oper='CASD' OR k.sian_cod_oper LIKE   CASE WHEN b.sian_cat_prodotto = '18' THEN      'PIGI'    ELSE     'CASD'   END  OR k.sian_cod_oper LIKE   CASE WHEN b.sian_cat_prodotto = '16' OR b.sian_cat_prodotto='17' THEN      'PIGI'    ELSE     'CASD'   END OR k.sian_cod_oper LIKE   CASE WHEN b.sian_cat_prodotto = '16' OR b.sian_cat_prodotto='17' THEN      'SVIN'    ELSE     'CASD'   END OR k.sian_cod_oper LIKE   CASE WHEN b.sian_cat_prodotto = '15'  THEN      'PIGI'    ELSE     'CASD'   END OR k.sian_cod_oper LIKE   CASE WHEN b.sian_cat_prodotto = '15' THEN      'SVIN'    ELSE     'CASD'   END OR k.sian_cod_oper LIKE   CASE WHEN b.sian_cat_prodotto = '15' THEN      'SFEC'    ELSE     'CASD'   END )  ";
        ret = ret + "GROUP BY a.cod_tipo_vino ";
        ret = ret + ") AS a ";
        return ret;
    }

    public void initialize(URL url, ResourceBundle rb) {
        try {
            this.groupTipoVino = new ToggleGroup();
            this.chk_imbo.setToggleGroup(this.groupTipoVino);
            this.chk_sfuso.setToggleGroup(this.groupTipoVino);
            this.chk_tutto.setToggleGroup(this.groupTipoVino);
            this.groupTipoVino.selectToggle((Toggle)this.chk_tutto);
            this.groupTipoStampa = new ToggleGroup();
            this.chk_pdf.setToggleGroup(this.groupTipoStampa);
            this.chk_xls.setToggleGroup(this.groupTipoStampa);
            this.groupTipoStampa2 = new ToggleGroup();
            this.chk_estesa.setToggleGroup(this.groupTipoStampa2);
            this.chk_standard.setToggleGroup(this.groupTipoStampa2);
            this.groupTipoStampa2.selectToggle((Toggle)this.chk_standard);
            this.groupTipoStampa.selectToggle((Toggle)this.chk_xls);
            this.dtp_alladata.setValue((Object)LocalDate.now());
            this.dtp_dalladata.setValue((Object)LocalDate.of(2017, Month.JANUARY, 1));
            this.editText_prodotto.textProperty().addListener((observable, oldValue, newValue) -> {
                try {
                    if (!newValue.equals("") && newValue.length() == 1) {
                        String prodotto = this.editText_prodotto.getText().trim();
                        FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/vin/view/SearchProdottoPool.fxml"));
                        Stage stage = new Stage();
                        stage.setMaximized(false);
                        stage.setTitle("Prodotto");
                        stage.setScene(new Scene((Parent)((Pane)loader.load())));
                        SearchProdottoPool controller = (SearchProdottoPool)loader.getController();
                        controller.setSearch((String)newValue, " ", "");
                        stage.initModality(Modality.APPLICATION_MODAL);
                        stage.setResizable(false);
                        stage.showAndWait();
                        String codice = controller.getCodice();
                        String descr = controller.getDesString();
                        String atto_cert = controller.getAttoCert();
                        String anno = controller.getAnno();
                        Double capacita = controller.getCapacita();
                        String id = controller.getID();
                        if (!codice.equals("")) {
                            this.editText_prodotto.setText(codice);
                        } else {
                            this.editText_prodotto.setText("");
                        }
                        stage.close();
                    }
                }
                catch (Exception ex) {
                    FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                }
            });
            this.caricaComboBoxCategoria();
            this.cmbx_categoria.setItems(this.lista_sian_categoria);
        }
        catch (JSONException ex) {
            Logger.getLogger(StampaCaricoProdottiController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void caricaComboBoxCategoria() throws JSONException {
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        lastID.add(false);
        strSQL.add("SELECT * FROM sian_t_categoria");
        tipoSQL.add("select");
        String strJson = FXMLDocumentController.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
        String data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = FXMLDocumentController.jsonUtil.strJsonToJSONArray(data_select);
            this.lista_sian_categoria.add((Object)new Combobox_SIAN_Categoria("", "", ""));
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    JSONObject rec = arrayJson.getJSONObject(i);
                    this.lista_sian_categoria.add((Object)new Combobox_SIAN_Categoria(rec.getString("codice"), rec.getString("descrizione"), rec.getString("unita_di_misura")));
                    continue;
                }
                catch (JSONException ex) {
                    FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                }
            }
        } else {
            FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", data_select);
        }
    }
}

