/*
 * Decompiled with CFR 0.152.
 */
package vin.controller;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Alert;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import vin.Class.ColumnTableGridVasiVinariInvio;
import vin.Class.EditingCellBoolean;
import vin.Class.WorkIndicatorDialog;
import vin.controller.AnagGeneraSoggettiT;
import vin.controller.FXMLDocumentController;
import vin.controller.StampaMovimentiController;

public class SearchVasoController
implements Initializable {
    ObservableList<ColumnTableGridVasiVinariInvio> lista_tablegridvaso = null;
    String data_select = "";
    @FXML
    TableView<ColumnTableGridVasiVinariInvio> table_vaso;
    @FXML
    TableColumn<ColumnTableGridVasiVinariInvio, Integer> column_id;
    @FXML
    TableColumn<ColumnTableGridVasiVinariInvio, Boolean> column_invio;
    @FXML
    TableColumn<ColumnTableGridVasiVinariInvio, String> column_codicevaso;
    @FXML
    TableColumn<ColumnTableGridVasiVinariInvio, String> column_tipovaso;
    @FXML
    TableColumn<ColumnTableGridVasiVinariInvio, String> column_descrizione;
    @FXML
    TableColumn<ColumnTableGridVasiVinariInvio, Double> column_capacita;
    @FXML
    TextField editText_searcharticolo;
    FilteredList<ColumnTableGridVasiVinariInvio> filteredData = null;
    WorkIndicatorDialog wd = null;

    public void initialize(URL url, ResourceBundle rb) {
        try {
            this.lista_tablegridvaso = FXCollections.observableArrayList();
            this.column_invio.setCellValueFactory((Callback)new PropertyValueFactory("column_invio"));
            this.column_id.setCellValueFactory((Callback)new PropertyValueFactory("column_id"));
            this.column_codicevaso.setCellValueFactory((Callback)new PropertyValueFactory("column_codicevaso"));
            this.column_tipovaso.setCellValueFactory((Callback)new PropertyValueFactory("column_tipovaso"));
            this.column_descrizione.setCellValueFactory((Callback)new PropertyValueFactory("column_descrizione"));
            this.column_capacita.setCellValueFactory((Callback)new PropertyValueFactory("column_capacita"));
            Callback<TableColumn<ColumnTableGridVasiVinariInvio, Boolean>, TableCell<ColumnTableGridVasiVinariInvio, Boolean>> invioflag = new Callback<TableColumn<ColumnTableGridVasiVinariInvio, Boolean>, TableCell<ColumnTableGridVasiVinariInvio, Boolean>>(){

                public TableCell call(TableColumn p) {
                    return new EditingCellBoolean();
                }
            };
            this.column_invio.setCellFactory((Callback)invioflag);
            this.column_invio.setOnEditCommit(t -> ((ColumnTableGridVasiVinariInvio)t.getTableView().getItems().get(t.getTablePosition().getRow())).setColumn_invio((Boolean)t.getNewValue()));
            this.filteredData = new FilteredList(this.lista_tablegridvaso, p -> true);
            this.editText_searcharticolo.textProperty().addListener((observable, oldValue, newValue) -> this.filteredData.setPredicate(person -> {
                if (newValue == null || newValue.isEmpty()) {
                    return true;
                }
                String lowerCaseFilter = newValue.toLowerCase();
                if (person.getColumn_codicevaso().toLowerCase().contains(lowerCaseFilter)) {
                    return true;
                }
                return person.getColumn_descrizione().toLowerCase().contains(lowerCaseFilter);
            }));
            SortedList sortedData = new SortedList(this.filteredData);
            sortedData.comparatorProperty().bind((ObservableValue)this.table_vaso.comparatorProperty());
            this.table_vaso.setItems((ObservableList)sortedData);
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        SearchVasoController.this.refreshLista();
                    }
                    catch (JSONException ex) {
                        Logger.getLogger(AnagGeneraSoggettiT.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            });
        }
        catch (Exception ex) {
            FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
        }
    }

    public List<ColumnTableGridVasiVinariInvio> getLista() {
        ArrayList<ColumnTableGridVasiVinariInvio> res = new ArrayList<ColumnTableGridVasiVinariInvio>();
        for (int i = 0; i < this.lista_tablegridvaso.size(); ++i) {
            if (!((ColumnTableGridVasiVinariInvio)this.lista_tablegridvaso.get(i)).getColumn_invio().booleanValue()) continue;
            res.add((ColumnTableGridVasiVinariInvio)this.lista_tablegridvaso.get(i));
        }
        return res;
    }

    @FXML
    void btnSeleziona(ActionEvent event) {
        Stage stage = (Stage)this.table_vaso.getScene().getWindow();
        stage.close();
    }

    private void refreshLista() throws JSONException {
        this.wd = new WorkIndicatorDialog(this.table_vaso.getScene().getWindow(), "Caricamento in corso...");
        this.wd.addTaskEndNotification(result -> {
            this.wd = null;
        });
        this.wd.exec("123", inputParam -> {
            try {
                ArrayList<String> tipo = new ArrayList<String>();
                ArrayList<String> strSQL = new ArrayList<String>();
                ArrayList<Boolean> last_ID = new ArrayList<Boolean>();
                tipo.add("select");
                strSQL.add("SELECT id,codice_vaso,descr_vaso,tipo_vaso,capacita FROM gen_vasi_vinari_ana WHERE azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' ");
                last_ID.add(false);
                String str = FXMLDocumentController.util.makeStringJsonDB("OFF", tipo, strSQL, null, null, last_ID, null);
                this.data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + str);
                if (!this.data_select.contains("#ERR:")) {
                    this.lista_tablegridvaso.clear();
                    JSONArray arrayJson = FXMLDocumentController.jsonUtil.strJsonToJSONArray(this.data_select);
                    for (int i = 0; i < arrayJson.length(); ++i) {
                        try {
                            JSONObject rec = arrayJson.getJSONObject(i);
                            int id = rec.getInt("id");
                            String tipov = rec.getString("tipo_vaso");
                            String descr_vaso = rec.getString("descr_vaso");
                            String codice_vaso = rec.getString("codice_vaso");
                            Double capacita = Double.parseDouble(rec.get("capacita").toString());
                            this.lista_tablegridvaso.add((Object)new ColumnTableGridVasiVinariInvio(false, id, codice_vaso, tipov, descr_vaso, capacita));
                            continue;
                        }
                        catch (JSONException ex) {
                            FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                        }
                    }
                }
            }
            catch (Exception ex) {
                Logger.getLogger(StampaMovimentiController.class.getName()).log(Level.SEVERE, null, ex);
            }
            return 1;
        });
    }
}

