/*
 * Decompiled with CFR 0.152.
 */
package vin.controller;

import com.jfoenix.controls.JFXButton;
import java.net.URL;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Alert;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import vin.Class.ColumnTableSearchVascheGiacenza;
import vin.Class.EditingCellBoolean;
import vin.Class.Ricerca;
import vin.Class.WorkIndicatorDialog;
import vin.controller.FXMLDocumentController;

public class SearchVasca_2
implements Initializable {
    String data_select = "";
    String strCodice = "";
    String codvaso = "";
    ObservableList<ColumnTableSearchVascheGiacenza> lista = null;
    FilteredList<ColumnTableSearchVascheGiacenza> filteredData = null;
    List<ColumnTableSearchVascheGiacenza> listas = new ArrayList<ColumnTableSearchVascheGiacenza>();
    @FXML
    private JFXButton btn_deselezionatutto;
    @FXML
    private JFXButton btn_selezionatutto;
    @FXML
    private JFXButton btn_ok;
    @FXML
    private JFXButton btn_search;
    @FXML
    public TextField editText_search;
    @FXML
    TableView<ColumnTableSearchVascheGiacenza> table;
    @FXML
    TableColumn<ColumnTableSearchVascheGiacenza, Boolean> column_check;
    @FXML
    TableColumn<ColumnTableSearchVascheGiacenza, String> column_codice_vaso;
    @FXML
    TableColumn<ColumnTableSearchVascheGiacenza, String> column_descr_vaso;
    @FXML
    TableColumn<ColumnTableSearchVascheGiacenza, Double> column_capacita;
    @FXML
    TableColumn<ColumnTableSearchVascheGiacenza, Double> column_esi;
    @FXML
    TableColumn<ColumnTableSearchVascheGiacenza, Integer> column_id;
    WorkIndicatorDialog wd = null;
    @FXML
    private StackPane stack;

    public List<ColumnTableSearchVascheGiacenza> getListas() {
        return this.listas;
    }

    public void setListas(List<ColumnTableSearchVascheGiacenza> listas) {
        this.listas = listas;
    }

    @FXML
    void btnSearch(ActionEvent event) {
    }

    public void initialize(URL url, ResourceBundle rb) {
        try {
            this.lista = FXCollections.observableArrayList();
            this.column_check.setCellValueFactory((Callback)new PropertyValueFactory("column_checked"));
            this.column_codice_vaso.setCellValueFactory((Callback)new PropertyValueFactory("column_codice_vaso"));
            this.column_descr_vaso.setCellValueFactory((Callback)new PropertyValueFactory("column_descr_vaso"));
            this.column_capacita.setCellValueFactory((Callback)new PropertyValueFactory("column_capacita"));
            this.column_esi.setCellValueFactory((Callback)new PropertyValueFactory("column_esi"));
            this.column_id.setCellValueFactory((Callback)new PropertyValueFactory("column_id"));
            Callback<TableColumn<ColumnTableSearchVascheGiacenza, Boolean>, TableCell<ColumnTableSearchVascheGiacenza, Boolean>> invioflag = new Callback<TableColumn<ColumnTableSearchVascheGiacenza, Boolean>, TableCell<ColumnTableSearchVascheGiacenza, Boolean>>(){

                public TableCell call(TableColumn p) {
                    return new EditingCellBoolean();
                }
            };
            this.column_check.setCellFactory((Callback)invioflag);
            this.column_check.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<ColumnTableSearchVascheGiacenza, Boolean>>(){

                public void handle(TableColumn.CellEditEvent<ColumnTableSearchVascheGiacenza, Boolean> t) {
                    ((ColumnTableSearchVascheGiacenza)t.getTableView().getItems().get(t.getTablePosition().getRow())).setColumn_checked((Boolean)t.getNewValue());
                }
            });
            this.filteredData = new FilteredList(this.lista, p -> true);
            this.editText_search.textProperty().addListener((observable, oldValue, newValue) -> this.filteredData.setPredicate(person -> {
                if (newValue == null || newValue.isEmpty()) {
                    return true;
                }
                String lowerCaseFilter = newValue.toLowerCase();
                if (person.getColumn_codice_vaso().toLowerCase().contains(lowerCaseFilter)) {
                    return true;
                }
                return person.getColumn_descr_vaso().toLowerCase().contains(lowerCaseFilter);
            }));
            SortedList sortedData = new SortedList(this.filteredData);
            sortedData.comparatorProperty().bind((ObservableValue)this.table.comparatorProperty());
            this.table.setItems((ObservableList)sortedData);
            this.table.setRowFactory(tv -> {
                TableRow row = new TableRow();
                row.setOnMouseClicked(event -> {
                    if (event.getClickCount() == 2 && !row.isEmpty()) {
                        ColumnTableSearchVascheGiacenza rowData = (ColumnTableSearchVascheGiacenza)row.getItem();
                        if (!rowData.getChecked().booleanValue()) {
                            rowData.setChecked(Boolean.TRUE);
                        } else {
                            rowData.setChecked(Boolean.FALSE);
                        }
                        this.table.refresh();
                    }
                });
                return row;
            });
        }
        catch (Exception ex) {
            FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
        }
    }

    @FXML
    void btnDeselezionatutto(ActionEvent event) {
        for (int i = 0; i < this.lista.size(); ++i) {
            ((ColumnTableSearchVascheGiacenza)this.lista.get(i)).setChecked(Boolean.FALSE);
        }
        this.table.refresh();
    }

    @FXML
    void btnOk(ActionEvent event) {
        this.listas = new ArrayList<ColumnTableSearchVascheGiacenza>();
        for (int i = 0; i < this.lista.size(); ++i) {
            if (!((ColumnTableSearchVascheGiacenza)this.lista.get(i)).getChecked().booleanValue()) continue;
            ColumnTableSearchVascheGiacenza f = (ColumnTableSearchVascheGiacenza)this.lista.get(i);
            this.listas.add(f);
        }
        Stage stage = (Stage)this.table.getScene().getWindow();
        stage.close();
    }

    @FXML
    void btnSelezionaTutto(ActionEvent event) {
        for (int i = 0; i < this.lista.size(); ++i) {
            ((ColumnTableSearchVascheGiacenza)this.lista.get(i)).setChecked(Boolean.TRUE);
        }
        this.table.refresh();
    }

    public void setSearchCaricoScarico(String where) throws JSONException {
        this.searcher(where);
    }

    private void searcher(String where) throws JSONException {
        String alladata;
        JSONArray ret;
        String dalladata = "";
        LocalDate endtime2 = LocalDate.parse(FXMLDocumentController.ricerca.getDallaDataInizioAnno());
        if (endtime2 != null) {
            dalladata = endtime2.toString().equals("2017-01-01") ? endtime2.toString() : endtime2.plusDays(1L).toString();
        }
        if ((ret = new Ricerca().giacenzaVasiOperazione(where, dalladata, alladata = LocalDate.now().toString())) != null) {
            this.lista.clear();
            JSONArray arrayJson = ret;
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    JSONObject rec = arrayJson.getJSONObject(i);
                    this.lista.add((Object)new ColumnTableSearchVascheGiacenza(false, "", rec.getInt("id"), rec.getString("codice_vaso"), rec.getString("descr_vaso"), rec.getDouble("residuo"), rec.getDouble("giacenza"), 0.0, rec.getDouble("capacita")));
                    continue;
                }
                catch (JSONException ex) {
                    FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                    return;
                }
            }
        } else {
            FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", "ERRORE");
        }
    }

    public void setSearch(String where, String where_key) throws JSONException {
        JSONArray ret = new Ricerca().giacenzaVasi(where, where_key, true);
        if (ret != null) {
            this.lista.clear();
            JSONArray arrayJson = ret;
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    JSONObject rec = arrayJson.getJSONObject(i);
                    this.lista.add((Object)new ColumnTableSearchVascheGiacenza(false, "", rec.getInt("id"), rec.getString("codice_vaso"), rec.getString("descr_vaso"), rec.getDouble("residuo"), rec.getDouble("giacenza"), 0.0, rec.getDouble("capacita")));
                    continue;
                }
                catch (JSONException ex) {
                    FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                    return;
                }
            }
        } else {
            FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", "ERRORE");
        }
    }

    public void setCodice(String codice) {
        this.strCodice = codice;
    }

    public void setCodVaso(String codVaso) {
        this.codvaso = codVaso;
    }
}

