/*
 * Decompiled with CFR 0.152.
 */
package vin.controller;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Alert;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.MouseEvent;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import vin.Class.ColumnTableLottoGiacenza;
import vin.Comunicator.Sk1SrvCommunicator;
import vin.Uility.JsonUtils;
import vin.Uility.Utility;
import vin.controller.FXMLDocumentController;
import vin.controller.ToastFXMessages;

public class SearchVascaDeriLotto
implements Initializable {
    Sk1SrvCommunicator sk1Comm = new Sk1SrvCommunicator();
    JsonUtils jsonUtil = new JsonUtils();
    ToastFXMessages toast = new ToastFXMessages();
    Utility util;
    String data_select = "";
    String strCodice = "";
    String codice = "";
    String descrizione = "";
    String lotto = "";
    Double qta = 0.0;
    int id = 0;
    String codvaso = "";
    ObservableList<ColumnTableLottoGiacenza> lista = null;
    @FXML
    TableView<ColumnTableLottoGiacenza> table;
    @FXML
    TableColumn<ColumnTableLottoGiacenza, String> column_codice;
    @FXML
    TableColumn<ColumnTableLottoGiacenza, String> column_descr;
    @FXML
    TableColumn<ColumnTableLottoGiacenza, String> column_lotto;
    @FXML
    TableColumn<ColumnTableLottoGiacenza, Double> column_qta;

    public void initialize(URL url, ResourceBundle rb) {
        try {
            this.util = new Utility();
            this.lista = FXCollections.observableArrayList();
            this.column_codice.setCellValueFactory((Callback)new PropertyValueFactory("column_codice_mx"));
            this.column_descr.setCellValueFactory((Callback)new PropertyValueFactory("column_descrizione"));
            this.column_lotto.setCellValueFactory((Callback)new PropertyValueFactory("column_codice"));
            this.column_qta.setCellValueFactory((Callback)new PropertyValueFactory("column_qta"));
            this.table.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent e) {
                    if (e.isPrimaryButtonDown() && e.getClickCount() == 2) {
                        ColumnTableLottoGiacenza f = (ColumnTableLottoGiacenza)SearchVascaDeriLotto.this.table.getSelectionModel().getSelectedItem();
                        SearchVascaDeriLotto.this.codice = f.getColumn_codice_mx();
                        SearchVascaDeriLotto.this.descrizione = f.getColumn_descrizione();
                        SearchVascaDeriLotto.this.lotto = f.getColumn_codice();
                        SearchVascaDeriLotto.this.qta = f.getColumn_qta();
                        Stage stage = (Stage)SearchVascaDeriLotto.this.table.getScene().getWindow();
                        stage.close();
                    }
                }
            });
        }
        catch (IOException ex) {
            Logger.getLogger("").log(Level.SEVERE, null, ex);
        }
    }

    public void setSearchLotto(String prodotto) throws JSONException {
        try {
            JSONArray arrayJson = null;
            ArrayList<String> tipoSQL = new ArrayList<String>();
            ArrayList<String> strSQL = new ArrayList<String>();
            ArrayList lenghtBidimensionalArray = new ArrayList();
            ArrayList<Boolean> lastID = new ArrayList<Boolean>();
            String str = "";
            String data_select = "";
            lastID.add(false);
            tipoSQL.add("select");
            strSQL.add("SELECT b.codice,b.descrizione FROM gen_tipo_vino_ana AS a LEFT JOIN gen_tipo_vino_ana_mx AS b ON a.id=b.id_tipo_vino_ana WHERE a.codice LIKE '%" + prodotto + "%' AND a.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND a.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND a.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND a.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "'");
            str = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
            data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + str);
            if (!data_select.contains("#ERR:")) {
                arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
                this.lista.clear();
                for (int i = 0; i < arrayJson.length(); ++i) {
                    try {
                        JSONObject rec = arrayJson.getJSONObject(i);
                        String codice = rec.getString("codice").replace("null", "").trim();
                        String descrizione = rec.getString("descrizione").trim();
                        if (codice.equals("")) continue;
                        this.lista.add((Object)new ColumnTableLottoGiacenza(rec.getString("codice").replace("null", ""), rec.getString("descrizione").replace("null", ""), "", 0.0));
                        continue;
                    }
                    catch (JSONException ex) {
                        this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                    }
                }
            } else {
                this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", data_select);
                return;
            }
            this.table.setItems(this.lista);
        }
        catch (Exception ex) {
            Logger.getLogger("").log(Level.SEVERE, null, ex);
        }
    }

    public void setCodice(String codice) {
        this.strCodice = codice;
    }

    public String getCodice() {
        return this.codice;
    }

    public String getDescrizione() {
        return this.descrizione;
    }

    public Double getQta() {
        return this.qta;
    }

    public String getLotto() {
        return this.lotto;
    }

    public int getID() {
        return this.id;
    }

    public void setCodVaso(String codVaso) {
        this.codvaso = codVaso;
    }
}

