/*
 * Decompiled with CFR 0.152.
 */
package vin.controller;

import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Alert;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.MouseEvent;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import vin.Class.ColumnTableSearchVascheGiacenza;
import vin.Class.Ricerca;
import vin.Comunicator.Sk1SrvCommunicator;
import vin.Uility.JsonUtils;
import vin.Uility.Utility;
import vin.controller.FXMLDocumentController;
import vin.controller.ToastFXMessages;

public class SearchVascaDeri
implements Initializable {
    Sk1SrvCommunicator sk1Comm = new Sk1SrvCommunicator();
    JsonUtils jsonUtil = new JsonUtils();
    ToastFXMessages toast = new ToastFXMessages();
    Utility util;
    String data_select = "";
    String strCodice = "";
    String codice = "";
    String descrizione = "";
    Double capacita = 0.0;
    Double residuo = 0.0;
    Double giacenza = 0.0;
    int id = 0;
    String codvaso = "";
    ObservableList<ColumnTableSearchVascheGiacenza> lista = null;
    @FXML
    TableView<ColumnTableSearchVascheGiacenza> table;
    @FXML
    TableColumn<ColumnTableSearchVascheGiacenza, String> column_codice_vaso;
    @FXML
    TableColumn<ColumnTableSearchVascheGiacenza, String> column_descr_vaso;
    @FXML
    TableColumn<ColumnTableSearchVascheGiacenza, Double> column_capacita;
    @FXML
    TableColumn<ColumnTableSearchVascheGiacenza, Double> column_esi;
    @FXML
    TableColumn<ColumnTableSearchVascheGiacenza, Integer> column_id;

    public void initialize(URL url, ResourceBundle rb) {
        try {
            this.util = new Utility();
            this.lista = FXCollections.observableArrayList();
            this.column_codice_vaso.setCellValueFactory((Callback)new PropertyValueFactory("column_codice_vaso"));
            this.column_descr_vaso.setCellValueFactory((Callback)new PropertyValueFactory("column_descr_vaso"));
            this.column_capacita.setCellValueFactory((Callback)new PropertyValueFactory("column_capacita"));
            this.column_esi.setCellValueFactory((Callback)new PropertyValueFactory("column_esi"));
            this.column_id.setCellValueFactory((Callback)new PropertyValueFactory("column_id"));
            this.table.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent e) {
                    if (e.isPrimaryButtonDown() && e.getClickCount() == 2) {
                        ColumnTableSearchVascheGiacenza f = (ColumnTableSearchVascheGiacenza)SearchVascaDeri.this.table.getSelectionModel().getSelectedItem();
                        SearchVascaDeri.this.codice = f.getColumn_codice_vaso();
                        SearchVascaDeri.this.descrizione = f.getColumn_descr_vaso();
                        SearchVascaDeri.this.capacita = f.getColumn_capacita();
                        SearchVascaDeri.this.residuo = f.getColumn_residuo();
                        SearchVascaDeri.this.giacenza = f.getColumn_esi();
                        SearchVascaDeri.this.id = f.getColumn_id();
                        Stage stage = (Stage)SearchVascaDeri.this.table.getScene().getWindow();
                        stage.close();
                    }
                }
            });
        }
        catch (IOException ex) {
            Logger.getLogger("").log(Level.SEVERE, null, ex);
        }
    }

    public void setSearch(String where, String where_key) throws JSONException {
        JSONArray ret = new Ricerca().giacenzaVasi(where, where_key, true);
        if (ret != null) {
            this.lista.clear();
            JSONArray arrayJson = ret;
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    JSONObject rec = arrayJson.getJSONObject(i);
                    this.lista.add((Object)new ColumnTableSearchVascheGiacenza(false, "", rec.getInt("id"), rec.getString("codice_vaso"), rec.getString("descr_vaso"), rec.getDouble("residuo"), rec.getDouble("giacenza"), 0.0, rec.getDouble("capacita")));
                    continue;
                }
                catch (JSONException ex) {
                    this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                    return;
                }
            }
        } else {
            this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", this.data_select);
            return;
        }
        this.table.setItems(this.lista);
    }

    public void setSearchLotto(String codiceDescrArticolo, String where, boolean cod_art_mx) throws JSONException {
        String ret = FXMLDocumentController.ricerca.giacenzaLottiArticoloMexal(codiceDescrArticolo, where, cod_art_mx);
        if (ret != null) {
            this.lista.clear();
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(ret);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    JSONObject rec = arrayJson.getJSONObject(i);
                    this.lista.add((Object)new ColumnTableSearchVascheGiacenza(false, "", rec.getInt("id"), rec.getString("codice_vaso"), rec.getString("descr_vaso"), rec.getDouble("capacita"), rec.getDouble("giacenza"), 0.0, rec.getDouble("capacita")));
                    continue;
                }
                catch (JSONException ex) {
                    this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                    return;
                }
            }
        } else {
            this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", this.data_select);
            return;
        }
        this.table.setItems(this.lista);
    }

    public void setCodice(String codice) {
        this.strCodice = codice;
    }

    public String getCodice() {
        return this.codice;
    }

    public String getDescrizione() {
        return this.descrizione;
    }

    public Double getGiacenza() {
        return this.giacenza;
    }

    public Double getResiduo() {
        return this.residuo;
    }

    public Double getCapacita() {
        return this.capacita;
    }

    public int getID() {
        return this.id;
    }

    public void setCodVaso(String codVaso) {
        this.codvaso = codVaso;
    }
}

