/*
 * Decompiled with CFR 0.152.
 */
package vin.controller;

import java.net.URL;
import java.time.LocalDate;
import java.util.ResourceBundle;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Alert;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.MouseEvent;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import vin.Class.ColumnTableSearchVascheGiacenza;
import vin.Class.Ricerca;
import vin.controller.FXMLDocumentController;

public class SearchVasca
implements Initializable {
    String data_select = "";
    String strCodice = "";
    String codice = "";
    String descrizione = "";
    Double capacita = 0.0;
    Double residuo = 0.0;
    Double giacenza = 0.0;
    int id = 0;
    String codvaso = "";
    ObservableList<ColumnTableSearchVascheGiacenza> lista = null;
    FilteredList<ColumnTableSearchVascheGiacenza> filteredData = null;
    @FXML
    public TextField editText_search;
    @FXML
    TableView<ColumnTableSearchVascheGiacenza> table;
    @FXML
    TableColumn<ColumnTableSearchVascheGiacenza, String> column_codice_vaso;
    @FXML
    TableColumn<ColumnTableSearchVascheGiacenza, String> column_descr_vaso;
    @FXML
    TableColumn<ColumnTableSearchVascheGiacenza, Double> column_capacita;
    @FXML
    TableColumn<ColumnTableSearchVascheGiacenza, Double> column_esi;
    @FXML
    TableColumn<ColumnTableSearchVascheGiacenza, Integer> column_id;

    public void initialize(URL url, ResourceBundle rb) {
        try {
            this.lista = FXCollections.observableArrayList();
            this.column_codice_vaso.setCellValueFactory((Callback)new PropertyValueFactory("column_codice_vaso"));
            this.column_descr_vaso.setCellValueFactory((Callback)new PropertyValueFactory("column_descr_vaso"));
            this.column_capacita.setCellValueFactory((Callback)new PropertyValueFactory("column_capacita"));
            this.column_esi.setCellValueFactory((Callback)new PropertyValueFactory("column_esi"));
            this.column_id.setCellValueFactory((Callback)new PropertyValueFactory("column_id"));
            this.table.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent e) {
                    if (e.isPrimaryButtonDown() && e.getClickCount() == 2) {
                        ColumnTableSearchVascheGiacenza f = (ColumnTableSearchVascheGiacenza)SearchVasca.this.table.getSelectionModel().getSelectedItem();
                        SearchVasca.this.codice = f.getColumn_codice_vaso();
                        SearchVasca.this.descrizione = f.getColumn_descr_vaso();
                        SearchVasca.this.capacita = f.getColumn_capacita();
                        SearchVasca.this.residuo = f.getColumn_residuo();
                        SearchVasca.this.giacenza = f.getColumn_esi();
                        SearchVasca.this.id = f.getColumn_id();
                        Stage stage = (Stage)SearchVasca.this.table.getScene().getWindow();
                        stage.close();
                    }
                }
            });
            this.filteredData = new FilteredList(this.lista, p -> true);
            this.editText_search.textProperty().addListener((observable, oldValue, newValue) -> this.filteredData.setPredicate(person -> {
                if (newValue == null || newValue.isEmpty()) {
                    return true;
                }
                String lowerCaseFilter = newValue.toLowerCase();
                if (person.getColumn_codice_vaso().toLowerCase().contains(lowerCaseFilter)) {
                    return true;
                }
                return person.getColumn_descr_vaso().toLowerCase().contains(lowerCaseFilter);
            }));
            SortedList sortedData = new SortedList(this.filteredData);
            sortedData.comparatorProperty().bind((ObservableValue)this.table.comparatorProperty());
            this.table.setItems((ObservableList)sortedData);
        }
        catch (Exception ex) {
            FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
        }
    }

    public void setSearchCaricoScarico(String where) throws JSONException {
        String alladata;
        JSONArray ret;
        String dalladata = "";
        LocalDate endtime2 = LocalDate.parse(FXMLDocumentController.ricerca.getDallaDataInizioAnno());
        if (endtime2 != null) {
            dalladata = endtime2.toString().equals("2017-01-01") ? endtime2.toString() : endtime2.plusDays(1L).toString();
        }
        if ((ret = new Ricerca().giacenzaVasiOperazione(where, dalladata, alladata = LocalDate.now().toString())) != null) {
            this.lista.clear();
            JSONArray arrayJson = ret;
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    JSONObject rec = arrayJson.getJSONObject(i);
                    this.lista.add((Object)new ColumnTableSearchVascheGiacenza(false, "", rec.getInt("id"), rec.getString("codice_vaso"), rec.getString("descr_vaso"), rec.getDouble("residuo"), rec.getDouble("giacenza"), 0.0, rec.getDouble("capacita")));
                    continue;
                }
                catch (JSONException ex) {
                    FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                    return;
                }
            }
        } else {
            FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", "ERRORE");
        }
    }

    public void setSearch(String where, String where_key) throws JSONException {
        JSONArray ret = new Ricerca().giacenzaVasi(where, where_key, true);
        if (ret != null) {
            this.lista.clear();
            JSONArray arrayJson = ret;
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    JSONObject rec = arrayJson.getJSONObject(i);
                    this.lista.add((Object)new ColumnTableSearchVascheGiacenza(false, "", rec.getInt("id"), rec.getString("codice_vaso"), rec.getString("descr_vaso"), rec.getDouble("residuo"), rec.getDouble("giacenza"), 0.0, rec.getDouble("capacita")));
                    continue;
                }
                catch (JSONException ex) {
                    FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                    return;
                }
            }
        } else {
            FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", "ERRORE");
        }
    }

    public void setCodice(String codice) {
        this.strCodice = codice;
    }

    public String getCodice() {
        return this.codice;
    }

    public String getDescrizione() {
        return this.descrizione;
    }

    public Double getGiacenza() {
        return this.giacenza;
    }

    public Double getCapacita() {
        return this.capacita;
    }

    public Double getResiduo() {
        return this.residuo;
    }

    public int getID() {
        return this.id;
    }

    public void setCodVaso(String codVaso) {
        this.codvaso = codVaso;
    }
}

