/*
 * Decompiled with CFR 0.152.
 */
package vin.controller;

import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Alert;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.MouseEvent;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import vin.Class.ColumnTableSearchTipoVino;
import vin.Class.Ricerca;
import vin.Comunicator.Sk1SrvCommunicator;
import vin.Uility.JsonUtils;
import vin.Uility.Utility;
import vin.controller.ToastFXMessages;

public class SearchTipoVinoController
implements Initializable {
    String anno = "";
    String flag = "";
    String magazzino = "";
    Sk1SrvCommunicator sk1Comm = new Sk1SrvCommunicator();
    JsonUtils jsonUtil = new JsonUtils();
    ToastFXMessages toast = new ToastFXMessages();
    Utility util;
    String data_select = "";
    ObservableList<ColumnTableSearchTipoVino> lista = null;
    @FXML
    TableView<ColumnTableSearchTipoVino> table_art;
    @FXML
    TableColumn<ColumnTableSearchTipoVino, String> column_descrizione;
    @FXML
    TableColumn<ColumnTableSearchTipoVino, String> column_codice;
    @FXML
    TextField editText_searcharticolo;
    String strCodice = "";
    String strDescrizione = "";
    String strID = "";
    String cod_stato_fisico = "";
    String atto_cert = "";
    String strAnnata = "";
    Double capacita = 0.0;
    String where = "";
    String wherelitri = "";

    public void initialize(URL url, ResourceBundle rb) {
        try {
            this.util = new Utility();
            this.lista = FXCollections.observableArrayList();
            this.column_descrizione.setCellValueFactory((Callback)new PropertyValueFactory("column_descrizione"));
            this.column_codice.setCellValueFactory((Callback)new PropertyValueFactory("column_codice"));
            this.table_art.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent e) {
                    if (e.isPrimaryButtonDown() && e.getClickCount() == 2) {
                        ColumnTableSearchTipoVino f = (ColumnTableSearchTipoVino)SearchTipoVinoController.this.table_art.getSelectionModel().getSelectedItem();
                        SearchTipoVinoController.this.strCodice = f.getColumn_codice();
                        SearchTipoVinoController.this.strID = "" + f.getColumn_id();
                        SearchTipoVinoController.this.strAnnata = f.getAnno();
                        SearchTipoVinoController.this.strDescrizione = f.getColumn_descrizione();
                        SearchTipoVinoController.this.atto_cert = f.getAtto_cert();
                        SearchTipoVinoController.this.cod_stato_fisico = f.getColumn_stato_fisico();
                        SearchTipoVinoController.this.capacita = f.getCapacita();
                        Stage stage = (Stage)SearchTipoVinoController.this.table_art.getScene().getWindow();
                        stage.close();
                    }
                }
            });
            this.editText_searcharticolo.textProperty().addListener((observable, oldValue, newValue) -> {
                block6: {
                    String codart = this.editText_searcharticolo.getText().trim();
                    if (!codart.equals("")) {
                        try {
                            JSONArray ret = new Ricerca().giacenzaVino((String)newValue, this.where, this.wherelitri, false);
                            if (ret != null) {
                                JSONArray arrayJson = ret;
                                this.lista.clear();
                                for (int i = 0; i < arrayJson.length(); ++i) {
                                    JSONObject rec = arrayJson.getJSONObject(i);
                                    this.lista.add((Object)new ColumnTableSearchTipoVino(0, rec.getString("descrizione"), rec.getString("codice"), "", rec.getString("sian_cod_stato_fisico"), rec.getString("sian_atto_certificato"), rec.getString("sian_annata"), rec.getDouble("sian_volume_nominale"), 0.0));
                                }
                                this.table_art.setItems(this.lista);
                                break block6;
                            }
                            this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", this.data_select);
                        }
                        catch (JSONException ex) {
                            this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", this.data_select);
                        }
                    } else {
                        this.lista.clear();
                        this.table_art.setItems(this.lista);
                    }
                }
            });
        }
        catch (IOException ex) {
            this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
        }
    }

    public String getCodice() {
        return this.strCodice;
    }

    public Double getCapacita() {
        return this.capacita;
    }

    public String getAnno() {
        return this.strAnnata;
    }

    public String getDesString() {
        return this.strDescrizione;
    }

    public String getAttoCert() {
        return this.atto_cert;
    }

    public String getStatoFisico() {
        return this.cod_stato_fisico;
    }

    public String getID() {
        return this.strID;
    }

    public void setSearch(String codiceProdotto, String where, String wherelitri) {
        this.where = where;
        this.wherelitri = wherelitri;
        this.editText_searcharticolo.setText(codiceProdotto);
        this.editText_searcharticolo.requestFocus();
        this.editText_searcharticolo.positionCaret(codiceProdotto.length());
    }
}

