/*
 * Decompiled with CFR 0.152.
 */
package vin.controller;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Alert;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.MouseEvent;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import vin.Class.ColumnTableTipoVinoAna;
import vin.Comunicator.Sk1SrvCommunicator;
import vin.Uility.JsonUtils;
import vin.Uility.Utility;
import vin.controller.FXMLDocumentController;
import vin.controller.ToastFXMessages;

public class SearchTipoVinoAnagraficaController
implements Initializable {
    String anno = "";
    String flag = "";
    String magazzino = "";
    Sk1SrvCommunicator sk1Comm = new Sk1SrvCommunicator();
    JsonUtils jsonUtil = new JsonUtils();
    ToastFXMessages toast = new ToastFXMessages();
    Utility util;
    String data_select = "";
    ObservableList<ColumnTableTipoVinoAna> lista = null;
    String codice = "";
    @FXML
    TableView<ColumnTableTipoVinoAna> table_art;
    @FXML
    TableColumn<ColumnTableTipoVinoAna, String> column_descrizione;
    @FXML
    TableColumn<ColumnTableTipoVinoAna, String> column_codice;
    @FXML
    TextField editText_searcharticolo;
    String strCodice = "";
    String strDescrizione = "";
    String strID = "";
    String cod_stato_fisico = "";
    String atto_cert = "";
    String strAnnata = "";
    Double capacita = 0.0;
    @FXML
    private CheckBox chk_precancellati;
    int precancellati = 0;

    public void initialize(URL url, ResourceBundle rb) {
        try {
            this.util = new Utility();
            this.lista = FXCollections.observableArrayList();
            this.column_descrizione.setCellValueFactory((Callback)new PropertyValueFactory("column_descrizione"));
            this.column_codice.setCellValueFactory((Callback)new PropertyValueFactory("column_codice"));
            this.chk_precancellati.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                    SearchTipoVinoAnagraficaController.this.precancellati = newValue != false ? 1 : 0;
                    try {
                        String codart = SearchTipoVinoAnagraficaController.this.editText_searcharticolo.getText().trim();
                        SearchTipoVinoAnagraficaController.this.search(codart);
                    }
                    catch (JSONException ex) {
                        SearchTipoVinoAnagraficaController.this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", SearchTipoVinoAnagraficaController.this.data_select);
                    }
                }
            });
            this.table_art.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent e) {
                    if (e.isPrimaryButtonDown() && e.getClickCount() == 2) {
                        ColumnTableTipoVinoAna f = (ColumnTableTipoVinoAna)SearchTipoVinoAnagraficaController.this.table_art.getSelectionModel().getSelectedItem();
                        if (f != null) {
                            SearchTipoVinoAnagraficaController.this.strCodice = f.getColumn_codice();
                            SearchTipoVinoAnagraficaController.this.strID = "" + f.getColumn_id();
                            SearchTipoVinoAnagraficaController.this.strDescrizione = f.getColumn_descrizione();
                        }
                        Stage stage = (Stage)SearchTipoVinoAnagraficaController.this.table_art.getScene().getWindow();
                        stage.close();
                    }
                }
            });
            this.column_codice.setCellFactory(column -> new TableCell<ColumnTableTipoVinoAna, String>(){

                protected void updateItem(String item, boolean empty) {
                    ColumnTableTipoVinoAna er;
                    super.updateItem((Object)item, empty);
                    this.setText(empty ? "" : ((String)this.getItem()).toString());
                    this.setGraphic(null);
                    TableRow currentRow = this.getTableRow();
                    if (!this.isEmpty() && currentRow != null && (er = (ColumnTableTipoVinoAna)currentRow.getItem()) != null && er.getColumn_precancellato() == 1) {
                        currentRow.setStyle("-fx-background-color:#00C0EF;");
                    }
                }
            });
            this.editText_searcharticolo.textProperty().addListener((observable, oldValue, newValue) -> {
                if (newValue != null) {
                    String codart = this.editText_searcharticolo.getText().trim();
                    if (!codart.equals("")) {
                        try {
                            this.search(codart);
                        }
                        catch (JSONException ex) {
                            this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", this.data_select);
                        }
                    } else {
                        this.lista.clear();
                        this.table_art.setItems(this.lista);
                    }
                }
            });
        }
        catch (IOException ex) {
            this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
        }
    }

    private void search(String codart) throws JSONException {
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        lastID.add(false);
        tipoSQL.add("select");
        String select = "SELECT a.cancellato,a.codice,a.descrizione,a.id,a.mexal FROM (SELECT a.cancellato,a.id,a.codice,a.descrizione,IF(ISNULL(b.codice),'',b.codice) AS mexal FROM gen_tipo_vino_ana AS a LEFT JOIN gen_tipo_vino_ana_mx AS b ON a.id=b.id_tipo_vino_ana WHERE a.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND a.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND a.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND a.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "'  ) AS a  WHERE (a.codice LIKE '%" + codart + "%' OR a.descrizione LIKE '%" + codart + "%') ";
        if (this.precancellati == 0) {
            select = select + " AND a.cancellato=0 ";
        }
        strSQL.add(select);
        String str = this.util.makeStringJsonDB("ON", tipoSQL, strSQL, null, null, lastID, null);
        this.data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + str);
        if (!this.data_select.contains("#ERR:")) {
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(this.data_select);
            this.lista.clear();
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    JSONObject rec = arrayJson.getJSONObject(i);
                    this.lista.add((Object)new ColumnTableTipoVinoAna(rec.getInt("id"), rec.getString("codice"), rec.getString("descrizione"), rec.getString("mexal"), rec.getInt("cancellato")));
                    continue;
                }
                catch (JSONException ex) {
                    this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                }
            }
            this.table_art.setItems(this.lista);
        } else {
            this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", this.data_select);
        }
    }

    public String getCodice() {
        return this.strCodice;
    }

    public Double getCapacita() {
        return this.capacita;
    }

    public String getAnno() {
        return this.strAnnata;
    }

    public String getDesString() {
        return this.strDescrizione;
    }

    public String getAttoCert() {
        return this.atto_cert;
    }

    public String getStatoFisico() {
        return this.cod_stato_fisico;
    }

    public String getID() {
        return this.strID;
    }

    public void setCodice(String val) {
        this.codice = val;
    }

    public void setSearch(String val) {
        this.editText_searcharticolo.setText(val);
        this.editText_searcharticolo.requestFocus();
        this.editText_searcharticolo.positionCaret(val.length());
    }
}

