/*
 * Decompiled with CFR 0.152.
 */
package vin.controller;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Alert;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.MouseEvent;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import vin.Class.ColumnTableCodiceDescrizione;
import vin.controller.FXMLDocumentController;

public class SearchTableCodiceDescrizioneController
implements Initializable {
    List<String> strSQL;
    List<String> tipoSQL;
    List<Boolean> lastID;
    String strJson = "";
    String strCodice = "";
    String strDescrizione = "";
    String codice = "";
    @FXML
    TextField editText_searchT;
    @FXML
    TableView<ColumnTableCodiceDescrizione> table_;
    @FXML
    TableColumn<ColumnTableCodiceDescrizione, String> column_codice;
    @FXML
    TableColumn<ColumnTableCodiceDescrizione, String> column_descrizione;
    ObservableList<ColumnTableCodiceDescrizione> lista = FXCollections.observableArrayList();
    FilteredList<ColumnTableCodiceDescrizione> filteredData = null;

    public void setCodice(String codice) {
        this.codice = codice;
        this.editText_searchT.setText(codice);
    }

    public void initialize(URL url, ResourceBundle rb) {
        try {
            this.column_codice.setCellValueFactory((Callback)new PropertyValueFactory("column_codice"));
            this.column_descrizione.setCellValueFactory((Callback)new PropertyValueFactory("column_descrizione"));
            this.table_.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent e) {
                    ColumnTableCodiceDescrizione f;
                    if (e.isPrimaryButtonDown() && e.getClickCount() == 2 && (f = (ColumnTableCodiceDescrizione)SearchTableCodiceDescrizioneController.this.table_.getSelectionModel().getSelectedItem()) != null) {
                        SearchTableCodiceDescrizioneController.this.strCodice = f.getColumn_codice();
                        SearchTableCodiceDescrizioneController.this.strDescrizione = f.getColumn_descrizione();
                        Stage stage = (Stage)SearchTableCodiceDescrizioneController.this.table_.getScene().getWindow();
                        SearchTableCodiceDescrizioneController.this.lista.clear();
                        stage.close();
                    }
                }
            });
            this.filteredData = new FilteredList(this.lista, p -> true);
            this.editText_searchT.textProperty().addListener((observable, oldValue, newValue) -> this.filteredData.setPredicate(pluto -> {
                if (newValue == null || newValue.isEmpty()) {
                    return true;
                }
                ColumnTableCodiceDescrizione pr = pluto;
                String lowerCaseFilter = newValue.toLowerCase();
                if (pluto.getColumn_codice().toLowerCase().contains(lowerCaseFilter)) {
                    return true;
                }
                return pluto.getColumn_descrizione().toLowerCase().contains(lowerCaseFilter);
            }));
            SortedList sortedData = new SortedList(this.filteredData);
            sortedData.comparatorProperty().bind((ObservableValue)this.table_.comparatorProperty());
            this.table_.setItems((ObservableList)sortedData);
        }
        catch (Exception ex) {
            FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
        }
    }

    public void setTableLotto() throws JSONException {
        this.strSQL = new ArrayList<String>();
        this.tipoSQL = new ArrayList<String>();
        this.lastID = new ArrayList<Boolean>();
        this.lastID.add(false);
        this.strSQL.add("SELECT IFNULL(cod_lotto,'') AS codice FROM c_movimenti_lotti WHERE azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' GROUP BY cod_lotto ");
        this.tipoSQL.add("select");
        this.strJson = FXMLDocumentController.util.makeStringJsonDB("OFF", this.tipoSQL, this.strSQL, null, null, this.lastID, null);
        String data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + this.strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = FXMLDocumentController.jsonUtil.strJsonToJSONArray(data_select);
            this.lista.clear();
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    JSONObject rec = arrayJson.getJSONObject(i);
                    this.lista.add((Object)new ColumnTableCodiceDescrizione(0, rec.getString("codice"), ""));
                    continue;
                }
                catch (JSONException ex) {
                    FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                }
            }
        } else {
            FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", data_select);
        }
    }

    public void setTable(String table) throws JSONException {
        this.strSQL = new ArrayList<String>();
        this.tipoSQL = new ArrayList<String>();
        this.lastID = new ArrayList<Boolean>();
        this.lastID.add(false);
        if (!table.equals("sian_t_dopigp")) {
            this.strSQL.add("SELECT * FROM " + table);
        } else {
            this.strSQL.add("SELECT * FROM " + table + " WHERE progressivo='' ");
        }
        this.tipoSQL.add("select");
        this.strJson = FXMLDocumentController.util.makeStringJsonDB("OFF", this.tipoSQL, this.strSQL, null, null, this.lastID, null);
        String data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + this.strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = FXMLDocumentController.jsonUtil.strJsonToJSONArray(data_select);
            this.lista.clear();
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    JSONObject rec = arrayJson.getJSONObject(i);
                    switch (table) {
                        case "sian_t_paesiiso": {
                            this.lista.add((Object)new ColumnTableCodiceDescrizione(0, rec.getString("iso3166_1_numeric"), rec.getString("name")));
                            break;
                        }
                        case "sian_t_categoria": {
                            this.lista.add((Object)new ColumnTableCodiceDescrizione(0, rec.getString("codice"), rec.getString("descrizione") + " " + rec.getString("unita_di_misura")));
                            break;
                        }
                        case "sian_t_stato_fisico": {
                            this.lista.add((Object)new ColumnTableCodiceDescrizione(0, rec.getString("codice"), rec.getString("descrizione")));
                            break;
                        }
                        case "sian_t_classificazione": {
                            this.lista.add((Object)new ColumnTableCodiceDescrizione(0, rec.getString("codice"), rec.getString("descrizione")));
                            break;
                        }
                        case "accise_t_010": {
                            this.lista.add((Object)new ColumnTableCodiceDescrizione(0, rec.getString("codice"), rec.getString("descrizione_italiana")));
                            break;
                        }
                        default: {
                            this.lista.add((Object)new ColumnTableCodiceDescrizione(0, rec.getString("codice"), rec.getString("descrizione")));
                            break;
                        }
                    }
                    continue;
                }
                catch (JSONException ex) {
                    FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                }
            }
        } else {
            FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", data_select);
        }
    }

    public String getCodice() {
        return this.strCodice;
    }

    public String getDescrizione() {
        return this.strDescrizione;
    }
}

