/*
 * Decompiled with CFR 0.152.
 */
package vin.controller;

import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Alert;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.MouseEvent;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import vin.Class.ColumnTableSearchProdotto;
import vin.Class.Ricerca;
import vin.controller.FXMLDocumentController;

public class SearchProdottoPool
implements Initializable {
    String anno = "";
    String flag = "";
    String magazzino = "";
    String data_select = "";
    @FXML
    TableView<ColumnTableSearchProdotto> table_art;
    @FXML
    TableColumn<ColumnTableSearchProdotto, String> column_descrizione;
    @FXML
    TableColumn<ColumnTableSearchProdotto, String> column_codice;
    @FXML
    TableColumn<ColumnTableSearchProdotto, String> column_codicemx;
    @FXML
    TableColumn<ColumnTableSearchProdotto, Integer> column_id;
    @FXML
    TableColumn<ColumnTableSearchProdotto, Double> column_litri;
    @FXML
    TextField editText_searcharticolo;
    String strCodice = "";
    String strDescrizione = "";
    String strID = "";
    String cod_stato_fisico = "";
    String atto_cert = "";
    String strAnnata = "";
    Double capacita = 0.0;
    String codstatofisico = "";
    Double giacenza = 0.0;
    String annata = "";
    String ander = "";
    String controllo = "";
    String categoria = "";
    String codicemx = "";
    int precancellato = 0;
    double volume_nominale = 0.0;
    ObservableList<ColumnTableSearchProdotto> lista = FXCollections.observableArrayList();
    FilteredList<ColumnTableSearchProdotto> filteredData = null;
    @FXML
    private CheckBox chk_precancellati;

    public void initialize(URL url, ResourceBundle rb) {
        try {
            this.column_descrizione.setCellValueFactory((Callback)new PropertyValueFactory("column_descrizione"));
            this.column_codice.setCellValueFactory((Callback)new PropertyValueFactory("column_codice"));
            this.column_codicemx.setCellValueFactory((Callback)new PropertyValueFactory("column_codice_mx"));
            this.column_id.setCellValueFactory((Callback)new PropertyValueFactory("column_id"));
            this.column_litri.setCellValueFactory((Callback)new PropertyValueFactory("column_giacenza"));
            this.chk_precancellati.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                    SearchProdottoPool.this.precancellato = newValue != false ? 1 : 0;
                    SearchProdottoPool.this.fillTable();
                }
            });
            this.table_art.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent e) {
                    if (e.isPrimaryButtonDown() && e.getClickCount() == 2) {
                        ColumnTableSearchProdotto f = (ColumnTableSearchProdotto)SearchProdottoPool.this.table_art.getSelectionModel().getSelectedItem();
                        SearchProdottoPool.this.strCodice = f.getColumn_codice();
                        SearchProdottoPool.this.strID = "" + f.getColumn_id();
                        SearchProdottoPool.this.strAnnata = f.getAnno();
                        SearchProdottoPool.this.strDescrizione = f.getColumn_descrizione();
                        SearchProdottoPool.this.atto_cert = f.getAtto_cert();
                        SearchProdottoPool.this.cod_stato_fisico = f.getColumn_stato_fisico();
                        SearchProdottoPool.this.capacita = f.getCapacita();
                        SearchProdottoPool.this.giacenza = Double.parseDouble(f.getColumn_giacenza());
                        SearchProdottoPool.this.categoria = f.getCategoriaProdotto();
                        SearchProdottoPool.this.volume_nominale = f.getColumn_volumenominale();
                        SearchProdottoPool.this.codicemx = f.getColumn_codice_mx();
                        Stage stage = (Stage)SearchProdottoPool.this.table_art.getScene().getWindow();
                        stage.close();
                    }
                }
            });
            this.column_codice.setCellFactory(column -> new TableCell<ColumnTableSearchProdotto, String>(){

                protected void updateItem(String item, boolean empty) {
                    ColumnTableSearchProdotto er;
                    super.updateItem((Object)item, empty);
                    this.setText(empty ? "" : ((String)this.getItem()).toString());
                    this.setGraphic(null);
                    TableRow currentRow = this.getTableRow();
                    if (!this.isEmpty() && currentRow != null && (er = (ColumnTableSearchProdotto)currentRow.getItem()) != null && er.getColumn_precancellato() == 1) {
                        currentRow.setStyle("-fx-background-color:#00C0EF;");
                    }
                }
            });
            this.filteredData = new FilteredList(this.lista, p -> true);
            this.editText_searcharticolo.textProperty().addListener((observable, oldValue, newValue) -> this.filteredData.setPredicate(person -> {
                if (newValue == null || newValue.isEmpty()) {
                    return true;
                }
                String lowerCaseFilter = newValue.toLowerCase();
                if (person.getColumn_codice().toLowerCase().contains(lowerCaseFilter)) {
                    return true;
                }
                return person.getColumn_descrizione().toLowerCase().contains(lowerCaseFilter);
            }));
            SortedList sortedData = new SortedList(this.filteredData);
            sortedData.comparatorProperty().bind((ObservableValue)this.table_art.comparatorProperty());
            this.table_art.setItems((ObservableList)sortedData);
        }
        catch (Exception ex) {
            FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
        }
    }

    private void fillTable() {
        try {
            JSONArray ret = new Ricerca().giacenzaVino("", this.ander, this.controllo, false);
            if (ret != null) {
                JSONArray arrayJson = ret;
                this.lista.clear();
                for (int i = 0; i < arrayJson.length(); ++i) {
                    try {
                        String vol_nom;
                        JSONObject rec = arrayJson.getJSONObject(i);
                        double litri = rec.getDouble("litri");
                        String idint = rec.get("id").toString().replace("null", "");
                        if (idint.equals("")) {
                            idint = "0";
                        }
                        if ((vol_nom = rec.get("sian_volume_nominale").toString().replace("null", "")).equals("")) {
                            vol_nom = "0.0";
                        }
                        if (this.precancellato == 0 && rec.getInt("cancellato") == 0) {
                            this.lista.add((Object)new ColumnTableSearchProdotto(Integer.parseInt(idint), rec.getString("descrizione"), rec.getString("codice"), rec.getString("sian_cod_stato_fisico"), rec.getString("sian_atto_certificato"), rec.getString("sian_annata"), rec.getDouble("sian_massa_volumica"), rec.getString("sian_cat_prodotto"), String.valueOf(litri), rec.getString("cod_prod_mx").replace("null", ""), Double.parseDouble(vol_nom), rec.getInt("cancellato")));
                            continue;
                        }
                        if (this.precancellato != 1) continue;
                        this.lista.add((Object)new ColumnTableSearchProdotto(Integer.parseInt(idint), rec.getString("descrizione"), rec.getString("codice"), rec.getString("sian_cod_stato_fisico"), rec.getString("sian_atto_certificato"), rec.getString("sian_annata"), rec.getDouble("sian_massa_volumica"), rec.getString("sian_cat_prodotto"), String.valueOf(litri), rec.getString("cod_prod_mx").replace("null", ""), Double.parseDouble(vol_nom), rec.getInt("cancellato")));
                        continue;
                    }
                    catch (JSONException ex) {
                        FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                    }
                }
            } else {
                FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", "NESSUN DATO TROVATO");
            }
        }
        catch (JSONException ex) {
            FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
        }
    }

    public String getCodice() {
        return this.strCodice;
    }

    public String getCodiceMx() {
        return this.codicemx;
    }

    public Double getCapacita() {
        return this.capacita;
    }

    public String getAnno() {
        return this.strAnnata;
    }

    public String getDesString() {
        return this.strDescrizione;
    }

    public String getAttoCert() {
        return this.atto_cert;
    }

    public String getStatoFisico() {
        return this.cod_stato_fisico;
    }

    public String getID() {
        return this.strID;
    }

    public String getCategoria() {
        return this.categoria;
    }

    public double getVNominale() {
        return this.volume_nominale;
    }

    public void setSearch(String val, String ander, String controllo) {
        this.ander = ander;
        this.controllo = controllo;
        this.fillTable();
        this.editText_searcharticolo.setText(val);
        this.editText_searcharticolo.requestFocus();
        this.editText_searcharticolo.positionCaret(val.length());
    }
}

