/*
 * Decompiled with CFR 0.152.
 */
package vin.controller;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Alert;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.MouseEvent;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import vin.Class.ColumnTableSearchProdotto;
import vin.Class.ColumnTableSearchTipoVino;
import vin.Class.Ricerca;
import vin.Comunicator.Sk1SrvCommunicator;
import vin.Uility.JsonUtils;
import vin.Uility.Utility;
import vin.controller.FXMLDocumentController;
import vin.controller.ToastFXMessages;

public class SearchProdottoEticController
implements Initializable {
    String anno = "";
    String flag = "";
    String magazzino = "";
    Ricerca ricerca = new Ricerca();
    Sk1SrvCommunicator sk1Comm = new Sk1SrvCommunicator();
    JsonUtils jsonUtil = new JsonUtils();
    ToastFXMessages toast = new ToastFXMessages();
    Utility util;
    String data_select = "";
    ObservableList<ColumnTableSearchProdotto> lista = null;
    String equ = "";
    @FXML
    TableView<ColumnTableSearchProdotto> table_art;
    @FXML
    TableColumn<ColumnTableSearchTipoVino, String> column_descrizione;
    @FXML
    TableColumn<ColumnTableSearchTipoVino, String> column_codice;
    String strCodice = "";
    String strCodiceMX = "";
    String strDescrizione = "";
    String strID = "";
    String cod_stato_fisico = "";
    String atto_cert = "";
    String strAnnata = "";
    Double capacita = 0.0;
    String categoria = "";
    String ander = "";
    String valgia = "";

    public void initialize(URL url, ResourceBundle rb) {
        try {
            this.util = new Utility();
            this.lista = FXCollections.observableArrayList();
            this.column_descrizione.setCellValueFactory((Callback)new PropertyValueFactory("column_descrizione"));
            this.column_codice.setCellValueFactory((Callback)new PropertyValueFactory("column_codice"));
            this.table_art.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent e) {
                    if (e.isPrimaryButtonDown() && e.getClickCount() == 2) {
                        ColumnTableSearchProdotto f = (ColumnTableSearchProdotto)SearchProdottoEticController.this.table_art.getSelectionModel().getSelectedItem();
                        SearchProdottoEticController.this.strCodice = f.getColumn_codice();
                        SearchProdottoEticController.this.strID = "" + f.getColumn_id();
                        SearchProdottoEticController.this.strAnnata = f.getAnno();
                        SearchProdottoEticController.this.strDescrizione = f.getColumn_descrizione();
                        SearchProdottoEticController.this.atto_cert = f.getAtto_cert();
                        SearchProdottoEticController.this.cod_stato_fisico = f.getColumn_stato_fisico();
                        SearchProdottoEticController.this.capacita = f.getCapacita();
                        SearchProdottoEticController.this.categoria = f.getCategoriaProdotto();
                        SearchProdottoEticController.this.strCodiceMX = f.getColumn_codice_mx();
                        Stage stage = (Stage)SearchProdottoEticController.this.table_art.getScene().getWindow();
                        stage.close();
                    }
                }
            });
        }
        catch (IOException ex) {
            Logger.getLogger(SearchProdottoEticController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public String getCodice() {
        return this.strCodice;
    }

    public String getCodiceMX() {
        return this.strCodiceMX;
    }

    public Double getCapacita() {
        return this.capacita;
    }

    public String getAnno() {
        return this.strAnnata;
    }

    public String getCategoriaProd() {
        return this.categoria;
    }

    public String getDesString() {
        return this.strDescrizione;
    }

    public String getAttoCert() {
        return this.atto_cert;
    }

    public String getStatoFisico() {
        return this.cod_stato_fisico;
    }

    public String getID() {
        return this.strID;
    }

    public void setSearch(String val) {
        try {
            JSONArray arrayJson = null;
            ArrayList<String> tipoSQL = new ArrayList<String>();
            ArrayList<String> strSQL = new ArrayList<String>();
            ArrayList lenghtBidimensionalArray = new ArrayList();
            ArrayList<Boolean> lastID = new ArrayList<Boolean>();
            String str = "";
            String data_select = "";
            lastID.add(false);
            tipoSQL.add("select");
            strSQL.add("SELECT b.codice,b.descrizione FROM gen_tipo_vino_ana AS a LEFT JOIN gen_tipo_vino_ana_mx AS b ON a.id=b.id_tipo_vino_ana WHERE a.codice='" + val + "' AND a.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND a.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND a.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND a.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "'");
            str = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
            data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + str);
            if (!data_select.contains("#ERR:")) {
                arrayJson = this.jsonUtil.strJsonToJSONArray(data_select);
                this.lista.clear();
                for (int i = 0; i < arrayJson.length(); ++i) {
                    try {
                        JSONObject rec = arrayJson.getJSONObject(i);
                        String codice = rec.getString("codice").replace("null", "").trim();
                        String descrizione = rec.getString("descrizione").trim();
                        if (codice.equals("")) continue;
                        this.lista.add((Object)new ColumnTableSearchProdotto(0, descrizione, codice, "", "", "", 0.0, "", "0", "", 0.0, 0));
                        continue;
                    }
                    catch (JSONException ex) {
                        this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                    }
                }
            } else {
                this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", data_select);
                return;
            }
            this.table_art.setItems(this.lista);
        }
        catch (Exception ex) {
            Logger.getLogger(SearchProdottoEticController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void setEqu(String val) {
        this.equ = val;
    }
}

