/*
 * Decompiled with CFR 0.152.
 */
package vin.controller;

import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Alert;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.MouseEvent;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import vin.Class.ColumnTableSearchProdotto;
import vin.Class.ColumnTableSearchTipoVino;
import vin.Class.Ricerca;
import vin.Comunicator.Sk1SrvCommunicator;
import vin.Uility.JsonUtils;
import vin.Uility.Utility;
import vin.controller.ToastFXMessages;

public class SearchProdottoDocumentiController
implements Initializable {
    String anno = "";
    String flag = "";
    String magazzino = "";
    Ricerca ricerca = new Ricerca();
    Sk1SrvCommunicator sk1Comm = new Sk1SrvCommunicator();
    JsonUtils jsonUtil = new JsonUtils();
    ToastFXMessages toast = new ToastFXMessages();
    Utility util;
    String data_select = "";
    ObservableList<ColumnTableSearchProdotto> lista = null;
    String equ = "";
    @FXML
    TableView<ColumnTableSearchProdotto> table_art;
    @FXML
    TableColumn<ColumnTableSearchTipoVino, String> column_descrizione;
    @FXML
    TableColumn<ColumnTableSearchTipoVino, String> column_codice;
    @FXML
    TableColumn<ColumnTableSearchTipoVino, String> column_codice_mx;
    @FXML
    TableColumn<ColumnTableSearchTipoVino, Double> column_giacenza;
    @FXML
    TextField editText_searcharticolo;
    @FXML
    CheckBox chk_mexal;
    String strCodice = "";
    String strCodiceMX = "";
    String strDescrizione = "";
    String strID = "";
    String cod_stato_fisico = "";
    String atto_cert = "";
    String strAnnata = "";
    Double capacita = 0.0;
    String categoria = "";
    String ander = "";
    String valgia = "";

    public void initialize(URL url, ResourceBundle rb) {
        try {
            this.util = new Utility();
            this.lista = FXCollections.observableArrayList();
            this.column_descrizione.setCellValueFactory((Callback)new PropertyValueFactory("column_descrizione"));
            this.column_codice.setCellValueFactory((Callback)new PropertyValueFactory("column_codice"));
            this.column_codice_mx.setCellValueFactory((Callback)new PropertyValueFactory("column_codice_mx"));
            this.column_giacenza.setCellValueFactory((Callback)new PropertyValueFactory("column_giacenza"));
            this.table_art.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent e) {
                    if (e.isPrimaryButtonDown() && e.getClickCount() == 2) {
                        ColumnTableSearchProdotto f = (ColumnTableSearchProdotto)SearchProdottoDocumentiController.this.table_art.getSelectionModel().getSelectedItem();
                        SearchProdottoDocumentiController.this.strCodice = f.getColumn_codice();
                        SearchProdottoDocumentiController.this.strID = "" + f.getColumn_id();
                        SearchProdottoDocumentiController.this.strAnnata = f.getAnno();
                        SearchProdottoDocumentiController.this.strDescrizione = f.getColumn_descrizione();
                        SearchProdottoDocumentiController.this.atto_cert = f.getAtto_cert();
                        SearchProdottoDocumentiController.this.cod_stato_fisico = f.getColumn_stato_fisico();
                        SearchProdottoDocumentiController.this.capacita = f.getCapacita();
                        SearchProdottoDocumentiController.this.categoria = f.getCategoriaProdotto();
                        SearchProdottoDocumentiController.this.strCodiceMX = f.getColumn_codice_mx();
                        Stage stage = (Stage)SearchProdottoDocumentiController.this.table_art.getScene().getWindow();
                        stage.close();
                    }
                }
            });
            this.editText_searcharticolo.textProperty().addListener((observable, oldValue, newValue) -> {
                String codart = this.editText_searcharticolo.getText().trim();
                if (!codart.equals("")) {
                    try {
                        JSONArray arrayJson = null;
                        boolean check = this.chk_mexal.isSelected();
                        arrayJson = this.ricerca.giacenzaVinoPerMexal(codart, this.ander, check);
                        this.lista.clear();
                        for (int i = 0; i < arrayJson.length(); ++i) {
                            try {
                                JSONObject rec = arrayJson.getJSONObject(i);
                                this.lista.add((Object)new ColumnTableSearchProdotto(0, rec.getString("descrizione"), rec.getString("codice"), rec.getString("sian_cod_stato_fisico"), rec.getString("sian_atto_certificato"), rec.getString("sian_annata"), 0.0, rec.getString("sian_cat_prodotto"), "0", rec.getString("cod_prod_mx"), rec.getDouble("sian_volume_nominale"), rec.getInt("cancellato")));
                                continue;
                            }
                            catch (JSONException ex) {
                                this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                            }
                        }
                        this.table_art.setItems(this.lista);
                    }
                    catch (Exception ex) {
                        this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", this.data_select);
                    }
                } else {
                    this.lista.clear();
                    this.table_art.setItems(this.lista);
                }
            });
        }
        catch (IOException ex) {
            Logger.getLogger(SearchProdottoDocumentiController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public String getCodice() {
        return this.strCodice;
    }

    public String getCodiceMX() {
        return this.strCodiceMX;
    }

    public Double getCapacita() {
        return this.capacita;
    }

    public String getAnno() {
        return this.strAnnata;
    }

    public String getCategoriaProd() {
        return this.categoria;
    }

    public String getDesString() {
        return this.strDescrizione;
    }

    public String getAttoCert() {
        return this.atto_cert;
    }

    public String getStatoFisico() {
        return this.cod_stato_fisico;
    }

    public String getID() {
        return this.strID;
    }

    public void setSearch(String val, String ander) {
        this.ander = ander;
        this.valgia = this.valgia;
        this.editText_searcharticolo.setText(val);
        this.editText_searcharticolo.requestFocus();
        this.editText_searcharticolo.positionCaret(val.length());
    }

    public void setEqu(String val) {
        this.equ = val;
    }
}

