/*
 * Decompiled with CFR 0.152.
 */
package vin.controller;

import com.jfoenix.controls.JFXButton;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import vin.Class.ColumnTableSearchProdotto;
import vin.Class.Ricerca;
import vin.Class.WorkIndicatorDialog;
import vin.Comunicator.Sk1SrvCommunicator;
import vin.Uility.JsonUtils;
import vin.Uility.Utility;
import vin.controller.StampaMovimentiController;
import vin.controller.ToastFXMessages;

public class SearchProdottoController_2
implements Initializable {
    String anno = "";
    String flag = "";
    String magazzino = "";
    Ricerca ricerca = new Ricerca();
    Sk1SrvCommunicator sk1Comm = new Sk1SrvCommunicator();
    JsonUtils jsonUtil = new JsonUtils();
    ToastFXMessages toast = new ToastFXMessages();
    Utility util;
    String data_select = "";
    ObservableList<ColumnTableSearchProdotto> lista = null;
    String equ = "";
    @FXML
    TableView<ColumnTableSearchProdotto> table_art;
    @FXML
    TableColumn<ColumnTableSearchProdotto, String> column_check;
    @FXML
    TableColumn<ColumnTableSearchProdotto, String> column_descrizione;
    @FXML
    TableColumn<ColumnTableSearchProdotto, String> column_codice;
    @FXML
    TableColumn<ColumnTableSearchProdotto, String> column_codice_mx;
    @FXML
    TableColumn<ColumnTableSearchProdotto, Double> column_giacenza;
    @FXML
    TextField editText_searcharticolo;
    @FXML
    CheckBox chk_mexal;
    @FXML
    JFXButton btn_search;
    String strCodice = "";
    String strCodiceMX = "";
    String strDescrizione = "";
    String strID = "";
    String cod_stato_fisico = "";
    String atto_cert = "";
    String strAnnata = "";
    Double capacita = 0.0;
    String categoria = "";
    String ander = "";
    String valgia = "";
    @FXML
    private StackPane stack;
    WorkIndicatorDialog wd = null;

    public void initialize(URL url, ResourceBundle rb) {
        try {
            this.util = new Utility();
            this.lista = FXCollections.observableArrayList();
            this.column_check.setCellValueFactory((Callback)new PropertyValueFactory("column_check"));
            this.column_descrizione.setCellValueFactory((Callback)new PropertyValueFactory("column_descrizione"));
            this.column_codice.setCellValueFactory((Callback)new PropertyValueFactory("column_codice"));
            this.column_codice_mx.setCellValueFactory((Callback)new PropertyValueFactory("column_codice_mx"));
            this.column_giacenza.setCellValueFactory((Callback)new PropertyValueFactory("column_giacenza"));
            this.editText_searcharticolo.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent event) {
                    if (event.getCode().equals((Object)KeyCode.ENTER)) {
                        SearchProdottoController_2.this.searcher(SearchProdottoController_2.this.editText_searcharticolo.getText().trim());
                    }
                }
            });
            this.table_art.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent e) {
                    if (e.isPrimaryButtonDown() && e.getClickCount() == 2) {
                        ColumnTableSearchProdotto f = (ColumnTableSearchProdotto)SearchProdottoController_2.this.table_art.getSelectionModel().getSelectedItem();
                        SearchProdottoController_2.this.strCodice = f.getColumn_codice();
                        SearchProdottoController_2.this.strID = "" + f.getColumn_id();
                        SearchProdottoController_2.this.strAnnata = f.getAnno();
                        SearchProdottoController_2.this.strDescrizione = f.getColumn_descrizione();
                        SearchProdottoController_2.this.atto_cert = f.getAtto_cert();
                        SearchProdottoController_2.this.cod_stato_fisico = f.getColumn_stato_fisico();
                        SearchProdottoController_2.this.capacita = f.getCapacita();
                        SearchProdottoController_2.this.categoria = f.getCategoriaProdotto();
                        SearchProdottoController_2.this.strCodiceMX = f.getColumn_codice_mx();
                        Stage stage = (Stage)SearchProdottoController_2.this.table_art.getScene().getWindow();
                        stage.close();
                    }
                }
            });
            this.table_art.setItems(this.lista);
        }
        catch (IOException ex) {
            Logger.getLogger(SearchProdottoController_2.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public String getCodice() {
        return this.strCodice;
    }

    public String getCodiceMX() {
        return this.strCodiceMX;
    }

    public Double getCapacita() {
        return this.capacita;
    }

    public String getAnno() {
        return this.strAnnata;
    }

    public String getCategoriaProd() {
        return this.categoria;
    }

    public String getDesString() {
        return this.strDescrizione;
    }

    public String getAttoCert() {
        return this.atto_cert;
    }

    public String getStatoFisico() {
        return this.cod_stato_fisico;
    }

    public String getID() {
        return this.strID;
    }

    @FXML
    void btnSearch(ActionEvent event) {
        this.searcher(this.editText_searcharticolo.getText().trim());
    }

    public void setSearch(String val, String ander, String valgia) {
        try {
            this.ander = ander;
            this.valgia = valgia;
            this.editText_searcharticolo.setText(val);
            this.editText_searcharticolo.requestFocus();
            this.editText_searcharticolo.positionCaret(val.length());
        }
        catch (Exception ex) {
            Logger.getLogger(SearchProdottoController_2.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void searcher(String val) {
        this.wd = new WorkIndicatorDialog(this.table_art.getScene().getWindow(), "Caricamento in corso...");
        this.wd.addTaskEndNotification(result -> {
            System.out.println(result);
            if (this.wd.labelWord.contains("#ERR")) {
                this.util.alertWindow(this.stack, this.wd.labelWord, "ERRORE", "ERRORE");
            }
            this.table_art.refresh();
            this.wd = null;
        });
        this.wd.exec("123", inputParam -> {
            try {
                this.search(val);
            }
            catch (JSONException ex) {
                Logger.getLogger(StampaMovimentiController.class.getName()).log(Level.SEVERE, null, ex);
            }
            return 1;
        });
    }

    private void search(String val) throws JSONException {
        JSONArray arrayJson = null;
        boolean check_mexal = this.chk_mexal.selectedProperty().get();
        arrayJson = this.ricerca.giacenzaVino(val, this.ander, this.valgia, check_mexal);
        if (arrayJson != null) {
            this.lista.clear();
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    JSONObject rec = arrayJson.getJSONObject(i);
                    String litri = rec.get("litri").toString();
                    BigDecimal litris = new BigDecimal(0);
                    if (!litri.equals("")) {
                        litris = new BigDecimal(litri).setScale(5, RoundingMode.HALF_UP);
                    }
                    String litrie = litris.toString();
                    this.lista.add((Object)new ColumnTableSearchProdotto(0, rec.getString("descrizione"), rec.getString("codice"), rec.getString("sian_cod_stato_fisico"), rec.getString("sian_atto_certificato"), rec.getString("sian_annata"), 0.0, rec.getString("sian_cat_prodotto"), litrie, rec.getString("cod_prod_mx").replace("null", ""), rec.getDouble("sian_volume_nominale"), rec.getInt("cancellato")));
                    continue;
                }
                catch (JSONException ex) {
                    this.wd.labelWord = ex.toString();
                }
            }
        }
    }

    public void setEqu(String val) {
        this.equ = val;
    }
}

