/*
 * Decompiled with CFR 0.152.
 */
package vin.controller;

import java.io.IOException;
import java.net.URL;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.Pane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import org.json.JSONException;
import vin.Class.Validazioni;
import vin.Class.WorkIndicatorDialog;
import vin.Comunicator.Sk1SrvCommunicator;
import vin.Uility.JasperReport;
import vin.Uility.JsonUtils;
import vin.Uility.Utility;
import vin.controller.FXMLDocumentController;
import vin.controller.RicercaConferentiController;
import vin.controller.SearchTipoVinoAnagraficaController;
import vin.controller.StampaMovimentiController;
import vin.controller.ToastFXMessages;

public class SearchOperazioniConferimentiController
implements Initializable {
    WorkIndicatorDialog wd = null;
    String retJSON = "";
    JasperReport jasperReport = new JasperReport();
    Sk1SrvCommunicator sk1Comm = new Sk1SrvCommunicator();
    JsonUtils jsonUtil = new JsonUtils();
    static ToastFXMessages toast = new ToastFXMessages();
    Validazioni validaCampi = new Validazioni();
    Utility util;
    String data_select = "";
    List<String> strSQL;
    List<String> tipoSQL;
    List<Boolean> lastID;
    String strJson = "";
    String operazione = "";
    @FXML
    private Button btnOk;
    @FXML
    private Label label_artmx;
    @FXML
    private Label label_da_data;
    @FXML
    private Label label_a_data;
    @FXML
    private TextField editText_codice;
    @FXML
    private TextField editText_numero;
    @FXML
    private TextField editText_conferente;
    @FXML
    private DatePicker dtp_da;
    @FXML
    private DatePicker dtp_a;

    public void initialize(URL url, ResourceBundle rb) {
        try {
            this.util = new Utility();
            this.editText_codice.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

                public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                    if (!newValue.equals("") && newValue.length() == 1) {
                        try {
                            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/vin/view/SearchTipoVinoAnagrafica.fxml"));
                            Stage stage = new Stage();
                            stage.setMaximized(false);
                            stage.setTitle("Prodotto");
                            stage.setScene(new Scene((Parent)((Pane)loader.load())));
                            SearchTipoVinoAnagraficaController controller = (SearchTipoVinoAnagraficaController)loader.getController();
                            controller.setSearch(newValue);
                            stage.initModality(Modality.APPLICATION_MODAL);
                            stage.setResizable(false);
                            stage.showAndWait();
                            String codice = controller.getCodice();
                            String descr = controller.getDesString();
                            if (!codice.equals("")) {
                                SearchOperazioniConferimentiController.this.editText_codice.setText(codice);
                            }
                        }
                        catch (IOException ex) {
                            SearchOperazioniConferimentiController.this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                        }
                    }
                }
            });
            this.editText_conferente.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

                public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                    if (!newValue.equals("") && newValue.length() == 1) {
                        try {
                            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/vin/view/RicercaConferenti.fxml"));
                            Stage stage = new Stage();
                            stage.setMaximized(false);
                            stage.setTitle("CONFERENTI");
                            stage.setScene(new Scene((Parent)((Pane)loader.load())));
                            RicercaConferentiController controller = (RicercaConferentiController)loader.getController();
                            stage.initModality(Modality.APPLICATION_MODAL);
                            stage.initStyle(StageStyle.DECORATED);
                            stage.setResizable(false);
                            stage.showAndWait();
                            String codice = controller.getCodice();
                            if (!codice.equals("")) {
                                SearchOperazioniConferimentiController.this.editText_conferente.setText(codice);
                            }
                        }
                        catch (IOException ex) {
                            SearchOperazioniConferimentiController.this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                        }
                    }
                }
            });
        }
        catch (IOException ex) {
            this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
        }
    }

    public String getResult() {
        return this.retJSON;
    }

    @FXML
    private void btnRicerca(ActionEvent event) throws IOException, JSONException {
        this.wd = new WorkIndicatorDialog(this.editText_codice.getScene().getWindow(), "Caricamento in corso...");
        this.wd.addTaskEndNotification(result -> {
            System.out.println(result);
            Stage stage = (Stage)this.editText_codice.getScene().getWindow();
            stage.close();
            this.wd = null;
        });
        this.wd.exec("123", inputParam -> {
            try {
                String codice = this.editText_codice.getText();
                String conferente = this.editText_conferente.getText();
                String numero = this.editText_numero.getText();
                LocalDate ddata = (LocalDate)this.dtp_da.getValue();
                String dadata = "";
                String adata = "";
                if (ddata != null) {
                    dadata = ddata.toString();
                }
                if ((ddata = (LocalDate)this.dtp_a.getValue()) != null) {
                    adata = ddata.toString();
                }
                this.ricerca(codice, conferente, dadata, adata, numero);
            }
            catch (Exception ex) {
                Logger.getLogger(StampaMovimentiController.class.getName()).log(Level.SEVERE, null, ex);
            }
            return 1;
        });
    }

    private void ricerca(String codice, String conferente, String dadata, String adata, String numero) throws JSONException {
        this.lastID = new ArrayList<Boolean>();
        this.tipoSQL = new ArrayList<String>();
        this.strSQL = new ArrayList<String>();
        this.lastID.add(false);
        String stringa = "SELECT a.numeratore,a.serie,a.id,c.id_conferimento AS id_oper,a.qta_netto,a.qta_lordo,a.tara,a.prodotto,a.data_oper,b.rag_soc AS conferente FROM f_movimenti AS a LEFT JOIN gen_ana_clifor AS b ON a.conferente=b.codice AND a.azienda=b.azienda AND a.sotto_az=b.sotto_az LEFT JOIN c_operazioni AS c ON a.id=c.id_conferimento WHERE a.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND a.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND a.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' ";
        if (!codice.equals("")) {
            stringa = stringa + " AND a.prodotto='" + codice + "' ";
        }
        if (!conferente.equals("")) {
            stringa = stringa + " AND a.conferente='" + conferente + "' ";
        }
        if (!dadata.equals("") && !adata.equals("")) {
            stringa = stringa + " AND (a.data_oper>='" + dadata + "' AND a.data_oper<='" + adata + "' )";
        }
        if (!numero.equals("")) {
            stringa = stringa + " AND a.numeratore='" + numero + "' ";
        }
        stringa = stringa + " GROUP BY c.id";
        this.strSQL.add(stringa);
        this.tipoSQL.add("select");
        this.strJson = this.util.makeStringJsonDB("OFF", this.tipoSQL, this.strSQL, null, null, this.lastID, null);
        this.data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + this.strJson);
        if (this.data_select.contains("#ERR:")) {
            this.retJSON = "#ERR:" + this.data_select;
            return;
        }
        this.retJSON = this.data_select;
    }
}

