/*
 * Decompiled with CFR 0.152.
 */
package vin.controller;

import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Alert;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.MouseEvent;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import vin.Class.ColumnTableCodiceDescrizione;
import vin.Comunicator.Sk1SrvCommunicator;
import vin.Uility.JsonUtils;
import vin.Uility.Utility;
import vin.controller.FXMLDocumentController;
import vin.controller.ToastFXMessages;

public class SearchMagazzinoMexalController
implements Initializable {
    String codice = "";
    Sk1SrvCommunicator sk1Comm = new Sk1SrvCommunicator();
    JsonUtils jsonUtil = new JsonUtils();
    ToastFXMessages toast = new ToastFXMessages();
    Utility util;
    String data_select = "";
    ObservableList<ColumnTableCodiceDescrizione> lista = null;
    String descrizione = "";
    @FXML
    TableView<ColumnTableCodiceDescrizione> table;
    @FXML
    TableColumn<ColumnTableCodiceDescrizione, String> column_descrizione;
    @FXML
    TableColumn<ColumnTableCodiceDescrizione, String> column_codice;

    public void initialize(URL url, ResourceBundle rb) {
        try {
            this.util = new Utility();
            this.lista = FXCollections.observableArrayList();
            this.column_descrizione.setCellValueFactory((Callback)new PropertyValueFactory("column_descrizione"));
            this.column_codice.setCellValueFactory((Callback)new PropertyValueFactory("column_codice"));
            this.table.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent e) {
                    if (e.isPrimaryButtonDown() && e.getClickCount() == 2) {
                        ColumnTableCodiceDescrizione f = (ColumnTableCodiceDescrizione)SearchMagazzinoMexalController.this.table.getSelectionModel().getSelectedItem();
                        SearchMagazzinoMexalController.this.codice = f.getColumn_codice();
                        SearchMagazzinoMexalController.this.descrizione = f.getColumn_descrizione();
                        Stage stage = (Stage)SearchMagazzinoMexalController.this.table.getScene().getWindow();
                        stage.close();
                    }
                }
            });
            this.data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "mxSelectMag#@" + FXMLDocumentController.GLOBAL_AZIENDA + "#@" + FXMLDocumentController.GLOBAL_SOTTOAZZ);
            if (!this.data_select.contains("#ERR:")) {
                JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(this.data_select);
                this.lista.clear();
                for (int i = 0; i < arrayJson.length(); ++i) {
                    try {
                        JSONObject rec = arrayJson.getJSONObject(i);
                        this.lista.add((Object)new ColumnTableCodiceDescrizione(0, String.valueOf(rec.getInt("codice")), rec.getString("descrizione")));
                        continue;
                    }
                    catch (JSONException ex) {
                        this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.getMessage());
                    }
                }
                this.table.setItems(this.lista);
            } else {
                this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", this.data_select);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(SearchMagazzinoMexalController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public String getCodice() {
        return this.codice;
    }

    public String getDescrizione() {
        return this.descrizione;
    }
}

