/*
 * Decompiled with CFR 0.152.
 */
package vin.controller;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Alert;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import vin.Class.ColumnTableClienti;
import vin.Class.EditingCellBoolean;
import vin.controller.FXMLDocumentController;

public class SearchClientiListaController
implements Initializable {
    String id = "";
    String codice = "";
    String descrizione = "";
    String provinciaIstat = "";
    String comuneIstat = "";
    String statoIstat = "";
    String tipo = "";
    String cap = "";
    String indirizzo = "";
    String nome = "";
    String cognome = "";
    String rag_soc = "";
    String stato = "";
    String codFisc = "";
    String pIva = "";
    String icqrf = "";
    ObservableList<ColumnTableClienti> lista = FXCollections.observableArrayList();
    FilteredList<ColumnTableClienti> filteredData = null;
    @FXML
    private TextField editText_searcharticolo;
    @FXML
    private TableView<ColumnTableClienti> table_art;
    @FXML
    private TableColumn<ColumnTableClienti, Integer> column_id;
    @FXML
    private TableColumn<ColumnTableClienti, String> column_codice;
    @FXML
    private TableColumn<ColumnTableClienti, String> column_descrizione;
    @FXML
    private TableColumn<ColumnTableClienti, String> column_ragsoc;
    @FXML
    private TableColumn<ColumnTableClienti, String> column_nome;
    @FXML
    private TableColumn<ColumnTableClienti, String> column_cognome;
    @FXML
    private TableColumn<ColumnTableClienti, String> column_piva;
    @FXML
    private TableColumn<ColumnTableClienti, String> column_codfisc;
    @FXML
    private TableColumn<ColumnTableClienti, String> column_paeseiso;
    @FXML
    private TableColumn<ColumnTableClienti, String> column_istat;
    @FXML
    private TableColumn<ColumnTableClienti, String> column_tipo;
    @FXML
    private TableColumn<ColumnTableClienti, Boolean> column_invio;

    public void initialize(URL url, ResourceBundle rb) {
        try {
            this.column_codice.setCellValueFactory((Callback)new PropertyValueFactory("column_codice"));
            this.column_codfisc.setCellValueFactory((Callback)new PropertyValueFactory("column_codfisc"));
            this.column_id.setCellValueFactory((Callback)new PropertyValueFactory("column_id"));
            this.column_cognome.setCellValueFactory((Callback)new PropertyValueFactory("column_cognome"));
            this.column_descrizione.setCellValueFactory((Callback)new PropertyValueFactory("column_descrizione"));
            this.column_istat.setCellValueFactory((Callback)new PropertyValueFactory("column_istat"));
            this.column_nome.setCellValueFactory((Callback)new PropertyValueFactory("column_nome"));
            this.column_paeseiso.setCellValueFactory((Callback)new PropertyValueFactory("column_paeseiso"));
            this.column_piva.setCellValueFactory((Callback)new PropertyValueFactory("column_piva"));
            this.column_ragsoc.setCellValueFactory((Callback)new PropertyValueFactory("column_ragsoc"));
            this.column_tipo.setCellValueFactory((Callback)new PropertyValueFactory("column_tipo"));
            this.column_invio.setCellValueFactory((Callback)new PropertyValueFactory("column_invio"));
            Callback<TableColumn<ColumnTableClienti, Boolean>, TableCell<ColumnTableClienti, Boolean>> invioflag = new Callback<TableColumn<ColumnTableClienti, Boolean>, TableCell<ColumnTableClienti, Boolean>>(){

                public TableCell call(TableColumn p) {
                    return new EditingCellBoolean();
                }
            };
            this.column_invio.setCellFactory((Callback)invioflag);
            this.column_invio.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<ColumnTableClienti, Boolean>>(){

                public void handle(TableColumn.CellEditEvent<ColumnTableClienti, Boolean> t) {
                    ((ColumnTableClienti)t.getTableView().getItems().get(t.getTablePosition().getRow())).setColumn_invio((Boolean)t.getNewValue());
                }
            });
            this.filteredData = new FilteredList(this.lista, p -> true);
            this.editText_searcharticolo.textProperty().addListener((observable, oldValue, newValue) -> this.filteredData.setPredicate(person -> {
                if (newValue == null || newValue.isEmpty()) {
                    return true;
                }
                String lowerCaseFilter = newValue.toLowerCase();
                if (person.getColumn_codice().toLowerCase().contains(lowerCaseFilter)) {
                    return true;
                }
                if (person.getColumn_nome().toLowerCase().contains(lowerCaseFilter)) {
                    return true;
                }
                return person.getColumn_cognome().toLowerCase().contains(lowerCaseFilter);
            }));
            SortedList sortedData = new SortedList(this.filteredData);
            sortedData.comparatorProperty().bind((ObservableValue)this.table_art.comparatorProperty());
            this.table_art.setItems((ObservableList)sortedData);
        }
        catch (Exception ex) {
            FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
        }
    }

    public List<ColumnTableClienti> getLista() {
        ArrayList<ColumnTableClienti> res = new ArrayList<ColumnTableClienti>();
        for (int i = 0; i < this.lista.size(); ++i) {
            if (!((ColumnTableClienti)this.lista.get(i)).getColumn_invio()) continue;
            res.add((ColumnTableClienti)this.lista.get(i));
        }
        return res;
    }

    @FXML
    void btnSeleziona(ActionEvent event) {
        Stage stage = (Stage)this.table_art.getScene().getWindow();
        stage.close();
    }

    public void fillTable(String tipo, String azienda, String sotto_az) throws JSONException {
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        this.lista.clear();
        String str = "SELECT id,codice,rag_soc,cognome,nome,p_iva,paese_iso,cod_istat_prov_comume,cod_fisc,tipo,indirizzo,cap,stato,IFNULL(icqrfsogg,'') AS icqrfsogg FROM gen_ana_clifor WHERE azienda='" + azienda + "' AND sotto_az='" + sotto_az + "' ";
        if (!tipo.equals("")) {
            str = str + " AND tipo='" + tipo + "' ";
        }
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = FXMLDocumentController.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = FXMLDocumentController.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    JSONObject rec = arrayJson.getJSONObject(i);
                    this.lista.add((Object)new ColumnTableClienti(false, rec.getInt("id"), rec.getString("codice"), "", rec.getString("rag_soc"), rec.getString("nome"), rec.getString("cognome"), rec.getString("p_iva"), rec.getString("cod_fisc"), rec.getString("paese_iso"), rec.getString("cod_istat_prov_comume"), rec.getString("tipo"), rec.getString("indirizzo"), rec.getString("cap"), rec.getString("stato"), rec.getString("icqrfsogg"), false, false, false, false, "", "", "", "", "", ""));
                    continue;
                }
                catch (Exception ex) {
                    FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                }
            }
        } else {
            FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", data_select);
        }
    }

    public String getCodice() {
        return this.codice;
    }

    public String getDescrizione() {
        return this.descrizione;
    }
}

