/*
 * Decompiled with CFR 0.152.
 */
package vin.controller;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Alert;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import vin.Class.ColumnTableClienti;
import vin.Class.EditingCellBoolean;
import vin.Class.WorkIndicatorDialog;
import vin.controller.FXMLDocumentController;
import vin.controller.StampaMovimentiController;

public class SearchClientiController
implements Initializable {
    String id = "";
    String codice = "";
    String descrizione = "";
    String provinciaIstat = "";
    String comuneIstat = "";
    String statoIstat = "";
    String tipo = "";
    String cap = "";
    String indirizzo = "";
    String nome = "";
    String cognome = "";
    String rag_soc = "";
    String stato = "";
    String codFisc = "";
    String pIva = "";
    String icqrf = "";
    ObservableList<ColumnTableClienti> lista = FXCollections.observableArrayList();
    FilteredList<ColumnTableClienti> filteredData = null;
    @FXML
    private TextField editText_searcharticolo;
    @FXML
    private TableView<ColumnTableClienti> table_art;
    @FXML
    private TableColumn<ColumnTableClienti, Integer> column_id;
    @FXML
    private TableColumn<ColumnTableClienti, String> column_codice;
    @FXML
    private TableColumn<ColumnTableClienti, String> column_descrizione;
    @FXML
    private TableColumn<ColumnTableClienti, String> column_ragsoc;
    @FXML
    private TableColumn<ColumnTableClienti, String> column_nome;
    @FXML
    private TableColumn<ColumnTableClienti, String> column_cognome;
    @FXML
    private TableColumn<ColumnTableClienti, String> column_piva;
    @FXML
    private TableColumn<ColumnTableClienti, String> column_codfisc;
    @FXML
    private TableColumn<ColumnTableClienti, String> column_paeseiso;
    @FXML
    private TableColumn<ColumnTableClienti, String> column_istat;
    @FXML
    private TableColumn<ColumnTableClienti, String> column_tipo;
    @FXML
    private TableColumn<ColumnTableClienti, Boolean> column_invio;
    @FXML
    private TableColumn<ColumnTableClienti, String> column_indirizzo;
    boolean fillIndirizzo = false;
    boolean fillNormal = false;
    String azienda = "";
    String sotto_az = "";
    WorkIndicatorDialog wd = null;

    public void initialize(URL url, ResourceBundle rb) {
        try {
            this.column_codice.setCellValueFactory((Callback)new PropertyValueFactory("column_codice"));
            this.column_codfisc.setCellValueFactory((Callback)new PropertyValueFactory("column_codfisc"));
            this.column_id.setCellValueFactory((Callback)new PropertyValueFactory("column_id"));
            this.column_cognome.setCellValueFactory((Callback)new PropertyValueFactory("column_cognome"));
            this.column_descrizione.setCellValueFactory((Callback)new PropertyValueFactory("column_descrizione"));
            this.column_istat.setCellValueFactory((Callback)new PropertyValueFactory("column_istat"));
            this.column_nome.setCellValueFactory((Callback)new PropertyValueFactory("column_nome"));
            this.column_paeseiso.setCellValueFactory((Callback)new PropertyValueFactory("column_descrIstat"));
            this.column_piva.setCellValueFactory((Callback)new PropertyValueFactory("column_piva"));
            this.column_ragsoc.setCellValueFactory((Callback)new PropertyValueFactory("column_ragsoc"));
            this.column_tipo.setCellValueFactory((Callback)new PropertyValueFactory("column_tipo"));
            this.column_invio.setCellValueFactory((Callback)new PropertyValueFactory("column_invio"));
            this.column_indirizzo.setCellValueFactory((Callback)new PropertyValueFactory("column_indirizzo"));
            Callback<TableColumn<ColumnTableClienti, Boolean>, TableCell<ColumnTableClienti, Boolean>> invioflag = new Callback<TableColumn<ColumnTableClienti, Boolean>, TableCell<ColumnTableClienti, Boolean>>(){

                public TableCell call(TableColumn p) {
                    return new EditingCellBoolean();
                }
            };
            this.column_invio.setCellFactory((Callback)invioflag);
            this.column_invio.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<ColumnTableClienti, Boolean>>(){

                public void handle(TableColumn.CellEditEvent<ColumnTableClienti, Boolean> t) {
                    ((ColumnTableClienti)t.getTableView().getItems().get(t.getTablePosition().getRow())).setColumn_invio((Boolean)t.getNewValue());
                }
            });
            this.table_art.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent e) {
                    if (e.isPrimaryButtonDown() && e.getClickCount() == 2) {
                        ColumnTableClienti f = (ColumnTableClienti)SearchClientiController.this.table_art.getSelectionModel().getSelectedItem();
                        SearchClientiController.this.codice = f.getColumn_codice();
                        SearchClientiController.this.id = f.getColumn_id() + "";
                        SearchClientiController.this.statoIstat = f.getColumn_paeseiso();
                        SearchClientiController.this.icqrf = f.getColumn_icqrfsogg();
                        SearchClientiController.this.comuneIstat = f.getColumn_istat();
                        SearchClientiController.this.provinciaIstat = f.getColumn_istat();
                        SearchClientiController.this.indirizzo = f.getColumn_indirizzo();
                        SearchClientiController.this.rag_soc = f.getColumn_ragsoc();
                        SearchClientiController.this.nome = f.getColumn_nome();
                        SearchClientiController.this.cognome = f.getColumn_cognome();
                        SearchClientiController.this.cap = f.getColumn_cap();
                        SearchClientiController.this.stato = f.getColumn_stato();
                        SearchClientiController.this.pIva = f.getColumn_piva();
                        SearchClientiController.this.codFisc = f.getColumn_codfisc();
                        if (!SearchClientiController.this.comuneIstat.equals("")) {
                            SearchClientiController.this.comuneIstat = SearchClientiController.this.comuneIstat.substring(3, 6);
                        }
                        if (!SearchClientiController.this.provinciaIstat.equals("")) {
                            SearchClientiController.this.provinciaIstat = SearchClientiController.this.provinciaIstat.substring(0, 3);
                        }
                        if (!f.getColumn_ragsoc().equals("") && f.getColumn_nome().equals("") && f.getColumn_nome().equals("")) {
                            SearchClientiController.this.descrizione = f.getColumn_ragsoc();
                        } else if (f.getColumn_ragsoc().equals("") && !f.getColumn_nome().equals("") && !f.getColumn_nome().equals("")) {
                            SearchClientiController.this.descrizione = f.getColumn_nome() + " " + f.getColumn_cognome();
                        }
                        Stage stage = (Stage)SearchClientiController.this.table_art.getScene().getWindow();
                        stage.close();
                    }
                }
            });
            this.editText_searcharticolo.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent event) {
                    if (event.getCode().equals((Object)KeyCode.ENTER)) {
                        SearchClientiController.this.setCerca();
                    }
                }
            });
            this.table_art.setItems(this.lista);
        }
        catch (Exception ex) {
            FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
        }
    }

    public String getCodFisc() {
        return this.codFisc;
    }

    public void setCodFisc(String codFisc) {
        this.codFisc = codFisc;
    }

    public String getpIva() {
        return this.pIva;
    }

    public void setpIva(String pIva) {
        this.pIva = pIva;
    }

    public String getStato() {
        return this.stato;
    }

    public void setStato(String stato) {
        this.stato = stato;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public String getCognome() {
        return this.cognome;
    }

    public void setCognome(String cognome) {
        this.cognome = cognome;
    }

    public String getRag_soc() {
        return this.rag_soc;
    }

    public void setRag_soc(String rag_soc) {
        this.rag_soc = rag_soc;
    }

    public String getCap() {
        return this.cap;
    }

    public void setCap(String cap) {
        this.cap = cap;
    }

    public String getIndirizzo() {
        return this.indirizzo;
    }

    public String getIcqrfSogg() {
        return this.icqrf;
    }

    public void setIndirizzo(String indirizzo) {
        this.indirizzo = indirizzo;
    }

    public String getTipo() {
        return this.tipo;
    }

    public void setTipo(String tipo) {
        this.tipo = tipo;
    }

    public String getProvinciaIstat() {
        return this.provinciaIstat;
    }

    public void setProvinciaIstat(String provinciaIstat) {
        this.provinciaIstat = provinciaIstat;
    }

    public String getComuneIstat() {
        return this.comuneIstat;
    }

    public void setComuneIstat(String comuneIstat) {
        this.comuneIstat = comuneIstat;
    }

    public String getStatoIstat() {
        return this.statoIstat;
    }

    public void setStatoIstat(String statoIstat) {
        this.statoIstat = statoIstat;
    }

    public List<ColumnTableClienti> getLista() {
        ArrayList<ColumnTableClienti> res = new ArrayList<ColumnTableClienti>();
        for (int i = 0; i < this.lista.size(); ++i) {
            if (!((ColumnTableClienti)this.lista.get(i)).getColumn_invio()) continue;
            res.add((ColumnTableClienti)this.lista.get(i));
        }
        return res;
    }

    private void fillTable(String tipo, String azienda, String sotto_az, String text) throws JSONException {
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        this.lista.clear();
        String str = "SELECT id,codice,rag_soc,cognome,nome,p_iva,paese_iso,cod_istat_prov_comume,cod_fisc,tipo,indirizzo,cap,stato,icqrfsogg ,IFNULL(b.name,'') AS descr_paeseiso FROM gen_ana_clifor AS a LEFT JOIN sian_t_paesiiso AS b ON a.paese_iso=b.ISO3166_1_numeric WHERE azienda='" + azienda + "' AND sotto_az='" + sotto_az + "' ";
        if (!tipo.equals("")) {
            str = str + " AND tipo='" + tipo + "' ";
        }
        if (!text.equals("")) {
            str = str + " AND (a.codice LIKE '%" + text + "%' OR a.indirizzo LIKE '%" + text + "%' OR a.rag_soc LIKE '%" + text + "%' )";
        }
        str = str + " LIMIT 100";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = FXMLDocumentController.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = FXMLDocumentController.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    JSONObject rec = arrayJson.getJSONObject(i);
                    this.lista.add((Object)new ColumnTableClienti(false, rec.getInt("id"), rec.getString("codice"), "", rec.getString("rag_soc"), rec.getString("nome"), rec.getString("cognome"), rec.getString("p_iva"), rec.getString("cod_fisc"), rec.getString("paese_iso"), rec.getString("cod_istat_prov_comume"), rec.getString("tipo"), rec.getString("indirizzo"), rec.getString("cap"), rec.getString("stato"), rec.getString("icqrfsogg"), false, false, false, false, "", "", rec.get("descr_paeseiso").toString(), "", "", ""));
                    continue;
                }
                catch (Exception ex) {
                    FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                }
            }
        } else {
            FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", data_select);
        }
    }

    private void fillTableIndirizzo(String tipo, String azienda, String sotto_az, String text) throws JSONException {
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        this.lista.clear();
        String str = "SELECT id,codice,indirizzo,cap,rag_soc,nome,cognome,p_iva,cod_fisc,paese_iso,cod_istat_prov_comume,tipo,icqrfsogg,stato,descr_paeseiso FROM(SELECT id,codice,indirizzo,cap,rag_soc,nome,cognome,p_iva,cod_fisc,paese_iso,cod_istat_prov_comume,tipo,icqrfsogg,stato,IFNULL(b.name,'') AS descr_paeseiso FROM gen_ana_clifor AS a LEFT JOIN sian_t_paesiiso AS b ON a.paese_iso=b.ISO3166_1_numeric WHERE azienda='" + azienda + "' AND sotto_az='" + sotto_az + "' UNION SELECT a.id,a.codice,a.indirizzo,a.cap,b.rag_soc,b.nome,b.cognome,b.p_iva,b.cod_fisc,a.paese_iso,CONCAT(a.istat_province,a.istat_paese) AS cod_istat_prov_comume,b.tipo,b.icqrfsogg,a.stato,IFNULL(c.name,'') AS descr_paeseiso FROM gen_ana_indirizzi AS a LEFT JOIN gen_ana_clifor AS b ON a.codice_cliente=b.codice AND a.azienda=b.azienda AND a.sotto_az=b.sotto_az LEFT JOIN sian_t_paesiiso AS c ON a.paese_iso=c.ISO3166_1_numeric WHERE a.azienda='" + azienda + "' AND a.sotto_az='" + sotto_az + "' GROUP BY a.codice ) AS a ";
        if (!text.equals("")) {
            str = str + " WHERE (a.codice LIKE '%" + text + "%' OR a.indirizzo LIKE '%" + text + "%' OR a.rag_soc LIKE '%" + text + "%' )";
        }
        str = str + " LIMIT 100 ";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = FXMLDocumentController.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = FXMLDocumentController.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    JSONObject rec = arrayJson.getJSONObject(i);
                    this.lista.add((Object)new ColumnTableClienti(false, rec.getInt("id"), rec.getString("codice"), "", rec.getString("rag_soc"), rec.getString("nome"), rec.getString("cognome"), rec.getString("p_iva"), rec.getString("cod_fisc"), rec.getString("paese_iso"), rec.getString("cod_istat_prov_comume"), rec.getString("tipo"), rec.getString("indirizzo"), rec.getString("cap"), rec.getString("stato"), rec.getString("icqrfsogg"), false, false, false, false, "", "", rec.get("descr_paeseiso").toString(), "", "", ""));
                    continue;
                }
                catch (Exception ex) {
                    FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                }
            }
        } else {
            FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", data_select);
        }
    }

    public String getCodice() {
        return this.codice;
    }

    public String getDescrizione() {
        return this.descrizione;
    }

    public void setFillIndirizzo(boolean fillIndirizzo, String azienda, String sotto_az, String tipo) {
        this.fillIndirizzo = fillIndirizzo;
        this.azienda = azienda;
        this.sotto_az = sotto_az;
        this.tipo = tipo;
    }

    public void setFillNormal(boolean fillNormal, String azienda, String sotto_az, String tipo) {
        this.fillNormal = fillNormal;
        this.azienda = azienda;
        this.sotto_az = sotto_az;
        this.tipo = tipo;
    }

    public void setAzienda(String azienda) {
        this.azienda = azienda;
    }

    public void setSotto_az(String sotto_az) {
        this.sotto_az = sotto_az;
    }

    @FXML
    private void btnCerca(ActionEvent event) {
        this.setCerca();
    }

    private void setCerca() {
        String cerca = this.editText_searcharticolo.getText().trim();
        if (this.fillIndirizzo) {
            try {
                this.wd = new WorkIndicatorDialog(this.table_art.getScene().getWindow(), "Caricamento in corso...");
                this.wd.addTaskEndNotification(result -> {
                    System.out.println(result);
                    this.wd = null;
                });
                this.wd.exec("123", inputParam -> {
                    try {
                        this.fillTableIndirizzo(this.tipo, this.azienda, this.sotto_az, cerca);
                    }
                    catch (Exception ex) {
                        Logger.getLogger(StampaMovimentiController.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    return 1;
                });
            }
            catch (Exception ex) {
                Logger.getLogger(SearchClientiController.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else if (this.fillNormal) {
            try {
                this.wd = new WorkIndicatorDialog(this.table_art.getScene().getWindow(), "Caricamento in corso...");
                this.wd.addTaskEndNotification(result -> {
                    System.out.println(result);
                    this.wd = null;
                });
                this.wd.exec("123", inputParam -> {
                    try {
                        this.fillTable(this.tipo, this.azienda, this.sotto_az, cerca);
                    }
                    catch (Exception ex) {
                        Logger.getLogger(StampaMovimentiController.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    return 1;
                });
            }
            catch (Exception ex) {
                Logger.getLogger(SearchClientiController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

