/*
 * Decompiled with CFR 0.152.
 */
package vin.controller;

import java.net.URL;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Alert;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.MouseEvent;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import vin.Class.IdoneitaImbSfuso;
import vin.controller.FXMLDocumentController;

public class SearchCertPool
implements Initializable {
    @FXML
    private TextField editText_searcharticolo;
    @FXML
    private TableView<IdoneitaImbSfuso> table_art;
    @FXML
    private TableColumn<IdoneitaImbSfuso, String> column_codice;
    @FXML
    private TableColumn<IdoneitaImbSfuso, String> column_descrizione;
    @FXML
    private TableColumn<IdoneitaImbSfuso, String> column_codicemx;
    ObservableList<IdoneitaImbSfuso> lista = FXCollections.observableArrayList();
    FilteredList<IdoneitaImbSfuso> filteredData = null;
    String data_ido = "";
    String ente_cert = "";
    String num_prot = "";

    public void initialize(URL url, ResourceBundle rb) {
        this.column_descrizione.setCellValueFactory((Callback)new PropertyValueFactory("descrizione"));
        this.column_codice.setCellValueFactory((Callback)new PropertyValueFactory("codice"));
        this.column_codicemx.setCellValueFactory((Callback)new PropertyValueFactory("entecert"));
        this.table_art.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent e) {
                if (e.isPrimaryButtonDown() && e.getClickCount() == 2) {
                    IdoneitaImbSfuso f = (IdoneitaImbSfuso)SearchCertPool.this.table_art.getSelectionModel().getSelectedItem();
                    SearchCertPool.this.data_ido = f.getDescrizione();
                    SearchCertPool.this.ente_cert = f.getEntecert();
                    SearchCertPool.this.num_prot = f.getCodice();
                    Stage stage = (Stage)SearchCertPool.this.table_art.getScene().getWindow();
                    stage.close();
                }
            }
        });
        this.filteredData = new FilteredList(this.lista, p -> true);
        this.editText_searcharticolo.textProperty().addListener((observable, oldValue, newValue) -> this.filteredData.setPredicate(person -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lowerCaseFilter = newValue.toLowerCase();
            if (person.getCodice().toLowerCase().contains(lowerCaseFilter)) {
                return true;
            }
            if (person.getDescrizione().toLowerCase().contains(lowerCaseFilter)) {
                return true;
            }
            return person.getEntecert().toLowerCase().contains(lowerCaseFilter);
        }));
        SortedList sortedData = new SortedList(this.filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)this.table_art.comparatorProperty());
        this.table_art.setItems((ObservableList)sortedData);
    }

    public String getData_ido() {
        return this.data_ido;
    }

    public void setData_ido(String data_ido) {
        this.data_ido = data_ido;
    }

    public String getEnte_cert() {
        return this.ente_cert;
    }

    public void setEnte_cert(String ente_cert) {
        this.ente_cert = ente_cert;
    }

    public String getNum_prot() {
        return this.num_prot;
    }

    public void setNum_prot(String num_prot) {
        this.num_prot = num_prot;
    }

    public void fillTableConfezionato(String prodotto, String cod_lotto) {
        try {
            ArrayList<String> tipoSQL = new ArrayList<String>();
            ArrayList<String> strSQL = new ArrayList<String>();
            ArrayList lenghtBidimensionalArray = new ArrayList();
            ArrayList<Boolean> lastID = new ArrayList<Boolean>();
            lastID.add(false);
            tipoSQL.add("select");
            String sele = "SELECT a.num_prot_ido AS num_protocollo,data_ido,ente_cert,IFNULL(cod_lotto,'') AS cod_lotto \nFROM c_movimenti AS a \nLEFT JOIN c_movimenti_lotti AS b ON a.id=b.id_mov\nWHERE   a.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND a.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND a.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "'\n";
            if (!cod_lotto.equals("")) {
                sele = sele + "AND b.cod_lotto='" + cod_lotto + "' \n";
            }
            sele = sele + "GROUP BY num_prot_ido,data_ido,ente_cert\nHAVING a.num_prot_ido<>''";
            strSQL.add(sele);
            String str = FXMLDocumentController.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
            String data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + str);
            if (!data_select.contains("#ERR:")) {
                JSONArray arrayJson = FXMLDocumentController.jsonUtil.strJsonToJSONArray(data_select);
                for (int i = 0; i < arrayJson.length(); ++i) {
                    try {
                        JSONObject rec = arrayJson.getJSONObject(i);
                        String num_protocollo = rec.get("num_protocollo").toString();
                        String data_ido = rec.get("data_ido").toString();
                        String ente_cert = rec.get("ente_cert").toString();
                        this.lista.add((Object)new IdoneitaImbSfuso(num_protocollo, data_ido, ente_cert));
                        continue;
                    }
                    catch (JSONException ex) {
                        FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                        return;
                    }
                }
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void fillTableSenzaEtichetta(String prodotto) {
        try {
            ArrayList<String> tipoSQL = new ArrayList<String>();
            ArrayList<String> strSQL = new ArrayList<String>();
            ArrayList lenghtBidimensionalArray = new ArrayList();
            ArrayList<Boolean> lastID = new ArrayList<Boolean>();
            lastID.add(false);
            tipoSQL.add("select");
            strSQL.add("SELECT num_prot_ido,data_ido,ente_cert FROM c_movimenti WHERE azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND cod_tipo_vino='" + prodotto + "' GROUP BY num_prot_ido,data_ido,ente_cert");
            String str = FXMLDocumentController.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
            String data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + str);
            if (!data_select.contains("#ERR:")) {
                JSONArray arrayJson = FXMLDocumentController.jsonUtil.strJsonToJSONArray(data_select);
                for (int i = 0; i < arrayJson.length(); ++i) {
                    try {
                        JSONObject rec = arrayJson.getJSONObject(i);
                        String num_protocollo = rec.get("num_prot_ido").toString();
                        String data_ido = rec.get("data_ido").toString();
                        String ente_cert = rec.get("ente_cert").toString();
                        this.lista.add((Object)new IdoneitaImbSfuso(num_protocollo, data_ido, ente_cert));
                        continue;
                    }
                    catch (JSONException ex) {
                        FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                        return;
                    }
                }
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }
}

