/*
 * Decompiled with CFR 0.152.
 */
package vin.controller;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Alert;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.MouseEvent;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import vin.Class.ColumnTableSearchArticoloMexal;
import vin.Comunicator.Sk1SrvCommunicator;
import vin.Uility.JsonUtils;
import vin.Uility.Utility;
import vin.controller.FXMLDocumentController;
import vin.controller.ToastFXMessages;

public class SearchArticoloMexalLottoController
implements Initializable {
    String anno = "";
    String flag = "";
    String magazzino = "";
    Sk1SrvCommunicator sk1Comm = new Sk1SrvCommunicator();
    JsonUtils jsonUtil = new JsonUtils();
    ToastFXMessages toast = new ToastFXMessages();
    Utility util;
    String data_select = "";
    ObservableList<ColumnTableSearchArticoloMexal> lista = null;
    @FXML
    TableView<ColumnTableSearchArticoloMexal> table_art;
    @FXML
    TableColumn<ColumnTableSearchArticoloMexal, String> column_descrizione;
    @FXML
    TableColumn<ColumnTableSearchArticoloMexal, String> column_codice;
    @FXML
    TableColumn<ColumnTableSearchArticoloMexal, String> column_iva;
    @FXML
    TableColumn<ColumnTableSearchArticoloMexal, String> column_um;
    @FXML
    TableColumn<ColumnTableSearchArticoloMexal, String> column_codalt;
    @FXML
    TextField editText_searcharticolo;
    String strCodice = "";
    String strDescrizione = "";
    String strID = "";
    String strIva = "";
    String strUm = "";
    String strCodAlt = "";

    public void initialize(URL url, ResourceBundle rb) {
        try {
            this.util = new Utility();
            this.lista = FXCollections.observableArrayList();
            this.column_descrizione.setCellValueFactory((Callback)new PropertyValueFactory("column_descrizione"));
            this.column_codice.setCellValueFactory((Callback)new PropertyValueFactory("column_codice"));
            this.column_iva.setCellValueFactory((Callback)new PropertyValueFactory("column_iva"));
            this.column_um.setCellValueFactory((Callback)new PropertyValueFactory("column_um"));
            this.column_codalt.setCellValueFactory((Callback)new PropertyValueFactory("column_codalt"));
            this.table_art.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent e) {
                    if (e.isPrimaryButtonDown() && e.getClickCount() == 2) {
                        ColumnTableSearchArticoloMexal f = (ColumnTableSearchArticoloMexal)SearchArticoloMexalLottoController.this.table_art.getSelectionModel().getSelectedItem();
                        SearchArticoloMexalLottoController.this.strCodice = f.getColumn_codice();
                        SearchArticoloMexalLottoController.this.strDescrizione = f.getColumn_descrizione();
                        SearchArticoloMexalLottoController.this.strCodAlt = f.getColumn_codalt();
                        SearchArticoloMexalLottoController.this.strIva = f.getColumn_iva();
                        SearchArticoloMexalLottoController.this.strUm = f.getColumn_um();
                        Stage stage = (Stage)SearchArticoloMexalLottoController.this.table_art.getScene().getWindow();
                        stage.close();
                    }
                }
            });
            this.editText_searcharticolo.textProperty().addListener((observable, oldValue, newValue) -> {
                String codart = this.editText_searcharticolo.getText().trim();
                if (!codart.equals("")) {
                    try {
                        this.search(codart);
                    }
                    catch (JSONException ex) {
                        Logger.getLogger(SearchArticoloMexalLottoController.class.getName()).log(Level.SEVERE, null, ex);
                    }
                } else {
                    this.lista.clear();
                    this.table_art.setItems(this.lista);
                }
            });
        }
        catch (IOException ex) {
            Logger.getLogger(SearchArticoloMexalLottoController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void search(String cod) throws JSONException {
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        tipoSQL.add("select");
        strSQL.add("SELECT b.codice,b.descrizione FROM gen_tipo_vino_ana AS a LEFT JOIN gen_tipo_vino_ana_mx AS b ON a.id=b.id_tipo_vino_ana WHERE a.codice='" + cod + "' AND a.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND a.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND a.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND a.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "'");
        lastID.add(false);
        String str = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
        this.data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + str);
        String codice = "";
        String descrizione = "";
        if (!this.data_select.contains("#ERR:")) {
            this.lista.clear();
            JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(this.data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    JSONObject rec = arrayJson.getJSONObject(i);
                    codice = rec.getString("codice");
                    descrizione = rec.getString("descrizione");
                    this.lista.add((Object)new ColumnTableSearchArticoloMexal(rec.getString("descrizione"), rec.getString("codice"), "", "", ""));
                    continue;
                }
                catch (JSONException ex) {
                    this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                    return;
                }
            }
        } else {
            this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", this.data_select);
            return;
        }
        this.table_art.setItems(this.lista);
    }

    public String getCodice() {
        return this.strCodice;
    }

    public String getIva() {
        return this.strIva;
    }

    public String getUm() {
        return this.strUm;
    }

    public String getCodAlt() {
        return this.strCodAlt;
    }

    public String getDesString() {
        return this.strDescrizione;
    }

    public String getID() {
        return this.strID;
    }

    public void setSearch(String val) throws JSONException {
        this.editText_searcharticolo.setText(val);
        this.editText_searcharticolo.requestFocus();
        this.editText_searcharticolo.positionCaret(val.length());
        this.search(val);
    }
}

