/*
 * Decompiled with CFR 0.152.
 */
package vin.controller;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.Pane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import org.json.JSONException;
import vin.Class.Validazioni;
import vin.Class.WorkIndicatorDialog;
import vin.Comunicator.Sk1SrvCommunicator;
import vin.Uility.JasperReport;
import vin.Uility.JsonUtils;
import vin.Uility.Utility;
import vin.controller.FXMLDocumentController;
import vin.controller.SearchTipoVinoAnagraficaController;
import vin.controller.StampaMovimentiController;
import vin.controller.ToastFXMessages;

public class RicercaStampaOperazioneController
implements Initializable {
    String retJSON = "";
    JasperReport jasperReport = new JasperReport();
    Sk1SrvCommunicator sk1Comm = new Sk1SrvCommunicator();
    JsonUtils jsonUtil = new JsonUtils();
    static ToastFXMessages toast = new ToastFXMessages();
    Validazioni validaCampi = new Validazioni();
    Utility util;
    String data_select = "";
    List<String> strSQL;
    List<String> tipoSQL;
    List<Boolean> lastID;
    String strJson = "";
    String operazione = "";
    @FXML
    TextField editText_codice;
    @FXML
    TextField editText_artmx;
    @FXML
    DatePicker dtp_da;
    @FXML
    DatePicker dtp_a;
    @FXML
    TextField editText_cod_categoria;
    @FXML
    TextField editText_classificazione;
    @FXML
    TextField editText_atto_certificato;
    @FXML
    TextField editText_annata;
    @FXML
    TextField editText_sigla;
    @FXML
    TextField editText_serie;
    @FXML
    TextField editText_numero;
    @FXML
    TextField editText_progressivo;
    @FXML
    Button btnStampa;
    @FXML
    Button btnOk;
    @FXML
    Label label_artmx;
    @FXML
    Label label_a_data;
    @FXML
    Label label_da_data;
    @FXML
    Label label_cod_categoria;
    @FXML
    Label label_classificazione;
    @FXML
    Label label_atto_certificato;
    @FXML
    Label label_annata;
    @FXML
    private Label label_sigla;
    @FXML
    private Label label_serie;
    @FXML
    private Label label_numero;
    @FXML
    private Label label_progressivo;
    @FXML
    RadioButton chk_imbo;
    @FXML
    RadioButton chk_sfuso;
    @FXML
    RadioButton chk_tutto;
    @FXML
    ToggleGroup groupStatoFisico;
    WorkIndicatorDialog wd = null;

    public void initialize(URL url, ResourceBundle rb) {
        try {
            this.util = new Utility();
            this.editText_codice.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

                public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                    if (!newValue.equals("") && newValue.length() == 1) {
                        try {
                            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/vin/view/SearchTipoVinoAnagrafica.fxml"));
                            Stage stage = new Stage();
                            stage.setMaximized(false);
                            stage.setTitle("Prodotto");
                            stage.setScene(new Scene((Parent)((Pane)loader.load())));
                            SearchTipoVinoAnagraficaController controller = (SearchTipoVinoAnagraficaController)loader.getController();
                            controller.setSearch(newValue);
                            stage.initModality(Modality.APPLICATION_MODAL);
                            stage.setResizable(false);
                            stage.showAndWait();
                            String codice = controller.getCodice();
                            String descr = controller.getDesString();
                            if (!codice.equals("")) {
                                RicercaStampaOperazioneController.this.editText_codice.setText(codice);
                            }
                        }
                        catch (IOException ex) {
                            RicercaStampaOperazioneController.this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                        }
                    }
                }
            });
            this.editText_annata.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

                public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                    if (RicercaStampaOperazioneController.this.editText_annata.getText().length() > 4) {
                        RicercaStampaOperazioneController.this.editText_annata.setText(RicercaStampaOperazioneController.this.editText_annata.getText().substring(0, 4));
                    }
                }
            });
            this.groupStatoFisico = new ToggleGroup();
            this.chk_imbo.setToggleGroup(this.groupStatoFisico);
            this.chk_sfuso.setToggleGroup(this.groupStatoFisico);
            this.chk_tutto.setToggleGroup(this.groupStatoFisico);
        }
        catch (IOException ex) {
            this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
        }
    }

    @FXML
    private void btnRicerca(ActionEvent event) throws IOException, JSONException {
        this.wd = new WorkIndicatorDialog(this.editText_annata.getScene().getWindow(), "Caricamento in corso...");
        this.wd.addTaskEndNotification(result -> {
            System.out.println(result);
            Stage stage = (Stage)this.editText_codice.getScene().getWindow();
            stage.close();
            this.wd = null;
        });
        this.wd.exec("123", inputParam -> {
            try {
                if (this.operazione.equals("AnagTipoVino")) {
                    this.reportAnag("ricerca", 0);
                } else {
                    this.reportTabMovimenti("ricerca");
                }
            }
            catch (IOException | JSONException ex) {
                Logger.getLogger(StampaMovimentiController.class.getName()).log(Level.SEVERE, null, ex);
            }
            return 1;
        });
    }

    @FXML
    private void btnStampa(ActionEvent event) throws IOException, JSONException {
        this.wd = new WorkIndicatorDialog(this.editText_annata.getScene().getWindow(), "Caricamento in corso...");
        this.wd.addTaskEndNotification(result -> {
            System.out.println(result);
            this.wd = null;
            Stage stage = (Stage)this.editText_codice.getScene().getWindow();
            stage.close();
        });
        this.wd.exec("123", inputParam -> {
            try {
                if (this.operazione.equals("AnagTipoVino")) {
                    this.reportAnag("stampa", 1);
                } else {
                    this.reportTabMovimenti("stampa");
                }
            }
            catch (IOException | JSONException ex) {
                Logger.getLogger(StampaMovimentiController.class.getName()).log(Level.SEVERE, null, ex);
            }
            return 1;
        });
    }

    private void reportTabMovimenti(String flag) throws JSONException, IOException {
        String codice = "";
        String data_da = "";
        String data_a = "";
        String annata = "";
        String sigla = "";
        String serie = "";
        String numero = "";
        String progressivo = "";
        codice = this.editText_codice.getText();
        annata = this.editText_annata.getText();
        LocalDate dadate = (LocalDate)this.dtp_da.getValue();
        LocalDate adate = (LocalDate)this.dtp_a.getValue();
        sigla = this.editText_sigla.getText();
        serie = this.editText_serie.getText();
        numero = this.editText_numero.getText();
        progressivo = this.editText_progressivo.getText();
        if (dadate != null) {
            data_da = dadate.toString();
        }
        if (adate != null) {
            data_a = adate.toString();
        }
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String stringa = "";
        String strJson = "";
        if (flag.equals("ricerca")) {
            lastID = new ArrayList();
            tipoSQL = new ArrayList();
            strSQL = new ArrayList();
            lastID.add(false);
            stringa = this.operazione.length() == 2 ? this.stampaMovimenti(data_a, data_da, codice, annata, this.operazione, progressivo) : this.stampaMovimentiDocx(data_a, data_da, codice, annata, this.operazione, sigla, serie, numero, progressivo);
            strSQL.add(stringa);
            tipoSQL.add("select");
            strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
            this.data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
            if (this.data_select.contains("#ERR:")) {
                this.retJSON = "#ERR:" + this.data_select;
                return;
            }
            this.retJSON = this.data_select;
        } else {
            String nomeFile = "";
            ArrayList<String> key = null;
            ArrayList<Object> value = null;
            int tipoFile = 0;
            String nomeFileJRXML = "";
            String resp = "";
            stringa = this.operazione.length() == 2 ? this.stampaMovimenti(data_a, data_da, codice, annata, this.operazione, progressivo) : (this.operazione.equals("DocDup") ? this.stampaDocDup(data_a, data_da, sigla) : this.stampaMovimentiDocx(data_a, data_da, codice, annata, this.operazione, sigla, serie, numero, progressivo));
            key = new ArrayList<String>();
            value = new ArrayList<Object>();
            tipoFile = 0;
            nomeFileJRXML = "";
            key.add("QUERY");
            key.add("AZIENDA");
            key.add("SOTTO_AZ");
            key.add("ICQRF");
            key.add("COD_COMMITTENTE");
            value.add(stringa);
            value.add(FXMLDocumentController.GLOBAL_AZIENDA);
            value.add(FXMLDocumentController.GLOBAL_SOTTOAZZ);
            value.add(FXMLDocumentController.GLOBAL_ICQRF);
            value.add(FXMLDocumentController.GLOBAL_CODCOMM);
            tipoFile = 1;
            nomeFileJRXML = "movimenti_" + this.operazione.toLowerCase() + ".jrxml";
            resp = this.jasperReport.JSONjr(nomeFileJRXML, key, value, tipoFile, "");
            nomeFile = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "JasperReport#@" + resp);
            if (!nomeFile.contains("#ERR:")) {
                this.util.downloadFileTemp(nomeFile);
            } else {
                this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", nomeFile);
            }
        }
    }

    private String stampaMovimentiDocx(String a_data, String da_data, String prodotto, String annata, String cod_oper, String sigla, String serie, String numero, String progressivo) {
        String stringa = "SELECT id,data_oper, cod_oper,numero,serie, sigla, cod_tipo_vino, descrizione, progressivo FROM ( SELECT @idmov := b.id AS id_movimento, a.data_oper AS data_oper, d.sian_cod_oper AS cod_oper, a.azienda AS azienda, a.sotto_az AS sotto_az, a.icqrf AS icqrf, a.cod_committente AS cod_committente,a.id, a.data_oper AS data_doc_mx, a.tipo_oper,a.mx_doc_ser AS serie,mx_doc_num AS numero, a.mx_doc_sigla AS sigla, IF(a.mx_doc_num <> 0, CONCAT(CAST(a.mx_doc_ser AS CHAR(50)), '/', CAST(a.mx_doc_num AS CHAR(50))), '') AS num_doc, b.cod_tipo_vino AS cod_tipo_vino, c.descrizione AS descrizione, a.invio_sian_id AS progressivo FROM c_operazioni AS a LEFT JOIN c_movimenti AS b ON a.id = b.id_oper LEFT JOIN gen_tipo_vino_ana AS c ON b.cod_tipo_vino = c.codice AND b.azienda=c.azienda AND b.sotto_az=c.sotto_az AND b.icqrf=c.icqrf AND b.cod_committente=c.cod_committente LEFT JOIN gen_t_oper_sian AS d ON a.cod_oper = d.tipo_oper WHERE (ISNULL(a.tipo_oper) OR a.tipo_oper='') AND !ISNULL(b.id) AND d.sian_cod_oper='" + cod_oper + "' AND a.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND a.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND a.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND a.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "' ";
        if (da_data.equals("")) {
            da_data = "2017-01-01";
        }
        if (a_data.equals("")) {
            a_data = LocalDate.now().toString();
        }
        stringa = stringa + " AND (a.data_oper >= '" + da_data + "' AND a.data_oper <= '" + a_data + "') ";
        if (!prodotto.equals("")) {
            stringa = stringa + "AND b.cod_tipo_vino = '" + prodotto + "' ";
        }
        if (!annata.equals("")) {
            stringa = stringa + "AND c.sian_annata = '" + annata + "' ";
        }
        if (!cod_oper.equals("")) {
            stringa = stringa + "AND d.sian_cod_oper = '" + cod_oper + "' ";
        }
        if (!sigla.equals("")) {
            stringa = stringa + "AND a.mx_doc_sigla='" + sigla + "' ";
        }
        if (!serie.equals("")) {
            stringa = stringa + "AND a.mx_doc_ser='" + serie + "' ";
        }
        if (!numero.equals("")) {
            stringa = stringa + "AND a.mx_doc_num=" + numero + " ";
        }
        if (!progressivo.equals("")) {
            stringa = stringa + "AND a.invio_sian_id=" + progressivo + " ";
        }
        stringa = stringa + ") AS x GROUP BY id  ORDER BY data_oper ";
        return stringa;
    }

    private String stampaDocDup(String a_data, String da_data, String sigla) {
        String stringa = "SELECT COUNT(a.id) AS conto,a.id,a.azienda,a.sotto_az,a.icqrf,a.cod_committente,a.data_oper AS data_oper,a.mx_doc_sigla AS sigla_documento,a.mx_doc_ser AS serie_documento,a.mx_doc_num AS numero_documento,a.mx_doc_clifor AS clifor_documento,v.sian_cod_oper AS cod_oper,a.tipo_oper FROM c_operazioni AS a LEFT JOIN gen_t_oper_sian AS v ON a.cod_oper=v.tipo_oper WHERE azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND (a.tipo_oper<>'C' OR ISNULL(a.tipo_oper)) AND (v.sian_cod_oper='CASD' OR v.sian_cod_oper='USSD' ) AND (a.mx_doc_sigla<>'CL' AND a.mx_doc_sigla<>'SL')";
        if (da_data.equals("")) {
            da_data = "2017-01-01";
        }
        if (a_data.equals("")) {
            a_data = LocalDate.now().toString();
        }
        stringa = stringa + " AND (a.data_oper >= '" + da_data + "' AND a.data_oper <= '" + a_data + "')   ";
        stringa = !sigla.equals("") ? stringa + "AND a.mx_doc_sigla='" + sigla + "' " : stringa + "AND a.mx_doc_sigla<>'' ";
        stringa = stringa + "GROUP BY a.mx_doc_sigla,a.mx_doc_ser,a.mx_doc_num HAVING conto>1 ORDER BY a.mx_doc_sigla,a.mx_doc_ser,a.mx_doc_num";
        return stringa;
    }

    private String stampaMovimenti(String a_data, String da_data, String prodotto, String annata, String cod_oper, String invio_sian_id) {
        String stringa = "";
        if (cod_oper.equals("VE") || cod_oper.equals("SR") || cod_oper.equals("AQ") || cod_oper.equals("CA") || cod_oper.equals("AU")) {
            stringa = "SELECT a.invio_sian_id,j.sian_cod_oper AS cod_oper,a.id,a.data_oper,a.icqrf,a.azienda,a.sotto_az,b.qta,a.mx_doc_sigla,mx_doc_ser,mx_doc_num,SUM(b.litri) AS litri,a.mx_doc_ser FROM c_operazioni AS a LEFT JOIN c_movimenti AS b ON a.id=b.id_oper LEFT JOIN gen_t_oper_sian AS j ON a.cod_oper=j.tipo_oper WHERE (a.cod_oper='" + cod_oper + "' OR a.cod_oper='" + cod_oper + "') AND (a.tipo_oper='' OR a.tipo_oper IS NULL) AND a.azienda= '" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND a.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND a.sotto_az= '" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND a.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "' ";
            if (!prodotto.equals("")) {
                stringa = "AND b.cod_tipo_vino='" + prodotto + "' ";
            }
            if (da_data.equals("")) {
                da_data = "2017-01-01";
            }
            if (a_data.equals("")) {
                a_data = LocalDate.now().toString();
            }
            stringa = stringa + " AND (a.data_oper >= '" + da_data + "' AND a.data_oper <= '" + a_data + "') ";
            stringa = stringa + "GROUP BY a.id ORDER BY a.data_oper DESC,a.id DESC";
        } else {
            stringa = "SELECT id,data_oper, cod_oper, sigla, num_doc, cod_tipo_vino, descrizione, annata, num_prot_ido, ente_cert, data_ido, confez, lotti, qta,progressivo FROM ( SELECT @idmov := b.id AS id_movimento, a.data_oper AS data_oper, d.sian_cod_oper AS cod_oper, a.azienda AS azienda, a.sotto_az AS sotto_az, a.icqrf AS icqrf, a.cod_committente AS cod_committente,a.id, a.data_oper AS data_doc_mx, a.tipo_oper, a.mx_doc_sigla AS sigla, IF(a.mx_doc_num <> 0, CONCAT(CAST(a.mx_doc_ser AS CHAR(50)), '/', CAST(a.mx_doc_num AS CHAR(50))), '') AS num_doc, b.cod_tipo_vino AS cod_tipo_vino, c.descrizione AS descrizione, c.sian_annata AS annata, if(b.data_ido = '0000-00-00', NULL, b.data_ido) AS data_ido, b.num_prot_ido AS num_prot_ido, b.ente_cert AS ente_cert,b.confez AS confez, IFNULL((SELECT GROUP_CONCAT(CAST(y.cod_lotto AS CHAR) SEPARATOR '|') FROM c_movimenti_lotti AS y WHERE y.id_mov = @idmov GROUP BY y.id_mov),'') AS lotti, b.volume AS volume_nominale, b.qta AS qta, a.invio_sian_id AS progressivo FROM c_operazioni AS a LEFT JOIN c_movimenti AS b ON a.id = b.id_oper LEFT JOIN gen_tipo_vino_ana AS c ON b.cod_tipo_vino = c.codice AND b.azienda=c.azienda AND b.sotto_az=c.sotto_az AND b.icqrf=c.icqrf AND b.cod_committente=c.cod_committente LEFT JOIN gen_t_oper_sian AS d ON a.cod_oper = d.tipo_oper WHERE (ISNULL(a.tipo_oper) OR a.tipo_oper='') AND !ISNULL(b.id)AND a.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND a.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND a.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND a.cod_committente='" + FXMLDocumentController.GLOBAL_CODCOMM + "' ";
            if (da_data.equals("")) {
                da_data = "2017-01-01";
            }
            if (a_data.equals("")) {
                a_data = LocalDate.now().toString();
            }
            stringa = stringa + " AND (a.data_oper >= '" + da_data + "' AND a.data_oper <= '" + a_data + "') ";
            if (!prodotto.equals("")) {
                stringa = stringa + "AND b.cod_tipo_vino = '" + prodotto + "' ";
            }
            if (!annata.equals("")) {
                stringa = stringa + "AND c.sian_annata = '" + annata + "' ";
            }
            if (!cod_oper.equals("")) {
                stringa = stringa + "AND a.cod_oper = '" + cod_oper + "' ";
            }
            if (!invio_sian_id.equals("")) {
                stringa = stringa + "AND a.invio_sian_id = '" + invio_sian_id + "' ";
            }
            stringa = stringa + ") AS x ORDER BY data_oper ";
        }
        return stringa;
    }

    private void reportAnag(String flag, int precancellato) throws JSONException, IOException {
        String codice = this.editText_codice.getText();
        String cod_mx_art = this.editText_artmx.getText().trim();
        String cat_prodotto = this.editText_cod_categoria.getText();
        String classificazione = this.editText_classificazione.getText();
        String atto_certificato = this.editText_atto_certificato.getText();
        String annata = this.editText_annata.getText();
        String sigla = this.editText_sigla.getText();
        String serie = this.editText_serie.getText();
        String numero = this.editText_numero.getText();
        String progressivo = this.editText_progressivo.getText();
        String cod_stato_fisico = this.chk_imbo.isSelected() ? "<> '1'" : (this.chk_sfuso.isSelected() ? "= '1'" : "");
        LocalDate a_data = (LocalDate)this.dtp_a.getValue();
        LocalDate da_data = (LocalDate)this.dtp_da.getValue();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        lastID.add(false);
        String stringa = "SELECT DISTINCT a.id AS ID, a.cancellato,a.codice AS codice, a.descrizione AS descrizione, IFNULL(c.codice,'') AS mexal, sian_cat_prodotto AS categoria,d.DESCRIZIONE AS descr_categoria, sian_classificazione AS classificazione,g.DESCRIZIONE AS descr_classificazione, sian_atto_certificato AS atto_certificato,o.DESCRIZIONE AS descr_attocert, sian_cod_stato_fisico AS stato_fisico,k.DESCRIZIONE AS descr_fisico, sian_colore AS colore,j.DESCRIZIONE AS descr_colore, sian_biologico AS biologico,q.DESCRIZIONE AS descr_bio, sian_codice_dop_igp AS codice_dop_igp,f.Descrizione AS descr_dopigp, sian_cod_sottozona AS sottozona,r.DESCRIZIONE AS descr_sottozona, sian_cod_vigna AS vigna, sian_menzioni AS menzione,";
        if (flag.equals("stampa")) {
            stringa = stringa + "IFNULL(num_prot_ido,'') AS protocollo, IF(data_ido = '0000-00-00', NULL, data_ido) AS data_ido, ";
        }
        stringa = stringa + " sian_cod_ebac AS ebacchus, sian_annata AS annata, sian_annata_percentuale AS perc_annata, sian_varieta AS varieta, sian_perc_varieta AS perc_varieta, sian_origine_uve AS origine_uve, sian_paese AS provenienza, sian_paese_provenienza AS paesi_provenienza, sian_cod_zona_viticola AS zona_viticola, sian_pratiche_eno AS pratiche_enologiche, sian_cod_partita_gg_inv AS codice_partita, sian_massa_volumica AS massa_volumica, a.cod_committente AS cod_committente FROM gen_tipo_vino_ana AS a LEFT JOIN c_movimenti AS b ON a.codice = b.cod_tipo_vino AND a.azienda = b.azienda AND a.sotto_az = b.sotto_az AND a.icqrf = b.icqrf AND a.cod_committente = b.cod_committente LEFT JOIN gen_tipo_vino_ana_mx AS c ON a.id = c.id_tipo_vino_ana AND a.azienda = c.azienda AND a.sotto_az = c.sotto_az AND a.icqrf = c.icqrf AND a.cod_committente = c.cod_committente LEFT JOIN sian_t_dopigp AS f ON a.sian_codice_dop_igp=f.Codice AND f.progressivo='' LEFT JOIN sian_t_stato_fisico AS k ON a.sian_cod_stato_fisico=k.CODICE LEFT JOIN sian_t_colore AS j ON a.sian_colore=j.CODICE LEFT JOIN sian_t_classificazione AS g ON a.sian_classificazione=g.CODICE LEFT JOIN sian_t_atto_certificato AS o ON a.sian_atto_certificato=o.CODICE LEFT JOIN sian_t_categoria AS d ON a.sian_cat_prodotto=d.CODICE LEFT JOIN sian_t_biologico AS q ON a.sian_biologico=q.CODICE LEFT JOIN sian_t_sottozone AS r ON a.sian_cod_sottozona=r.CODICE WHERE a.azienda = '" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND a.sotto_az = '" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND a.icqrf = '" + FXMLDocumentController.GLOBAL_ICQRF + "' AND a.cod_committente = '" + FXMLDocumentController.GLOBAL_CODCOMM + "' ";
        if (!codice.equals("")) {
            stringa = stringa + "AND a.codice='" + codice + "' ";
        }
        if (!cod_mx_art.equals("")) {
            stringa = stringa + " AND c.codice LIKE '%" + cod_mx_art + "%' ";
        }
        if (!cat_prodotto.equals("")) {
            stringa = stringa + "AND a.sian_cat_prodotto='" + cat_prodotto + "' ";
        }
        if (!classificazione.equals("")) {
            stringa = stringa + "AND a.sian_classificazione='" + classificazione + "' ";
        }
        if (!atto_certificato.equals("")) {
            stringa = stringa + "AND a.sian_atto_certificato='" + atto_certificato + "' ";
        }
        if (!cod_stato_fisico.equals("")) {
            stringa = stringa + "AND a.sian_cod_stato_fisico " + cod_stato_fisico + " ";
        }
        if (!annata.equals("")) {
            stringa = stringa + "AND a.sian_annata='" + annata + "' ";
        }
        if (precancellato == 0 && codice.equals("")) {
            stringa = stringa + "AND a.cancellato=0 ";
        }
        stringa = stringa + "ORDER BY codice";
        strSQL.add(stringa);
        tipoSQL.add("select");
        String strJson = this.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
        this.data_select = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!this.data_select.contains("#ERR:")) {
            if (flag.equals("ricerca")) {
                this.retJSON = this.data_select;
            } else {
                String nomeFile = "";
                ArrayList<String> key = null;
                ArrayList<Object> value = null;
                int tipoFile = 0;
                String nomeFileJRXML = "";
                String resp = "";
                key = new ArrayList<String>();
                value = new ArrayList<Object>();
                tipoFile = 0;
                nomeFileJRXML = "";
                key.add("QUERY");
                key.add("AZIENDA");
                key.add("SOTTO_AZ");
                key.add("ICQRF");
                key.add("COD_COMMITTENTE");
                value.add(stringa);
                value.add(FXMLDocumentController.GLOBAL_AZIENDA);
                value.add(FXMLDocumentController.GLOBAL_SOTTOAZZ);
                value.add(FXMLDocumentController.GLOBAL_ICQRF);
                value.add(FXMLDocumentController.GLOBAL_CODCOMM);
                tipoFile = 2;
                nomeFileJRXML = "catalogo.jrxml";
                resp = this.jasperReport.JSONjr(nomeFileJRXML, key, value, tipoFile, "");
                nomeFile = this.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "JasperReport#@" + resp);
                if (!nomeFile.equals("#ERR:")) {
                    String br = this.util.getPathSO();
                    String workingDir = System.getProperty("user.dir");
                    Path p = Paths.get(nomeFile, new String[0]);
                    String fileName = p.getFileName().toString();
                    String pathToSave = workingDir + br + "temp" + br + fileName;
                    boolean ret = this.sk1Comm.Sk1fileDownloadRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "file_download#@" + nomeFile, pathToSave);
                    if (ret && Desktop.isDesktopSupported()) {
                        try {
                            File myFile = new File(pathToSave);
                            Desktop.getDesktop().open(myFile);
                        }
                        catch (IOException ex) {
                            this.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                        }
                    }
                }
            }
        } else {
            this.retJSON = "#ERR:" + this.data_select;
        }
    }

    public String getResult() {
        return this.retJSON;
    }

    public void setOperazione(String val) {
        this.operazione = val;
        switch (val) {
            case "AnagTipoVino": {
                this.btnStampa.setVisible(true);
                this.dtp_a.setVisible(false);
                this.dtp_da.setVisible(false);
                this.label_a_data.setVisible(false);
                this.label_da_data.setVisible(false);
                this.editText_codice.setVisible(true);
                this.editText_artmx.setVisible(true);
                this.label_artmx.setVisible(true);
                this.label_artmx.setManaged(true);
                this.editText_artmx.setManaged(true);
                this.editText_sigla.setManaged(false);
                this.editText_serie.setManaged(false);
                this.editText_numero.setManaged(false);
                this.editText_progressivo.setManaged(false);
                this.editText_sigla.setVisible(false);
                this.editText_serie.setVisible(false);
                this.editText_numero.setVisible(false);
                this.editText_progressivo.setVisible(false);
                this.label_sigla.setVisible(false);
                this.label_serie.setVisible(false);
                this.label_numero.setVisible(false);
                this.label_progressivo.setVisible(false);
                this.editText_cod_categoria.setVisible(true);
                this.editText_classificazione.setVisible(true);
                this.editText_atto_certificato.setVisible(true);
                this.editText_annata.setVisible(true);
                this.label_cod_categoria.setVisible(true);
                this.label_classificazione.setVisible(true);
                this.label_atto_certificato.setVisible(true);
                this.label_annata.setVisible(true);
                this.chk_imbo.setVisible(true);
                this.chk_sfuso.setVisible(true);
                this.chk_tutto.setVisible(true);
                this.chk_tutto.setSelected(true);
                break;
            }
            case "DocDup": {
                this.dtp_a.setVisible(true);
                this.dtp_da.setVisible(true);
                this.btnStampa.setVisible(true);
                this.btnOk.setVisible(false);
                this.label_a_data.setVisible(true);
                this.label_da_data.setVisible(true);
                this.label_artmx.setVisible(false);
                this.editText_artmx.setVisible(false);
                this.label_artmx.setManaged(false);
                this.editText_artmx.setManaged(false);
                this.label_sigla.setVisible(true);
                this.label_serie.setVisible(false);
                this.label_numero.setVisible(false);
                this.label_progressivo.setVisible(false);
                this.editText_cod_categoria.setVisible(false);
                this.editText_classificazione.setVisible(false);
                this.editText_atto_certificato.setVisible(false);
                this.editText_annata.setVisible(false);
                this.label_cod_categoria.setVisible(false);
                this.label_classificazione.setVisible(false);
                this.label_atto_certificato.setVisible(false);
                this.label_annata.setVisible(false);
                this.chk_imbo.setVisible(false);
                this.chk_sfuso.setVisible(false);
                this.chk_tutto.setVisible(false);
                this.chk_tutto.setSelected(false);
                this.editText_sigla.setManaged(true);
                this.editText_serie.setManaged(false);
                this.editText_numero.setManaged(false);
                this.editText_progressivo.setManaged(false);
                this.editText_sigla.setVisible(true);
                this.editText_serie.setVisible(false);
                this.editText_numero.setVisible(false);
                this.editText_progressivo.setVisible(false);
                break;
            }
            case "CASD": {
                this.dtp_a.setVisible(true);
                this.dtp_da.setVisible(true);
                this.btnStampa.setVisible(true);
                this.label_a_data.setVisible(true);
                this.label_da_data.setVisible(true);
                this.label_artmx.setVisible(false);
                this.editText_artmx.setVisible(false);
                this.label_artmx.setManaged(false);
                this.editText_artmx.setManaged(false);
                this.label_sigla.setVisible(true);
                this.label_serie.setVisible(true);
                this.label_numero.setVisible(true);
                this.label_progressivo.setVisible(true);
                this.editText_cod_categoria.setVisible(false);
                this.editText_classificazione.setVisible(false);
                this.editText_atto_certificato.setVisible(false);
                this.editText_annata.setVisible(false);
                this.label_cod_categoria.setVisible(false);
                this.label_classificazione.setVisible(false);
                this.label_atto_certificato.setVisible(false);
                this.label_annata.setVisible(false);
                this.chk_imbo.setVisible(false);
                this.chk_sfuso.setVisible(false);
                this.chk_tutto.setVisible(false);
                this.chk_tutto.setSelected(false);
                this.editText_sigla.setManaged(true);
                this.editText_serie.setManaged(true);
                this.editText_numero.setManaged(true);
                this.editText_progressivo.setManaged(true);
                this.editText_sigla.setVisible(true);
                this.editText_serie.setVisible(true);
                this.editText_numero.setVisible(true);
                this.editText_progressivo.setVisible(true);
                break;
            }
            case "USSD": {
                this.dtp_a.setVisible(true);
                this.dtp_da.setVisible(true);
                this.btnStampa.setVisible(true);
                this.label_a_data.setVisible(true);
                this.label_da_data.setVisible(true);
                this.label_artmx.setVisible(false);
                this.editText_artmx.setVisible(false);
                this.label_artmx.setManaged(false);
                this.editText_artmx.setManaged(false);
                this.editText_sigla.setManaged(true);
                this.editText_serie.setManaged(true);
                this.editText_numero.setManaged(true);
                this.editText_progressivo.setManaged(true);
                this.editText_sigla.setVisible(true);
                this.editText_serie.setVisible(true);
                this.editText_numero.setVisible(true);
                this.editText_progressivo.setVisible(true);
                this.editText_cod_categoria.setVisible(false);
                this.editText_classificazione.setVisible(false);
                this.editText_atto_certificato.setVisible(false);
                this.editText_annata.setVisible(false);
                this.label_cod_categoria.setVisible(false);
                this.label_classificazione.setVisible(false);
                this.label_atto_certificato.setVisible(false);
                this.label_annata.setVisible(false);
                this.chk_imbo.setVisible(false);
                this.chk_sfuso.setVisible(false);
                this.chk_tutto.setVisible(false);
                this.chk_tutto.setSelected(false);
                this.label_sigla.setVisible(true);
                this.label_serie.setVisible(true);
                this.label_numero.setVisible(true);
                this.label_progressivo.setVisible(true);
                break;
            }
            case "AUCO": {
                this.dtp_a.setVisible(true);
                this.dtp_da.setVisible(true);
                this.btnStampa.setVisible(true);
                this.label_a_data.setVisible(true);
                this.label_da_data.setVisible(true);
                this.label_artmx.setVisible(false);
                this.editText_artmx.setVisible(false);
                this.label_artmx.setManaged(false);
                this.editText_artmx.setManaged(false);
                this.editText_sigla.setManaged(true);
                this.editText_serie.setManaged(true);
                this.editText_numero.setManaged(true);
                this.editText_progressivo.setManaged(true);
                this.editText_sigla.setVisible(true);
                this.editText_serie.setVisible(true);
                this.editText_numero.setVisible(true);
                this.editText_progressivo.setVisible(true);
                this.editText_cod_categoria.setVisible(false);
                this.editText_classificazione.setVisible(false);
                this.editText_atto_certificato.setVisible(false);
                this.editText_annata.setVisible(false);
                this.label_cod_categoria.setVisible(false);
                this.label_classificazione.setVisible(false);
                this.label_atto_certificato.setVisible(false);
                this.label_annata.setVisible(false);
                this.chk_imbo.setVisible(false);
                this.chk_sfuso.setVisible(false);
                this.chk_tutto.setVisible(false);
                this.chk_tutto.setSelected(false);
                this.label_sigla.setVisible(true);
                this.label_serie.setVisible(true);
                this.label_numero.setVisible(true);
                this.label_progressivo.setVisible(true);
                break;
            }
            case "GI": {
                this.dtp_a.setVisible(false);
                this.dtp_da.setVisible(false);
                this.btnStampa.setVisible(true);
                this.label_a_data.setVisible(false);
                this.label_da_data.setVisible(false);
                this.label_artmx.setVisible(false);
                this.editText_artmx.setVisible(false);
                this.label_artmx.setManaged(false);
                this.editText_artmx.setManaged(false);
                this.editText_sigla.setManaged(false);
                this.editText_serie.setManaged(false);
                this.editText_numero.setManaged(false);
                this.editText_progressivo.setManaged(false);
                this.editText_sigla.setVisible(false);
                this.editText_serie.setVisible(false);
                this.editText_numero.setVisible(false);
                this.editText_progressivo.setVisible(false);
                this.editText_cod_categoria.setVisible(false);
                this.editText_classificazione.setVisible(false);
                this.editText_atto_certificato.setVisible(false);
                this.editText_annata.setVisible(false);
                this.label_cod_categoria.setVisible(false);
                this.label_classificazione.setVisible(false);
                this.label_atto_certificato.setVisible(false);
                this.label_annata.setVisible(false);
                this.chk_imbo.setVisible(false);
                this.chk_sfuso.setVisible(false);
                this.chk_tutto.setVisible(false);
                this.chk_tutto.setSelected(false);
                this.label_sigla.setVisible(false);
                this.label_serie.setVisible(false);
                this.label_numero.setVisible(false);
                this.label_progressivo.setVisible(false);
                break;
            }
            default: {
                this.dtp_a.setVisible(true);
                this.dtp_da.setVisible(true);
                this.btnStampa.setVisible(true);
                this.label_a_data.setVisible(true);
                this.label_da_data.setVisible(true);
                this.label_artmx.setVisible(false);
                this.editText_artmx.setVisible(false);
                this.label_artmx.setManaged(false);
                this.editText_artmx.setManaged(false);
                this.editText_sigla.setManaged(true);
                this.editText_serie.setManaged(true);
                this.editText_numero.setManaged(true);
                this.editText_progressivo.setManaged(true);
                this.editText_sigla.setVisible(true);
                this.editText_serie.setVisible(true);
                this.editText_numero.setVisible(true);
                this.editText_progressivo.setVisible(true);
                this.editText_cod_categoria.setVisible(false);
                this.editText_classificazione.setVisible(false);
                this.editText_atto_certificato.setVisible(false);
                this.editText_annata.setVisible(false);
                this.label_cod_categoria.setVisible(false);
                this.label_classificazione.setVisible(false);
                this.label_atto_certificato.setVisible(false);
                this.label_annata.setVisible(false);
                this.chk_imbo.setVisible(false);
                this.chk_sfuso.setVisible(false);
                this.chk_tutto.setVisible(false);
                this.chk_tutto.setSelected(false);
                this.label_sigla.setVisible(true);
                this.label_serie.setVisible(true);
                this.label_numero.setVisible(true);
                this.label_progressivo.setVisible(true);
            }
        }
    }
}

