/*
 * Decompiled with CFR 0.152.
 */
package vin.controller;

import java.net.URL;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Alert;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.MouseEvent;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import vin.Class.ColumnTabellaAppezzamenti;
import vin.controller.FXMLDocumentController;

public class RicercaObbiettiviController
implements Initializable {
    String id = "";
    String varieta = "";
    String obbiettivo = "";
    String classificazione = "";
    String classificazionedescr = "";
    String colore = "";
    @FXML
    private TableView<ColumnTabellaAppezzamenti> table;
    @FXML
    private TableColumn<ColumnTabellaAppezzamenti, String> column_obbiettivo;
    @FXML
    private TableColumn<ColumnTabellaAppezzamenti, String> column_classificazione;
    @FXML
    private TableColumn<ColumnTabellaAppezzamenti, String> column_colore;
    @FXML
    private TableColumn<ColumnTabellaAppezzamenti, Integer> column_id;
    ObservableList<ColumnTabellaAppezzamenti> lista = FXCollections.observableArrayList();
    FilteredList<ColumnTabellaAppezzamenti> filteredData = null;
    String coloredescr = "";
    @FXML
    private TextField editText_searcharticolo;

    public void initialize(URL url, ResourceBundle rb) {
        try {
            this.column_id.setCellValueFactory((Callback)new PropertyValueFactory("column_id"));
            this.column_obbiettivo.setCellValueFactory((Callback)new PropertyValueFactory("column_superficie"));
            this.column_classificazione.setCellValueFactory((Callback)new PropertyValueFactory("column_classificazionedescr"));
            this.column_colore.setCellValueFactory((Callback)new PropertyValueFactory("column_coloredescr"));
            this.table.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent e) {
                    if (e.isPrimaryButtonDown() && e.getClickCount() == 2) {
                        ColumnTabellaAppezzamenti f = (ColumnTabellaAppezzamenti)RicercaObbiettiviController.this.table.getSelectionModel().getSelectedItem();
                        RicercaObbiettiviController.this.id = f.getColumn_id() + "";
                        RicercaObbiettiviController.this.obbiettivo = f.getColumn_superficie();
                        RicercaObbiettiviController.this.classificazione = f.getColumn_classificazione();
                        RicercaObbiettiviController.this.classificazionedescr = f.getColumn_classificazionedescr();
                        RicercaObbiettiviController.this.varieta = f.getColumn_varieta();
                        RicercaObbiettiviController.this.colore = f.getColumn_codvarieta();
                        RicercaObbiettiviController.this.coloredescr = f.getColumn_coloredescr();
                        Stage stage = (Stage)RicercaObbiettiviController.this.table.getScene().getWindow();
                        stage.close();
                    }
                }
            });
            this.filteredData = new FilteredList(this.lista, p -> true);
            this.editText_searcharticolo.textProperty().addListener((observable, oldValue, newValue) -> this.filteredData.setPredicate(person -> {
                if (newValue == null || newValue.isEmpty()) {
                    return true;
                }
                String lowerCaseFilter = newValue.toLowerCase();
                if (person.getColumn_classificazione().toLowerCase().contains(lowerCaseFilter)) {
                    return true;
                }
                if (person.getColumn_varieta().toLowerCase().contains(lowerCaseFilter)) {
                    return true;
                }
                return person.getColumn_superficie().toLowerCase().contains(lowerCaseFilter);
            }));
            SortedList sortedData = new SortedList(this.filteredData);
            sortedData.comparatorProperty().bind((ObservableValue)this.table.comparatorProperty());
            this.table.setItems((ObservableList)sortedData);
            this.fillTable();
        }
        catch (JSONException ex) {
            FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
        }
    }

    private void fillTable() throws JSONException {
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        this.lista.clear();
        String str = "SELECT a.id,a.obbiettivo,a.colore,a.varieta,a.classificazione,b.DESCRIZIONE AS classificazionedescr,c.DESCRIZIONE AS coloredescr FROM f_ana_obbiettivi AS a LEFT JOIN sian_t_classificazione AS b ON a.classificazione=b.codice LEFT JOIN sian_t_colore AS c ON a.colore=c.CODICE WHERE a.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND a.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND ISNULL(a.data_mod) ";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = FXMLDocumentController.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = FXMLDocumentController.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    JSONObject rec = arrayJson.getJSONObject(i);
                    this.lista.add((Object)new ColumnTabellaAppezzamenti(rec.getInt("id"), rec.getString("varieta"), rec.getString("obbiettivo"), "", rec.getString("colore"), "", "", rec.getString("classificazione"), rec.getString("classificazionedescr"), rec.getString("coloredescr")));
                    continue;
                }
                catch (Exception ex) {
                    FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                }
            }
        } else {
            FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", data_select);
        }
    }

    public String getVarieta() {
        return this.varieta;
    }

    public String getColore() {
        return this.colore;
    }

    public String getObbiettivo() {
        return this.obbiettivo;
    }

    public String getClassificazione() {
        return this.classificazione;
    }

    public String getClassificazioneDescr() {
        return this.classificazionedescr;
    }

    public String getID() {
        return this.id;
    }
}

