/*
 * Decompiled with CFR 0.152.
 */
package vin.controller;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXDialog;
import com.jfoenix.controls.JFXDialogLayout;
import java.io.IOException;
import java.net.URL;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.text.Text;
import javafx.stage.Modality;
import javafx.stage.Stage;
import org.json.JSONException;
import vin.Class.WorkIndicatorDialog;
import vin.Uility.JasperReport;
import vin.controller.FXMLDocumentController;
import vin.controller.GeneraFileVascheController;
import vin.controller.SearchTipoVinoAnagraficaController;
import vin.controller.StampaMovimentiController;

public class RicercaMVVController
implements Initializable {
    String retJSON = "";
    JasperReport jasperReport = new JasperReport();
    String data_select = "";
    List<String> strSQL;
    List<String> tipoSQL;
    List<Boolean> lastID;
    String strJson = "";
    String operazione = "";
    @FXML
    TextField editText_codice;
    @FXML
    DatePicker dtp_da;
    @FXML
    DatePicker dtp_a;
    @FXML
    TextField editText_numero;
    @FXML
    Button btnStampa;
    @FXML
    Button btnOk;
    WorkIndicatorDialog wd = null;
    @FXML
    private StackPane stack;
    ComboBox<String> edit;

    public void initialize(URL url, ResourceBundle rb) {
        try {
            this.editText_codice.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

                public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                    if (!newValue.equals("") && newValue.length() == 1) {
                        try {
                            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/vin/view/SearchTipoVinoAnagrafica.fxml"));
                            Stage stage = new Stage();
                            stage.setMaximized(false);
                            stage.setTitle("Prodotto");
                            stage.setScene(new Scene((Parent)((Pane)loader.load())));
                            SearchTipoVinoAnagraficaController controller = (SearchTipoVinoAnagraficaController)loader.getController();
                            controller.setSearch(newValue);
                            stage.initModality(Modality.APPLICATION_MODAL);
                            stage.setResizable(false);
                            stage.showAndWait();
                            String codice = controller.getCodice();
                            String descr = controller.getDesString();
                            if (!codice.equals("")) {
                                RicercaMVVController.this.editText_codice.setText(codice);
                            }
                        }
                        catch (IOException ex) {
                            FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                        }
                    }
                }
            });
        }
        catch (Exception ex) {
            FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
        }
    }

    @FXML
    private void btnRicerca(ActionEvent event) throws IOException, JSONException {
        String numero_mvv = this.editText_numero.getText().trim();
        this.wd = new WorkIndicatorDialog(this.editText_codice.getScene().getWindow(), "Caricamento in corso...");
        this.wd.addTaskEndNotification(result -> {
            System.out.println(result);
            Stage stage = (Stage)this.editText_codice.getScene().getWindow();
            stage.close();
            this.wd = null;
        });
        this.wd.exec("123", inputParam -> {
            try {
                this.reportTabMovimenti("REALE");
            }
            catch (IOException | JSONException ex) {
                Logger.getLogger(StampaMovimentiController.class.getName()).log(Level.SEVERE, null, ex);
            }
            return 1;
        });
    }

    private void alertDialogTESTREALE(final String tipoOper) {
        JFXDialogLayout dialogLayout = new JFXDialogLayout();
        dialogLayout.setHeading(new Node[]{new Text("TEST - REALE")});
        this.edit = new ComboBox();
        this.edit.getItems().add((Object)"TEST");
        this.edit.getItems().add((Object)"REALE");
        this.edit.setCursor(Cursor.HAND);
        HBox lolo2 = new HBox();
        lolo2.getChildren().add(this.edit);
        lolo2.setSpacing(5.0);
        lolo2.setAlignment(Pos.CENTER);
        dialogLayout.setBody(new Node[]{lolo2});
        final JFXDialog dialog = new JFXDialog(this.stack, (Region)dialogLayout, JFXDialog.DialogTransition.CENTER);
        dialog.setStyle("-fx-background-color: rgba(221,75,57,0.7);");
        JFXButton btn = new JFXButton("OK");
        btn.setCursor(Cursor.HAND);
        btn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                RicercaMVVController.this.wd = new WorkIndicatorDialog(RicercaMVVController.this.stack.getScene().getWindow(), "Caricamento in corso...");
                RicercaMVVController.this.wd.addTaskEndNotification(result -> {
                    try {
                        System.out.println(result);
                        if (!RicercaMVVController.this.wd.labelWord.equals("")) {
                            FXMLDocumentController.toast.startToast(RicercaMVVController.this.wd.labelWord, "ERRORE", "ERRORE");
                        }
                        RicercaMVVController.this.wd = null;
                    }
                    catch (Exception ex) {
                        Logger.getLogger(GeneraFileVascheController.class.getName()).log(Level.SEVERE, null, ex);
                    }
                });
                RicercaMVVController.this.wd.exec("123", inputParam -> {
                    try {
                        String tipo = (String)RicercaMVVController.this.edit.getSelectionModel().getSelectedItem();
                        if (tipoOper.equals("RICERCA")) {
                            RicercaMVVController.this.reportTabMovimenti(tipo);
                        }
                    }
                    catch (Exception ex) {
                        RicercaMVVController.this.wd.labelWord = ex.getMessage();
                    }
                    return 1;
                });
                dialog.close();
            }
        });
        JFXButton btn2 = new JFXButton("ANNULLA");
        btn2.setCursor(Cursor.HAND);
        btn2.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                dialog.close();
            }
        });
        btn.setPadding(new Insets(5.0));
        btn2.setPadding(new Insets(5.0));
        btn.setStyle("-fx-background-color: #00A65A;-fx-text-fill: #FFFFFF;-fx-font-weight: bold;-fx-font-size: 14px;");
        btn2.setStyle("-fx-background-color: #ACACAC;-fx-text-fill: #FFFFFF;-fx-font-weight: bold;-fx-font-size: 14px;");
        HBox lolo = new HBox();
        lolo.getChildren().add((Object)btn);
        lolo.getChildren().add((Object)btn2);
        lolo.setSpacing(5.0);
        dialogLayout.setActions(new Node[]{lolo});
        dialog.setDialogContainer(this.stack);
        dialog.show();
    }

    private void reportTabMovimenti(String tipoINVIO) throws JSONException, IOException {
        String codice = "";
        String data_da = "";
        String data_a = "";
        String annata = "";
        String numero = "";
        String progressivo = "";
        codice = this.editText_codice.getText();
        LocalDate dadate = (LocalDate)this.dtp_da.getValue();
        LocalDate adate = (LocalDate)this.dtp_a.getValue();
        numero = this.editText_numero.getText();
        if (dadate != null) {
            data_da = dadate.toString();
        }
        if (adate != null) {
            data_a = adate.toString();
        }
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String stringa = "";
        String strJson = "";
        lastID = new ArrayList();
        tipoSQL = new ArrayList();
        strSQL = new ArrayList();
        lastID.add(false);
        stringa = this.stampaMovimenti(data_a, data_da, codice, numero, tipoINVIO);
        strSQL.add(stringa);
        tipoSQL.add("select");
        strJson = FXMLDocumentController.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, null);
        this.data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        this.retJSON = this.data_select.contains("#ERR:") ? "#ERR:" + this.data_select : this.data_select;
    }

    private String stampaMovimenti(String a_data, String da_data, String prodotto, String numero_mvv, String tipoINVIO) {
        String stringa = "";
        stringa = "SELECT b.prodotto,a.id,a.dest_codice,a.acq_codice,a.stato_inviotest,a.marcatemporaletest,a.stato_invioreale,a.marcatemporalereale,a.data_trasporto,a.numeromvvtest,a.numeromvvreale FROM mvv_testata AS a LEFT JOIN mvv_corpo AS b ON a.id=b.id_testata WHERE   a.azienda= '" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND a.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND a.sotto_az= '" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' ";
        if (!prodotto.equals("")) {
            stringa = "AND b.prodotto='" + prodotto + "' ";
        }
        if (!da_data.equals("")) {
            stringa = stringa + "AND a.data_trasporto>='" + da_data + "' ";
        }
        if (!a_data.equals("")) {
            stringa = stringa + "AND a.data_trasporto<='" + a_data + "' ";
        }
        if (!numero_mvv.equals("")) {
            stringa = stringa + "AND a.numeromvv" + tipoINVIO.toLowerCase() + "='" + numero_mvv + "' ";
        }
        stringa = stringa + " GROUP BY a.id ORDER BY a.data_trasporto DESC";
        return stringa;
    }

    public String getResult() {
        return this.retJSON;
    }
}

