/*
 * Decompiled with CFR 0.152.
 */
package vin.controller;

import java.net.URL;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Alert;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.MouseEvent;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import vin.Class.ColumnTableCodiceDescrizione;
import vin.controller.FXMLDocumentController;

public class RicercaConferentiController
implements Initializable {
    String id = "";
    String codice = "";
    String descrizione = "";
    @FXML
    private TableView<ColumnTableCodiceDescrizione> table;
    @FXML
    private TableColumn<ColumnTableCodiceDescrizione, String> column_codice;
    @FXML
    private TableColumn<ColumnTableCodiceDescrizione, String> column_descrizione;
    @FXML
    private TableColumn<ColumnTableCodiceDescrizione, Integer> column_id;
    ObservableList<ColumnTableCodiceDescrizione> lista = FXCollections.observableArrayList();
    FilteredList<ColumnTableCodiceDescrizione> filteredData = null;
    @FXML
    private TextField editText_searcharticolo;

    public void initialize(URL url, ResourceBundle rb) {
        try {
            this.column_id.setCellValueFactory((Callback)new PropertyValueFactory("column_id"));
            this.column_codice.setCellValueFactory((Callback)new PropertyValueFactory("column_codice"));
            this.column_descrizione.setCellValueFactory((Callback)new PropertyValueFactory("column_descrizione"));
            this.table.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent e) {
                    if (e.isPrimaryButtonDown() && e.getClickCount() == 2) {
                        ColumnTableCodiceDescrizione f = (ColumnTableCodiceDescrizione)RicercaConferentiController.this.table.getSelectionModel().getSelectedItem();
                        RicercaConferentiController.this.codice = f.getColumn_codice();
                        RicercaConferentiController.this.id = f.getColumn_id() + "";
                        RicercaConferentiController.this.descrizione = f.getColumn_descrizione();
                        Stage stage = (Stage)RicercaConferentiController.this.table.getScene().getWindow();
                        stage.close();
                    }
                }
            });
            this.filteredData = new FilteredList(this.lista, p -> true);
            this.editText_searcharticolo.textProperty().addListener((observable, oldValue, newValue) -> this.filteredData.setPredicate(person -> {
                if (newValue == null || newValue.isEmpty()) {
                    return true;
                }
                String lowerCaseFilter = newValue.toLowerCase();
                if (person.getColumn_codice().toLowerCase().contains(lowerCaseFilter)) {
                    return true;
                }
                return person.getColumn_descrizione().toLowerCase().contains(lowerCaseFilter);
            }));
            SortedList sortedData = new SortedList(this.filteredData);
            sortedData.comparatorProperty().bind((ObservableValue)this.table.comparatorProperty());
            this.table.setItems((ObservableList)sortedData);
            this.fillTable();
        }
        catch (JSONException ex) {
            FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
        }
    }

    private void fillTable() throws JSONException {
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        this.lista.clear();
        String str = "SELECT a.id,a.cod_forn,b.rag_soc,b.nome,b.cognome FROM f_ana_fornitore AS a LEFT JOIN gen_ana_clifor AS b ON a.cod_forn=b.codice AND a.azienda=b.azienda ANd a.sotto_az=b.sotto_az  WHERE a.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND a.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND a.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "'  ";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = FXMLDocumentController.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = FXMLDocumentController.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    JSONObject rec = arrayJson.getJSONObject(i);
                    String descr = "";
                    String rag_soc = rec.getString("rag_soc");
                    String nome = rec.getString("nome");
                    String cognome = rec.getString("cognome");
                    descr = rag_soc.equals("") ? nome + " " + cognome : rag_soc;
                    this.lista.add((Object)new ColumnTableCodiceDescrizione(rec.getInt("id"), rec.getString("cod_forn"), descr));
                    continue;
                }
                catch (Exception ex) {
                    FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                }
            }
        } else {
            FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", data_select);
        }
    }

    public String getCodice() {
        return this.codice;
    }

    public String getDescrizione() {
        return this.descrizione;
    }

    public String getID() {
        return this.id;
    }
}

