/*
 * Decompiled with CFR 0.152.
 */
package vin.controller;

import java.net.URL;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.MouseEvent;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import vin.Class.ColumnTableGridSearch;
import vin.Comunicator.Sk1SrvCommunicator;
import vin.Uility.JsonUtils;

public class GridSearchController
implements Initializable {
    String strJsonsearch = "";
    String strJSONreturn = "";
    ObservableList<ColumnTableGridSearch> lista_gridsearch = null;
    Sk1SrvCommunicator sk1Comm = new Sk1SrvCommunicator();
    JsonUtils jsonUtil = new JsonUtils();
    @FXML
    TableView<ColumnTableGridSearch> table_gridsearch;
    @FXML
    TableColumn<ColumnTableGridSearch, String> column_codice;
    @FXML
    TableColumn<ColumnTableGridSearch, String> column_ragsoc;
    @FXML
    TableColumn<ColumnTableGridSearch, String> column_indirizzo;
    @FXML
    TableColumn<ColumnTableGridSearch, String> column_localita;
    @FXML
    TableColumn<ColumnTableGridSearch, String> column_cap;
    @FXML
    TableColumn<ColumnTableGridSearch, String> column_provincia;

    public void initialize(URL url, ResourceBundle rb) {
        this.lista_gridsearch = FXCollections.observableArrayList();
        this.column_codice.setCellValueFactory((Callback)new PropertyValueFactory("column_codice"));
        this.column_ragsoc.setCellValueFactory((Callback)new PropertyValueFactory("column_ragsoc"));
        this.column_indirizzo.setCellValueFactory((Callback)new PropertyValueFactory("column_indirizzo"));
        this.column_localita.setCellValueFactory((Callback)new PropertyValueFactory("column_localita"));
        this.column_cap.setCellValueFactory((Callback)new PropertyValueFactory("column_cap"));
        this.column_provincia.setCellValueFactory((Callback)new PropertyValueFactory("column_provincia"));
        this.table_gridsearch.setItems(this.lista_gridsearch);
        this.table_gridsearch.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent e) {
                if (e.isPrimaryButtonDown() && e.getClickCount() == 2) {
                    ColumnTableGridSearch f = (ColumnTableGridSearch)GridSearchController.this.table_gridsearch.getSelectionModel().getSelectedItem();
                    GridSearchController.this.strJSONreturn = f.getColumn_codice();
                    Stage stage = (Stage)GridSearchController.this.table_gridsearch.getScene().getWindow();
                    stage.close();
                }
            }
        });
    }

    public String setStringSearch(String search) {
        String descrizione = "";
        String codice = "";
        String localita = "";
        String cap = "";
        String provincia = "";
        String indirizzo = "";
        JSONArray arrayJson = this.jsonUtil.strJsonToJSONArray(search);
        for (int k = 0; k < arrayJson.length(); ++k) {
            try {
                JSONObject rec = arrayJson.getJSONObject(k);
                descrizione = rec.getString("descrizione");
                codice = rec.getString("codice");
                indirizzo = rec.getString("indirizzo");
                localita = rec.getString("localita");
                cap = String.valueOf(rec.getDouble("cap")).replace(".0", "");
                provincia = rec.getString("provincia");
                this.lista_gridsearch.add((Object)new ColumnTableGridSearch(codice, descrizione, indirizzo, localita, cap, provincia));
                continue;
            }
            catch (JSONException ex) {
                Logger.getLogger(GridSearchController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.table_gridsearch.setItems(this.lista_gridsearch);
        return "";
    }

    public String getStringJSONSearch() {
        String ret = "";
        ret = this.strJSONreturn;
        return ret;
    }
}

