/*
 * Decompiled with CFR 0.152.
 */
package vin.controller;

import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.controls.JFXTextField;
import java.io.IOException;
import java.net.URL;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.TextFormatter;
import javafx.stage.Modality;
import javafx.stage.Stage;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import vin.Class.CodiceDescrizioneComboBox;
import vin.controller.FXMLDocumentController;
import vin.controller.SearchTableCodiceDescrizioneController;

public class FinestraObbiettivoController
implements Initializable {
    @FXML
    private JFXComboBox<CodiceDescrizioneComboBox> cmbx_categoria;
    @FXML
    private JFXComboBox<CodiceDescrizioneComboBox> cmbx_classificazione;
    @FXML
    private JFXTextField editText_kgceppo;
    @FXML
    private JFXTextField editText_gradomin;
    @FXML
    private JFXTextField editText_percpiu;
    @FXML
    private JFXTextField editText_percmeno;
    boolean flg_modifica = false;
    String id_mod = "";
    @FXML
    private JFXTextField editText_supperc;
    @FXML
    private JFXTextField editText_suppercdisc;
    @FXML
    private JFXTextField editText_prezzo;
    @FXML
    private JFXTextField editText_obbiettivo;
    @FXML
    private JFXTextField editText_varieta;

    @FXML
    void btnCerca(ActionEvent event) throws JSONException, IOException {
        FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/vin/view/SearchTableCodiceDescrizione.fxml"));
        Parent rootLayout = (Parent)loader.load();
        Scene scene = new Scene(rootLayout);
        Stage stage = new Stage();
        stage.setTitle("Variet\u00e0");
        stage.setScene(scene);
        SearchTableCodiceDescrizioneController controller = (SearchTableCodiceDescrizioneController)loader.getController();
        controller.setTable("sian_t_varieta");
        stage.initModality(Modality.APPLICATION_MODAL);
        stage.setResizable(true);
        stage.showAndWait();
        String codice = controller.getCodice();
        String descr = controller.getDescrizione();
        if (!codice.equals("")) {
            this.editText_varieta.setText(codice);
        }
    }

    @FXML
    void btnRemove(ActionEvent event) {
        this.editText_varieta.setText("");
    }

    /*
     * Enabled aggressive block sorting
     */
    @FXML
    void btnSalva(ActionEvent event) throws JSONException {
        String obbiettivo = this.editText_obbiettivo.getText().trim();
        String varieta = this.editText_varieta.getText().trim();
        String nrceppi = "0";
        String percmeno = this.editText_percmeno.getText().trim();
        String percpiu = this.editText_percpiu.getText().trim();
        String prezzo = this.editText_prezzo.getText().trim();
        String supperc = this.editText_supperc.getText().trim();
        String suppercdisc = this.editText_suppercdisc.getText().trim();
        String classificazione = "";
        String categoria = "";
        if (this.cmbx_categoria.getSelectionModel().getSelectedItem() != null) {
            categoria = ((CodiceDescrizioneComboBox)this.cmbx_categoria.getSelectionModel().getSelectedItem()).getCodice();
        }
        if (this.cmbx_classificazione.getSelectionModel().getSelectedItem() != null) {
            classificazione = ((CodiceDescrizioneComboBox)this.cmbx_classificazione.getSelectionModel().getSelectedItem()).getCodice();
        }
        String kgceppo = this.editText_kgceppo.getText().trim();
        String gradomin = this.editText_gradomin.getText().trim();
        if (obbiettivo.equals("")) {
            obbiettivo = "0";
        }
        if (percmeno.equals("")) {
            percmeno = "0.0";
        }
        if (percpiu.equals("")) {
            percpiu = "0.0";
        }
        if (prezzo.equals("")) {
            prezzo = "0.0";
        }
        if (supperc.equals("")) {
            supperc = "0.0";
        }
        if (suppercdisc.equals("")) {
            suppercdisc = "0.0";
        }
        if (kgceppo.equals("")) {
            kgceppo = "0.0";
        }
        if (gradomin.equals("")) {
            gradomin = "0.0";
        }
        String[] campi_vuoti = new String[30];
        int count = 0;
        if (categoria.equals("")) {
            campi_vuoti[count] = "(Colore) Campo bloccante";
            ++count;
        }
        if (obbiettivo.equals("")) {
            campi_vuoti[count] = "(Obbiettivo) Campo bloccante";
            ++count;
        }
        if (Double.parseDouble(kgceppo) == 0.0) {
            campi_vuoti[count] = "(Kg/Ceppo) Campo bloccante";
            ++count;
        }
        if (Double.parseDouble(gradomin) == 0.0) {
            campi_vuoti[count] = "(Grado Min) Campo bloccante";
            ++count;
        }
        if (campi_vuoti[0] != null) {
            StringBuilder builder = new StringBuilder();
            String[] stringArray = campi_vuoti;
            int n = stringArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE:", "VALIDAZIONE", builder.toString());
                    return;
                }
                String s = stringArray[n2];
                if (s != null) {
                    builder.append(s + "\r\n");
                }
                ++n2;
            }
        }
        String h = "";
        if (!this.flg_modifica) {
            boolean rt = this.getIfObbiettivoEsiste(obbiettivo);
            if (rt) {
                FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE:", "VALIDAZIONE", "Obbiettivo gi\u00e0 presente per l'anno inserito");
                return;
            }
            boolean res = this.insert(obbiettivo, categoria, gradomin, kgceppo, percpiu, percmeno, supperc, prezzo, "", nrceppi, varieta, classificazione, suppercdisc);
            if (!res) {
                return;
            }
            FXMLDocumentController.toast.startToast("Operazione completata.", "SUCCESSO", "SUCCESSO");
        } else {
            String data_mod = LocalDate.now().toString();
            boolean res = this.update(obbiettivo, categoria, gradomin, kgceppo, percpiu, percmeno, supperc, prezzo, data_mod, nrceppi, varieta, classificazione, suppercdisc);
            if (!res) {
                return;
            }
            FXMLDocumentController.toast.startToast("Operazione completata.", "SUCCESSO", "SUCCESSO");
        }
        Stage stage = (Stage)this.editText_gradomin.getScene().getWindow();
        stage.close();
    }

    public void setLoadField() throws JSONException {
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        int year = Calendar.getInstance().get(1);
        String str = "SELECT a.suppercdisc,c.codice AS codice_class,c.descrizione AS descr_class,a.varieta,a.nr_ceppi,b.descrizione,a.id,a.obbiettivo,a.colore,a.kg_ceppo,a.grado_min,a.perc_piu,a.perc_meno,a.sup_perc,a.prezzo,a.data_mod FROM f_ana_obbiettivi AS a LEFT JOIN sian_t_colore AS b ON a.colore=b.codice LEFT JOIN sian_t_classificazione AS c ON a.classificazione=c.codice WHERE  a.azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND a.sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND a.icqrf='" + FXMLDocumentController.GLOBAL_ICQRF + "' AND a.id=" + this.id_mod;
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = FXMLDocumentController.util.makeStringJsonDB("OFF", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = FXMLDocumentController.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    JSONObject rec = arrayJson.getJSONObject(i);
                    String obb = rec.getString("obbiettivo");
                    String categoria = rec.getString("colore");
                    String descr_uva = rec.getString("descrizione");
                    String codice_class = rec.getString("codice_class");
                    String descr_class = rec.getString("descr_class");
                    String varieta = rec.getString("varieta");
                    Double kgceppo = rec.getDouble("kg_ceppo");
                    Double gradomin = rec.getDouble("grado_min");
                    String we = rec.get("suppercdisc").toString().trim().replace("null", "");
                    this.editText_suppercdisc.setText(we);
                    Double percpiu = 0.0;
                    Double percmeno = 0.0;
                    Double supperc = rec.getDouble("sup_perc");
                    Double prezzo = rec.getDouble("prezzo");
                    Double nrceppi = rec.getDouble("nr_ceppi");
                    this.editText_obbiettivo.setText(obb);
                    this.editText_kgceppo.setText(String.valueOf(kgceppo));
                    this.editText_percmeno.setText(String.valueOf(percmeno));
                    this.editText_percpiu.setText(String.valueOf(percpiu));
                    this.editText_gradomin.setText(String.valueOf(gradomin));
                    this.editText_prezzo.setText(String.valueOf(prezzo));
                    this.editText_supperc.setText(String.valueOf(supperc));
                    this.editText_varieta.setText(varieta);
                    CodiceDescrizioneComboBox er = new CodiceDescrizioneComboBox(categoria, descr_uva);
                    if (er != null) {
                        this.cmbx_categoria.getSelectionModel().select((Object)er);
                    } else {
                        this.cmbx_categoria.getSelectionModel().selectFirst();
                    }
                    er = new CodiceDescrizioneComboBox(codice_class, descr_class);
                    if (er != null) {
                        this.cmbx_classificazione.getSelectionModel().select((Object)er);
                    } else {
                        this.cmbx_classificazione.getSelectionModel().selectFirst();
                    }
                    this.editText_obbiettivo.setEditable(false);
                    continue;
                }
                catch (Exception ex) {
                    FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                }
            }
        } else {
            FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", data_select);
        }
    }

    public boolean isFlg_modifica() {
        return this.flg_modifica;
    }

    public void setFlg_modifica(boolean flg_modifica) {
        this.flg_modifica = flg_modifica;
    }

    public void setId_mod(String id_mod) {
        this.id_mod = id_mod;
    }

    private boolean update(String obbiettivo, String categoria, String gradomin, String kgceppo, String percpiu, String percmeno, String supperc, String prezzo, String data_mod, String nrceppi, String varieta, String classificazione, String suppercdisc) throws JSONException {
        boolean ret = false;
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String str = "";
        String data_select = "";
        String[][] tipo_ins = null;
        String[][] valore = null;
        int iterator = 0;
        int towt = 2;
        tipo_ins = new String[towt][35];
        valore = new String[towt][35];
        String strSQLstringa = "UPDATE  f_ana_obbiettivi  SET data_mod='" + data_mod + "'  WHERE  id=" + this.id_mod;
        strSQL.add(strSQLstringa);
        tipoSQL.add("delete");
        lenghtBidimensionalArray.add(0);
        lastID.add(false);
        tipo_ins[iterator][0] = "";
        valore[iterator][0] = "";
        ++iterator;
        FXMLDocumentController.sqlUtil.insert_f_ana_obbiettivi(FXMLDocumentController.GLOBAL_AZIENDA, FXMLDocumentController.GLOBAL_SOTTOAZZ, FXMLDocumentController.GLOBAL_ICQRF, obbiettivo, categoria, gradomin, kgceppo, percpiu, percmeno, supperc, prezzo, "", nrceppi, varieta, classificazione, suppercdisc);
        strSQL.addAll(FXMLDocumentController.sqlUtil.strSQL);
        tipoSQL.addAll(FXMLDocumentController.sqlUtil.tipoinsSQL);
        lenghtBidimensionalArray.addAll(FXMLDocumentController.sqlUtil.lengthSQL);
        lastID.addAll(FXMLDocumentController.sqlUtil.lastID);
        tipo_ins[iterator] = FXMLDocumentController.sqlUtil.tipovaloreSQL.toArray(new String[0]);
        valore[iterator] = FXMLDocumentController.sqlUtil.valoreSQL.toArray(new String[0]);
        ++iterator;
        String strJson = FXMLDocumentController.util.makeStringJsonDB("ON", tipoSQL, strSQL, tipo_ins, valore, lastID, lenghtBidimensionalArray);
        data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            ret = true;
        } else {
            FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", data_select);
        }
        return ret;
    }

    private boolean insert(String obbiettivo, String categoria, String gradomin, String kgceppo, String percpiu, String percmeno, String supperc, String prezzo, String data_mod, String nrceppi, String varieta, String classificazione, String suppercdisc) throws JSONException {
        int iterator = 0;
        boolean rt = false;
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String str = "";
        String data_select = "";
        String[][] tipo_ins = null;
        String[][] valore = null;
        int towt = 1;
        tipo_ins = new String[towt][35];
        valore = new String[towt][35];
        FXMLDocumentController.sqlUtil.insert_f_ana_obbiettivi(FXMLDocumentController.GLOBAL_AZIENDA, FXMLDocumentController.GLOBAL_SOTTOAZZ, FXMLDocumentController.GLOBAL_ICQRF, obbiettivo, categoria, gradomin, kgceppo, percpiu, percmeno, supperc, prezzo, data_mod, nrceppi, varieta, classificazione, suppercdisc);
        strSQL.addAll(FXMLDocumentController.sqlUtil.strSQL);
        tipoSQL.addAll(FXMLDocumentController.sqlUtil.tipoinsSQL);
        lenghtBidimensionalArray.addAll(FXMLDocumentController.sqlUtil.lengthSQL);
        lastID.addAll(FXMLDocumentController.sqlUtil.lastID);
        tipo_ins[iterator] = FXMLDocumentController.sqlUtil.tipovaloreSQL.toArray(new String[0]);
        valore[iterator] = FXMLDocumentController.sqlUtil.valoreSQL.toArray(new String[0]);
        ++iterator;
        String strJson = FXMLDocumentController.util.makeStringJsonDB("ON", tipoSQL, strSQL, tipo_ins, valore, lastID, lenghtBidimensionalArray);
        data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            rt = true;
        } else {
            FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", data_select);
        }
        return rt;
    }

    private boolean getIfObbiettivoEsiste(String obbiettivo) throws JSONException {
        boolean ret = false;
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT id FROM f_ana_obbiettivi WHERE ISNULL(data_mod) AND obbiettivo='" + obbiettivo + "' AND azienda='" + FXMLDocumentController.GLOBAL_AZIENDA + "' AND sotto_az='" + FXMLDocumentController.GLOBAL_SOTTOAZZ + "' AND sotto_az='" + FXMLDocumentController.GLOBAL_ICQRF + "' ";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = FXMLDocumentController.util.makeStringJsonDB("ON", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            JSONArray arrayJson = FXMLDocumentController.jsonUtil.strJsonToJSONArray(data_select);
            if (arrayJson.length() > 0) {
                ret = true;
            }
        } else {
            FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", data_select);
        }
        return ret;
    }

    @FXML
    void btnAnnulla(ActionEvent event) {
        Stage stage = (Stage)this.editText_gradomin.getScene().getWindow();
        stage.close();
    }

    public void initialize(URL url, ResourceBundle rb) {
        try {
            this.fillCombo();
            this.fillComboClassificazione();
            Pattern pattern = Pattern.compile("\\d*|\\d+\\.\\d*");
            TextFormatter formatter = new TextFormatter(change -> pattern.matcher(change.getControlNewText()).matches() ? change : null);
            Pattern pattern2 = Pattern.compile("\\d*|\\d+\\.\\d*");
            TextFormatter formatter2 = new TextFormatter(change -> pattern2.matcher(change.getControlNewText()).matches() ? change : null);
            Pattern pattern3 = Pattern.compile("\\d*|\\d+\\.\\d*");
            TextFormatter formatter3 = new TextFormatter(change -> pattern3.matcher(change.getControlNewText()).matches() ? change : null);
            Pattern pattern4 = Pattern.compile("\\d*|\\d+\\.\\d*");
            TextFormatter formatter4 = new TextFormatter(change -> pattern4.matcher(change.getControlNewText()).matches() ? change : null);
            Pattern pattern5 = Pattern.compile("\\d*|\\d+\\.\\d*");
            TextFormatter formatter5 = new TextFormatter(change -> pattern5.matcher(change.getControlNewText()).matches() ? change : null);
            Pattern pattern6 = Pattern.compile("\\d*|\\d+\\.\\d*");
            TextFormatter formatter6 = new TextFormatter(change -> pattern6.matcher(change.getControlNewText()).matches() ? change : null);
            Pattern pattern7 = Pattern.compile("\\d*|\\d+\\.\\d*");
            TextFormatter formatter7 = new TextFormatter(change -> pattern7.matcher(change.getControlNewText()).matches() ? change : null);
            this.editText_prezzo.setTextFormatter(formatter);
            this.editText_gradomin.setTextFormatter(formatter2);
            this.editText_kgceppo.setTextFormatter(formatter3);
            this.editText_percmeno.setTextFormatter(formatter4);
            this.editText_percpiu.setTextFormatter(formatter5);
            this.editText_percpiu.setVisible(false);
            this.editText_percmeno.setVisible(false);
            this.editText_percpiu.setManaged(false);
            this.editText_percmeno.setManaged(false);
            this.editText_supperc.setTextFormatter(formatter6);
            this.editText_suppercdisc.setTextFormatter(formatter7);
        }
        catch (JSONException ex) {
            Logger.getLogger(FinestraObbiettivoController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void fillCombo() throws JSONException {
        ObservableList lista = FXCollections.observableArrayList();
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT CODICE,DESCRIZIONE FROM sian_t_colore ";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = FXMLDocumentController.util.makeStringJsonDB("ON", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            lista.add(null);
            JSONArray arrayJson = FXMLDocumentController.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    JSONObject rec = arrayJson.getJSONObject(i);
                    lista.add((Object)new CodiceDescrizioneComboBox(rec.getString("codice"), rec.getString("descrizione")));
                    continue;
                }
                catch (Exception ex) {
                    FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                }
            }
        } else {
            FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", data_select);
        }
        this.cmbx_categoria.setItems(lista);
    }

    private void fillComboClassificazione() throws JSONException {
        ObservableList lista = FXCollections.observableArrayList();
        ArrayList<String> tipoSQL = new ArrayList<String>();
        ArrayList<String> strSQL = new ArrayList<String>();
        ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
        ArrayList<Boolean> lastID = new ArrayList<Boolean>();
        String data_select = "";
        lastID.add(false);
        String str = "SELECT CODICE,DESCRIZIONE FROM sian_t_classificazione ";
        strSQL.add(str);
        tipoSQL.add("select");
        lenghtBidimensionalArray.add(0);
        String strJson = FXMLDocumentController.util.makeStringJsonDB("ON", tipoSQL, strSQL, null, null, lastID, lenghtBidimensionalArray);
        data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
        if (!data_select.contains("#ERR:")) {
            lista.add(null);
            JSONArray arrayJson = FXMLDocumentController.jsonUtil.strJsonToJSONArray(data_select);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    JSONObject rec = arrayJson.getJSONObject(i);
                    lista.add((Object)new CodiceDescrizioneComboBox(rec.getString("codice"), rec.getString("descrizione")));
                    continue;
                }
                catch (Exception ex) {
                    FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
                }
            }
        } else {
            FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", data_select);
        }
        this.cmbx_classificazione.setItems(lista);
    }
}

