/*
 * Decompiled with CFR 0.152.
 */
package vin.controller;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ChoiceDialog;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.Pane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import vin.Class.CodiceDescrizione;
import vin.Class.ColumnTableAzzeramentoVasi;
import vin.Class.ColumnTableSearchVascheGiacenza;
import vin.Class.EditingCellDoublePool;
import vin.Class.IdoneitaImbSfuso;
import vin.controller.FXMLDocumentController;
import vin.controller.SearchProdottoController_2;
import vin.controller.SearchVasca_2;

public class AzzeramentoVascheController
implements Initializable {
    ObservableList<ColumnTableAzzeramentoVasi> lista = null;
    FilteredList<ColumnTableAzzeramentoVasi> filteredData = null;
    @FXML
    private TableView<ColumnTableAzzeramentoVasi> table;
    @FXML
    private TableColumn<ColumnTableAzzeramentoVasi, Integer> column_id;
    @FXML
    private TableColumn<ColumnTableAzzeramentoVasi, String> column_prodotto;
    @FXML
    private TableColumn<ColumnTableAzzeramentoVasi, String> column_codicevaso;
    @FXML
    private TableColumn<ColumnTableAzzeramentoVasi, Double> column_qta;
    @FXML
    private TableColumn<ColumnTableAzzeramentoVasi, String> column_numprot;
    @FXML
    private TableColumn<ColumnTableAzzeramentoVasi, String> column_dataido;
    @FXML
    private TableColumn<ColumnTableAzzeramentoVasi, String> columnentecert;
    @FXML
    private TableColumn<ColumnTableAzzeramentoVasi, String> column_descrizione;
    public ObservableList<IdoneitaImbSfuso> lista_cmbxidoneita_ve = FXCollections.observableArrayList();

    public String choiceInputDialog(String title, String headerText, String contentText, List choices) {
        ChoiceDialog choice = new ChoiceDialog(null, (Collection)choices);
        choice.setResultConverter(type -> {
            ButtonBar.ButtonData data;
            ButtonBar.ButtonData buttonData = data = type == null ? null : type.getButtonData();
            if (data == ButtonBar.ButtonData.HELP) {
                return "DEBUG@" + (String)choice.getSelectedItem();
            }
            if (data == ButtonBar.ButtonData.OK_DONE) {
                return "OK@" + ((String)choice.getSelectedItem()).toString();
            }
            if (data == ButtonBar.ButtonData.CANCEL_CLOSE) {
                return "#ERR@Campo vuoto";
            }
            return null;
        });
        choice.setTitle(title);
        choice.setHeaderText(headerText);
        choice.setContentText(contentText);
        Optional result = choice.showAndWait();
        if (result.isPresent()) {
            return (String)choice.getSelectedItem();
        }
        return "";
    }

    @FXML
    void btnSalva(ActionEvent event) throws ParseException {
        try {
            int iterator = 0;
            Double qta = 0.0;
            HashMap map = FXMLDocumentController.util.getParameters();
            boolean SIAN_INVIO_VASI = Boolean.parseBoolean(map.get("SIAN_INVIO_VASI").toString());
            Double qtaC = 0.0;
            boolean iteratorVasca = false;
            boolean iteratorProdotto = false;
            double qtaKg = 0.0;
            String num_protC = "";
            String data_idoC = "";
            String ente_certC = "";
            ArrayList<String> tipoSQL = new ArrayList<String>();
            ArrayList<String> strSQL = new ArrayList<String>();
            ArrayList<Integer> lenghtBidimensionalArray = new ArrayList<Integer>();
            ArrayList<Boolean> lastID = new ArrayList<Boolean>();
            String str = "";
            String data_select = "";
            String[][] tipo_ins = new String[2 + 3 * this.lista.size()][35];
            String[][] valore = new String[2 + 3 * this.lista.size()][35];
            String cod_prod_mx = "";
            String res = "";
            String categoria = "";
            String um = "";
            String sian = "";
            JSONArray ar = null;
            double massa = 0.0;
            double volume_nominale = 0.0;
            String stato_fisico = "";
            FXMLDocumentController.sqlUtil.insert_c_operazioni(FXMLDocumentController.GLOBAL_AZIENDA, FXMLDocumentController.GLOBAL_SOTTOAZZ, FXMLDocumentController.GLOBAL_ICQRF, "AZZERAMENTO", LocalDate.now().toString(), "0", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "0", FXMLDocumentController.GLOBAL_CODCOMM, "", "AZZERAMENTO VASI", "0", "", "", "", "0", "", "", "", "");
            strSQL.addAll(FXMLDocumentController.sqlUtil.strSQL);
            tipoSQL.addAll(FXMLDocumentController.sqlUtil.tipoinsSQL);
            lenghtBidimensionalArray.addAll(FXMLDocumentController.sqlUtil.lengthSQL);
            lastID.addAll(FXMLDocumentController.sqlUtil.lastID);
            tipo_ins[iterator] = FXMLDocumentController.sqlUtil.tipovaloreSQL.toArray(new String[0]);
            valore[iterator] = FXMLDocumentController.sqlUtil.valoreSQL.toArray(new String[0]);
            ++iterator;
            lastID.add(false);
            tipoSQL.add("insert");
            strSQL.add("SET @id_oper:=(LAST_INSERT_ID());");
            lenghtBidimensionalArray.add(0);
            tipo_ins[iterator][0] = "";
            valore[iterator][0] = "";
            ++iterator;
            for (int i = 0; i < this.lista.size(); ++i) {
                String prodotto = ((ColumnTableAzzeramentoVasi)this.lista.get(i)).getColumn_prodotto();
                res = FXMLDocumentController.ricerca.getMXProdottoFromProdotto(prodotto);
                if (!res.equals("#ERR")) {
                    cod_prod_mx = res.replace("null", "");
                }
                stato_fisico = "";
                categoria = FXMLDocumentController.ricerca.getCategoriaProdottofromProdotto(prodotto);
                um = FXMLDocumentController.ricerca.getUMfromCategoriaProdotto(categoria);
                sian = FXMLDocumentController.ricerca.getSianAnaProdotto(prodotto);
                ar = FXMLDocumentController.jsonUtil.strJsonToJSONArray(sian);
                massa = 0.0;
                volume_nominale = 0.0;
                for (int j = 0; j < ar.length(); ++j) {
                    JSONObject obj = ar.getJSONObject(j);
                    stato_fisico = obj.getString("sian_cod_stato_fisico");
                    massa = obj.getDouble("sian_massa_volumica");
                    volume_nominale = obj.getDouble("sian_volume_nominale");
                }
                qta = ((ColumnTableAzzeramentoVasi)this.lista.get(i)).getColumn_qta();
                String tipo = "";
                tipo = qta > 0.0 ? "C" : "S";
                String dts = ((ColumnTableAzzeramentoVasi)this.lista.get(i)).getColumn_dataido().replace("-", "/").replace("null", "");
                String data = "";
                if (!dts.equals("")) {
                    data = FXMLDocumentController.util.GiornoMeseAnnoToAnnoMeseGiorno(dts);
                }
                FXMLDocumentController.sqlUtil.insert_c_movimenti(FXMLDocumentController.GLOBAL_AZIENDA, FXMLDocumentController.GLOBAL_SOTTOAZZ, "@id_oper", tipo, prodotto, ((ColumnTableAzzeramentoVasi)this.lista.get(i)).getColumn_numprot(), ((ColumnTableAzzeramentoVasi)this.lista.get(i)).getColumn_entecert(), data, "0", "0", "0", stato_fisico, FXMLDocumentController.GLOBAL_ICQRF, "F", "0", FXMLDocumentController.GLOBAL_CODCOMM, cod_prod_mx, "", "", "", "", "", "", "", "", "", "", "");
                strSQL.addAll(FXMLDocumentController.sqlUtil.strSQL);
                tipoSQL.addAll(FXMLDocumentController.sqlUtil.tipoinsSQL);
                lenghtBidimensionalArray.addAll(FXMLDocumentController.sqlUtil.lengthSQL);
                lastID.addAll(FXMLDocumentController.sqlUtil.lastID);
                tipo_ins[iterator] = FXMLDocumentController.sqlUtil.tipovaloreSQL.toArray(new String[0]);
                valore[iterator] = FXMLDocumentController.sqlUtil.valoreSQL.toArray(new String[0]);
                ++iterator;
                lastID.add(false);
                tipoSQL.add("insert");
                strSQL.add("SET @id_mov:=(LAST_INSERT_ID());");
                lenghtBidimensionalArray.add(0);
                tipo_ins[iterator][0] = "";
                valore[iterator][0] = "";
                ++iterator;
                int flg_invio = 0;
                FXMLDocumentController.sqlUtil.insert_gen_vasi_vinari_mov(FXMLDocumentController.GLOBAL_AZIENDA, FXMLDocumentController.GLOBAL_SOTTOAZZ, "@id_mov", ((ColumnTableAzzeramentoVasi)this.lista.get(i)).getColumn_id() + "", "0", "AZZERAMENTO", prodotto, qta + "", FXMLDocumentController.GLOBAL_ICQRF, FXMLDocumentController.GLOBAL_CODCOMM, flg_invio + "");
                strSQL.addAll(FXMLDocumentController.sqlUtil.strSQL);
                tipoSQL.addAll(FXMLDocumentController.sqlUtil.tipoinsSQL);
                lenghtBidimensionalArray.addAll(FXMLDocumentController.sqlUtil.lengthSQL);
                lastID.addAll(FXMLDocumentController.sqlUtil.lastID);
                tipo_ins[iterator] = FXMLDocumentController.sqlUtil.tipovaloreSQL.toArray(new String[0]);
                valore[iterator] = FXMLDocumentController.sqlUtil.valoreSQL.toArray(new String[0]);
                ++iterator;
            }
            String strJson = FXMLDocumentController.util.makeStringJsonDB("ON", tipoSQL, strSQL, tipo_ins, valore, lastID, lenghtBidimensionalArray);
            data_select = FXMLDocumentController.sk1Comm.ServerEsecuteRequest(FXMLDocumentController.GLOBAL_IP, FXMLDocumentController.GLOBAL_PORT, "dbInteraction#@" + strJson);
            if (!data_select.contains("#ERR:")) {
                this.lista.clear();
                this.table.refresh();
                FXMLDocumentController.toast.startToast("Operazione completata.", "SUCCESSO", "SUCCESSO");
            } else {
                FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", data_select);
            }
        }
        catch (IOException | URISyntaxException | JSONException ex) {
            FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
        }
    }

    @FXML
    void btnElimina(ActionEvent event) {
        ColumnTableAzzeramentoVasi id = (ColumnTableAzzeramentoVasi)this.table.getSelectionModel().getSelectedItem();
        if (id != null) {
            this.lista.remove((Object)id);
            this.table.refresh();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @FXML
    void btnAggiungi(ActionEvent event) throws JSONException, IOException, FileNotFoundException, URISyntaxException, ParseException {
        FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/vin/view/SearchProdotto_2.fxml"));
        Stage stage = new Stage();
        stage.setMaximized(false);
        stage.setTitle("Prodotto");
        stage.setScene(new Scene((Parent)((Pane)loader.load())));
        SearchProdottoController_2 controller = (SearchProdottoController_2)loader.getController();
        HashMap lis = FXMLDocumentController.util.getParameters();
        boolean GESTIONE_VASCHE = (Boolean)lis.get("GESTIONE_VASCHE");
        controller.setSearch("", " AND (CAST(sian_cod_stato_fisico AS UNSIGNED)=1   AND sian_um='l' ) OR (CAST(sian_cod_stato_fisico AS UNSIGNED)=1   AND sian_massa_volumica>0 )", "");
        stage.initModality(Modality.APPLICATION_MODAL);
        stage.setResizable(false);
        stage.showAndWait();
        String codiceProdotto = controller.getCodice();
        String descrizioneProdotto = controller.getDesString();
        String categoriaProdotto = controller.getCategoriaProd();
        String atto_cert = controller.getAttoCert();
        if (codiceProdotto.equals("")) return;
        String ido = "";
        FXMLLoader loader2 = new FXMLLoader(this.getClass().getResource("/vin/view/SearchVasca_2.fxml"));
        Stage stage2 = new Stage();
        stage2.setMaximized(false);
        stage2.setTitle("Vasca");
        stage2.setScene(new Scene((Parent)((Pane)loader2.load())));
        SearchVasca_2 controller2 = (SearchVasca_2)loader2.getController();
        lis = FXMLDocumentController.util.getParameters();
        GESTIONE_VASCHE = (Boolean)lis.get("GESTIONE_VASCHE");
        controller2.setSearch(" GROUP BY codice_vaso ", "");
        stage2.initModality(Modality.APPLICATION_MODAL);
        stage2.setResizable(false);
        stage2.showAndWait();
        List<ColumnTableSearchVascheGiacenza> listas = controller2.getListas();
        if (listas == null) return;
        for (int o = 0; o < listas.size(); ++o) {
            ColumnTableSearchVascheGiacenza op = listas.get(0);
            String codicevasca = op.getColumn_codice_vaso();
            String descrvasca = op.getColumn_descr_vaso();
            double capacita = op.getColumn_capacita();
            double residuo = op.getColumn_residuo();
            double giacenza = op.getColumn_esi();
            int id_vasca = op.getColumn_id();
            boolean s = false;
            if (codicevasca.equals("")) continue;
            double qta = giacenza;
            if (atto_cert.equals("2")) {
                String res = FXMLDocumentController.ricerca.idoneitaAnagGiacenza(codiceProdotto).replace("null", "");
                if (!res.contains("#ERR:")) {
                    if (!res.equals("[]")) {
                        String[] row = res.replace("[", "").replace("]", "").split(",");
                        for (int i = 0; i < row.length; ++i) {
                            String[] rowinrow = row[i].split("\\#@", -1);
                            if (rowinrow.length <= 0) continue;
                            this.lista_cmbxidoneita_ve.add((Object)new IdoneitaImbSfuso(rowinrow[0], rowinrow[1], rowinrow[2]));
                        }
                        int ui = 0;
                        if (this.lista_cmbxidoneita_ve.size() > 0) {
                            ArrayList<String> l = new ArrayList<String>();
                            for (int i = 0; i < this.lista_cmbxidoneita_ve.size(); ++i) {
                                l.add(((IdoneitaImbSfuso)this.lista_cmbxidoneita_ve.get(ui)).getCodice() + " | " + ((IdoneitaImbSfuso)this.lista_cmbxidoneita_ve.get(ui)).getDescrizione() + " | " + ((IdoneitaImbSfuso)this.lista_cmbxidoneita_ve.get(ui)).getEntecert());
                                ++ui;
                            }
                            ido = this.choiceInputDialog("Idoneita", "Scegli l'idoneit\u00e0", "Idoneita ", l);
                        }
                    }
                } else {
                    FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", res);
                    return;
                }
            }
            CodiceDescrizione ente_cert = null;
            String data_ido = "";
            String num_prot = "";
            String ente = "";
            if (!ido.equals("")) {
                String[] val = ido.split(" \\| ");
                num_prot = val[0].trim();
                data_ido = val[1].trim();
                ente = val[2].trim();
                String rest = FXMLDocumentController.ricerca.getIdEnteCertificatore(val[2].trim());
                if (!rest.equals("")) {
                    ente_cert = new CodiceDescrizione(rest, val[2].trim());
                }
            }
            if (!data_ido.equals("")) {
                data_ido = data_ido.replace("/", "-");
                data_ido = FXMLDocumentController.util.AnnoMeseGiornoTOGiornoMeseAnno(data_ido).replace("/", "-");
            }
            this.lista.add((Object)new ColumnTableAzzeramentoVasi(id_vasca, codicevasca, descrvasca, codiceProdotto, num_prot, data_ido, ente, qta));
        }
    }

    public void initialize(URL url, ResourceBundle rb) {
        try {
            this.lista = FXCollections.observableArrayList();
            this.column_codicevaso.setCellValueFactory((Callback)new PropertyValueFactory("column_codicevaso"));
            this.column_descrizione.setCellValueFactory((Callback)new PropertyValueFactory("column_descrizione"));
            this.column_numprot.setCellValueFactory((Callback)new PropertyValueFactory("column_numprot"));
            this.column_dataido.setCellValueFactory((Callback)new PropertyValueFactory("column_dataido"));
            this.columnentecert.setCellValueFactory((Callback)new PropertyValueFactory("column_entecert"));
            this.column_qta.setCellValueFactory((Callback)new PropertyValueFactory("column_qta"));
            this.column_prodotto.setCellValueFactory((Callback)new PropertyValueFactory("column_prodotto"));
            this.column_id.setCellValueFactory((Callback)new PropertyValueFactory("column_id"));
            Callback<TableColumn<ColumnTableAzzeramentoVasi, Double>, TableCell<ColumnTableAzzeramentoVasi, Double>> invioflag = new Callback<TableColumn<ColumnTableAzzeramentoVasi, Double>, TableCell<ColumnTableAzzeramentoVasi, Double>>(){

                public TableCell call(TableColumn p) {
                    return new EditingCellDoublePool();
                }
            };
            this.column_qta.setCellFactory((Callback)invioflag);
            this.column_qta.setOnEditCommit(t -> ((ColumnTableAzzeramentoVasi)t.getTableView().getItems().get(t.getTablePosition().getRow())).setColumn_qta((Double)t.getNewValue()));
            this.table.setItems(this.lista);
        }
        catch (Exception ex) {
            FXMLDocumentController.util.alertWindow(Alert.AlertType.ERROR, "ERRORE", "", ex.toString());
        }
    }
}

